
/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
DROP TABLE IF EXISTS `accept_estimates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accept_estimates` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `estimate_id` int unsigned NOT NULL,
  `full_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `signature` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `accept_estimates_company_id_foreign` (`company_id`),
  KEY `accept_estimates_estimate_id_foreign` (`estimate_id`),
  CONSTRAINT `accept_estimates_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `accept_estimates_estimate_id_foreign` FOREIGN KEY (`estimate_id`) REFERENCES `estimates` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accept_estimates` WRITE;
/*!40000 ALTER TABLE `accept_estimates` DISABLE KEYS */;
/*!40000 ALTER TABLE `accept_estimates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `application_sources`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_sources` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `application_source` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `application_sources` WRITE;
/*!40000 ALTER TABLE `application_sources` DISABLE KEYS */;
INSERT INTO `application_sources` VALUES (1,'Linkedin','2023-04-06 06:33:08','2023-04-06 06:33:08'),(2,'Facebook','2023-04-06 06:33:08','2023-04-06 06:33:08'),(3,'Instagram','2023-04-06 06:33:08','2023-04-06 06:33:08'),(4,'Twitter','2023-04-06 06:33:08','2023-04-06 06:33:08'),(5,'Other','2023-04-06 06:33:08','2023-04-06 06:33:08');
/*!40000 ALTER TABLE `application_sources` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `appreciations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `appreciations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `award_id` bigint unsigned NOT NULL,
  `award_to` int unsigned NOT NULL,
  `award_date` date NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `summary` text COLLATE utf8mb4_unicode_ci,
  `added_by` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `appreciations_company_id_foreign` (`company_id`),
  KEY `appreciations_award_id_foreign` (`award_id`),
  KEY `appreciations_award_to_foreign` (`award_to`),
  KEY `appreciations_added_by_foreign` (`added_by`),
  CONSTRAINT `appreciations_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `appreciations_award_id_foreign` FOREIGN KEY (`award_id`) REFERENCES `awards` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `appreciations_award_to_foreign` FOREIGN KEY (`award_to`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `appreciations_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `appreciations` WRITE;
/*!40000 ALTER TABLE `appreciations` DISABLE KEYS */;
INSERT INTO `appreciations` VALUES (1,1,2,23,'2023-01-14',NULL,NULL,21,NULL,NULL),(2,1,17,2,'2023-01-14',NULL,NULL,2,NULL,NULL),(3,1,11,15,'2023-01-14',NULL,NULL,20,NULL,NULL),(4,1,6,20,'2023-01-14',NULL,NULL,22,NULL,NULL),(5,1,3,16,'2023-01-14',NULL,NULL,23,NULL,NULL),(6,1,10,22,'2023-01-14',NULL,NULL,2,NULL,NULL),(7,1,6,21,'2023-01-14',NULL,NULL,17,NULL,NULL),(8,1,7,15,'2023-01-14',NULL,NULL,19,NULL,NULL),(9,1,16,2,'2023-01-14',NULL,NULL,18,NULL,NULL),(10,1,10,2,'2023-01-14',NULL,NULL,16,NULL,NULL);
/*!40000 ALTER TABLE `appreciations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `asset_lending_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `asset_lending_history` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `asset_id` bigint unsigned NOT NULL,
  `user_id` int unsigned NOT NULL,
  `lender_id` int unsigned NOT NULL,
  `returner_id` int unsigned DEFAULT NULL,
  `date_given` datetime NOT NULL,
  `return_date` datetime DEFAULT NULL,
  `date_of_return` datetime DEFAULT NULL,
  `notes` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `asset_lending_history_asset_id_foreign` (`asset_id`),
  KEY `asset_lending_history_user_id_foreign` (`user_id`),
  KEY `asset_lending_history_lender_id_foreign` (`lender_id`),
  KEY `asset_lending_history_returner_id_foreign` (`returner_id`),
  KEY `asset_lending_history_company_id_foreign` (`company_id`),
  CONSTRAINT `asset_lending_history_asset_id_foreign` FOREIGN KEY (`asset_id`) REFERENCES `assets` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `asset_lending_history_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `asset_lending_history_lender_id_foreign` FOREIGN KEY (`lender_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `asset_lending_history_returner_id_foreign` FOREIGN KEY (`returner_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `asset_lending_history_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `asset_lending_history` WRITE;
/*!40000 ALTER TABLE `asset_lending_history` DISABLE KEYS */;
/*!40000 ALTER TABLE `asset_lending_history` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `asset_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `asset_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `purchase_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `supported_until` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `asset_settings` WRITE;
/*!40000 ALTER TABLE `asset_settings` DISABLE KEYS */;
INSERT INTO `asset_settings` VALUES (1,NULL,NULL,'2023-04-06 06:33:05','2023-04-06 06:33:05');
/*!40000 ALTER TABLE `asset_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `asset_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `asset_types` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `asset_types_company_id_foreign` (`company_id`),
  CONSTRAINT `asset_types_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `asset_types` WRITE;
/*!40000 ALTER TABLE `asset_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `asset_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `asset_type_id` bigint unsigned DEFAULT NULL,
  `serial_number` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `status` enum('lent','available','non-functional') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'available',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `value` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `assets_asset_type_id_foreign` (`asset_type_id`),
  KEY `assets_serial_number_index` (`serial_number`),
  KEY `assets_added_by_foreign` (`added_by`),
  KEY `assets_last_updated_by_foreign` (`last_updated_by`),
  KEY `assets_company_id_foreign` (`company_id`),
  CONSTRAINT `assets_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `assets_asset_type_id_foreign` FOREIGN KEY (`asset_type_id`) REFERENCES `asset_types` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `assets_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `assets_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `attendance_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendance_settings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `auto_clock_in` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `auto_clock_in_location` enum('office','home') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'office',
  `office_start_time` time NOT NULL,
  `office_end_time` time NOT NULL,
  `halfday_mark_time` time DEFAULT NULL,
  `late_mark_duration` tinyint NOT NULL,
  `clockin_in_day` int NOT NULL DEFAULT '1',
  `employee_clock_in_out` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `office_open_days` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '[1,2,3,4,5]',
  `ip_address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `radius` int DEFAULT NULL,
  `radius_check` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `ip_check` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `alert_after` int DEFAULT NULL,
  `alert_after_status` tinyint(1) NOT NULL DEFAULT '1',
  `save_current_location` tinyint(1) NOT NULL DEFAULT '0',
  `default_employee_shift` bigint unsigned DEFAULT '1',
  `week_start_from` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `allow_shift_change` tinyint(1) NOT NULL DEFAULT '1',
  `show_clock_in_button` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `monthly_report` tinyint(1) NOT NULL DEFAULT '0',
  `monthly_report_roles` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `attendance_settings_company_id_foreign` (`company_id`),
  KEY `attendance_settings_default_employee_shift_foreign` (`default_employee_shift`),
  CONSTRAINT `attendance_settings_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `attendance_settings_default_employee_shift_foreign` FOREIGN KEY (`default_employee_shift`) REFERENCES `employee_shifts` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `attendance_settings` WRITE;
/*!40000 ALTER TABLE `attendance_settings` DISABLE KEYS */;
INSERT INTO `attendance_settings` VALUES (1,1,'no','office','09:00:00','18:00:00',NULL,20,1,'yes','[1,2,3,4,5]',NULL,NULL,'no','no',NULL,0,0,2,'1',1,'no','2023-04-06 06:33:16','2023-04-06 06:33:16',0,NULL);
/*!40000 ALTER TABLE `attendance_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `attendances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendances` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `location_id` bigint unsigned DEFAULT NULL,
  `clock_in_time` datetime NOT NULL,
  `clock_out_time` datetime DEFAULT NULL,
  `clock_in_ip` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `clock_out_ip` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `working_from` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'office',
  `late` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `half_day` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `latitude` decimal(10,8) DEFAULT NULL,
  `longitude` decimal(11,8) DEFAULT NULL,
  `shift_start_time` datetime DEFAULT NULL,
  `shift_end_time` datetime DEFAULT NULL,
  `employee_shift_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `work_from_type` enum('home','office','other') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'other',
  PRIMARY KEY (`id`),
  KEY `attendances_company_id_foreign` (`company_id`),
  KEY `attendances_user_id_foreign` (`user_id`),
  KEY `attendances_location_id_foreign` (`location_id`),
  KEY `attendances_clock_in_time_index` (`clock_in_time`),
  KEY `attendances_clock_out_time_index` (`clock_out_time`),
  KEY `attendances_added_by_foreign` (`added_by`),
  KEY `attendances_last_updated_by_foreign` (`last_updated_by`),
  KEY `attendances_employee_shift_id_foreign` (`employee_shift_id`),
  CONSTRAINT `attendances_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `attendances_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `attendances_employee_shift_id_foreign` FOREIGN KEY (`employee_shift_id`) REFERENCES `employee_shifts` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `attendances_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `attendances_location_id_foreign` FOREIGN KEY (`location_id`) REFERENCES `company_addresses` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `attendances_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `attendances` WRITE;
/*!40000 ALTER TABLE `attendances` DISABLE KEYS */;
INSERT INTO `attendances` VALUES (1,1,1,NULL,'2023-02-12 12:00:00','2023-02-12 21:00:00','133.87.107.28','133.87.107.28','office','yes','no',1,NULL,NULL,NULL,NULL,NULL,NULL,'2023-03-26 08:12:13',NULL,'other'),(2,1,2,NULL,'2023-03-01 12:00:00','2023-03-01 13:00:00','86.178.197.3','86.178.197.3','office','no','no',1,NULL,NULL,NULL,NULL,NULL,NULL,'2023-03-03 06:12:30',NULL,'other'),(3,1,14,NULL,'2023-03-10 13:00:00','2023-03-10 19:00:00','50.251.70.54','50.251.70.54','office','no','no',1,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-01 00:59:31',NULL,'other'),(4,1,15,NULL,'2023-03-28 13:00:00','2023-03-28 14:00:00','53.120.229.102','53.120.229.102','office','no','no',1,NULL,NULL,NULL,NULL,NULL,NULL,'2023-01-23 23:35:49',NULL,'other'),(5,1,16,NULL,'2023-03-10 13:00:00','2023-03-10 17:00:00','151.253.116.115','151.253.116.115','office','yes','no',1,NULL,NULL,NULL,NULL,NULL,NULL,'2023-01-19 06:50:37',NULL,'other'),(6,1,17,NULL,'2023-03-22 10:00:00','2023-03-22 15:00:00','43.91.125.164','43.91.125.164','office','no','no',1,NULL,NULL,NULL,NULL,NULL,NULL,'2023-03-10 19:39:42',NULL,'other'),(7,1,18,NULL,'2023-02-28 11:00:00','2023-02-28 20:00:00','150.117.117.35','150.117.117.35','office','no','no',1,NULL,NULL,NULL,NULL,NULL,NULL,'2023-03-10 23:49:00',NULL,'other'),(8,1,19,NULL,'2023-03-10 13:00:00','2023-03-10 22:00:00','216.1.122.20','216.1.122.20','office','yes','no',1,NULL,NULL,NULL,NULL,NULL,NULL,'2023-03-08 12:51:04',NULL,'other'),(9,1,20,NULL,'2023-01-19 13:00:00','2023-01-19 19:00:00','182.23.35.9','182.23.35.9','office','yes','no',1,NULL,NULL,NULL,NULL,NULL,NULL,'2023-03-30 04:39:28',NULL,'other'),(10,1,21,NULL,'2023-03-16 11:00:00','2023-03-16 18:00:00','19.180.119.135','19.180.119.135','office','no','no',1,NULL,NULL,NULL,NULL,NULL,NULL,'2023-01-05 00:48:03',NULL,'other'),(11,1,22,NULL,'2023-01-11 11:00:00','2023-01-11 14:00:00','234.65.74.101','234.65.74.101','office','no','no',1,NULL,NULL,NULL,NULL,NULL,NULL,'2023-03-04 20:12:07',NULL,'other'),(12,1,23,NULL,'2023-03-24 10:00:00','2023-03-24 17:00:00','189.79.231.179','189.79.231.179','office','no','no',1,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-03 00:36:45',NULL,'other');
/*!40000 ALTER TABLE `attendances` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `award_icons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `award_icons` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `icon` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `award_icons` WRITE;
/*!40000 ALTER TABLE `award_icons` DISABLE KEYS */;
INSERT INTO `award_icons` VALUES (1,'Trophy','trophy-fill','2023-04-06 06:33:16','2023-04-06 06:33:16'),(2,'Thumbs Up','hand-thumbs-up-fill','2023-04-06 06:33:16','2023-04-06 06:33:16'),(3,'Award','award-fill','2023-04-06 06:33:16','2023-04-06 06:33:16'),(4,'Book','book-fill','2023-04-06 06:33:16','2023-04-06 06:33:16'),(5,'Gift','gift-fill','2023-04-06 06:33:16','2023-04-06 06:33:16'),(6,'Watch','watch','2023-04-06 06:33:16','2023-04-06 06:33:16'),(7,'Cup','cup-hot-fill','2023-04-06 06:33:16','2023-04-06 06:33:16'),(8,'Puzzle','puzzle-fill','2023-04-06 06:33:16','2023-04-06 06:33:16'),(9,'Plane','airplane-fill','2023-04-06 06:33:16','2023-04-06 06:33:16'),(10,'Money','piggy-bank-fill','2023-04-06 06:33:16','2023-04-06 06:33:16');
/*!40000 ALTER TABLE `award_icons` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `awards`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `awards` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `award_icon_id` bigint unsigned DEFAULT NULL,
  `summary` text COLLATE utf8mb4_unicode_ci,
  `status` enum('active','inactive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `color_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `awards_company_id_foreign` (`company_id`),
  KEY `awards_award_icon_id_foreign` (`award_icon_id`),
  CONSTRAINT `awards_award_icon_id_foreign` FOREIGN KEY (`award_icon_id`) REFERENCES `award_icons` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `awards_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `awards` WRITE;
/*!40000 ALTER TABLE `awards` DISABLE KEYS */;
INSERT INTO `awards` VALUES (1,1,'Best Team Player',10,NULL,'active','#387B1C',NULL,NULL),(2,1,'Most Innovative Project',5,NULL,'active','#495E67',NULL,NULL),(3,1,'Best Technical Solution',6,NULL,'active','#387B1C',NULL,NULL),(4,1,'Best Customer Service',3,NULL,'active','#282E33',NULL,NULL),(5,1,'Employee of the Month',8,NULL,'active','#282E33',NULL,NULL),(6,1,'Best Mentor',1,NULL,'active','#3DADDD',NULL,NULL),(7,1,'Top Sales Performer',7,NULL,'active','#7B1C2E',NULL,NULL),(8,1,'Best Project Manager',1,NULL,'active','#7B1C2E',NULL,NULL),(9,1,'Top Code Contributor',2,NULL,'active','#282E33',NULL,NULL),(10,1,'Most Improved Employee',10,NULL,'active','#7B1C2E',NULL,NULL),(11,1,'Best New Hire',9,NULL,'active','#282E33',NULL,NULL),(12,1,'Best Presentation',3,NULL,'active','#7B1C2E',NULL,NULL),(13,1,'Best Quality Control',10,NULL,'active','#387B1C',NULL,NULL),(14,1,'Best Technical Writer',2,NULL,'active','#3DADDD',NULL,NULL),(15,1,'Most Valuable Employee',5,NULL,'active','#387B1C',NULL,NULL),(16,1,'Employee of the month',4,NULL,'active','#387B1C',NULL,NULL),(17,1,'Star Performer Award',2,NULL,'active','#282E33',NULL,NULL);
/*!40000 ALTER TABLE `awards` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bank_accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `bank_accounts` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bank_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `currency_id` int unsigned DEFAULT NULL,
  `contact_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `opening_balance` double(15,2) DEFAULT NULL,
  `bank_logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `bank_balance` double(16,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bank_accounts_company_id_foreign` (`company_id`),
  KEY `bank_accounts_currency_id_foreign` (`currency_id`),
  KEY `bank_accounts_added_by_foreign` (`added_by`),
  KEY `bank_accounts_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `bank_accounts_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `bank_accounts_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `bank_accounts_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `bank_accounts_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bank_accounts` WRITE;
/*!40000 ALTER TABLE `bank_accounts` DISABLE KEYS */;
INSERT INTO `bank_accounts` VALUES (1,1,'bank','Primary Account','Kshlerin, Wehner and Dicki','9342976054273112','current',1,'(847) 708-3252',38160.00,NULL,1,NULL,NULL,215314.00,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(2,1,'bank','Secondary Account','Lemke PLC','56803167874414','current',1,'(316) 440-5675',94001.00,NULL,1,NULL,NULL,296544.00,'2023-04-06 06:33:18','2023-04-06 06:33:18');
/*!40000 ALTER TABLE `bank_accounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bank_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `bank_transactions` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `bank_account_id` int unsigned DEFAULT NULL,
  `payment_id` int unsigned DEFAULT NULL,
  `invoice_id` int unsigned DEFAULT NULL,
  `expense_id` int unsigned DEFAULT NULL,
  `amount` double(15,2) DEFAULT NULL,
  `type` enum('Cr','Dr') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Cr',
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `memo` text COLLATE utf8mb4_unicode_ci,
  `transaction_relation` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_related_to` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` text COLLATE utf8mb4_unicode_ci,
  `transaction_date` date DEFAULT NULL,
  `bank_balance` double(16,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bank_transactions_company_id_foreign` (`company_id`),
  KEY `bank_transactions_bank_account_id_foreign` (`bank_account_id`),
  KEY `bank_transactions_payment_id_foreign` (`payment_id`),
  KEY `bank_transactions_invoice_id_foreign` (`invoice_id`),
  KEY `bank_transactions_expense_id_foreign` (`expense_id`),
  KEY `bank_transactions_added_by_foreign` (`added_by`),
  KEY `bank_transactions_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `bank_transactions_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `bank_transactions_bank_account_id_foreign` FOREIGN KEY (`bank_account_id`) REFERENCES `bank_accounts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `bank_transactions_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `bank_transactions_expense_id_foreign` FOREIGN KEY (`expense_id`) REFERENCES `expenses` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `bank_transactions_invoice_id_foreign` FOREIGN KEY (`invoice_id`) REFERENCES `invoices` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `bank_transactions_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `bank_transactions_payment_id_foreign` FOREIGN KEY (`payment_id`) REFERENCES `payments` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bank_transactions` WRITE;
/*!40000 ALTER TABLE `bank_transactions` DISABLE KEYS */;
INSERT INTO `bank_transactions` VALUES (1,1,1,NULL,NULL,NULL,38160.00,'Cr',NULL,NULL,NULL,'bank',NULL,'bank-account-created','2023-04-06',38160.00,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(2,1,2,NULL,NULL,NULL,94001.00,'Cr',NULL,NULL,NULL,'bank',NULL,'bank-account-created','2023-04-06',94001.00,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(3,1,2,1,1,NULL,58266.00,'Cr',NULL,NULL,NULL,'payment','1','payment-credited','2023-04-03',152267.00,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(4,1,2,2,7,NULL,55086.00,'Cr',NULL,NULL,NULL,'payment','2','payment-credited','2023-04-05',207353.00,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(5,1,2,3,8,NULL,11655.00,'Cr',NULL,NULL,NULL,'payment','3','payment-credited','2023-04-04',219008.00,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(6,1,1,4,9,NULL,61408.00,'Cr',NULL,NULL,NULL,'payment','4','payment-credited','2023-04-04',99568.00,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(7,1,2,5,10,NULL,29974.00,'Cr',NULL,NULL,NULL,'payment','5','payment-credited','2023-04-02',248982.00,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(8,1,1,6,13,NULL,30536.00,'Cr',NULL,NULL,NULL,'payment','6','payment-credited','2023-04-06',130104.00,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(9,1,2,7,17,NULL,23364.00,'Cr',NULL,NULL,NULL,'payment','7','payment-credited','2023-04-05',272346.00,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(10,1,2,8,18,NULL,24198.00,'Cr',NULL,NULL,NULL,'payment','8','payment-credited','2023-04-01',296544.00,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(11,1,1,9,19,NULL,20048.00,'Cr',NULL,NULL,NULL,'payment','9','payment-credited','2023-04-03',150152.00,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(12,1,1,10,20,NULL,28065.00,'Cr',NULL,NULL,NULL,'payment','10','payment-credited','2023-04-05',178217.00,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(13,1,1,11,21,NULL,37097.00,'Cr',NULL,NULL,NULL,'payment','11','payment-credited','2023-04-01',215314.00,'2023-04-06 06:33:18','2023-04-06 06:33:18');
/*!40000 ALTER TABLE `bank_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `client_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `client_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `category_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `client_categories_company_id_foreign` (`company_id`),
  CONSTRAINT `client_categories_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `client_categories` WRITE;
/*!40000 ALTER TABLE `client_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `client_categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `client_contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `client_contacts` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `contact_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `client_contacts_company_id_foreign` (`company_id`),
  KEY `client_contacts_user_id_foreign` (`user_id`),
  KEY `client_contacts_added_by_foreign` (`added_by`),
  KEY `client_contacts_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `client_contacts_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `client_contacts_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `client_contacts_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `client_contacts_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `client_contacts` WRITE;
/*!40000 ALTER TABLE `client_contacts` DISABLE KEYS */;
/*!40000 ALTER TABLE `client_contacts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `client_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `client_details` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `company_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `shipping_address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `postal_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `office` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `website` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `linkedin` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `facebook` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `twitter` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `skype` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gst_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `category_id` bigint unsigned DEFAULT NULL,
  `sub_category_id` bigint unsigned DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `company_logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `quickbooks_client_id` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `client_details_company_id_foreign` (`company_id`),
  KEY `client_details_user_id_foreign` (`user_id`),
  KEY `client_details_category_id_foreign` (`category_id`),
  KEY `client_details_sub_category_id_foreign` (`sub_category_id`),
  KEY `client_details_added_by_foreign` (`added_by`),
  KEY `client_details_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `client_details_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `client_details_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `client_categories` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `client_details_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `client_details_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `client_details_sub_category_id_foreign` FOREIGN KEY (`sub_category_id`) REFERENCES `client_sub_categories` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `client_details_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `client_details` WRITE;
/*!40000 ALTER TABLE `client_details` DISABLE KEYS */;
INSERT INTO `client_details` VALUES (1,1,3,'Labadie LLC','435 Alessandro Plains\nNorth Alanafurt, AL 60199',NULL,NULL,NULL,NULL,NULL,'https://worksuite.biz',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16',NULL),(2,1,4,'Schoen-Ritchie','483 Ashly Haven\nWest Gideonmouth, RI 32153-4051',NULL,NULL,NULL,NULL,NULL,'https://worksuite.biz',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:17','2023-04-06 06:33:17',NULL),(3,1,5,'Reilly, Hahn and Kutch','2420 Waelchi Courts Suite 156\nPort Verona, WI 14329-4248',NULL,NULL,NULL,NULL,NULL,'https://worksuite.biz',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:17','2023-04-06 06:33:17',NULL),(4,1,6,'Maggio LLC','23939 Reynolds Park\nLake Abel, VA 06435',NULL,NULL,NULL,NULL,NULL,'https://worksuite.biz',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:17','2023-04-06 06:33:17',NULL),(5,1,7,'Herman, Erdman and Hane','5445 Terrance Forks\nNew Dorthymouth, VT 76596-2349',NULL,NULL,NULL,NULL,NULL,'https://worksuite.biz',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:17','2023-04-06 06:33:17',NULL),(6,1,8,'Hagenes PLC','762 Carolanne Mount Apt. 042\nWest Agustinafurt, PA 43080',NULL,NULL,NULL,NULL,NULL,'https://worksuite.biz',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:17','2023-04-06 06:33:17',NULL),(7,1,9,'Schneider Group','148 Monahan Knolls\nAnnamariemouth, TX 97265',NULL,NULL,NULL,NULL,NULL,'https://worksuite.biz',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:17','2023-04-06 06:33:17',NULL),(8,1,10,'Padberg Group','726 Roberts Lights\nLake Esmeralda, AK 49917-1703',NULL,NULL,NULL,NULL,NULL,'https://worksuite.biz',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:17','2023-04-06 06:33:17',NULL),(9,1,11,'Mueller-Mertz','8174 Kendra Harbor\nAntoninaville, MS 50958-6767',NULL,NULL,NULL,NULL,NULL,'https://worksuite.biz',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:17','2023-04-06 06:33:17',NULL),(10,1,12,'Watsica, Waelchi and Glover','1597 Johnston Trail\nKiaramouth, OK 29256-9367',NULL,NULL,NULL,NULL,NULL,'https://worksuite.biz',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:17','2023-04-06 06:33:17',NULL),(11,1,13,'Oberbrunner, Frami and Metz','53222 Frida Drive\nLake Eunice, ND 32753',NULL,NULL,NULL,NULL,NULL,'https://worksuite.biz',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:17','2023-04-06 06:33:17',NULL);
/*!40000 ALTER TABLE `client_details` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `client_docs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `client_docs` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `filename` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `hashname` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `client_docs_company_id_foreign` (`company_id`),
  KEY `client_docs_user_id_foreign` (`user_id`),
  KEY `client_docs_added_by_foreign` (`added_by`),
  KEY `client_docs_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `client_docs_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `client_docs_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `client_docs_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `client_docs_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `client_docs` WRITE;
/*!40000 ALTER TABLE `client_docs` DISABLE KEYS */;
/*!40000 ALTER TABLE `client_docs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `client_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `client_notes` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `client_id` int unsigned DEFAULT NULL,
  `title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `member_id` int unsigned DEFAULT NULL,
  `is_client_show` tinyint(1) NOT NULL DEFAULT '0',
  `ask_password` tinyint(1) NOT NULL DEFAULT '0',
  `details` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `client_notes_company_id_foreign` (`company_id`),
  KEY `client_notes_client_id_foreign` (`client_id`),
  KEY `client_notes_member_id_foreign` (`member_id`),
  KEY `client_notes_added_by_foreign` (`added_by`),
  KEY `client_notes_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `client_notes_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `client_notes_client_id_foreign` FOREIGN KEY (`client_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `client_notes_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `client_notes_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `client_notes_member_id_foreign` FOREIGN KEY (`member_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `client_notes` WRITE;
/*!40000 ALTER TABLE `client_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `client_notes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `client_sub_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `client_sub_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `category_id` bigint unsigned NOT NULL,
  `category_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `client_sub_categories_company_id_foreign` (`company_id`),
  KEY `client_sub_categories_category_id_foreign` (`category_id`),
  CONSTRAINT `client_sub_categories_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `client_categories` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `client_sub_categories_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `client_sub_categories` WRITE;
/*!40000 ALTER TABLE `client_sub_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `client_sub_categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `client_user_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `client_user_notes` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `client_note_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `client_user_notes_company_id_foreign` (`company_id`),
  KEY `client_user_notes_user_id_foreign` (`user_id`),
  KEY `client_user_notes_client_note_id_foreign` (`client_note_id`),
  CONSTRAINT `client_user_notes_client_note_id_foreign` FOREIGN KEY (`client_note_id`) REFERENCES `client_notes` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `client_user_notes_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `client_user_notes_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `client_user_notes` WRITE;
/*!40000 ALTER TABLE `client_user_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `client_user_notes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `companies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `companies` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `app_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_phone` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `logo` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `login_background` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `website` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `currency_id` int unsigned DEFAULT NULL,
  `timezone` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Asia/Kolkata',
  `date_format` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'd-m-Y',
  `date_picker_format` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'dd-mm-yyyy',
  `year_starts_from` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `moment_format` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'DD-MM-YYYY',
  `time_format` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'h:i a',
  `locale` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'en',
  `latitude` decimal(10,8) NOT NULL DEFAULT '26.91243360',
  `longitude` decimal(11,8) NOT NULL DEFAULT '75.78727090',
  `leaves_start_from` enum('joining_date','year_start') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'joining_date',
  `active_theme` enum('default','custom') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `status` enum('active','inactive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `last_updated_by` int unsigned DEFAULT NULL,
  `google_map_key` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `task_self` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `rounded_theme` tinyint(1) NOT NULL DEFAULT '1',
  `logo_background_color` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '#ffffff',
  `header_color` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '#1D82F5',
  `before_days` int NOT NULL,
  `after_days` int NOT NULL,
  `on_deadline` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `default_task_status` int unsigned DEFAULT NULL,
  `dashboard_clock` tinyint(1) NOT NULL DEFAULT '1',
  `ticket_form_google_captcha` tinyint(1) NOT NULL DEFAULT '0',
  `lead_form_google_captcha` tinyint(1) NOT NULL DEFAULT '0',
  `taskboard_length` int NOT NULL DEFAULT '10',
  `datatable_row_limit` int NOT NULL DEFAULT '10',
  `favicon` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `auth_theme` enum('dark','light') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'light',
  `light_logo` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sidebar_logo_style` enum('square','full') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'square',
  `allow_client_signup` tinyint(1) NOT NULL,
  `admin_client_signup_approval` tinyint(1) NOT NULL,
  `google_calendar_status` enum('active','inactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'inactive',
  `google_client_id` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `google_client_secret` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `google_calendar_verification_status` enum('verified','non_verified') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'non_verified',
  `google_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `token` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `hash` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `last_login` datetime DEFAULT NULL,
  `rtl` tinyint(1) NOT NULL DEFAULT '0',
  `show_new_webhook_alert` tinyint(1) NOT NULL DEFAULT '0',
  `pm_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pm_last_four` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `companies_currency_id_foreign` (`currency_id`),
  KEY `companies_last_updated_by_foreign` (`last_updated_by`),
  KEY `companies_default_task_status_foreign` (`default_task_status`),
  CONSTRAINT `companies_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `companies_default_task_status_foreign` FOREIGN KEY (`default_task_status`) REFERENCES `taskboard_columns` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `companies_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `companies` WRITE;
/*!40000 ALTER TABLE `companies` DISABLE KEYS */;
INSERT INTO `companies` VALUES (1,'Worksuite','Worksuite','company@email.com','1234567891',NULL,NULL,'Your Company address here','https://worksuite.biz',1,'Asia/Kolkata','d-m-Y','dd-mm-yyyy','1','DD-MM-YYYY','h:i a','en',26.91243360,75.78727090,'year_start','default','active',1,NULL,'yes',1,'1','#1D82F5',0,0,'yes',1,1,0,0,10,10,NULL,'light',NULL,'square',0,0,'inactive',NULL,NULL,'non_verified',NULL,NULL,NULL,'5d01cc6771a73df983bf1d112f5140d3','2023-04-06 06:33:16','2023-04-06 06:35:58',NULL,0,0,NULL,NULL);
/*!40000 ALTER TABLE `companies` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `company_addresses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `company_addresses` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `address` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL,
  `tax_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `latitude` decimal(10,8) DEFAULT NULL,
  `longitude` decimal(11,8) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `company_addresses_company_id_foreign` (`company_id`),
  CONSTRAINT `company_addresses_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `company_addresses` WRITE;
/*!40000 ALTER TABLE `company_addresses` DISABLE KEYS */;
INSERT INTO `company_addresses` VALUES (1,1,'Your Company address here',1,NULL,NULL,'Worksuite','2023-04-06 06:33:16','2023-04-06 06:33:16',NULL,NULL);
/*!40000 ALTER TABLE `company_addresses` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `contract_discussions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contract_discussions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `contract_id` bigint unsigned NOT NULL,
  `from` int unsigned NOT NULL,
  `message` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contract_discussions_company_id_foreign` (`company_id`),
  KEY `contract_discussions_contract_id_foreign` (`contract_id`),
  KEY `contract_discussions_from_foreign` (`from`),
  KEY `contract_discussions_added_by_foreign` (`added_by`),
  KEY `contract_discussions_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `contract_discussions_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `contract_discussions_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `contract_discussions_contract_id_foreign` FOREIGN KEY (`contract_id`) REFERENCES `contracts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `contract_discussions_from_foreign` FOREIGN KEY (`from`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `contract_discussions_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `contract_discussions` WRITE;
/*!40000 ALTER TABLE `contract_discussions` DISABLE KEYS */;
/*!40000 ALTER TABLE `contract_discussions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `contract_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contract_files` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `contract_id` bigint unsigned NOT NULL,
  `filename` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `hashname` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `google_url` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `dropbox_link` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `external_link_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `external_link` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contract_files_company_id_foreign` (`company_id`),
  KEY `contract_files_user_id_foreign` (`user_id`),
  KEY `contract_files_contract_id_foreign` (`contract_id`),
  KEY `contract_files_added_by_foreign` (`added_by`),
  KEY `contract_files_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `contract_files_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `contract_files_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `contract_files_contract_id_foreign` FOREIGN KEY (`contract_id`) REFERENCES `contracts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `contract_files_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `contract_files_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `contract_files` WRITE;
/*!40000 ALTER TABLE `contract_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `contract_files` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `contract_renews`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contract_renews` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `renewed_by` int unsigned NOT NULL,
  `contract_id` bigint unsigned NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `amount` decimal(12,2) NOT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contract_renews_company_id_foreign` (`company_id`),
  KEY `contract_renews_renewed_by_foreign` (`renewed_by`),
  KEY `contract_renews_contract_id_foreign` (`contract_id`),
  KEY `contract_renews_added_by_foreign` (`added_by`),
  KEY `contract_renews_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `contract_renews_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `contract_renews_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `contract_renews_contract_id_foreign` FOREIGN KEY (`contract_id`) REFERENCES `contracts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `contract_renews_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `contract_renews_renewed_by_foreign` FOREIGN KEY (`renewed_by`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `contract_renews` WRITE;
/*!40000 ALTER TABLE `contract_renews` DISABLE KEYS */;
/*!40000 ALTER TABLE `contract_renews` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `contract_signs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contract_signs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `contract_id` bigint unsigned NOT NULL,
  `full_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `signature` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `place` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contract_signs_contract_id_foreign` (`contract_id`),
  KEY `contract_signs_company_id_foreign` (`company_id`),
  CONSTRAINT `contract_signs_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `contract_signs_contract_id_foreign` FOREIGN KEY (`contract_id`) REFERENCES `contracts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `contract_signs` WRITE;
/*!40000 ALTER TABLE `contract_signs` DISABLE KEYS */;
/*!40000 ALTER TABLE `contract_signs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `contract_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contract_templates` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `contract_template_number` bigint DEFAULT NULL,
  `company_id` int unsigned DEFAULT NULL,
  `subject` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `amount` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `contract_type_id` bigint unsigned NOT NULL,
  `currency_id` int unsigned DEFAULT NULL,
  `contract_detail` longtext COLLATE utf8mb4_unicode_ci,
  `added_by` int NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contract_templates_company_id_foreign` (`company_id`),
  KEY `contract_templates_contract_type_id_foreign` (`contract_type_id`),
  KEY `contract_templates_currency_id_foreign` (`currency_id`),
  CONSTRAINT `contract_templates_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `contract_templates_contract_type_id_foreign` FOREIGN KEY (`contract_type_id`) REFERENCES `contract_types` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `contract_templates_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `contract_templates` WRITE;
/*!40000 ALTER TABLE `contract_templates` DISABLE KEYS */;
/*!40000 ALTER TABLE `contract_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `contract_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contract_types` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contract_types_company_id_foreign` (`company_id`),
  CONSTRAINT `contract_types_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=40 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `contract_types` WRITE;
/*!40000 ALTER TABLE `contract_types` DISABLE KEYS */;
INSERT INTO `contract_types` VALUES (1,1,'Employment contract',NULL,NULL),(2,1,'Service contract',NULL,NULL),(3,1,'Construction contract',NULL,NULL),(4,1,'Sales contract',NULL,NULL),(5,1,'Lease contract',NULL,NULL),(6,1,'Purchase agreement',NULL,NULL),(7,1,'Partnership agreement',NULL,NULL),(8,1,'Non-disclosure agreement',NULL,NULL),(9,1,'Non-compete agreement',NULL,NULL),(10,1,'Joint venture agreement',NULL,NULL),(11,1,'Franchise agreement',NULL,NULL),(12,1,'Loan agreement',NULL,NULL),(13,1,'License agreement',NULL,NULL),(14,1,'Consulting agreement',NULL,NULL),(15,1,'Distribution agreement',NULL,NULL),(16,1,'Supply agreement',NULL,NULL),(17,1,'Indemnification agreement',NULL,NULL),(18,1,'Guarantee agreement',NULL,NULL),(19,1,'Insurance contract',NULL,NULL),(20,1,'Agency agreement',NULL,NULL),(21,1,'Master service agreement',NULL,NULL),(22,1,'Subcontractor agreement',NULL,NULL),(23,1,'Operating agreement',NULL,NULL),(24,1,'Shareholders agreement',NULL,NULL),(25,1,'Employee handbook',NULL,NULL),(26,1,'Independent contractor agreement',NULL,NULL),(27,1,'Subscription agreement',NULL,NULL),(28,1,'Software license agreement',NULL,NULL),(29,1,'Terms of use',NULL,NULL),(30,1,'Privacy policy',NULL,NULL),(31,1,'End-user license agreement',NULL,NULL),(32,1,'Service level agreement',NULL,NULL),(33,1,'Maintenance agreement',NULL,NULL),(34,1,'Support agreement',NULL,NULL),(35,1,'Professional services agreement',NULL,NULL),(36,1,'Statement of work',NULL,NULL),(37,1,'Memorandum of understanding',NULL,NULL),(38,1,'Letter of intent',NULL,NULL),(39,1,'Memorandum of agreement',NULL,NULL);
/*!40000 ALTER TABLE `contract_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `contracts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contracts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `contract_number` bigint DEFAULT NULL,
  `company_id` int unsigned DEFAULT NULL,
  `client_id` int unsigned NOT NULL,
  `project_id` int unsigned DEFAULT NULL,
  `subject` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `original_amount` decimal(15,2) NOT NULL,
  `contract_type_id` bigint unsigned DEFAULT NULL,
  `start_date` date NOT NULL,
  `original_start_date` date NOT NULL,
  `end_date` date DEFAULT NULL,
  `original_end_date` date DEFAULT NULL,
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `contract_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alternate_address` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contract_note` text COLLATE utf8mb4_unicode_ci,
  `cell` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `office` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `postal_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contract_detail` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `hash` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `currency_id` int unsigned DEFAULT NULL,
  `event_id` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `company_sign` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sign_date` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contracts_company_id_foreign` (`company_id`),
  KEY `contracts_client_id_foreign` (`client_id`),
  KEY `contracts_contract_type_id_foreign` (`contract_type_id`),
  KEY `contracts_added_by_foreign` (`added_by`),
  KEY `contracts_last_updated_by_foreign` (`last_updated_by`),
  KEY `contracts_currency_id_foreign` (`currency_id`),
  KEY `contracts_project_id_foreign` (`project_id`),
  CONSTRAINT `contracts_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `contracts_client_id_foreign` FOREIGN KEY (`client_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `contracts_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `contracts_contract_type_id_foreign` FOREIGN KEY (`contract_type_id`) REFERENCES `contract_types` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `contracts_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `contracts_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `contracts_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `contracts` WRITE;
/*!40000 ALTER TABLE `contracts` DISABLE KEYS */;
INSERT INTO `contracts` VALUES (1,1,1,12,NULL,'Alice; \'only, as.','578',578.00,11,'2023-03-29','2023-03-29','2023-06-06','2023-06-06','Officia debitis eos eum laudantium iure rerum nihil. Corrupti quae minus dolore eos ad distinctio hic. Quis dolor saepe quae ipsum ratione adipisci. Voluptatibus totam omnis ducimus vitae porro.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'I only wish it was,\' he said. \'Fifteenth,\' said the King. The White Rabbit with pink eyes ran close by it, and behind them a new kind of authority over Alice. \'Stand up and down looking for eggs, as it can\'t possibly make me grow larger, I can find out the Fish-Footman was gone, and the arm that.',1,NULL,'1b8a6a15402a1212159eb5bda3ccf323',1,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL,NULL),(2,2,1,5,NULL,'Alice. \'And where.','512',512.00,6,'2023-03-07','2023-03-07','2023-06-06','2023-06-06','Quis nihil fuga beatae. Ut libero eligendi provident maiores. Autem quia ut consequatur. Vel exercitationem asperiores rerum ipsum velit est vitae. Cumque voluptas at in quia.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'I know who I am! But I\'d better take him his fan and the White Rabbit with pink eyes ran close by her. There was nothing else to say but \'It belongs to a mouse: she had not the right words,\' said poor Alice, \'to pretend to be done, I wonder?\' Alice guessed in a confused way, \'Prizes! Prizes!\'.',1,NULL,'336960ab164daca74cb379e485921384',1,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL,NULL),(3,3,1,6,NULL,'Footman remarked.','982',982.00,32,'2023-03-27','2023-03-27','2023-07-06','2023-07-06','Commodi iste impedit quam nemo aut asperiores placeat. Eligendi eos laborum quidem. Sit fugiat eius assumenda omnis. Quis commodi dolores rerum ut.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Alice\'s elbow was pressed hard against it, that attempt proved a failure. Alice heard it say to itself, \'Oh dear! Oh dear! I wish I had it written up somewhere.\' Down, down, down. Would the fall was over. Alice was more hopeless than ever: she sat down again in a great hurry; \'this paper has just.',1,NULL,'85e78e09105e340b2896c0eeef003028',1,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL,NULL),(4,4,1,6,NULL,'I believe.\' \'Boots.','708',708.00,17,'2023-03-23','2023-03-23','2023-09-06','2023-09-06','Ut incidunt nesciunt ipsam quia. Et nemo ipsa a facere natus cumque. Amet nisi nesciunt dolorum ad est ut enim.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'In another minute the whole cause, and condemn you to offer it,\' said the March Hare was said to herself what such an extraordinary ways of living would be as well say this), \'to go on till you come and join the dance? Will you, won\'t you join the dance. Would not, could not think of what work it.',1,NULL,'75f414348de7c9737e8f046a78b56252',1,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL,NULL),(5,5,1,13,NULL,'Adventures, till.','167',167.00,24,'2023-03-26','2023-03-26','2023-08-06','2023-08-06','Nihil ut est delectus est enim earum. Aut voluptatum ut officiis ullam molestiae. Dolor sit pariatur deserunt cupiditate sequi.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Mock Turtle: \'nine the next, and so on.\' \'What a curious dream!\' said Alice, who felt very curious sensation, which puzzled her very earnestly, \'Now, Dinah, tell me the list of singers. \'You may not have lived much under the hedge. In another minute there was enough of me left to make out which.',1,NULL,'8bb2690b0b302cef77e11af8fe515a6a',1,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL,NULL),(6,6,1,10,NULL,'I\'m quite tired of.','901',901.00,28,'2023-03-07','2023-03-07','2023-09-06','2023-09-06','Repellat qui laborum inventore est nesciunt temporibus. Ut aut asperiores reiciendis at eaque enim. Voluptas ipsa laboriosam adipisci nesciunt amet ut. Veniam rerum ratione veniam atque sint.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'I\'m here! Digging for apples, yer honour!\' \'Digging for apples, yer honour!\' \'Digging for apples, indeed!\' said the King: \'leave out that she was playing against herself, for this curious child was very provoking to find that she began shrinking directly. As soon as she had quite a chorus of.',1,NULL,'55705be1dde7e22974c0d1a493e8665a',1,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL,NULL),(7,7,1,12,NULL,'I ask! It\'s always.','181',181.00,1,'2023-03-14','2023-03-14','2023-09-06','2023-09-06','Minima corrupti in debitis eius ratione. In sit nisi vitae quia error corporis. Praesentium fuga expedita eaque illum. Doloribus dolorem dolorem et ratione id.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Alice dear!\' said her sister; \'Why, what a delightful thing a Lobster Quadrille is!\' \'No, indeed,\' said Alice. \'You must be,\' said the Mouse was swimming away from her as she did so, and giving it a little before she had hoped) a fan and a fall, and a pair of white kid gloves in one hand and a.',1,NULL,'f0188210efae89216c9be5b1e5a38e1b',1,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL,NULL),(8,8,1,5,NULL,'I might venture to.','171',171.00,31,'2023-04-02','2023-04-02','2023-09-06','2023-09-06','Animi perferendis ea temporibus officia. Non sapiente est ut voluptatum omnis dolor ut.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'The Gryphon sat up and say \"Who am I then? Tell me that first, and then another confusion of voices--\'Hold up his head--Brandy now--Don\'t choke him--How was it, old fellow? What happened to you? Tell us all about as she spoke. Alice did not like the look of it at all. However, \'jury-men\' would.',1,NULL,'1268977fdd1ebef5377d6ecf2a378b4e',1,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL,NULL),(9,9,1,9,NULL,'Alice could only.','639',639.00,15,'2023-04-02','2023-04-02','2023-09-06','2023-09-06','Voluptas nulla sapiente et omnis qui aliquam. Recusandae numquam perspiciatis nulla sit atque accusantium sed. Corrupti odit illo placeat quam.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Alice. \'And where HAVE my shoulders got to? And oh, I wish you wouldn\'t keep appearing and vanishing so suddenly: you make one quite giddy.\' \'All right,\' said the King, looking round the refreshments!\' But there seemed to be rude, so she waited. The Gryphon lifted up both its paws in surprise.',1,NULL,'5510cc4358bda969204d4b3b0b56162d',1,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL,NULL),(10,10,1,3,NULL,'And so it was all.','454',454.00,32,'2023-03-21','2023-03-21','2023-06-06','2023-06-06','Velit sed velit dolorem sint. Qui ut totam et ad nisi sunt. Eligendi omnis fugiat praesentium. Dolore enim vel a nihil et et nostrum.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Alice, \'as all the party were placed along the course, here and there they lay sprawling about, reminding her very much confused, \'I don\'t quite understand you,\' she said, as politely as she spoke--fancy CURTSEYING as you\'re falling through the air! Do you think I can say.\' This was quite silent.',1,NULL,'a4a9a6afb906e2dd1160193817bc2c64',1,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL,NULL);
/*!40000 ALTER TABLE `contracts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `conversation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `conversation` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `user_one` int unsigned NOT NULL,
  `user_two` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conversation_company_id_foreign` (`company_id`),
  KEY `conversation_user_one_foreign` (`user_one`),
  KEY `conversation_user_two_foreign` (`user_two`),
  CONSTRAINT `conversation_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `conversation` WRITE;
/*!40000 ALTER TABLE `conversation` DISABLE KEYS */;
/*!40000 ALTER TABLE `conversation` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `conversation_reply`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `conversation_reply` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `conversation_id` int unsigned NOT NULL,
  `reply` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conversation_reply_company_id_foreign` (`company_id`),
  KEY `conversation_reply_conversation_id_foreign` (`conversation_id`),
  KEY `conversation_reply_user_id_foreign` (`user_id`),
  CONSTRAINT `conversation_reply_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `conversation_reply_conversation_id_foreign` FOREIGN KEY (`conversation_id`) REFERENCES `conversation` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `conversation_reply_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `conversation_reply` WRITE;
/*!40000 ALTER TABLE `conversation_reply` DISABLE KEYS */;
/*!40000 ALTER TABLE `conversation_reply` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `countries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `iso` char(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `nicename` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `iso3` char(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `numcode` smallint DEFAULT NULL,
  `phonecode` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=254 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `countries` WRITE;
/*!40000 ALTER TABLE `countries` DISABLE KEYS */;
INSERT INTO `countries` VALUES (1,'AF','AFGHANISTAN','Afghanistan','AFG',4,93),(2,'AL','ALBANIA','Albania','ALB',8,355),(3,'DZ','ALGERIA','Algeria','DZA',12,213),(4,'AS','AMERICAN SAMOA','American Samoa','ASM',16,1684),(5,'AD','ANDORRA','Andorra','AND',20,376),(6,'AO','ANGOLA','Angola','AGO',24,244),(7,'AI','ANGUILLA','Anguilla','AIA',660,1264),(8,'AQ','ANTARCTICA','Antarctica',NULL,NULL,0),(9,'AG','ANTIGUA AND BARBUDA','Antigua and Barbuda','ATG',28,1268),(10,'AR','ARGENTINA','Argentina','ARG',32,54),(11,'AM','ARMENIA','Armenia','ARM',51,374),(12,'AW','ARUBA','Aruba','ABW',533,297),(13,'AU','AUSTRALIA','Australia','AUS',36,61),(14,'AT','AUSTRIA','Austria','AUT',40,43),(15,'AZ','AZERBAIJAN','Azerbaijan','AZE',31,994),(16,'BS','BAHAMAS','Bahamas','BHS',44,1242),(17,'BH','BAHRAIN','Bahrain','BHR',48,973),(18,'BD','BANGLADESH','Bangladesh','BGD',50,880),(19,'BB','BARBADOS','Barbados','BRB',52,1246),(20,'BY','BELARUS','Belarus','BLR',112,375),(21,'BE','BELGIUM','Belgium','BEL',56,32),(22,'BZ','BELIZE','Belize','BLZ',84,501),(23,'BJ','BENIN','Benin','BEN',204,229),(24,'BM','BERMUDA','Bermuda','BMU',60,1441),(25,'BT','BHUTAN','Bhutan','BTN',64,975),(26,'BO','BOLIVIA','Bolivia','BOL',68,591),(27,'BA','BOSNIA AND HERZEGOVINA','Bosnia and Herzegovina','BIH',70,387),(28,'BW','BOTSWANA','Botswana','BWA',72,267),(29,'BV','BOUVET ISLAND','Bouvet Island',NULL,NULL,0),(30,'BR','BRAZIL','Brazil','BRA',76,55),(31,'IO','BRITISH INDIAN OCEAN TERRITORY','British Indian Ocean Territory',NULL,NULL,246),(32,'BN','BRUNEI DARUSSALAM','Brunei Darussalam','BRN',96,673),(33,'BG','BULGARIA','Bulgaria','BGR',100,359),(34,'BF','BURKINA FASO','Burkina Faso','BFA',854,226),(35,'BI','BURUNDI','Burundi','BDI',108,257),(36,'KH','CAMBODIA','Cambodia','KHM',116,855),(37,'CM','CAMEROON','Cameroon','CMR',120,237),(38,'CA','CANADA','Canada','CAN',124,1),(39,'CV','CAPE VERDE','Cape Verde','CPV',132,238),(40,'KY','CAYMAN ISLANDS','Cayman Islands','CYM',136,1345),(41,'CF','CENTRAL AFRICAN REPUBLIC','Central African Republic','CAF',140,236),(42,'TD','CHAD','Chad','TCD',148,235),(43,'CL','CHILE','Chile','CHL',152,56),(44,'CN','CHINA','China','CHN',156,86),(45,'CX','CHRISTMAS ISLAND','Christmas Island',NULL,NULL,61),(46,'CC','COCOS (KEELING) ISLANDS','Cocos (Keeling) Islands',NULL,NULL,672),(47,'CO','COLOMBIA','Colombia','COL',170,57),(48,'KM','COMOROS','Comoros','COM',174,269),(49,'CG','CONGO','Congo','COG',178,242),(50,'CD','CONGO, THE DEMOCRATIC REPUBLIC OF THE','Congo, the Democratic Republic of the','COD',180,242),(51,'CK','COOK ISLANDS','Cook Islands','COK',184,682),(52,'CR','COSTA RICA','Costa Rica','CRI',188,506),(53,'CI','COTE D\'IVOIRE','Cote D\'Ivoire','CIV',384,225),(54,'HR','CROATIA','Croatia','HRV',191,385),(55,'CU','CUBA','Cuba','CUB',192,53),(56,'CY','CYPRUS','Cyprus','CYP',196,357),(57,'CZ','CZECH REPUBLIC','Czech Republic','CZE',203,420),(58,'DK','DENMARK','Denmark','DNK',208,45),(59,'DJ','DJIBOUTI','Djibouti','DJI',262,253),(60,'DM','DOMINICA','Dominica','DMA',212,1767),(61,'DO','DOMINICAN REPUBLIC','Dominican Republic','DOM',214,1809),(62,'EC','ECUADOR','Ecuador','ECU',218,593),(63,'EG','EGYPT','Egypt','EGY',818,20),(64,'SV','EL SALVADOR','El Salvador','SLV',222,503),(65,'GQ','EQUATORIAL GUINEA','Equatorial Guinea','GNQ',226,240),(66,'ER','ERITREA','Eritrea','ERI',232,291),(67,'EE','ESTONIA','Estonia','EST',233,372),(68,'ET','ETHIOPIA','Ethiopia','ETH',231,251),(69,'FK','FALKLAND ISLANDS (MALVINAS)','Falkland Islands (Malvinas)','FLK',238,500),(70,'FO','FAROE ISLANDS','Faroe Islands','FRO',234,298),(71,'FJ','FIJI','Fiji','FJI',242,679),(72,'FI','FINLAND','Finland','FIN',246,358),(73,'FR','FRANCE','France','FRA',250,33),(74,'GF','FRENCH GUIANA','French Guiana','GUF',254,594),(75,'PF','FRENCH POLYNESIA','French Polynesia','PYF',258,689),(76,'TF','FRENCH SOUTHERN TERRITORIES','French Southern Territories',NULL,NULL,0),(77,'GA','GABON','Gabon','GAB',266,241),(78,'GM','GAMBIA','Gambia','GMB',270,220),(79,'GE','GEORGIA','Georgia','GEO',268,995),(80,'DE','GERMANY','Germany','DEU',276,49),(81,'GH','GHANA','Ghana','GHA',288,233),(82,'GI','GIBRALTAR','Gibraltar','GIB',292,350),(83,'GR','GREECE','Greece','GRC',300,30),(84,'GL','GREENLAND','Greenland','GRL',304,299),(85,'GD','GRENADA','Grenada','GRD',308,1473),(86,'GP','GUADELOUPE','Guadeloupe','GLP',312,590),(87,'GU','GUAM','Guam','GUM',316,1671),(88,'GT','GUATEMALA','Guatemala','GTM',320,502),(89,'GN','GUINEA','Guinea','GIN',324,224),(90,'GW','GUINEA-BISSAU','Guinea-Bissau','GNB',624,245),(91,'GY','GUYANA','Guyana','GUY',328,592),(92,'HT','HAITI','Haiti','HTI',332,509),(93,'HM','HEARD ISLAND AND MCDONALD ISLANDS','Heard Island and Mcdonald Islands',NULL,NULL,0),(94,'VA','HOLY SEE (VATICAN CITY STATE)','Holy See (Vatican City State)','VAT',336,39),(95,'HN','HONDURAS','Honduras','HND',340,504),(96,'HK','HONG KONG','Hong Kong','HKG',344,852),(97,'HU','HUNGARY','Hungary','HUN',348,36),(98,'IS','ICELAND','Iceland','ISL',352,354),(99,'IN','INDIA','India','IND',356,91),(100,'ID','INDONESIA','Indonesia','IDN',360,62),(101,'IR','IRAN, ISLAMIC REPUBLIC OF','Iran, Islamic Republic of','IRN',364,98),(102,'IQ','IRAQ','Iraq','IRQ',368,964),(103,'IE','IRELAND','Ireland','IRL',372,353),(104,'IL','ISRAEL','Israel','ISR',376,972),(105,'IT','ITALY','Italy','ITA',380,39),(106,'JM','JAMAICA','Jamaica','JAM',388,1876),(107,'JP','JAPAN','Japan','JPN',392,81),(108,'JO','JORDAN','Jordan','JOR',400,962),(109,'KZ','KAZAKHSTAN','Kazakhstan','KAZ',398,7),(110,'KE','KENYA','Kenya','KEN',404,254),(111,'KI','KIRIBATI','Kiribati','KIR',296,686),(112,'KP','KOREA, DEMOCRATIC PEOPLE\'S REPUBLIC OF','Korea, Democratic People\'s Republic of','PRK',408,850),(113,'KR','KOREA, REPUBLIC OF','Korea, Republic of','KOR',410,82),(114,'KW','KUWAIT','Kuwait','KWT',414,965),(115,'KG','KYRGYZSTAN','Kyrgyzstan','KGZ',417,996),(116,'LA','LAO PEOPLE\'S DEMOCRATIC REPUBLIC','Lao People\'s Democratic Republic','LAO',418,856),(117,'LV','LATVIA','Latvia','LVA',428,371),(118,'LB','LEBANON','Lebanon','LBN',422,961),(119,'LS','LESOTHO','Lesotho','LSO',426,266),(120,'LR','LIBERIA','Liberia','LBR',430,231),(121,'LY','LIBYAN ARAB JAMAHIRIYA','Libyan Arab Jamahiriya','LBY',434,218),(122,'LI','LIECHTENSTEIN','Liechtenstein','LIE',438,423),(123,'LT','LITHUANIA','Lithuania','LTU',440,370),(124,'LU','LUXEMBOURG','Luxembourg','LUX',442,352),(125,'MO','MACAO','Macao','MAC',446,853),(126,'MK','MACEDONIA, THE FORMER YUGOSLAV REPUBLIC OF','Macedonia, the Former Yugoslav Republic of','MKD',807,389),(127,'MG','MADAGASCAR','Madagascar','MDG',450,261),(128,'MW','MALAWI','Malawi','MWI',454,265),(129,'MY','MALAYSIA','Malaysia','MYS',458,60),(130,'MV','MALDIVES','Maldives','MDV',462,960),(131,'ML','MALI','Mali','MLI',466,223),(132,'MT','MALTA','Malta','MLT',470,356),(133,'MH','MARSHALL ISLANDS','Marshall Islands','MHL',584,692),(134,'MQ','MARTINIQUE','Martinique','MTQ',474,596),(135,'MR','MAURITANIA','Mauritania','MRT',478,222),(136,'MU','MAURITIUS','Mauritius','MUS',480,230),(137,'YT','MAYOTTE','Mayotte',NULL,NULL,269),(138,'MX','MEXICO','Mexico','MEX',484,52),(139,'FM','MICRONESIA, FEDERATED STATES OF','Micronesia, Federated States of','FSM',583,691),(140,'MD','MOLDOVA, REPUBLIC OF','Moldova, Republic of','MDA',498,373),(141,'MC','MONACO','Monaco','MCO',492,377),(142,'MN','MONGOLIA','Mongolia','MNG',496,976),(143,'MS','MONTSERRAT','Montserrat','MSR',500,1664),(144,'MA','MOROCCO','Morocco','MAR',504,212),(145,'MZ','MOZAMBIQUE','Mozambique','MOZ',508,258),(146,'MM','MYANMAR','Myanmar','MMR',104,95),(147,'NA','NAMIBIA','Namibia','NAM',516,264),(148,'NR','NAURU','Nauru','NRU',520,674),(149,'NP','NEPAL','Nepal','NPL',524,977),(150,'NL','NETHERLANDS','Netherlands','NLD',528,31),(151,'AN','NETHERLANDS ANTILLES','Netherlands Antilles','ANT',530,599),(152,'NC','NEW CALEDONIA','New Caledonia','NCL',540,687),(153,'NZ','NEW ZEALAND','New Zealand','NZL',554,64),(154,'NI','NICARAGUA','Nicaragua','NIC',558,505),(155,'NE','NIGER','Niger','NER',562,227),(156,'NG','NIGERIA','Nigeria','NGA',566,234),(157,'NU','NIUE','Niue','NIU',570,683),(158,'NF','NORFOLK ISLAND','Norfolk Island','NFK',574,672),(159,'MP','NORTHERN MARIANA ISLANDS','Northern Mariana Islands','MNP',580,1670),(160,'NO','NORWAY','Norway','NOR',578,47),(161,'OM','OMAN','Oman','OMN',512,968),(162,'PK','PAKISTAN','Pakistan','PAK',586,92),(163,'PW','PALAU','Palau','PLW',585,680),(164,'PS','PALESTINIAN TERRITORY, OCCUPIED','Palestinian Territory, Occupied',NULL,NULL,970),(165,'PA','PANAMA','Panama','PAN',591,507),(166,'PG','PAPUA NEW GUINEA','Papua New Guinea','PNG',598,675),(167,'PY','PARAGUAY','Paraguay','PRY',600,595),(168,'PE','PERU','Peru','PER',604,51),(169,'PH','PHILIPPINES','Philippines','PHL',608,63),(170,'PN','PITCAIRN','Pitcairn','PCN',612,0),(171,'PL','POLAND','Poland','POL',616,48),(172,'PT','PORTUGAL','Portugal','PRT',620,351),(173,'PR','PUERTO RICO','Puerto Rico','PRI',630,1787),(174,'QA','QATAR','Qatar','QAT',634,974),(175,'RE','REUNION','Reunion','REU',638,262),(176,'RO','ROMANIA','Romania','ROM',642,40),(177,'RU','RUSSIAN FEDERATION','Russian Federation','RUS',643,70),(178,'RW','RWANDA','Rwanda','RWA',646,250),(179,'SH','SAINT HELENA','Saint Helena','SHN',654,290),(180,'KN','SAINT KITTS AND NEVIS','Saint Kitts and Nevis','KNA',659,1869),(181,'LC','SAINT LUCIA','Saint Lucia','LCA',662,1758),(182,'PM','SAINT PIERRE AND MIQUELON','Saint Pierre and Miquelon','SPM',666,508),(183,'VC','SAINT VINCENT AND THE GRENADINES','Saint Vincent and the Grenadines','VCT',670,1784),(184,'WS','SAMOA','Samoa','WSM',882,684),(185,'SM','SAN MARINO','San Marino','SMR',674,378),(186,'ST','SAO TOME AND PRINCIPE','Sao Tome and Principe','STP',678,239),(187,'SA','SAUDI ARABIA','Saudi Arabia','SAU',682,966),(188,'SN','SENEGAL','Senegal','SEN',686,221),(189,'CS','SERBIA AND MONTENEGRO','Serbia and Montenegro',NULL,NULL,381),(190,'SC','SEYCHELLES','Seychelles','SYC',690,248),(191,'SL','SIERRA LEONE','Sierra Leone','SLE',694,232),(192,'SG','SINGAPORE','Singapore','SGP',702,65),(193,'SK','SLOVAKIA','Slovakia','SVK',703,421),(194,'SI','SLOVENIA','Slovenia','SVN',705,386),(195,'SB','SOLOMON ISLANDS','Solomon Islands','SLB',90,677),(196,'SO','SOMALIA','Somalia','SOM',706,252),(197,'ZA','SOUTH AFRICA','South Africa','ZAF',710,27),(198,'GS','SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS','South Georgia and the South Sandwich Islands',NULL,NULL,0),(199,'ES','SPAIN','Spain','ESP',724,34),(200,'LK','SRI LANKA','Sri Lanka','LKA',144,94),(201,'SD','SUDAN','Sudan','SDN',736,249),(202,'SR','SURINAME','Suriname','SUR',740,597),(203,'SJ','SVALBARD AND JAN MAYEN','Svalbard and Jan Mayen','SJM',744,47),(204,'SZ','SWAZILAND','Swaziland','SWZ',748,268),(205,'SE','SWEDEN','Sweden','SWE',752,46),(206,'CH','SWITZERLAND','Switzerland','CHE',756,41),(207,'SY','SYRIAN ARAB REPUBLIC','Syrian Arab Republic','SYR',760,963),(208,'TW','TAIWAN, PROVINCE OF CHINA','Taiwan, Province of China','TWN',158,886),(209,'TJ','TAJIKISTAN','Tajikistan','TJK',762,992),(210,'TZ','TANZANIA, UNITED REPUBLIC OF','Tanzania, United Republic of','TZA',834,255),(211,'TH','THAILAND','Thailand','THA',764,66),(212,'TL','TIMOR-LESTE','Timor-Leste',NULL,NULL,670),(213,'TG','TOGO','Togo','TGO',768,228),(214,'TK','TOKELAU','Tokelau','TKL',772,690),(215,'TO','TONGA','Tonga','TON',776,676),(216,'TT','TRINIDAD AND TOBAGO','Trinidad and Tobago','TTO',780,1868),(217,'TN','TUNISIA','Tunisia','TUN',788,216),(218,'TR','TURKEY','Turkey','TUR',792,90),(219,'TM','TURKMENISTAN','Turkmenistan','TKM',795,7370),(220,'TC','TURKS AND CAICOS ISLANDS','Turks and Caicos Islands','TCA',796,1649),(221,'TV','TUVALU','Tuvalu','TUV',798,688),(222,'UG','UGANDA','Uganda','UGA',800,256),(223,'UA','UKRAINE','Ukraine','UKR',804,380),(224,'AE','UNITED ARAB EMIRATES','United Arab Emirates','ARE',784,971),(225,'GB','UNITED KINGDOM','United Kingdom','GBR',826,44),(226,'US','UNITED STATES','United States','USA',840,1),(227,'UM','UNITED STATES MINOR OUTLYING ISLANDS','United States Minor Outlying Islands',NULL,NULL,1),(228,'UY','URUGUAY','Uruguay','URY',858,598),(229,'UZ','UZBEKISTAN','Uzbekistan','UZB',860,998),(230,'VU','VANUATU','Vanuatu','VUT',548,678),(231,'VE','VENEZUELA','Venezuela','VEN',862,58),(232,'VN','VIET NAM','Viet Nam','VNM',704,84),(233,'VG','VIRGIN ISLANDS, BRITISH','Virgin Islands, British','VGB',92,1284),(234,'VI','VIRGIN ISLANDS, U.S.','Virgin Islands, U.s.','VIR',850,1340),(235,'WF','WALLIS AND FUTUNA','Wallis and Futuna','WLF',876,681),(236,'EH','WESTERN SAHARA','Western Sahara','ESH',732,212),(237,'YE','YEMEN','Yemen','YEM',887,967),(238,'ZM','ZAMBIA','Zambia','ZMB',894,260),(239,'ZW','ZIMBABWE','Zimbabwe','ZWE',716,263),(240,'RS','SERBIA','Serbia','SRB',688,381),(241,'AP','ASIA PACIFIC REGION','Asia / Pacific Region','0',0,0),(242,'ME','MONTENEGRO','Montenegro','MNE',499,382),(243,'AX','ALAND ISLANDS','Aland Islands','ALA',248,358),(244,'BQ','BONAIRE, SINT EUSTATIUS AND SABA','Bonaire, Sint Eustatius and Saba','BES',535,599),(245,'CW','CURACAO','Curacao','CUW',531,599),(246,'GG','GUERNSEY','Guernsey','GGY',831,44),(247,'IM','ISLE OF MAN','Isle of Man','IMN',833,44),(248,'JE','JERSEY','Jersey','JEY',832,44),(249,'XK','KOSOVO','Kosovo','---',0,381),(250,'BL','SAINT BARTHELEMY','Saint Barthelemy','BLM',652,590),(251,'MF','SAINT MARTIN','Saint Martin','MAF',663,590),(252,'SX','SINT MAARTEN','Sint Maarten','SXM',534,1),(253,'SS','SOUTH SUDAN','South Sudan','SSD',728,211);
/*!40000 ALTER TABLE `countries` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `credit_note_item_images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `credit_note_item_images` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `credit_note_item_id` int unsigned NOT NULL,
  `filename` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hashname` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `credit_note_item_images_credit_note_item_id_foreign` (`credit_note_item_id`),
  CONSTRAINT `credit_note_item_images_credit_note_item_id_foreign` FOREIGN KEY (`credit_note_item_id`) REFERENCES `credit_note_items` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `credit_note_item_images` WRITE;
/*!40000 ALTER TABLE `credit_note_item_images` DISABLE KEYS */;
/*!40000 ALTER TABLE `credit_note_item_images` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `credit_note_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `credit_note_items` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `credit_note_id` int unsigned NOT NULL,
  `item_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` enum('item','discount','tax') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'item',
  `quantity` int NOT NULL,
  `unit_price` double(8,2) NOT NULL,
  `amount` double(8,2) NOT NULL,
  `taxes` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hsn_sac_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item_summary` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `credit_note_items_credit_note_id_foreign` (`credit_note_id`),
  CONSTRAINT `credit_note_items_credit_note_id_foreign` FOREIGN KEY (`credit_note_id`) REFERENCES `credit_notes` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `credit_note_items` WRITE;
/*!40000 ALTER TABLE `credit_note_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `credit_note_items` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `credit_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `credit_notes` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `project_id` int unsigned DEFAULT NULL,
  `client_id` int unsigned DEFAULT NULL,
  `cn_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `invoice_id` int unsigned DEFAULT NULL,
  `issue_date` date NOT NULL,
  `due_date` date NOT NULL,
  `discount` double NOT NULL DEFAULT '0',
  `discount_type` enum('percent','fixed') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'percent',
  `sub_total` double(15,2) NOT NULL,
  `total` double(15,2) NOT NULL,
  `adjustment_amount` double(8,2) DEFAULT NULL,
  `currency_id` int unsigned DEFAULT NULL,
  `status` enum('closed','open') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `recurring` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `billing_frequency` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `billing_interval` int DEFAULT NULL,
  `billing_cycle` int DEFAULT NULL,
  `file` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file_original_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `calculate_tax` enum('after_discount','before_discount') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'after_discount',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `unit_id` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `credit_notes_company_id_foreign` (`company_id`),
  KEY `credit_notes_project_id_foreign` (`project_id`),
  KEY `credit_notes_client_id_foreign` (`client_id`),
  KEY `credit_notes_currency_id_foreign` (`currency_id`),
  KEY `credit_notes_added_by_foreign` (`added_by`),
  KEY `credit_notes_last_updated_by_foreign` (`last_updated_by`),
  KEY `credit_notes_unit_id_foreign` (`unit_id`),
  CONSTRAINT `credit_notes_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `credit_notes_client_id_foreign` FOREIGN KEY (`client_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `credit_notes_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `credit_notes_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `credit_notes_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `credit_notes_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `credit_notes_unit_id_foreign` FOREIGN KEY (`unit_id`) REFERENCES `unit_types` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `credit_notes` WRITE;
/*!40000 ALTER TABLE `credit_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `credit_notes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `currencies` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `currency_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency_symbol` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `currency_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `exchange_rate` double DEFAULT NULL,
  `is_cryptocurrency` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `usd_price` double DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `currency_position` enum('left','right','left_with_space','right_with_space') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'left',
  `no_of_decimal` int unsigned NOT NULL,
  `thousand_separator` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `decimal_separator` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `currencies_company_id_foreign` (`company_id`),
  CONSTRAINT `currencies_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `currencies` WRITE;
/*!40000 ALTER TABLE `currencies` DISABLE KEYS */;
INSERT INTO `currencies` VALUES (1,1,'Dollars','$','USD',1,'no',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16','left',2,',','.'),(2,1,'Pounds','£','GBP',1,'no',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16','left',2,',','.'),(3,1,'Euros','€','EUR',1,'no',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16','left',2,',','.'),(4,1,'Rupee','₹','INR',1,'no',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16','left',2,',','.');
/*!40000 ALTER TABLE `currencies` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `currency_format_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `currency_format_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `currency_position` enum('left','right','left_with_space','right_with_space') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'left',
  `no_of_decimal` int unsigned NOT NULL,
  `thousand_separator` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `decimal_separator` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `currency_format_settings_company_id_foreign` (`company_id`),
  CONSTRAINT `currency_format_settings_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `currency_format_settings` WRITE;
/*!40000 ALTER TABLE `currency_format_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `currency_format_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `custom_field_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `custom_field_groups` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `model` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `custom_field_groups_company_id_foreign` (`company_id`),
  KEY `custom_field_groups_model_index` (`model`),
  CONSTRAINT `custom_field_groups_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `custom_field_groups` WRITE;
/*!40000 ALTER TABLE `custom_field_groups` DISABLE KEYS */;
INSERT INTO `custom_field_groups` VALUES (1,1,'Client','App\\Models\\ClientDetails'),(2,1,'Employee','App\\Models\\EmployeeDetails'),(3,1,'Project','App\\Models\\Project'),(4,1,'Invoice','App\\Models\\Invoice'),(5,1,'Estimate','App\\Models\\Estimate'),(6,1,'Task','App\\Models\\Task'),(7,1,'Expense','App\\Models\\Expense'),(8,1,'Lead','App\\Models\\Lead'),(9,1,'Product','App\\Models\\Product'),(10,1,'Ticket','App\\Models\\Ticket'),(11,1,'Time Log','App\\Models\\ProjectTimeLog'),(12,1,'Contract','App\\Models\\Contract');
/*!40000 ALTER TABLE `custom_field_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `custom_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `custom_fields` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `custom_field_group_id` int unsigned DEFAULT NULL,
  `label` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `required` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `values` varchar(5000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `export` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `custom_fields_company_id_foreign` (`company_id`),
  KEY `custom_fields_custom_field_group_id_foreign` (`custom_field_group_id`),
  CONSTRAINT `custom_fields_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `custom_fields_custom_field_group_id_foreign` FOREIGN KEY (`custom_field_group_id`) REFERENCES `custom_field_groups` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `custom_fields` WRITE;
/*!40000 ALTER TABLE `custom_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `custom_fields` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `custom_fields_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `custom_fields_data` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `custom_field_id` int unsigned NOT NULL,
  `model_id` int unsigned NOT NULL,
  `model` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(10000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `custom_fields_data_custom_field_id_foreign` (`custom_field_id`),
  KEY `custom_fields_data_model_index` (`model`),
  CONSTRAINT `custom_fields_data_custom_field_id_foreign` FOREIGN KEY (`custom_field_id`) REFERENCES `custom_fields` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `custom_fields_data` WRITE;
/*!40000 ALTER TABLE `custom_fields_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `custom_fields_data` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `dashboard_widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `widget_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `dashboard_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dashboard_widgets_company_id_foreign` (`company_id`),
  CONSTRAINT `dashboard_widgets_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=82 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `dashboard_widgets` WRITE;
/*!40000 ALTER TABLE `dashboard_widgets` DISABLE KEYS */;
INSERT INTO `dashboard_widgets` VALUES (1,1,'total_clients',1,'admin-dashboard',NULL,NULL),(2,1,'total_employees',1,'admin-dashboard',NULL,NULL),(3,1,'total_projects',1,'admin-dashboard',NULL,NULL),(4,1,'total_unpaid_invoices',1,'admin-dashboard',NULL,NULL),(5,1,'total_hours_logged',1,'admin-dashboard',NULL,NULL),(6,1,'total_pending_tasks',1,'admin-dashboard',NULL,NULL),(7,1,'total_today_attendance',1,'admin-dashboard',NULL,NULL),(8,1,'total_unresolved_tickets',1,'admin-dashboard',NULL,NULL),(9,1,'recent_earnings',1,'admin-dashboard',NULL,NULL),(10,1,'settings_leaves',1,'admin-dashboard',NULL,NULL),(11,1,'new_tickets',1,'admin-dashboard',NULL,NULL),(12,1,'overdue_tasks',1,'admin-dashboard',NULL,NULL),(13,1,'pending_follow_up',1,'admin-dashboard',NULL,NULL),(14,1,'project_activity_timeline',1,'admin-dashboard',NULL,NULL),(15,1,'user_activity_timeline',1,'admin-dashboard',NULL,NULL),(16,1,'timelogs',1,'admin-dashboard',NULL,NULL),(17,1,'total_clients',1,'admin-client-dashboard',NULL,NULL),(18,1,'total_leads',1,'admin-client-dashboard',NULL,NULL),(19,1,'total_lead_conversions',1,'admin-client-dashboard',NULL,NULL),(20,1,'total_contracts_generated',1,'admin-client-dashboard',NULL,NULL),(21,1,'total_contracts_signed',1,'admin-client-dashboard',NULL,NULL),(22,1,'client_wise_earnings',1,'admin-client-dashboard',NULL,NULL),(23,1,'client_wise_timelogs',1,'admin-client-dashboard',NULL,NULL),(24,1,'lead_vs_status',1,'admin-client-dashboard',NULL,NULL),(25,1,'lead_vs_source',1,'admin-client-dashboard',NULL,NULL),(26,1,'latest_client',1,'admin-client-dashboard',NULL,NULL),(27,1,'recent_login_activities',1,'admin-client-dashboard',NULL,NULL),(28,1,'total_paid_invoices',1,'admin-finance-dashboard',NULL,NULL),(29,1,'total_expenses',1,'admin-finance-dashboard',NULL,NULL),(30,1,'total_earnings',1,'admin-finance-dashboard',NULL,NULL),(31,1,'total_pending_amount',1,'admin-finance-dashboard',NULL,NULL),(32,1,'invoice_overview',1,'admin-finance-dashboard',NULL,NULL),(33,1,'estimate_overview',1,'admin-finance-dashboard',NULL,NULL),(34,1,'proposal_overview',1,'admin-finance-dashboard',NULL,NULL),(35,1,'earnings_by_client',1,'admin-finance-dashboard',NULL,NULL),(36,1,'earnings_by_projects',1,'admin-finance-dashboard',NULL,NULL),(37,1,'total_unpaid_invoices',1,'admin-finance-dashboard',NULL,NULL),(38,1,'total_leaves_approved',1,'admin-hr-dashboard',NULL,NULL),(39,1,'total_new_employee',1,'admin-hr-dashboard',NULL,NULL),(40,1,'total_employee_exits',1,'admin-hr-dashboard',NULL,NULL),(41,1,'average_attendance',1,'admin-hr-dashboard',NULL,NULL),(42,1,'department_wise_employee',1,'admin-hr-dashboard',NULL,NULL),(43,1,'designation_wise_employee',1,'admin-hr-dashboard',NULL,NULL),(44,1,'gender_wise_employee',1,'admin-hr-dashboard',NULL,NULL),(45,1,'role_wise_employee',1,'admin-hr-dashboard',NULL,NULL),(46,1,'leaves_taken',1,'admin-hr-dashboard',NULL,NULL),(47,1,'late_attendance_mark',1,'admin-hr-dashboard',NULL,NULL),(48,1,'headcount',1,'admin-hr-dashboard',NULL,NULL),(49,1,'joining_vs_attrition',1,'admin-hr-dashboard',NULL,NULL),(50,1,'birthday',1,'admin-hr-dashboard',NULL,NULL),(51,1,'total_today_attendance',1,'admin-hr-dashboard',NULL,NULL),(52,1,'total_project',1,'admin-project-dashboard',NULL,NULL),(53,1,'total_hours_logged',1,'admin-project-dashboard',NULL,NULL),(54,1,'total_overdue_project',1,'admin-project-dashboard',NULL,NULL),(55,1,'status_wise_project',1,'admin-project-dashboard',NULL,NULL),(56,1,'pending_milestone',1,'admin-project-dashboard',NULL,NULL),(57,1,'total_tickets',1,'admin-ticket-dashboard',NULL,NULL),(58,1,'total_unassigned_ticket',1,'admin-ticket-dashboard',NULL,NULL),(59,1,'type_wise_ticket',1,'admin-ticket-dashboard',NULL,NULL),(60,1,'status_wise_ticket',1,'admin-ticket-dashboard',NULL,NULL),(61,1,'channel_wise_ticket',1,'admin-ticket-dashboard',NULL,NULL),(62,1,'new_tickets',1,'admin-ticket-dashboard',NULL,NULL),(63,1,'profile',1,'private-dashboard',NULL,NULL),(64,1,'shift_schedule',1,'private-dashboard',NULL,NULL),(65,1,'birthday',1,'private-dashboard',NULL,NULL),(66,1,'notices',1,'private-dashboard',NULL,NULL),(67,1,'tasks',1,'private-dashboard',NULL,NULL),(68,1,'projects',1,'private-dashboard',NULL,NULL),(69,1,'my_task',1,'private-dashboard',NULL,NULL),(70,1,'my_calender',1,'private-dashboard',NULL,NULL),(71,1,'week_timelog',1,'private-dashboard',NULL,NULL),(72,1,'leave',1,'private-dashboard',NULL,NULL),(73,1,'lead',1,'private-dashboard',NULL,NULL),(74,1,'work_from_home',1,'private-dashboard',NULL,NULL),(75,1,'appreciation',1,'private-dashboard',NULL,NULL),(76,1,'work_anniversary',1,'private-dashboard',NULL,NULL),(77,1,'ticket',1,'private-dashboard',NULL,NULL),(78,1,'notice_period_duration',1,'private-dashboard',NULL,NULL),(79,1,'probation_date',1,'private-dashboard',NULL,NULL),(80,1,'contract_date',1,'private-dashboard',NULL,NULL),(81,1,'internship_date',1,'private-dashboard',NULL,NULL);
/*!40000 ALTER TABLE `dashboard_widgets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `database_backup_cron_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `database_backup_cron_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `status` enum('active','inactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'inactive',
  `hour_of_day` time DEFAULT NULL,
  `backup_after_days` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `delete_backup_after_days` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `database_backup_cron_settings` WRITE;
/*!40000 ALTER TABLE `database_backup_cron_settings` DISABLE KEYS */;
INSERT INTO `database_backup_cron_settings` VALUES (1,'inactive','00:00:00','0','0');
/*!40000 ALTER TABLE `database_backup_cron_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `database_backups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `database_backups` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `filename` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `database_backups` WRITE;
/*!40000 ALTER TABLE `database_backups` DISABLE KEYS */;
/*!40000 ALTER TABLE `database_backups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `designations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `designations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` int unsigned DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `designations_company_id_foreign` (`company_id`),
  KEY `designations_added_by_foreign` (`added_by`),
  KEY `designations_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `designations_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `designations_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `designations_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `designations` WRITE;
/*!40000 ALTER TABLE `designations` DISABLE KEYS */;
INSERT INTO `designations` VALUES (1,1,'Trainee',NULL,NULL,NULL,NULL,NULL),(2,1,'Senior',NULL,NULL,NULL,NULL,NULL),(3,1,'Junior',NULL,NULL,NULL,NULL,NULL),(4,1,'Team Lead',NULL,NULL,NULL,NULL,NULL),(5,1,'Project Manager',NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `designations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `devices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `devices` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL,
  `device_id` bigint unsigned NOT NULL,
  `registration_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `details` varchar(1000) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` enum('active','inactive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `devices_user_id_foreign` (`user_id`),
  CONSTRAINT `devices_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `devices` WRITE;
/*!40000 ALTER TABLE `devices` DISABLE KEYS */;
/*!40000 ALTER TABLE `devices` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `discussion_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `discussion_categories` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `order` int NOT NULL DEFAULT '1',
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `discussion_categories_company_id_foreign` (`company_id`),
  CONSTRAINT `discussion_categories_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `discussion_categories` WRITE;
/*!40000 ALTER TABLE `discussion_categories` DISABLE KEYS */;
INSERT INTO `discussion_categories` VALUES (1,1,1,'General','#3498DB','2023-04-06 06:33:16','2023-04-06 06:33:16');
/*!40000 ALTER TABLE `discussion_categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `discussion_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `discussion_files` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `discussion_id` int unsigned DEFAULT NULL,
  `discussion_reply_id` int unsigned DEFAULT NULL,
  `filename` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `google_url` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hashname` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dropbox_link` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `discussion_files_company_id_foreign` (`company_id`),
  KEY `discussion_files_user_id_foreign` (`user_id`),
  KEY `discussion_files_discussion_id_foreign` (`discussion_id`),
  KEY `discussion_files_discussion_reply_id_foreign` (`discussion_reply_id`),
  CONSTRAINT `discussion_files_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `discussion_files_discussion_id_foreign` FOREIGN KEY (`discussion_id`) REFERENCES `discussions` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `discussion_files_discussion_reply_id_foreign` FOREIGN KEY (`discussion_reply_id`) REFERENCES `discussion_replies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `discussion_files_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `discussion_files` WRITE;
/*!40000 ALTER TABLE `discussion_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `discussion_files` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `discussion_replies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `discussion_replies` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `discussion_id` int unsigned NOT NULL,
  `user_id` int unsigned NOT NULL,
  `body` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `discussion_replies_discussion_id_foreign` (`discussion_id`),
  KEY `discussion_replies_user_id_foreign` (`user_id`),
  KEY `discussion_replies_company_id_foreign` (`company_id`),
  CONSTRAINT `discussion_replies_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `discussion_replies_discussion_id_foreign` FOREIGN KEY (`discussion_id`) REFERENCES `discussions` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `discussion_replies_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `discussion_replies` WRITE;
/*!40000 ALTER TABLE `discussion_replies` DISABLE KEYS */;
/*!40000 ALTER TABLE `discussion_replies` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `discussions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `discussions` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `discussion_category_id` int unsigned DEFAULT '1',
  `project_id` int unsigned DEFAULT NULL,
  `title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '#232629',
  `user_id` int unsigned NOT NULL,
  `pinned` tinyint(1) NOT NULL DEFAULT '0',
  `closed` tinyint(1) NOT NULL DEFAULT '0',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `last_reply_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `best_answer_id` int unsigned DEFAULT NULL,
  `last_reply_by_id` int unsigned DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `discussions_discussion_category_id_foreign` (`discussion_category_id`),
  KEY `discussions_project_id_foreign` (`project_id`),
  KEY `discussions_user_id_foreign` (`user_id`),
  KEY `discussions_best_answer_id_foreign` (`best_answer_id`),
  KEY `discussions_last_reply_by_id_foreign` (`last_reply_by_id`),
  KEY `discussions_added_by_foreign` (`added_by`),
  KEY `discussions_last_updated_by_foreign` (`last_updated_by`),
  KEY `discussions_company_id_foreign` (`company_id`),
  CONSTRAINT `discussions_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `discussions_best_answer_id_foreign` FOREIGN KEY (`best_answer_id`) REFERENCES `discussion_replies` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `discussions_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `discussions_discussion_category_id_foreign` FOREIGN KEY (`discussion_category_id`) REFERENCES `discussion_categories` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `discussions_last_reply_by_id_foreign` FOREIGN KEY (`last_reply_by_id`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `discussions_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `discussions_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `discussions_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `discussions` WRITE;
/*!40000 ALTER TABLE `discussions` DISABLE KEYS */;
/*!40000 ALTER TABLE `discussions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `email_notification_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `email_notification_settings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `slug` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `setting_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `send_email` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `send_slack` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `send_push` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `send_twilio` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  PRIMARY KEY (`id`),
  KEY `email_notification_settings_company_id_foreign` (`company_id`),
  CONSTRAINT `email_notification_settings_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `email_notification_settings` WRITE;
/*!40000 ALTER TABLE `email_notification_settings` DISABLE KEYS */;
INSERT INTO `email_notification_settings` VALUES (1,1,NULL,NULL,'new-expenseadded-by-admin','New Expense/Added by Admin','yes','no','no','no'),(2,1,NULL,NULL,'new-expenseadded-by-member','New Expense/Added by Member','yes','no','no','no'),(3,1,NULL,NULL,'expense-status-changed','Expense Status Changed','yes','no','no','no'),(4,1,NULL,NULL,'new-support-ticket-request','New Support Ticket Request','yes','no','no','no'),(5,1,NULL,NULL,'new-leave-application','New Leave Application','yes','no','no','no'),(6,1,NULL,NULL,'task-completed','Task Completed','yes','no','no','no'),(7,1,NULL,NULL,'invoice-createupdate-notification','Invoice Create/Update Notification','yes','no','no','no'),(8,1,NULL,NULL,'discussion-reply','Discussion Reply','yes','no','no','no'),(9,1,NULL,NULL,'new-product-purchase-request','New Product Purchase Request','yes','no','no','no'),(10,1,NULL,NULL,'lead-notification','Lead notification','yes','no','no','no'),(11,1,NULL,NULL,'order-createupdate-notification','Order Create/Update Notification','no','no','no','no'),(12,1,NULL,NULL,'user-join-via-invitation','User Join via Invitation','no','no','no','no'),(13,1,NULL,NULL,'follow-up-reminder','Follow Up Reminder','no','no','no','no'),(14,1,NULL,NULL,'user-registrationadded-by-admin','User Registration/Added by Admin','yes','no','no','no'),(15,1,NULL,NULL,'employee-assign-to-project','Employee Assign to Project','yes','no','no','no'),(16,1,NULL,NULL,'new-notice-published','New Notice Published','no','no','no','no'),(17,1,NULL,NULL,'user-assign-to-task','User Assign to Task','yes','no','no','no'),(18,1,NULL,NULL,'birthday-notification','Birthday notification','yes','yes','no','no'),(19,1,NULL,NULL,'payment-notification','Payment Notification','yes','no','no','no'),(20,1,NULL,NULL,'appreciation-notification','Employee Appreciation','yes','no','no','no'),(21,1,NULL,NULL,'clock-in-notification','Clock In Notification','no','no','no','no'),(22,1,NULL,NULL,'holiday-notification','Holiday Notification','no','no','no','no'),(23,1,NULL,NULL,'estimate-notification','Estimate Notification','yes','no','no','no'),(24,1,NULL,NULL,'event-notification','Event Notification','yes','no','no','no'),(25,1,NULL,NULL,'message-notification','Message Notification','yes','no','no','no');
/*!40000 ALTER TABLE `email_notification_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `emergency_contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `emergency_contacts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `relation` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `emergency_contacts_company_id_foreign` (`company_id`),
  KEY `emergency_contacts_user_id_foreign` (`user_id`),
  KEY `emergency_contacts_added_by_foreign` (`added_by`),
  KEY `emergency_contacts_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `emergency_contacts_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `emergency_contacts_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `emergency_contacts_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `emergency_contacts_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `emergency_contacts` WRITE;
/*!40000 ALTER TABLE `emergency_contacts` DISABLE KEYS */;
/*!40000 ALTER TABLE `emergency_contacts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `employee_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `employee_details` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `employee_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `hourly_rate` double DEFAULT NULL,
  `slack_username` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `department_id` int unsigned DEFAULT NULL,
  `designation_id` bigint unsigned DEFAULT NULL,
  `joining_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `last_date` date DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `attendance_reminder` date DEFAULT NULL,
  `date_of_birth` date DEFAULT NULL,
  `calendar_view` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `about_me` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `reporting_to` int unsigned DEFAULT NULL,
  `contract_end_date` date DEFAULT NULL,
  `internship_end_date` date DEFAULT NULL,
  `employment_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `marriage_anniversary_date` date DEFAULT NULL,
  `marital_status` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `notice_period_end_date` date DEFAULT NULL,
  `notice_period_start_date` date DEFAULT NULL,
  `probation_end_date` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `employee_details_employee_id_company_id_unique` (`employee_id`,`company_id`),
  UNIQUE KEY `employee_details_slack_username_company_id_unique` (`slack_username`,`company_id`),
  KEY `employee_details_company_id_foreign` (`company_id`),
  KEY `employee_details_user_id_foreign` (`user_id`),
  KEY `employee_details_department_id_foreign` (`department_id`),
  KEY `employee_details_designation_id_foreign` (`designation_id`),
  KEY `employee_details_added_by_foreign` (`added_by`),
  KEY `employee_details_last_updated_by_foreign` (`last_updated_by`),
  KEY `employee_details_reporting_to_foreign` (`reporting_to`),
  CONSTRAINT `employee_details_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `employee_details_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employee_details_department_id_foreign` FOREIGN KEY (`department_id`) REFERENCES `teams` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `employee_details_designation_id_foreign` FOREIGN KEY (`designation_id`) REFERENCES `designations` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employee_details_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `employee_details_reporting_to_foreign` FOREIGN KEY (`reporting_to`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `employee_details_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `employee_details` WRITE;
/*!40000 ALTER TABLE `employee_details` DISABLE KEYS */;
INSERT INTO `employee_details` VALUES (1,1,1,'EMP-1','70514 Letitia Mount Suite 559\nNew Cleta, WY 13397',20,NULL,2,4,'2022-07-06 06:33:16',NULL,NULL,NULL,NULL,NULL,'task,events,holiday,tickets,leaves','I am super human',NULL,NULL,NULL,NULL,NULL,'unmarried',NULL,NULL,NULL,'2023-04-06 06:33:16','2023-04-06 06:34:20'),(2,1,2,'EMP-2','36341 Nicolas Circle Apt. 207\nNorth Valentine, IN 04800-7943',51,NULL,2,4,'2022-07-06 06:33:16',NULL,NULL,NULL,NULL,NULL,'task,events,holiday,tickets,leaves','I am super human',NULL,NULL,NULL,NULL,NULL,'unmarried',NULL,NULL,NULL,'2023-04-06 06:33:16','2023-04-06 06:34:20'),(3,1,14,'EMP-3','657 Jody Brook Suite 404\nLake Minervaton, NY 40929',61,NULL,4,4,'2022-07-06 06:33:18',NULL,NULL,NULL,NULL,NULL,'task,events,holiday,tickets,leaves','I am super human',NULL,NULL,NULL,NULL,NULL,'unmarried',NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:34:20'),(4,1,15,'EMP-4','6666 Jensen Falls Apt. 725\nLaurianneburgh, NJ 38733-1443',40,NULL,4,5,'2022-07-06 06:33:18',NULL,NULL,NULL,NULL,NULL,'task,events,holiday,tickets,leaves','I am super human',NULL,NULL,NULL,NULL,NULL,'unmarried',NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:34:20'),(5,1,16,'EMP-5','8376 Abbie Key\nEast Roscoe, NJ 41748',95,NULL,2,1,'2022-07-06 06:33:18',NULL,NULL,NULL,NULL,NULL,'task,events,holiday,tickets,leaves','I am super human',NULL,NULL,NULL,NULL,NULL,'unmarried',NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:34:20'),(6,1,17,'EMP-6','894 Klocko Stravenue\nLake Lydiahaven, AL 14438-2398',91,NULL,2,1,'2022-07-06 06:33:18',NULL,NULL,NULL,NULL,NULL,'task,events,holiday,tickets,leaves','I am super human',NULL,NULL,NULL,NULL,NULL,'unmarried',NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:34:20'),(7,1,18,'EMP-7','3781 Adrienne Shores\nLake Gayburgh, SC 97621-6347',24,NULL,2,1,'2022-07-06 06:33:18',NULL,NULL,NULL,NULL,NULL,'task,events,holiday,tickets,leaves','I am super human',NULL,NULL,NULL,NULL,NULL,'unmarried',NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:34:20'),(8,1,19,'EMP-8','791 Feest Squares\nSavannahview, LA 29284-1193',51,NULL,5,4,'2022-07-06 06:33:18',NULL,NULL,NULL,NULL,NULL,'task,events,holiday,tickets,leaves','I am super human',NULL,NULL,NULL,NULL,NULL,'unmarried',NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:34:20'),(9,1,20,'EMP-9','87121 Pfannerstill Drive\nBlanchemouth, GA 45584-0629',71,NULL,5,5,'2022-07-06 06:33:18',NULL,NULL,NULL,NULL,NULL,'task,events,holiday,tickets,leaves','I am super human',NULL,NULL,NULL,NULL,NULL,'unmarried',NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:34:20'),(10,1,21,'EMP-10','61146 Rodolfo Crossing Suite 953\nWeberton, KY 90806',49,NULL,6,1,'2022-07-06 06:33:18',NULL,NULL,NULL,NULL,NULL,'task,events,holiday,tickets,leaves','I am super human',NULL,NULL,NULL,NULL,NULL,'unmarried',NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:34:20'),(11,1,22,'EMP-11','7312 Weber Port\nLake Jillianfort, NM 48911',38,NULL,3,4,'2022-07-06 06:33:18',NULL,NULL,NULL,NULL,NULL,'task,events,holiday,tickets,leaves','I am super human',NULL,NULL,NULL,NULL,NULL,'unmarried',NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:34:20'),(12,1,23,'EMP-12','4494 Reyna Path\nLake Katlynn, IN 09684-5136',93,NULL,6,2,'2022-07-06 06:33:18',NULL,NULL,NULL,NULL,NULL,'task,events,holiday,tickets,leaves','I am super human',NULL,NULL,NULL,NULL,NULL,'unmarried',NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:34:20');
/*!40000 ALTER TABLE `employee_details` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `employee_docs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `employee_docs` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `filename` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `hashname` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_docs_company_id_foreign` (`company_id`),
  KEY `employee_docs_user_id_foreign` (`user_id`),
  KEY `employee_docs_added_by_foreign` (`added_by`),
  KEY `employee_docs_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `employee_docs_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `employee_docs_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employee_docs_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `employee_docs_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `employee_docs` WRITE;
/*!40000 ALTER TABLE `employee_docs` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_docs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `employee_leave_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `employee_leave_quotas` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL,
  `leave_type_id` int unsigned NOT NULL,
  `no_of_leaves` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_leave_quotas_user_id_foreign` (`user_id`),
  KEY `employee_leave_quotas_leave_type_id_foreign` (`leave_type_id`),
  CONSTRAINT `employee_leave_quotas_leave_type_id_foreign` FOREIGN KEY (`leave_type_id`) REFERENCES `leave_types` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employee_leave_quotas_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `employee_leave_quotas` WRITE;
/*!40000 ALTER TABLE `employee_leave_quotas` DISABLE KEYS */;
INSERT INTO `employee_leave_quotas` VALUES (1,1,1,5,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(2,1,2,5,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(3,1,3,5,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(4,2,1,5,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(5,2,2,5,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(6,2,3,5,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(7,14,1,5,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(8,14,2,5,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(9,14,3,5,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(10,15,1,5,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(11,15,2,5,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(12,15,3,5,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(13,16,1,5,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(14,16,2,5,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(15,16,3,5,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(16,17,1,5,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(17,17,2,5,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(18,17,3,5,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(19,18,1,5,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(20,18,2,5,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(21,18,3,5,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(22,19,1,5,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(23,19,2,5,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(24,19,3,5,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(25,20,1,5,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(26,20,2,5,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(27,20,3,5,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(28,21,1,5,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(29,21,2,5,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(30,21,3,5,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(31,22,1,5,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(32,22,2,5,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(33,22,3,5,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(34,23,1,5,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(35,23,2,5,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(36,23,3,5,'2023-04-06 06:33:18','2023-04-06 06:33:18');
/*!40000 ALTER TABLE `employee_leave_quotas` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `employee_monthly_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `employee_monthly_salaries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL,
  `annual_salary` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `basic_salary` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fixed_allowance` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `basic_value_type` enum('fixed','ctc_percent') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` enum('initial','increment','decrement') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'initial',
  `date` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `allow_generate_payroll` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`id`),
  KEY `employee_monthly_salaries_user_id_foreign` (`user_id`),
  CONSTRAINT `employee_monthly_salaries_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `employee_monthly_salaries` WRITE;
/*!40000 ALTER TABLE `employee_monthly_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_monthly_salaries` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `employee_payroll_cycles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `employee_payroll_cycles` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `payroll_cycle_id` bigint unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_payroll_cycles_payroll_cycle_id_foreign` (`payroll_cycle_id`),
  KEY `employee_payroll_cycles_user_id_foreign` (`user_id`),
  KEY `employee_payroll_cycles_company_id_foreign` (`company_id`),
  CONSTRAINT `employee_payroll_cycles_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employee_payroll_cycles_payroll_cycle_id_foreign` FOREIGN KEY (`payroll_cycle_id`) REFERENCES `payroll_cycles` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employee_payroll_cycles_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `employee_payroll_cycles` WRITE;
/*!40000 ALTER TABLE `employee_payroll_cycles` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_payroll_cycles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `employee_salary_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `employee_salary_groups` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `salary_group_id` bigint unsigned NOT NULL,
  `user_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_salary_groups_salary_group_id_foreign` (`salary_group_id`),
  KEY `employee_salary_groups_user_id_foreign` (`user_id`),
  CONSTRAINT `employee_salary_groups_salary_group_id_foreign` FOREIGN KEY (`salary_group_id`) REFERENCES `salary_groups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `employee_salary_groups_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `employee_salary_groups` WRITE;
/*!40000 ALTER TABLE `employee_salary_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_salary_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `employee_shift_change_requests`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `employee_shift_change_requests` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `shift_schedule_id` bigint unsigned NOT NULL,
  `employee_shift_id` bigint unsigned NOT NULL,
  `status` enum('waiting','accepted','rejected') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'waiting',
  `reason` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_shift_change_requests_company_id_foreign` (`company_id`),
  KEY `employee_shift_change_requests_shift_schedule_id_foreign` (`shift_schedule_id`),
  KEY `employee_shift_change_requests_employee_shift_id_foreign` (`employee_shift_id`),
  CONSTRAINT `employee_shift_change_requests_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employee_shift_change_requests_employee_shift_id_foreign` FOREIGN KEY (`employee_shift_id`) REFERENCES `employee_shifts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employee_shift_change_requests_shift_schedule_id_foreign` FOREIGN KEY (`shift_schedule_id`) REFERENCES `employee_shift_schedules` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `employee_shift_change_requests` WRITE;
/*!40000 ALTER TABLE `employee_shift_change_requests` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_shift_change_requests` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `employee_shift_schedules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `employee_shift_schedules` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL,
  `date` date NOT NULL,
  `employee_shift_id` bigint unsigned NOT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `shift_start_time` datetime DEFAULT NULL,
  `shift_end_time` datetime DEFAULT NULL,
  `remarks` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_shift_schedules_user_id_foreign` (`user_id`),
  KEY `employee_shift_schedules_date_index` (`date`),
  KEY `employee_shift_schedules_employee_shift_id_foreign` (`employee_shift_id`),
  KEY `employee_shift_schedules_added_by_foreign` (`added_by`),
  KEY `employee_shift_schedules_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `employee_shift_schedules_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `employee_shift_schedules_employee_shift_id_foreign` FOREIGN KEY (`employee_shift_id`) REFERENCES `employee_shifts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employee_shift_schedules_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `employee_shift_schedules_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=241 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `employee_shift_schedules` WRITE;
/*!40000 ALTER TABLE `employee_shift_schedules` DISABLE KEYS */;
INSERT INTO `employee_shift_schedules` VALUES (1,1,'2023-04-01',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(2,1,'2023-04-02',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(3,1,'2023-04-03',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(4,1,'2023-04-04',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(5,1,'2023-04-05',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(6,1,'2023-04-06',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(7,1,'2023-04-07',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(8,1,'2023-04-08',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(9,1,'2023-04-09',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(10,1,'2023-04-10',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(11,1,'2023-04-11',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(12,1,'2023-04-12',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(13,1,'2023-04-13',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(14,1,'2023-04-14',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(15,1,'2023-04-15',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(16,1,'2023-04-16',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(17,1,'2023-04-17',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(18,1,'2023-04-18',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(19,1,'2023-04-19',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(20,1,'2023-04-20',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(21,2,'2023-04-01',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(22,2,'2023-04-02',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(23,2,'2023-04-03',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(24,2,'2023-04-04',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(25,2,'2023-04-05',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(26,2,'2023-04-06',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(27,2,'2023-04-07',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(28,2,'2023-04-08',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(29,2,'2023-04-09',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(30,2,'2023-04-10',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(31,2,'2023-04-11',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(32,2,'2023-04-12',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(33,2,'2023-04-13',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(34,2,'2023-04-14',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(35,2,'2023-04-15',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(36,2,'2023-04-16',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(37,2,'2023-04-17',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(38,2,'2023-04-18',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(39,2,'2023-04-19',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(40,2,'2023-04-20',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(41,14,'2023-04-01',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(42,14,'2023-04-02',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(43,14,'2023-04-03',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(44,14,'2023-04-04',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(45,14,'2023-04-05',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(46,14,'2023-04-06',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(47,14,'2023-04-07',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(48,14,'2023-04-08',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(49,14,'2023-04-09',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(50,14,'2023-04-10',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(51,14,'2023-04-11',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(52,14,'2023-04-12',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(53,14,'2023-04-13',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(54,14,'2023-04-14',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(55,14,'2023-04-15',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(56,14,'2023-04-16',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(57,14,'2023-04-17',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(58,14,'2023-04-18',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(59,14,'2023-04-19',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(60,14,'2023-04-20',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(61,15,'2023-04-01',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(62,15,'2023-04-02',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(63,15,'2023-04-03',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(64,15,'2023-04-04',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(65,15,'2023-04-05',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(66,15,'2023-04-06',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(67,15,'2023-04-07',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(68,15,'2023-04-08',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(69,15,'2023-04-09',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(70,15,'2023-04-10',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(71,15,'2023-04-11',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(72,15,'2023-04-12',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(73,15,'2023-04-13',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(74,15,'2023-04-14',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(75,15,'2023-04-15',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(76,15,'2023-04-16',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(77,15,'2023-04-17',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(78,15,'2023-04-18',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(79,15,'2023-04-19',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(80,15,'2023-04-20',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(81,16,'2023-04-01',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(82,16,'2023-04-02',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(83,16,'2023-04-03',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(84,16,'2023-04-04',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(85,16,'2023-04-05',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(86,16,'2023-04-06',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(87,16,'2023-04-07',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(88,16,'2023-04-08',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(89,16,'2023-04-09',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(90,16,'2023-04-10',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(91,16,'2023-04-11',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(92,16,'2023-04-12',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(93,16,'2023-04-13',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(94,16,'2023-04-14',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(95,16,'2023-04-15',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(96,16,'2023-04-16',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(97,16,'2023-04-17',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(98,16,'2023-04-18',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(99,16,'2023-04-19',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(100,16,'2023-04-20',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(101,17,'2023-04-01',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(102,17,'2023-04-02',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(103,17,'2023-04-03',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(104,17,'2023-04-04',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(105,17,'2023-04-05',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(106,17,'2023-04-06',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(107,17,'2023-04-07',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(108,17,'2023-04-08',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(109,17,'2023-04-09',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(110,17,'2023-04-10',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(111,17,'2023-04-11',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(112,17,'2023-04-12',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(113,17,'2023-04-13',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(114,17,'2023-04-14',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(115,17,'2023-04-15',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(116,17,'2023-04-16',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(117,17,'2023-04-17',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(118,17,'2023-04-18',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(119,17,'2023-04-19',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(120,17,'2023-04-20',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(121,18,'2023-04-01',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(122,18,'2023-04-02',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(123,18,'2023-04-03',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(124,18,'2023-04-04',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(125,18,'2023-04-05',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(126,18,'2023-04-06',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(127,18,'2023-04-07',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(128,18,'2023-04-08',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(129,18,'2023-04-09',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(130,18,'2023-04-10',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(131,18,'2023-04-11',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(132,18,'2023-04-12',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(133,18,'2023-04-13',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(134,18,'2023-04-14',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(135,18,'2023-04-15',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(136,18,'2023-04-16',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(137,18,'2023-04-17',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(138,18,'2023-04-18',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(139,18,'2023-04-19',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(140,18,'2023-04-20',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(141,19,'2023-04-01',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(142,19,'2023-04-02',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(143,19,'2023-04-03',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(144,19,'2023-04-04',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(145,19,'2023-04-05',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(146,19,'2023-04-06',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(147,19,'2023-04-07',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(148,19,'2023-04-08',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(149,19,'2023-04-09',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(150,19,'2023-04-10',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(151,19,'2023-04-11',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(152,19,'2023-04-12',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(153,19,'2023-04-13',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(154,19,'2023-04-14',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(155,19,'2023-04-15',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(156,19,'2023-04-16',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(157,19,'2023-04-17',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(158,19,'2023-04-18',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(159,19,'2023-04-19',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(160,19,'2023-04-20',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(161,20,'2023-04-01',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(162,20,'2023-04-02',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(163,20,'2023-04-03',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(164,20,'2023-04-04',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(165,20,'2023-04-05',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(166,20,'2023-04-06',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(167,20,'2023-04-07',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(168,20,'2023-04-08',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(169,20,'2023-04-09',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(170,20,'2023-04-10',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(171,20,'2023-04-11',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(172,20,'2023-04-12',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(173,20,'2023-04-13',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(174,20,'2023-04-14',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(175,20,'2023-04-15',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(176,20,'2023-04-16',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(177,20,'2023-04-17',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(178,20,'2023-04-18',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(179,20,'2023-04-19',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(180,20,'2023-04-20',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(181,21,'2023-04-01',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(182,21,'2023-04-02',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(183,21,'2023-04-03',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(184,21,'2023-04-04',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(185,21,'2023-04-05',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(186,21,'2023-04-06',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(187,21,'2023-04-07',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(188,21,'2023-04-08',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(189,21,'2023-04-09',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(190,21,'2023-04-10',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(191,21,'2023-04-11',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(192,21,'2023-04-12',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(193,21,'2023-04-13',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(194,21,'2023-04-14',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(195,21,'2023-04-15',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(196,21,'2023-04-16',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(197,21,'2023-04-17',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(198,21,'2023-04-18',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(199,21,'2023-04-19',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(200,21,'2023-04-20',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(201,22,'2023-04-01',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(202,22,'2023-04-02',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(203,22,'2023-04-03',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(204,22,'2023-04-04',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(205,22,'2023-04-05',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(206,22,'2023-04-06',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(207,22,'2023-04-07',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(208,22,'2023-04-08',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(209,22,'2023-04-09',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(210,22,'2023-04-10',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(211,22,'2023-04-11',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(212,22,'2023-04-12',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(213,22,'2023-04-13',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(214,22,'2023-04-14',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(215,22,'2023-04-15',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(216,22,'2023-04-16',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(217,22,'2023-04-17',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(218,22,'2023-04-18',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(219,22,'2023-04-19',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(220,22,'2023-04-20',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(221,23,'2023-04-01',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(222,23,'2023-04-02',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(223,23,'2023-04-03',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(224,23,'2023-04-04',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(225,23,'2023-04-05',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(226,23,'2023-04-06',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(227,23,'2023-04-07',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(228,23,'2023-04-08',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(229,23,'2023-04-09',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(230,23,'2023-04-10',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(231,23,'2023-04-11',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(232,23,'2023-04-12',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(233,23,'2023-04-13',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(234,23,'2023-04-14',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(235,23,'2023-04-15',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(236,23,'2023-04-16',2,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(237,23,'2023-04-17',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(238,23,'2023-04-18',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(239,23,'2023-04-19',4,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(240,23,'2023-04-20',3,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:19','2023-04-06 06:33:19');
/*!40000 ALTER TABLE `employee_shift_schedules` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `employee_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `employee_shifts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `shift_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `shift_short_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `office_start_time` time NOT NULL,
  `office_end_time` time NOT NULL,
  `halfday_mark_time` time DEFAULT NULL,
  `late_mark_duration` tinyint NOT NULL,
  `clockin_in_day` tinyint NOT NULL,
  `office_open_days` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_shifts_company_id_foreign` (`company_id`),
  CONSTRAINT `employee_shifts_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `employee_shifts` WRITE;
/*!40000 ALTER TABLE `employee_shifts` DISABLE KEYS */;
INSERT INTO `employee_shifts` VALUES (1,1,'Day Off','DO','','00:00:00','00:00:00',NULL,0,0,'','2023-04-06 06:33:16','2023-04-06 06:33:16'),(2,1,'General Shift','GS','#99C7F1','09:00:00','18:00:00',NULL,20,2,'[\"1\",\"2\",\"3\",\"4\",\"5\"]','2023-04-06 06:33:16','2023-04-06 06:33:16'),(3,1,'Night Shift','NS','#4d4c4c','22:00:00','06:00:00','01:00:00',15,1,'[\"1\",\"2\",\"3\",\"4\",\"5\"]','2023-04-06 06:33:18','2023-04-06 06:33:18'),(4,1,'Day Shift','DS','#ff0000','08:00:00','17:00:00','13:30:00',15,1,'[\"1\",\"2\",\"3\",\"4\",\"5\"]','2023-04-06 06:33:18','2023-04-06 06:33:18');
/*!40000 ALTER TABLE `employee_shifts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `employee_skills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `employee_skills` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `skill_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_skills_company_id_foreign` (`company_id`),
  KEY `employee_skills_user_id_foreign` (`user_id`),
  KEY `employee_skills_skill_id_foreign` (`skill_id`),
  CONSTRAINT `employee_skills_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employee_skills_skill_id_foreign` FOREIGN KEY (`skill_id`) REFERENCES `skills` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employee_skills_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `employee_skills` WRITE;
/*!40000 ALTER TABLE `employee_skills` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_skills` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `employee_teams`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `employee_teams` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `team_id` int unsigned NOT NULL,
  `user_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_teams_company_id_foreign` (`company_id`),
  KEY `employee_teams_team_id_foreign` (`team_id`),
  KEY `employee_teams_user_id_foreign` (`user_id`),
  CONSTRAINT `employee_teams_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employee_teams_team_id_foreign` FOREIGN KEY (`team_id`) REFERENCES `teams` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employee_teams_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `employee_teams` WRITE;
/*!40000 ALTER TABLE `employee_teams` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_teams` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `employee_variable_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `employee_variable_salaries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `monthly_salary_id` bigint unsigned NOT NULL,
  `variable_component_id` bigint unsigned NOT NULL,
  `variable_value` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_variable_salaries_monthly_salary_id_foreign` (`monthly_salary_id`),
  KEY `employee_variable_salaries_variable_component_id_foreign` (`variable_component_id`),
  CONSTRAINT `employee_variable_salaries_monthly_salary_id_foreign` FOREIGN KEY (`monthly_salary_id`) REFERENCES `employee_monthly_salaries` (`id`) ON DELETE CASCADE,
  CONSTRAINT `employee_variable_salaries_variable_component_id_foreign` FOREIGN KEY (`variable_component_id`) REFERENCES `salary_components` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `employee_variable_salaries` WRITE;
/*!40000 ALTER TABLE `employee_variable_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_variable_salaries` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `estimate_item_images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `estimate_item_images` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `estimate_item_id` int unsigned NOT NULL,
  `filename` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `hashname` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `estimate_item_images_estimate_item_id_foreign` (`estimate_item_id`),
  CONSTRAINT `estimate_item_images_estimate_item_id_foreign` FOREIGN KEY (`estimate_item_id`) REFERENCES `estimate_items` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `estimate_item_images` WRITE;
/*!40000 ALTER TABLE `estimate_item_images` DISABLE KEYS */;
/*!40000 ALTER TABLE `estimate_item_images` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `estimate_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `estimate_items` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `estimate_id` int unsigned NOT NULL,
  `item_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `item_summary` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `type` enum('item','discount','tax') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'item',
  `quantity` double(16,2) NOT NULL,
  `unit_price` double(16,2) NOT NULL,
  `amount` double(16,2) NOT NULL,
  `taxes` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hsn_sac_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `estimate_items_estimate_id_foreign` (`estimate_id`),
  CONSTRAINT `estimate_items_estimate_id_foreign` FOREIGN KEY (`estimate_id`) REFERENCES `estimates` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `estimate_items` WRITE;
/*!40000 ALTER TABLE `estimate_items` DISABLE KEYS */;
INSERT INTO `estimate_items` VALUES (1,1,'item 1',NULL,'item',1.00,500.00,500.00,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(2,1,'item 2',NULL,'item',1.00,700.00,700.00,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(3,2,'item 3',NULL,'item',2.00,1200.00,2400.00,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(4,2,'item 4',NULL,'item',1.00,1700.00,1700.00,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18');
/*!40000 ALTER TABLE `estimate_items` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `estimate_template_item_images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `estimate_template_item_images` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `estimate_template_item_id` int unsigned NOT NULL,
  `filename` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `hashname` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `estimate_template_item_images_company_id_foreign` (`company_id`),
  KEY `estimate_template_item_images_estimate_template_item_id_foreign` (`estimate_template_item_id`),
  CONSTRAINT `estimate_template_item_images_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `estimate_template_item_images_estimate_template_item_id_foreign` FOREIGN KEY (`estimate_template_item_id`) REFERENCES `estimate_template_items` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `estimate_template_item_images` WRITE;
/*!40000 ALTER TABLE `estimate_template_item_images` DISABLE KEYS */;
/*!40000 ALTER TABLE `estimate_template_item_images` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `estimate_template_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `estimate_template_items` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `estimate_template_id` bigint unsigned NOT NULL,
  `hsn_sac_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` enum('item','discount','tax') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'item',
  `quantity` tinyint NOT NULL,
  `unit_price` double NOT NULL,
  `amount` double NOT NULL,
  `item_summary` text COLLATE utf8mb4_unicode_ci,
  `taxes` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `estimate_template_items_company_id_foreign` (`company_id`),
  KEY `estimate_template_items_estimate_template_id_foreign` (`estimate_template_id`),
  CONSTRAINT `estimate_template_items_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `estimate_template_items_estimate_template_id_foreign` FOREIGN KEY (`estimate_template_id`) REFERENCES `estimate_templates` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `estimate_template_items` WRITE;
/*!40000 ALTER TABLE `estimate_template_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `estimate_template_items` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `estimate_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `estimate_templates` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sub_total` double NOT NULL,
  `total` double NOT NULL,
  `currency_id` int unsigned DEFAULT NULL,
  `discount_type` enum('percent','fixed') COLLATE utf8mb4_unicode_ci NOT NULL,
  `discount` double NOT NULL,
  `invoice_convert` tinyint(1) NOT NULL DEFAULT '0',
  `status` enum('declined','accepted','waiting') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'waiting',
  `note` mediumtext COLLATE utf8mb4_unicode_ci,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `calculate_tax` enum('after_discount','before_discount') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'after_discount',
  `client_comment` text COLLATE utf8mb4_unicode_ci,
  `signature_approval` tinyint(1) NOT NULL DEFAULT '1',
  `hash` text COLLATE utf8mb4_unicode_ci,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `unit_id` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `estimate_templates_company_id_foreign` (`company_id`),
  KEY `estimate_templates_currency_id_foreign` (`currency_id`),
  KEY `estimate_templates_added_by_foreign` (`added_by`),
  KEY `estimate_templates_last_updated_by_foreign` (`last_updated_by`),
  KEY `estimate_templates_unit_id_foreign` (`unit_id`),
  CONSTRAINT `estimate_templates_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `estimate_templates_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `estimate_templates_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `estimate_templates_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `estimate_templates_unit_id_foreign` FOREIGN KEY (`unit_id`) REFERENCES `unit_types` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `estimate_templates` WRITE;
/*!40000 ALTER TABLE `estimate_templates` DISABLE KEYS */;
/*!40000 ALTER TABLE `estimate_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `estimates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `estimates` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `client_id` int unsigned NOT NULL,
  `estimate_number` bigint DEFAULT NULL,
  `valid_till` date NOT NULL,
  `sub_total` double(16,2) NOT NULL,
  `discount` double NOT NULL DEFAULT '0',
  `discount_type` enum('percent','fixed') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'percent',
  `total` double(16,2) NOT NULL,
  `currency_id` int unsigned DEFAULT NULL,
  `status` enum('declined','accepted','waiting','sent','draft','canceled') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'waiting',
  `note` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `send_status` tinyint(1) NOT NULL DEFAULT '1',
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `hash` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `calculate_tax` enum('after_discount','before_discount') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'after_discount',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `last_viewed` timestamp NULL DEFAULT NULL,
  `ip_address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `unit_id` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `estimates_estimate_number_company_id_unique` (`estimate_number`,`company_id`),
  KEY `estimates_company_id_foreign` (`company_id`),
  KEY `estimates_client_id_foreign` (`client_id`),
  KEY `estimates_currency_id_foreign` (`currency_id`),
  KEY `estimates_added_by_foreign` (`added_by`),
  KEY `estimates_last_updated_by_foreign` (`last_updated_by`),
  KEY `estimates_unit_id_foreign` (`unit_id`),
  CONSTRAINT `estimates_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `estimates_client_id_foreign` FOREIGN KEY (`client_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `estimates_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `estimates_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `estimates_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `estimates_unit_id_foreign` FOREIGN KEY (`unit_id`) REFERENCES `unit_types` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `estimates` WRITE;
/*!40000 ALTER TABLE `estimates` DISABLE KEYS */;
INSERT INTO `estimates` VALUES (1,1,3,1,'2022-04-03',1200.00,0,'percent',1200.00,1,'waiting',NULL,NULL,1,NULL,NULL,'3a1f08aa7fc24d728a475e7a74ec3fde','after_discount','2023-04-06 06:33:18','2023-04-06 06:33:18',NULL,NULL,1),(2,1,3,2,'2022-04-10',4100.00,0,'percent',4100.00,1,'waiting',NULL,NULL,1,NULL,NULL,'f5b0501c65944aa92ff76e992be06aee','after_discount','2023-04-06 06:33:18','2023-04-06 06:33:18',NULL,NULL,1);
/*!40000 ALTER TABLE `estimates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `event_attendees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `event_attendees` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `event_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `event_attendees_company_id_foreign` (`company_id`),
  KEY `event_attendees_user_id_foreign` (`user_id`),
  KEY `event_attendees_event_id_foreign` (`event_id`),
  CONSTRAINT `event_attendees_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `event_attendees_event_id_foreign` FOREIGN KEY (`event_id`) REFERENCES `events` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `event_attendees_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `event_attendees` WRITE;
/*!40000 ALTER TABLE `event_attendees` DISABLE KEYS */;
INSERT INTO `event_attendees` VALUES (1,1,16,1,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(2,1,19,1,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(3,1,22,1,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(4,1,23,1,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(5,1,22,2,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(6,1,15,2,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(7,1,19,2,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(8,1,14,2,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(9,1,2,2,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(10,1,23,2,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(11,1,1,2,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(12,1,21,2,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(13,1,16,2,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(14,1,17,3,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(15,1,22,3,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(16,1,15,3,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(17,1,1,3,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(18,1,21,3,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(19,1,20,4,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(20,1,17,4,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(21,1,16,4,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(22,1,15,5,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(23,1,18,5,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(24,1,19,5,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(25,1,23,6,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(26,1,23,7,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(27,1,18,7,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(28,1,15,7,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(29,1,19,7,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(30,1,22,7,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(31,1,20,8,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(32,1,18,9,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(33,1,21,9,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(34,1,22,9,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(35,1,20,9,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(36,1,14,9,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(37,1,16,10,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(38,1,20,10,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(39,1,2,10,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(40,1,21,10,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(41,1,14,10,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(42,1,23,10,'2023-04-06 06:33:18','2023-04-06 06:33:18');
/*!40000 ALTER TABLE `event_attendees` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `event_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `event_files` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `event_id` int unsigned NOT NULL,
  `filename` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hashname` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `event_files_company_id_foreign` (`company_id`),
  KEY `event_files_event_id_foreign` (`event_id`),
  KEY `event_files_added_by_foreign` (`added_by`),
  KEY `event_files_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `event_files_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `event_files_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `event_files_event_id_foreign` FOREIGN KEY (`event_id`) REFERENCES `events` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `event_files_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `event_files` WRITE;
/*!40000 ALTER TABLE `event_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `event_files` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `events`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `events` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `event_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `label_color` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `where` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `start_date_time` datetime NOT NULL,
  `end_date_time` datetime NOT NULL,
  `repeat` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `repeat_every` int DEFAULT NULL,
  `repeat_cycles` int DEFAULT NULL,
  `repeat_type` enum('day','week','month','year') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'day',
  `send_reminder` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `remind_time` int DEFAULT NULL,
  `remind_type` enum('day','hour','minute') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'day',
  `event_link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `event_id` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `events_company_id_foreign` (`company_id`),
  KEY `events_added_by_foreign` (`added_by`),
  KEY `events_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `events_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `events_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `events_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `events` WRITE;
/*!40000 ALTER TABLE `events` DISABLE KEYS */;
INSERT INTO `events` VALUES (1,1,'Et optio est nihil.','#008000','4987 Alexie Estates Apt. 134\nLake Roxaneshire, SD 34321-7678','Aut dignissimos a maxime qui voluptas voluptas necessitatibus. At dolorem voluptatem sed repellat. Et fugit fuga distinctio corrupti.','2023-03-16 16:05:15','2023-03-16 16:05:15','no',NULL,NULL,'day','no',NULL,'day',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(2,1,'Vel veritatis vel.','#008000','50106 Bogan Pike Suite 148\nTonyburgh, MA 26729-1728','Quod culpa itaque corporis dignissimos labore quia et. Quasi praesentium non nisi at.','2023-03-21 17:14:24','2023-03-21 17:14:24','no',NULL,NULL,'day','no',NULL,'day',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(3,1,'Quasi voluptatem.','#808000','173 Robert Fall\nKrajcikmouth, MD 74016-2247','Qui debitis quia voluptas at maiores mollitia a quibusdam. Sint consequatur dolore nihil ducimus inventore. Accusamus autem minima blanditiis totam velit et nihil natus. Laboriosam similique dolorem consequuntur.','2023-03-07 22:44:06','2023-03-07 22:44:06','no',NULL,NULL,'day','no',NULL,'day',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(4,1,'Suscipit occaecati.','#000000','885 Vladimir Path\nEast Laney, NV 53257','Facere aut totam eligendi expedita pariatur nisi. Neque nisi doloribus autem. Nemo quia ut expedita sit et. Debitis id consectetur iste laborum nulla. Officiis quis aspernatur illo distinctio distinctio sequi voluptatum.','2023-03-26 14:51:16','2023-03-26 14:51:16','no',NULL,NULL,'day','no',NULL,'day',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(5,1,'Ut officiis aut.','#800080','27613 Kaleb Route Apt. 622\nDaynafort, WV 69437-6220','Molestiae rem recusandae voluptatum ut possimus quidem sit. Repudiandae et voluptatibus occaecati eos. Laudantium minus veritatis et aut. Fugit commodi dolorum ut laboriosam.','2023-03-13 09:51:42','2023-03-13 09:51:42','no',NULL,NULL,'day','no',NULL,'day',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(6,1,'Nostrum impedit.','#1d82f5','66752 Harmon Light Apt. 238\nAndreston, TN 48342','Corporis voluptatum eum illum. Dolor tenetur quis non temporibus. Voluptatem quisquam occaecati libero qui accusamus nam. Asperiores aut qui sit veritatis.','2023-01-10 17:01:58','2023-01-10 17:01:58','no',NULL,NULL,'day','no',NULL,'day',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(7,1,'Adipisci doloribus.','#1d82f5','320 Dennis Overpass Apt. 970\nNorth Chanelle, NJ 03932-2846','Voluptas cumque vel fuga itaque laudantium quibusdam ut. Earum sapiente et corporis eveniet a necessitatibus at repellat. Illo rerum et id culpa omnis nam.','2023-03-14 21:46:47','2023-03-14 21:46:47','no',NULL,NULL,'day','no',NULL,'day',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(8,1,'Fugiat asperiores.','#1d82f5','1604 Pasquale Plains\nKshlerinchester, AK 13374','Voluptatem natus tenetur ut. Sit quod necessitatibus commodi vel ea. Hic consequuntur quam neque.','2023-04-06 16:01:15','2023-04-06 16:01:15','no',NULL,NULL,'day','no',NULL,'day',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(9,1,'Id qui quo velit.','#000000','25259 Collins Keys Suite 916\nStephaniahaven, MA 09879','Ut dolor et maiores voluptatem quibusdam in praesentium. Eius aut et eaque dolore asperiores ea. Deserunt corrupti doloremque consequatur voluptatum. Libero est numquam voluptatem magni aliquid ducimus aut.','2023-03-18 15:11:43','2023-03-18 15:11:43','no',NULL,NULL,'day','no',NULL,'day',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(10,1,'Esse est quas quia.','#008000','10129 Hegmann Rapids Suite 153\nNew Kraig, NJ 95757-5981','Tempore eos omnis tempora assumenda ullam. Inventore quibusdam facere et sit. Quidem sapiente quidem cumque et in totam. Quia non est dolor velit architecto necessitatibus dignissimos.','2023-04-04 21:27:09','2023-04-04 21:27:09','no',NULL,NULL,'day','no',NULL,'day',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18');
/*!40000 ALTER TABLE `events` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `expenses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `expenses` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `item_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `purchase_date` date NOT NULL,
  `purchase_from` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `price` double(16,2) NOT NULL,
  `currency_id` int unsigned NOT NULL,
  `default_currency_id` int unsigned DEFAULT NULL,
  `exchange_rate` double DEFAULT NULL,
  `project_id` int unsigned DEFAULT NULL,
  `bill` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `status` enum('pending','approved','rejected') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `can_claim` tinyint(1) NOT NULL DEFAULT '1',
  `category_id` bigint unsigned DEFAULT NULL,
  `expenses_recurring_id` bigint unsigned DEFAULT NULL,
  `created_by` int unsigned DEFAULT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `approver_id` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `bank_account_id` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `expenses_company_id_foreign` (`company_id`),
  KEY `expenses_currency_id_foreign` (`currency_id`),
  KEY `expenses_user_id_foreign` (`user_id`),
  KEY `expenses_category_id_foreign` (`category_id`),
  KEY `expenses_expenses_recurring_id_foreign` (`expenses_recurring_id`),
  KEY `expenses_created_by_foreign` (`created_by`),
  KEY `expenses_added_by_foreign` (`added_by`),
  KEY `expenses_last_updated_by_foreign` (`last_updated_by`),
  KEY `expenses_approver_id_foreign` (`approver_id`),
  KEY `expenses_bank_account_id_foreign` (`bank_account_id`),
  KEY `expenses_default_currency_id_foreign` (`default_currency_id`),
  CONSTRAINT `expenses_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `expenses_approver_id_foreign` FOREIGN KEY (`approver_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `expenses_bank_account_id_foreign` FOREIGN KEY (`bank_account_id`) REFERENCES `bank_accounts` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `expenses_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `expenses_category` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `expenses_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `expenses_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `expenses_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `expenses_default_currency_id_foreign` FOREIGN KEY (`default_currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `expenses_expenses_recurring_id_foreign` FOREIGN KEY (`expenses_recurring_id`) REFERENCES `expenses_recurring` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `expenses_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `expenses_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `expenses` WRITE;
/*!40000 ALTER TABLE `expenses` DISABLE KEYS */;
INSERT INTO `expenses` VALUES (1,1,'Quae ut sit iure.','2023-04-03','Michigan',184.00,1,NULL,1,NULL,NULL,20,'approved',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL),(2,1,'Ut excepturi.','2023-03-21','Maine',618.00,1,NULL,1,NULL,NULL,20,'pending',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL),(3,1,'Enim aspernatur.','2023-03-06','Mississippi',507.00,1,NULL,1,NULL,NULL,20,'pending',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL),(4,1,'Voluptatem et.','2023-03-09','Kentucky',746.00,1,NULL,1,NULL,NULL,20,'pending',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL),(5,1,'Ut esse eius ut.','2023-03-10','Kentucky',953.00,1,NULL,1,NULL,NULL,20,'approved',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL),(6,1,'Quos magni aut.','2023-03-16','New Jersey',427.00,1,NULL,1,NULL,NULL,20,'approved',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL),(7,1,'Dignissimos culpa.','2023-02-24','New Jersey',544.00,1,NULL,1,NULL,NULL,20,'approved',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL),(8,1,'Facere aut quam.','2023-01-09','Montana',197.00,1,NULL,1,NULL,NULL,20,'approved',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL),(9,1,'Ullam aliquid.','2023-01-28','Montana',487.00,1,NULL,1,NULL,NULL,20,'rejected',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL),(10,1,'Commodi expedita.','2023-03-08','Colorado',727.00,1,NULL,1,NULL,NULL,20,'approved',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL);
/*!40000 ALTER TABLE `expenses` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `expenses_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `expenses_category` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `category_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `expenses_category_company_id_foreign` (`company_id`),
  KEY `expenses_category_added_by_foreign` (`added_by`),
  KEY `expenses_category_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `expenses_category_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `expenses_category_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `expenses_category_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `expenses_category` WRITE;
/*!40000 ALTER TABLE `expenses_category` DISABLE KEYS */;
/*!40000 ALTER TABLE `expenses_category` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `expenses_category_roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `expenses_category_roles` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `expenses_category_id` bigint unsigned DEFAULT NULL,
  `role_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `expenses_category_roles_company_id_foreign` (`company_id`),
  KEY `expenses_category_roles_expenses_category_id_foreign` (`expenses_category_id`),
  KEY `expenses_category_roles_role_id_foreign` (`role_id`),
  CONSTRAINT `expenses_category_roles_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `expenses_category_roles_expenses_category_id_foreign` FOREIGN KEY (`expenses_category_id`) REFERENCES `expenses_category` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `expenses_category_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `expenses_category_roles` WRITE;
/*!40000 ALTER TABLE `expenses_category_roles` DISABLE KEYS */;
/*!40000 ALTER TABLE `expenses_category_roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `expenses_recurring`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `expenses_recurring` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `category_id` bigint unsigned DEFAULT NULL,
  `currency_id` int unsigned DEFAULT NULL,
  `project_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned DEFAULT NULL,
  `created_by` int unsigned DEFAULT NULL,
  `item_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `day_of_month` int DEFAULT '1',
  `day_of_week` int DEFAULT '1',
  `payment_method` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `rotation` enum('monthly','weekly','bi-weekly','quarterly','half-yearly','annually','daily') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `billing_cycle` int DEFAULT NULL,
  `issue_date` date NOT NULL,
  `next_expense_date` date DEFAULT NULL,
  `unlimited_recurring` tinyint(1) NOT NULL DEFAULT '0',
  `price` double NOT NULL,
  `bill` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` enum('active','inactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `purchase_from` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `immediate_expense` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `expenses_recurring_company_id_foreign` (`company_id`),
  KEY `expenses_recurring_category_id_foreign` (`category_id`),
  KEY `expenses_recurring_currency_id_foreign` (`currency_id`),
  KEY `expenses_recurring_project_id_foreign` (`project_id`),
  KEY `expenses_recurring_user_id_foreign` (`user_id`),
  KEY `expenses_recurring_created_by_foreign` (`created_by`),
  KEY `expenses_recurring_added_by_foreign` (`added_by`),
  KEY `expenses_recurring_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `expenses_recurring_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `expenses_recurring_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `expenses_category` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `expenses_recurring_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `expenses_recurring_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `expenses_recurring_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `expenses_recurring_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `expenses_recurring_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `expenses_recurring_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `expenses_recurring` WRITE;
/*!40000 ALTER TABLE `expenses_recurring` DISABLE KEYS */;
/*!40000 ALTER TABLE `expenses_recurring` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `failed_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `file_storage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `file_storage` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `path` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `filename` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` int unsigned NOT NULL,
  `storage_location` enum('local','aws_s3','digitalocean','wasabi') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'local',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `file_storage_company_id_foreign` (`company_id`),
  CONSTRAINT `file_storage_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `file_storage` WRITE;
/*!40000 ALTER TABLE `file_storage` DISABLE KEYS */;
/*!40000 ALTER TABLE `file_storage` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `file_storage_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `file_storage_settings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `filesystem` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `auth_keys` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `status` enum('enabled','disabled') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'disabled',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `file_storage_settings` WRITE;
/*!40000 ALTER TABLE `file_storage_settings` DISABLE KEYS */;
INSERT INTO `file_storage_settings` VALUES (1,'local',NULL,'enabled','2023-04-06 06:33:16','2023-04-06 06:33:16');
/*!40000 ALTER TABLE `file_storage_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `flags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `flags` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `capital` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `continent` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=267 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `flags` WRITE;
/*!40000 ALTER TABLE `flags` DISABLE KEYS */;
INSERT INTO `flags` VALUES (1,'Kabul','af','Asia','Afghanistan'),(2,'Mariehamn','ax','Europe','Aland Islands'),(3,'Tirana','al','Europe','Albania'),(4,'Algiers','dz','Africa','Algeria'),(5,'Pago Pago','as','Oceania','American Samoa'),(6,'Andorra la Vella','ad','Europe','Andorra'),(7,'Luanda','ao','Africa','Angola'),(8,'The Valley','ai','North America','Anguilla'),(9,'','aq','','Antarctica'),(10,'St. John\'s','ag','North America','Antigua and Barbuda'),(11,'Buenos Aires','ar','South America','Argentina'),(12,'Yerevan','am','Asia','Armenia'),(13,'Oranjestad','aw','South America','Aruba'),(14,'Georgetown','ac','Africa','Ascension Island'),(15,'Canberra','au','Oceania','Australia'),(16,'Vienna','at','Europe','Austria'),(17,'Baku','az','Asia','Azerbaijan'),(18,'Nassau','bs','North America','Bahamas'),(19,'Manama','bh','Asia','Bahrain'),(20,'Dhaka','bd','Asia','Bangladesh'),(21,'Bridgetown','bb','North America','Barbados'),(22,'Minsk','by','Europe','Belarus'),(23,'Brussels','be','Europe','Belgium'),(24,'Belmopan','bz','North America','Belize'),(25,'Porto-Novo','bj','Africa','Benin'),(26,'Hamilton','bm','North America','Bermuda'),(27,'Thimphu','bt','Asia','Bhutan'),(28,'Sucre','bo','South America','Bolivia'),(29,'Kralendijk','bq','South America','Bonaire, Sint Eustatius and Saba'),(30,'Sarajevo','ba','Europe','Bosnia and Herzegovina'),(31,'Gaborone','bw','Africa','Botswana'),(32,'','bv','','Bouvet Island'),(33,'Brasília','br','South America','Brazil'),(34,'Diego Garcia','io','Asia','British Indian Ocean Territory'),(35,'Bandar Seri Begawan','bn','Asia','Brunei Darussalam'),(36,'Sofia','bg','Europe','Bulgaria'),(37,'Ouagadougou','bf','Africa','Burkina Faso'),(38,'Bujumbura','bi','Africa','Burundi'),(39,'Praia','cv','Africa','Cabo Verde'),(40,'Phnom Penh','kh','Asia','Cambodia'),(41,'Yaoundé','cm','Africa','Cameroon'),(42,'Ottawa','ca','North America','Canada'),(43,'','ic','','Canary Islands'),(44,'','es-ct','','Catalonia'),(45,'George Town','ky','North America','Cayman Islands'),(46,'Bangui','cf','Africa','Central African Republic'),(47,'','cefta','','Central European Free Trade Agreement'),(48,'','ea','','Ceuta & Melilla'),(49,'N\'Djamena','td','Africa','Chad'),(50,'Santiago','cl','South America','Chile'),(51,'Beijing','cn','Asia','China'),(52,'Flying Fish Cove','cx','Asia','Christmas Island'),(53,'','cp','','Clipperton Island'),(54,'West Island','cc','Asia','Cocos (Keeling) Islands'),(55,'Bogotá','co','South America','Colombia'),(56,'Moroni','km','Africa','Comoros'),(57,'Avarua','ck','Oceania','Cook Islands'),(58,'San José','cr','North America','Costa Rica'),(59,'Zagreb','hr','Europe','Croatia'),(60,'Havana','cu','North America','Cuba'),(61,'Willemstad','cw','South America','Curaçao'),(62,'Nicosia','cy','Europe','Cyprus'),(63,'Prague','cz','Europe','Czech Republic'),(64,'Yamoussoukro','ci','Africa','Côte d\'Ivoire'),(65,'Kinshasa','cd','Africa','Democratic Republic of the Congo'),(66,'Copenhagen','dk','Europe','Denmark'),(67,'','dg','','Diego Garcia'),(68,'Djibouti','dj','Africa','Djibouti'),(69,'Roseau','dm','North America','Dominica'),(70,'Santo Domingo','do','North America','Dominican Republic'),(71,'Quito','ec','South America','Ecuador'),(72,'Cairo','eg','Africa','Egypt'),(73,'San Salvador','sv','North America','El Salvador'),(74,'London','gb-eng','Europe','England'),(75,'Malabo','gq','Africa','Equatorial Guinea'),(76,'Asmara','er','Africa','Eritrea'),(77,'Tallinn','ee','Europe','Estonia'),(78,'Lobamba, Mbabane','sz','Africa','Eswatini'),(79,'Addis Ababa','et','Africa','Ethiopia'),(80,'','eu','','Europe'),(81,'Stanley','fk','South America','Falkland Islands'),(82,'Tórshavn','fo','Europe','Faroe Islands'),(83,'Palikir','fm','Oceania','Federated States of Micronesia'),(84,'Suva','fj','Oceania','Fiji'),(85,'Helsinki','fi','Europe','Finland'),(86,'Paris','fr','Europe','France'),(87,'Cayenne','gf','South America','French Guiana'),(88,'Papeete','pf','Oceania','French Polynesia'),(89,'Saint-Pierre, Réunion','tf','Africa','French Southern Territories'),(90,'Libreville','ga','Africa','Gabon'),(91,'','es-ga','','Galicia'),(92,'Banjul','gm','Africa','Gambia'),(93,'Tbilisi','ge','Asia','Georgia'),(94,'Berlin','de','Europe','Germany'),(95,'Accra','gh','Africa','Ghana'),(96,'Gibraltar','gi','Europe','Gibraltar'),(97,'Athens','gr','Europe','Greece'),(98,'Nuuk','gl','North America','Greenland'),(99,'St. George\'s','gd','North America','Grenada'),(100,'Basse-Terre','gp','North America','Guadeloupe'),(101,'Hagåtña','gu','Oceania','Guam'),(102,'Guatemala City','gt','North America','Guatemala'),(103,'Saint Peter Port','gg','Europe','Guernsey'),(104,'Conakry','gn','Africa','Guinea'),(105,'Bissau','gw','Africa','Guinea-Bissau'),(106,'Georgetown','gy','South America','Guyana'),(107,'Port-au-Prince','ht','North America','Haiti'),(108,'','hm','','Heard Island and McDonald Islands'),(109,'Vatican City','va','Europe','Holy See'),(110,'Tegucigalpa','hn','North America','Honduras'),(111,'Hong Kong','hk','Asia','Hong Kong'),(112,'Budapest','hu','Europe','Hungary'),(113,'Reykjavik','is','Europe','Iceland'),(114,'New Delhi','in','Asia','India'),(115,'Jakarta','id','Asia','Indonesia'),(116,'Tehran','ir','Asia','Iran'),(117,'Baghdad','iq','Asia','Iraq'),(118,'Dublin','ie','Europe','Ireland'),(119,'Douglas','im','Europe','Isle of Man'),(120,'Jerusalem','il','Asia','Israel'),(121,'Rome','it','Europe','Italy'),(122,'Kingston','jm','North America','Jamaica'),(123,'Tokyo','jp','Asia','Japan'),(124,'Saint Helier','je','Europe','Jersey'),(125,'Amman','jo','Asia','Jordan'),(126,'Astana','kz','Asia','Kazakhstan'),(127,'Nairobi','ke','Africa','Kenya'),(128,'South Tarawa','ki','Oceania','Kiribati'),(129,'Pristina','xk','Europe','Kosovo'),(130,'Kuwait City','kw','Asia','Kuwait'),(131,'Bishkek','kg','Asia','Kyrgyzstan'),(132,'Vientiane','la','Asia','Laos'),(133,'Riga','lv','Europe','Latvia'),(134,'Beirut','lb','Asia','Lebanon'),(135,'Maseru','ls','Africa','Lesotho'),(136,'Monrovia','lr','Africa','Liberia'),(137,'Tripoli','ly','Africa','Libya'),(138,'Vaduz','li','Europe','Liechtenstein'),(139,'Vilnius','lt','Europe','Lithuania'),(140,'Luxembourg City','lu','Europe','Luxembourg'),(141,'Macau','mo','Asia','Macau'),(142,'Antananarivo','mg','Africa','Madagascar'),(143,'Lilongwe','mw','Africa','Malawi'),(144,'Kuala Lumpur','my','Asia','Malaysia'),(145,'Malé','mv','Asia','Maldives'),(146,'Bamako','ml','Africa','Mali'),(147,'Valletta','mt','Europe','Malta'),(148,'Majuro','mh','Oceania','Marshall Islands'),(149,'Fort-de-France','mq','North America','Martinique'),(150,'Nouakchott','mr','Africa','Mauritania'),(151,'Port Louis','mu','Africa','Mauritius'),(152,'Mamoudzou','yt','Africa','Mayotte'),(153,'Mexico City','mx','North America','Mexico'),(154,'Chișinău','md','Europe','Moldova'),(155,'Monaco','mc','Europe','Monaco'),(156,'Ulaanbaatar','mn','Asia','Mongolia'),(157,'Podgorica','me','Europe','Montenegro'),(158,'Little Bay, Brades, Plymouth','ms','North America','Montserrat'),(159,'Rabat','ma','Africa','Morocco'),(160,'Maputo','mz','Africa','Mozambique'),(161,'Naypyidaw','mm','Asia','Myanmar'),(162,'Windhoek','na','Africa','Namibia'),(163,'Yaren District','nr','Oceania','Nauru'),(164,'Kathmandu','np','Asia','Nepal'),(165,'Amsterdam','nl','Europe','Netherlands'),(166,'Nouméa','nc','Oceania','New Caledonia'),(167,'Wellington','nz','Oceania','New Zealand'),(168,'Managua','ni','North America','Nicaragua'),(169,'Niamey','ne','Africa','Niger'),(170,'Abuja','ng','Africa','Nigeria'),(171,'Alofi','nu','Oceania','Niue'),(172,'Kingston','nf','Oceania','Norfolk Island'),(173,'Pyongyang','kp','Asia','North Korea'),(174,'Skopje','mk','Europe','North Macedonia'),(175,'Belfast','gb-nir','Europe','Northern Ireland'),(176,'Saipan','mp','Oceania','Northern Mariana Islands'),(177,'Oslo','no','Europe','Norway'),(178,'Muscat','om','Asia','Oman'),(179,'Islamabad','pk','Asia','Pakistan'),(180,'Ngerulmud','pw','Oceania','Palau'),(181,'Panama City','pa','North America','Panama'),(182,'Port Moresby','pg','Oceania','Papua New Guinea'),(183,'Asunción','py','South America','Paraguay'),(184,'Lima','pe','South America','Peru'),(185,'Manila','ph','Asia','Philippines'),(186,'Adamstown','pn','Oceania','Pitcairn'),(187,'Warsaw','pl','Europe','Poland'),(188,'Lisbon','pt','Europe','Portugal'),(189,'San Juan','pr','North America','Puerto Rico'),(190,'Doha','qa','Asia','Qatar'),(191,'Brazzaville','cg','Africa','Republic of the Congo'),(192,'Bucharest','ro','Europe','Romania'),(193,'Moscow','ru','Europe','Russia'),(194,'Kigali','rw','Africa','Rwanda'),(195,'Saint-Denis','re','Africa','Réunion'),(196,'Gustavia','bl','North America','Saint Barthélemy'),(197,'Jamestown','sh','Africa','Saint Helena, Ascension and Tristan da Cunha'),(198,'Basseterre','kn','North America','Saint Kitts and Nevis'),(199,'Castries','lc','North America','Saint Lucia'),(200,'Marigot','mf','North America','Saint Martin'),(201,'Saint-Pierre','pm','North America','Saint Pierre and Miquelon'),(202,'Kingstown','vc','North America','Saint Vincent and the Grenadines'),(203,'Apia','ws','Oceania','Samoa'),(204,'San Marino','sm','Europe','San Marino'),(205,'São Tomé','st','Africa','Sao Tome and Principe'),(206,'Riyadh','sa','Asia','Saudi Arabia'),(207,'Edinburgh','gb-sct','Europe','Scotland'),(208,'Dakar','sn','Africa','Senegal'),(209,'Belgrade','rs','Europe','Serbia'),(210,'Victoria','sc','Africa','Seychelles'),(211,'Freetown','sl','Africa','Sierra Leone'),(212,'Singapore','sg','Asia','Singapore'),(213,'Philipsburg','sx','North America','Sint Maarten'),(214,'Bratislava','sk','Europe','Slovakia'),(215,'Ljubljana','si','Europe','Slovenia'),(216,'Honiara','sb','Oceania','Solomon Islands'),(217,'Mogadishu','so','Africa','Somalia'),(218,'Pretoria','za','Africa','South Africa'),(219,'King Edward Point','gs','Antarctica','South Georgia and the South Sandwich Islands'),(220,'Seoul','kr','Asia','South Korea'),(221,'Juba','ss','Africa','South Sudan'),(222,'Madrid','es','Europe','Spain'),(223,'Sri Jayawardenepura Kotte, Colombo','lk','Asia','Sri Lanka'),(224,'Ramallah','ps','Asia','State of Palestine'),(225,'Khartoum','sd','Africa','Sudan'),(226,'Paramaribo','sr','South America','Suriname'),(227,'Longyearbyen','sj','Europe','Svalbard and Jan Mayen'),(228,'Stockholm','se','Europe','Sweden'),(229,'Bern','ch','Europe','Switzerland'),(230,'Damascus','sy','Asia','Syria'),(231,'Taipei','tw','Asia','Taiwan'),(232,'Dushanbe','tj','Asia','Tajikistan'),(233,'Dodoma','tz','Africa','Tanzania'),(234,'Bangkok','th','Asia','Thailand'),(235,'Dili','tl','Asia','Timor-Leste'),(236,'Lomé','tg','Africa','Togo'),(237,'Nukunonu, Atafu,Tokelau','tk','Oceania','Tokelau'),(238,'Nukuʻalofa','to','Oceania','Tonga'),(239,'Port of Spain','tt','South America','Trinidad and Tobago'),(240,'','ta','','Tristan da Cunha'),(241,'Tunis','tn','Africa','Tunisia'),(242,'Ankara','tr','Asia','Turkey'),(243,'Ashgabat','tm','Asia','Turkmenistan'),(244,'Cockburn Town','tc','North America','Turks and Caicos Islands'),(245,'Funafuti','tv','Oceania','Tuvalu'),(246,'Kampala','ug','Africa','Uganda'),(247,'Kiev','ua','Europe','Ukraine'),(248,'Abu Dhabi','ae','Asia','United Arab Emirates'),(249,'London','gb','Europe','United Kingdom'),(250,'','un','','United Nations'),(251,'Washington, D.C.','um','North America','United States Minor Outlying Islands'),(252,'Washington, D.C.','us','North America','United States of America'),(253,'','xx','','Unknown'),(254,'Montevideo','uy','South America','Uruguay'),(255,'Tashkent','uz','Asia','Uzbekistan'),(256,'Port Vila','vu','Oceania','Vanuatu'),(257,'Caracas','ve','South America','Venezuela'),(258,'Hanoi','vn','Asia','Vietnam'),(259,'Road Town','vg','North America','Virgin Islands (British)'),(260,'Charlotte Amalie','vi','North America','Virgin Islands (U.S.)'),(261,'Cardiff','gb-wls','Europe','Wales'),(262,'Mata-Utu','wf','Oceania','Wallis and Futuna'),(263,'Laayoune','eh','Africa','Western Sahara'),(264,'Sana\'a','ye','Asia','Yemen'),(265,'Lusaka','zm','Africa','Zambia'),(266,'Harare','zw','Africa','Zimbabwe');
/*!40000 ALTER TABLE `flags` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `gdpr_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gdpr_settings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `enable_gdpr` tinyint(1) NOT NULL DEFAULT '0',
  `show_customer_area` tinyint(1) NOT NULL DEFAULT '0',
  `show_customer_footer` tinyint(1) NOT NULL DEFAULT '0',
  `top_information_block` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `enable_export` tinyint(1) NOT NULL DEFAULT '0',
  `data_removal` tinyint(1) NOT NULL DEFAULT '0',
  `lead_removal_public_form` tinyint(1) NOT NULL DEFAULT '0',
  `terms_customer_footer` tinyint(1) NOT NULL DEFAULT '0',
  `terms` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `policy` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `public_lead_edit` tinyint(1) NOT NULL DEFAULT '0',
  `consent_customer` tinyint(1) NOT NULL DEFAULT '0',
  `consent_leads` tinyint(1) NOT NULL DEFAULT '0',
  `consent_block` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `gdpr_settings` WRITE;
/*!40000 ALTER TABLE `gdpr_settings` DISABLE KEYS */;
INSERT INTO `gdpr_settings` VALUES (1,0,0,0,NULL,0,0,0,0,NULL,NULL,0,0,0,NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16');
/*!40000 ALTER TABLE `gdpr_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `global_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `global_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `global_app_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `light_logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `login_background` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logo_background_color` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `header_color` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '#1D82F5',
  `sidebar_logo_style` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'square',
  `locale` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'en',
  `hash` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `purchase_code` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `supported_until` timestamp NULL DEFAULT NULL,
  `last_license_verified_at` timestamp NULL DEFAULT NULL,
  `google_recaptcha_status` enum('active','deactive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'deactive',
  `google_recaptcha_v2_status` enum('active','deactive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'deactive',
  `google_recaptcha_v2_site_key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `google_recaptcha_v2_secret_key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `google_recaptcha_v3_status` enum('active','deactive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'deactive',
  `google_recaptcha_v3_site_key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `google_recaptcha_v3_secret_key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `app_debug` tinyint(1) NOT NULL DEFAULT '0',
  `currency_converter_key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency_key_version` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'free',
  `date_format` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'd-m-Y',
  `time_format` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'h:i a',
  `moment_format` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'DD-MM-YYYY',
  `timezone` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Asia/Kolkata',
  `rtl` tinyint(1) NOT NULL DEFAULT '0',
  `license_type` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hide_cron_message` tinyint(1) NOT NULL DEFAULT '0',
  `system_update` tinyint(1) NOT NULL DEFAULT '1',
  `show_review_modal` tinyint(1) NOT NULL DEFAULT '1',
  `last_cron_run` timestamp NULL DEFAULT NULL,
  `favicon` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `auth_theme` enum('dark','light') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'light',
  `session_driver` enum('file','database') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'file',
  `allowed_file_types` text COLLATE utf8mb4_unicode_ci,
  `allowed_file_size` int NOT NULL DEFAULT '10',
  `datatable_row_limit` int NOT NULL DEFAULT '10',
  `show_update_popup` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `google_map_key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `google_calendar_status` enum('active','inactive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'inactive',
  `google_client_id` text COLLATE utf8mb4_unicode_ci,
  `google_client_secret` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `global_settings` WRITE;
/*!40000 ALTER TABLE `global_settings` DISABLE KEYS */;
INSERT INTO `global_settings` VALUES (1,'Worksuite',NULL,NULL,NULL,'1','#1D82F5','square','en','16b1f54dd1ee8f974a3dd72d0e8052df',NULL,NULL,NULL,'deactive','deactive',NULL,NULL,'deactive',NULL,NULL,0,'','free','d-m-Y','h:i a','DD-MM-YYYY','Asia/Kolkata',0,NULL,0,1,1,NULL,NULL,'light','file','image/*,application/vnd.ms-excel,application/vnd.openxmlformats-officedocument.wordprocessingml.document,application/docx,application/pdf,text/plain,application/msword,application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,application/zip,application/x-zip-compressed, application/x-compressed, multipart/x-zip,.xlsx,video/x-flv,video/mp4,application/x-mpegURL,video/MP2T,video/3gpp,video/quicktime,video/x-msvideo,video/x-ms-wmv,application/sla,.stl',10,10,1,'2023-04-06 06:33:16','2023-04-06 06:35:54',NULL,'inactive',NULL,NULL);
/*!40000 ALTER TABLE `global_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `google_calendar_modules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `google_calendar_modules` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `lead_status` tinyint(1) NOT NULL DEFAULT '0',
  `leave_status` tinyint(1) NOT NULL DEFAULT '0',
  `invoice_status` tinyint(1) NOT NULL DEFAULT '0',
  `contract_status` tinyint(1) NOT NULL DEFAULT '0',
  `task_status` tinyint(1) NOT NULL DEFAULT '0',
  `event_status` tinyint(1) NOT NULL DEFAULT '0',
  `holiday_status` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `google_calendar_modules_company_id_foreign` (`company_id`),
  CONSTRAINT `google_calendar_modules_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `google_calendar_modules` WRITE;
/*!40000 ALTER TABLE `google_calendar_modules` DISABLE KEYS */;
INSERT INTO `google_calendar_modules` VALUES (1,1,0,0,0,0,0,0,0,'2023-04-06 06:33:16','2023-04-06 06:33:16');
/*!40000 ALTER TABLE `google_calendar_modules` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `holidays` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `date` date NOT NULL,
  `occassion` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `event_id` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `holidays_company_id_foreign` (`company_id`),
  KEY `holidays_date_index` (`date`),
  KEY `holidays_added_by_foreign` (`added_by`),
  KEY `holidays_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `holidays_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `holidays_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `holidays_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `holidays` WRITE;
/*!40000 ALTER TABLE `holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `holidays` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_item_images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoice_item_images` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `invoice_item_id` int unsigned NOT NULL,
  `filename` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `hashname` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_item_images_invoice_item_id_foreign` (`invoice_item_id`),
  CONSTRAINT `invoice_item_images_invoice_item_id_foreign` FOREIGN KEY (`invoice_item_id`) REFERENCES `invoice_items` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_item_images` WRITE;
/*!40000 ALTER TABLE `invoice_item_images` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoice_item_images` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoice_items` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `invoice_id` int unsigned NOT NULL,
  `item_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `item_summary` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `type` enum('item','discount','tax') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'item',
  `quantity` double(16,2) NOT NULL,
  `unit_price` double(16,2) NOT NULL,
  `amount` double(16,2) NOT NULL,
  `taxes` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hsn_sac_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_items_invoice_id_foreign` (`invoice_id`),
  CONSTRAINT `invoice_items_invoice_id_foreign` FOREIGN KEY (`invoice_id`) REFERENCES `invoices` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_items` WRITE;
/*!40000 ALTER TABLE `invoice_items` DISABLE KEYS */;
INSERT INTO `invoice_items` VALUES (1,1,'culpa',NULL,'item',16.00,1557.00,24912.00,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(2,1,'rerum',NULL,'item',18.00,1853.00,33354.00,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(3,2,'et',NULL,'item',16.00,1479.00,23664.00,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(4,2,'corporis',NULL,'item',14.00,1115.00,15610.00,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(5,3,'nobis',NULL,'item',17.00,1777.00,30209.00,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(6,3,'est',NULL,'item',3.00,1422.00,4266.00,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(7,4,'in',NULL,'item',14.00,1199.00,16786.00,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(8,4,'dolor',NULL,'item',17.00,1614.00,27438.00,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(9,5,'tempora',NULL,'item',7.00,1885.00,13195.00,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(10,5,'rerum',NULL,'item',6.00,1896.00,11376.00,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(11,6,'non',NULL,'item',14.00,1900.00,26600.00,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(12,6,'omnis',NULL,'item',10.00,1018.00,10180.00,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(13,7,'sint',NULL,'item',17.00,1987.00,33779.00,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(14,7,'excepturi',NULL,'item',13.00,1639.00,21307.00,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(15,8,'deleniti',NULL,'item',6.00,1205.00,7230.00,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(16,8,'saepe',NULL,'item',3.00,1475.00,4425.00,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(17,9,'doloremque',NULL,'item',19.00,1750.00,33250.00,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(18,9,'tenetur',NULL,'item',19.00,1482.00,28158.00,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(19,10,'ipsum',NULL,'item',2.00,1371.00,2742.00,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(20,10,'deserunt',NULL,'item',16.00,1702.00,27232.00,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(21,11,'ipsa',NULL,'item',2.00,1739.00,3478.00,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(22,11,'autem',NULL,'item',3.00,1822.00,5466.00,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(23,12,'vel',NULL,'item',14.00,1962.00,27468.00,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(24,12,'id',NULL,'item',14.00,1892.00,26488.00,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(25,13,'reprehenderit',NULL,'item',14.00,1588.00,22232.00,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(26,13,'aut',NULL,'item',6.00,1384.00,8304.00,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(27,14,'architecto',NULL,'item',2.00,1632.00,3264.00,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(28,14,'necessitatibus',NULL,'item',19.00,1367.00,25973.00,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(29,15,'autem',NULL,'item',1.00,1710.00,1710.00,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(30,15,'ut',NULL,'item',19.00,1869.00,35511.00,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(31,16,'consequatur',NULL,'item',13.00,1311.00,17043.00,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(32,16,'magni',NULL,'item',4.00,1455.00,5820.00,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(33,17,'deserunt',NULL,'item',4.00,1215.00,4860.00,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(34,17,'sed',NULL,'item',12.00,1542.00,18504.00,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(35,18,'pariatur',NULL,'item',15.00,1333.00,19995.00,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(36,18,'quia',NULL,'item',3.00,1401.00,4203.00,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(37,19,'eius',NULL,'item',1.00,1372.00,1372.00,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(38,19,'sequi',NULL,'item',14.00,1334.00,18676.00,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(39,20,'quis',NULL,'item',10.00,1602.00,16020.00,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(40,20,'placeat',NULL,'item',11.00,1095.00,12045.00,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(41,21,'in',NULL,'item',1.00,1457.00,1457.00,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(42,21,'consequatur',NULL,'item',18.00,1980.00,35640.00,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18');
/*!40000 ALTER TABLE `invoice_items` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_recurring`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoice_recurring` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `currency_id` int unsigned DEFAULT NULL,
  `project_id` int unsigned DEFAULT NULL,
  `client_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned DEFAULT NULL,
  `created_by` int unsigned DEFAULT NULL,
  `issue_date` date NOT NULL,
  `next_invoice_date` date DEFAULT NULL,
  `due_date` date NOT NULL,
  `sub_total` double NOT NULL DEFAULT '0',
  `total` double NOT NULL DEFAULT '0',
  `discount` double NOT NULL DEFAULT '0',
  `discount_type` enum('percent','fixed') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'percent',
  `status` enum('active','inactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `file` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file_original_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `show_shipping_address` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `day_of_month` int DEFAULT '1',
  `day_of_week` int DEFAULT '1',
  `payment_method` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `rotation` enum('monthly','weekly','bi-weekly','quarterly','half-yearly','annually','daily') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `billing_cycle` int DEFAULT NULL,
  `client_can_stop` tinyint(1) NOT NULL DEFAULT '1',
  `unlimited_recurring` tinyint(1) NOT NULL DEFAULT '0',
  `deleted_at` datetime DEFAULT NULL,
  `shipping_address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `calculate_tax` enum('after_discount','before_discount') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'after_discount',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `unit_id` bigint unsigned DEFAULT NULL,
  `immediate_invoice` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `invoice_recurring_company_id_foreign` (`company_id`),
  KEY `invoice_recurring_currency_id_foreign` (`currency_id`),
  KEY `invoice_recurring_project_id_foreign` (`project_id`),
  KEY `invoice_recurring_client_id_foreign` (`client_id`),
  KEY `invoice_recurring_user_id_foreign` (`user_id`),
  KEY `invoice_recurring_created_by_foreign` (`created_by`),
  KEY `invoice_recurring_added_by_foreign` (`added_by`),
  KEY `invoice_recurring_last_updated_by_foreign` (`last_updated_by`),
  KEY `invoice_recurring_unit_id_foreign` (`unit_id`),
  CONSTRAINT `invoice_recurring_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `invoice_recurring_client_id_foreign` FOREIGN KEY (`client_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `invoice_recurring_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `invoice_recurring_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `invoice_recurring_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `invoice_recurring_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `invoice_recurring_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `invoice_recurring_unit_id_foreign` FOREIGN KEY (`unit_id`) REFERENCES `unit_types` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `invoice_recurring_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_recurring` WRITE;
/*!40000 ALTER TABLE `invoice_recurring` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoice_recurring` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_recurring_item_images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoice_recurring_item_images` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `invoice_recurring_item_id` int unsigned NOT NULL,
  `filename` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `hashname` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_recurring_item_images_invoice_recurring_item_id_foreign` (`invoice_recurring_item_id`),
  CONSTRAINT `invoice_recurring_item_images_invoice_recurring_item_id_foreign` FOREIGN KEY (`invoice_recurring_item_id`) REFERENCES `invoice_recurring_items` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_recurring_item_images` WRITE;
/*!40000 ALTER TABLE `invoice_recurring_item_images` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoice_recurring_item_images` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_recurring_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoice_recurring_items` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `invoice_recurring_id` bigint unsigned NOT NULL,
  `item_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `quantity` double NOT NULL,
  `unit_price` double NOT NULL,
  `amount` double NOT NULL,
  `taxes` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `type` enum('item','discount','tax') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'item',
  `item_summary` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `hsn_sac_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_recurring_items_invoice_recurring_id_foreign` (`invoice_recurring_id`),
  CONSTRAINT `invoice_recurring_items_invoice_recurring_id_foreign` FOREIGN KEY (`invoice_recurring_id`) REFERENCES `invoice_recurring` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_recurring_items` WRITE;
/*!40000 ALTER TABLE `invoice_recurring_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoice_recurring_items` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoice_settings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `invoice_prefix` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `invoice_number_separator` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '#',
  `invoice_digit` int unsigned NOT NULL DEFAULT '3',
  `estimate_prefix` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'EST',
  `estimate_number_separator` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '#',
  `estimate_digit` int unsigned NOT NULL DEFAULT '3',
  `credit_note_prefix` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'CN',
  `credit_note_number_separator` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '#',
  `credit_note_digit` int unsigned NOT NULL DEFAULT '3',
  `contract_prefix` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'CONT',
  `contract_number_separator` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '#',
  `contract_digit` int unsigned NOT NULL DEFAULT '3',
  `order_prefix` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'ODR',
  `order_number_separator` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '#',
  `order_digit` int unsigned NOT NULL DEFAULT '3',
  `template` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `due_after` int NOT NULL,
  `invoice_terms` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `estimate_terms` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `gst_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_gst` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `logo` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hsn_sac_code_show` tinyint(1) NOT NULL DEFAULT '0',
  `locale` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'en',
  `send_reminder` int NOT NULL DEFAULT '0',
  `reminder` enum('after','every') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `send_reminder_after` int NOT NULL DEFAULT '0',
  `tax_calculation_msg` tinyint(1) NOT NULL DEFAULT '0',
  `show_status` tinyint(1) NOT NULL DEFAULT '1',
  `authorised_signatory` tinyint(1) NOT NULL DEFAULT '0',
  `authorised_signatory_signature` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_project` int NOT NULL DEFAULT '0',
  `show_client_name` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `show_client_email` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `show_client_phone` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `show_client_company_address` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `show_client_company_name` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_settings_company_id_foreign` (`company_id`),
  CONSTRAINT `invoice_settings_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_settings` WRITE;
/*!40000 ALTER TABLE `invoice_settings` DISABLE KEYS */;
INSERT INTO `invoice_settings` VALUES (1,1,'INV','#',3,'EST','#',3,'CN','#',3,'CONT','#',3,'ODR','#',3,'invoice-5',15,'Thank you for your business.',NULL,NULL,'no',NULL,0,'en',0,NULL,0,0,1,0,NULL,0,'yes','yes','yes','yes','yes','2023-04-06 06:33:16','2023-04-06 06:33:16');
/*!40000 ALTER TABLE `invoice_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `project_id` int unsigned DEFAULT NULL,
  `client_id` int unsigned DEFAULT NULL,
  `order_id` bigint unsigned DEFAULT NULL,
  `invoice_number` bigint NOT NULL,
  `issue_date` date NOT NULL,
  `due_date` date NOT NULL,
  `sub_total` double(16,2) NOT NULL,
  `discount` double NOT NULL DEFAULT '0',
  `discount_type` enum('percent','fixed') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'percent',
  `total` double(16,2) NOT NULL,
  `currency_id` int unsigned DEFAULT NULL,
  `default_currency_id` int unsigned DEFAULT NULL,
  `exchange_rate` double DEFAULT NULL,
  `status` enum('paid','unpaid','partial','canceled','draft') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'unpaid',
  `recurring` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `billing_cycle` int DEFAULT NULL,
  `billing_interval` int DEFAULT NULL,
  `billing_frequency` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file_original_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `credit_note` tinyint(1) NOT NULL DEFAULT '0',
  `show_shipping_address` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `estimate_id` int unsigned DEFAULT NULL,
  `send_status` tinyint(1) NOT NULL DEFAULT '1',
  `due_amount` double(8,2) NOT NULL DEFAULT '0.00',
  `parent_id` int unsigned DEFAULT NULL,
  `invoice_recurring_id` bigint unsigned DEFAULT NULL,
  `created_by` int unsigned DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `hash` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `calculate_tax` enum('after_discount','before_discount') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'after_discount',
  `company_address_id` bigint unsigned DEFAULT NULL,
  `event_id` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `custom_invoice_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_status` enum('1','0') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `offline_method_id` int unsigned DEFAULT NULL,
  `transaction_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gateway` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `bank_account_id` int unsigned DEFAULT NULL,
  `last_viewed` timestamp NULL DEFAULT NULL,
  `ip_address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `unit_id` bigint unsigned DEFAULT NULL,
  `quickbooks_invoice_id` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `invoices_invoice_number_company_id_unique` (`invoice_number`,`company_id`),
  UNIQUE KEY `invoices_transaction_id_unique` (`transaction_id`),
  KEY `invoices_company_id_foreign` (`company_id`),
  KEY `invoices_project_id_foreign` (`project_id`),
  KEY `invoices_client_id_foreign` (`client_id`),
  KEY `invoices_order_id_foreign` (`order_id`),
  KEY `invoices_due_date_index` (`due_date`),
  KEY `invoices_currency_id_foreign` (`currency_id`),
  KEY `invoices_estimate_id_foreign` (`estimate_id`),
  KEY `invoices_parent_id_foreign` (`parent_id`),
  KEY `invoices_invoice_recurring_id_foreign` (`invoice_recurring_id`),
  KEY `invoices_created_by_foreign` (`created_by`),
  KEY `invoices_added_by_foreign` (`added_by`),
  KEY `invoices_last_updated_by_foreign` (`last_updated_by`),
  KEY `invoices_company_address_id_foreign` (`company_address_id`),
  KEY `invoices_bank_account_id_foreign` (`bank_account_id`),
  KEY `invoices_default_currency_id_foreign` (`default_currency_id`),
  KEY `invoices_unit_id_foreign` (`unit_id`),
  KEY `payments_offline_method_id_foreign` (`offline_method_id`),
  CONSTRAINT `invoices_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `invoices_bank_account_id_foreign` FOREIGN KEY (`bank_account_id`) REFERENCES `bank_accounts` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `invoices_client_id_foreign` FOREIGN KEY (`client_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `invoices_company_address_id_foreign` FOREIGN KEY (`company_address_id`) REFERENCES `company_addresses` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `invoices_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `invoices_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `invoices_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `invoices_default_currency_id_foreign` FOREIGN KEY (`default_currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `invoices_estimate_id_foreign` FOREIGN KEY (`estimate_id`) REFERENCES `estimates` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `invoices_invoice_recurring_id_foreign` FOREIGN KEY (`invoice_recurring_id`) REFERENCES `invoice_recurring` (`id`) ON DELETE SET NULL,
  CONSTRAINT `invoices_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `invoices_offline_method_id_foreign` FOREIGN KEY (`offline_method_id`) REFERENCES `offline_payment_methods` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `invoices_order_id_foreign` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `invoices_parent_id_foreign` FOREIGN KEY (`parent_id`) REFERENCES `invoices` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `invoices_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `invoices_unit_id_foreign` FOREIGN KEY (`unit_id`) REFERENCES `unit_types` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoices` WRITE;
/*!40000 ALTER TABLE `invoices` DISABLE KEYS */;
INSERT INTO `invoices` VALUES (1,1,1,6,NULL,1,'2023-03-08','2023-03-18',58266.00,0,'percent',58266.00,1,1,1,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'e9c1f762cea72848fda7549dae853692','after_discount',1,NULL,'INV#001','0',NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',2,NULL,NULL,1,NULL),(2,1,1,6,NULL,2,'2023-03-27','2023-04-06',39274.00,0,'percent',39274.00,1,1,1,'unpaid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no',NULL,1,39274.00,NULL,NULL,NULL,NULL,NULL,'328c64c5de8387248311bf9516d7fe8d','after_discount',1,NULL,'INV#002','0',NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',2,NULL,NULL,1,NULL),(3,1,2,10,NULL,3,'2023-03-22','2023-04-01',34475.00,0,'percent',34475.00,1,1,1,'unpaid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no',NULL,1,34475.00,NULL,NULL,NULL,NULL,NULL,'b2c7936ded2ef43f3d5aa9361d621cfb','after_discount',1,NULL,'INV#003','0',NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',2,NULL,NULL,1,NULL),(4,1,2,10,NULL,4,'2023-03-09','2023-03-19',44224.00,0,'percent',44224.00,1,1,1,'unpaid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no',NULL,1,44224.00,NULL,NULL,NULL,NULL,NULL,'1f91cee1cb588f2df01365f010bf590e','after_discount',1,NULL,'INV#004','0',NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',2,NULL,NULL,1,NULL),(5,1,3,5,NULL,5,'2023-03-07','2023-03-17',24571.00,0,'percent',24571.00,1,1,1,'unpaid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no',NULL,1,24571.00,NULL,NULL,NULL,NULL,NULL,'0684cd8245c2fcf85e1a2156874a76d9','after_discount',1,NULL,'INV#005','0',NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',2,NULL,NULL,1,NULL),(6,1,3,5,NULL,6,'2023-03-11','2023-03-21',36780.00,0,'percent',36780.00,1,1,1,'unpaid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no',NULL,1,36780.00,NULL,NULL,NULL,NULL,NULL,'1880816bf7202f5b5cdb17dae014d07a','after_discount',1,NULL,'INV#006','0',NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',2,NULL,NULL,1,NULL),(7,1,3,5,NULL,7,'2023-03-16','2023-03-26',55086.00,0,'percent',55086.00,1,1,1,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'04e2ae04ee338d3a180975020d21d3f4','after_discount',1,NULL,'INV#007','0',NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',2,NULL,NULL,1,NULL),(8,1,4,11,NULL,8,'2023-03-27','2023-04-06',11655.00,0,'percent',11655.00,1,1,1,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'b6cefceec52a7c6bf5a8a7f8f265c537','after_discount',1,NULL,'INV#008','0',NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',2,NULL,NULL,1,NULL),(9,1,4,11,NULL,9,'2023-03-25','2023-04-04',61408.00,0,'percent',61408.00,1,1,1,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'2b57d9b2d17efa90f5997133aa1b1b53','after_discount',1,NULL,'INV#009','0',NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',1,NULL,NULL,1,NULL),(10,1,5,3,NULL,10,'2023-03-29','2023-04-08',29974.00,0,'percent',29974.00,1,1,1,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'7826d99170ec516c24ea792589e95f17','after_discount',1,NULL,'INV#010','0',NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',2,NULL,NULL,1,NULL),(11,1,5,3,NULL,11,'2023-03-17','2023-03-27',8944.00,0,'percent',8944.00,1,1,1,'unpaid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no',NULL,1,8944.00,NULL,NULL,NULL,NULL,NULL,'b3fed0a2e6e9ca5a2d29ecb9b3a74e01','after_discount',1,NULL,'INV#011','0',NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',2,NULL,NULL,1,NULL),(12,1,5,3,NULL,12,'2023-03-24','2023-04-03',53956.00,0,'percent',53956.00,1,1,1,'unpaid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no',NULL,1,53956.00,NULL,NULL,NULL,NULL,NULL,'96f4088f0900ac0d326b4bbf207644da','after_discount',1,NULL,'INV#012','0',NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',2,NULL,NULL,1,NULL),(13,1,6,12,NULL,13,'2023-03-02','2023-03-12',30536.00,0,'percent',30536.00,1,1,1,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'9381873f2f942efcdc70b4c4000e8e1e','after_discount',1,NULL,'INV#013','0',NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',1,NULL,NULL,1,NULL),(14,1,6,12,NULL,14,'2023-03-10','2023-03-20',29237.00,0,'percent',29237.00,1,1,1,'unpaid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no',NULL,1,29237.00,NULL,NULL,NULL,NULL,NULL,'4d7d76a209c4a0c9a8b7556ffcb80dbb','after_discount',1,NULL,'INV#014','0',NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',1,NULL,NULL,1,NULL),(15,1,6,12,NULL,15,'2023-03-18','2023-03-28',37221.00,0,'percent',37221.00,1,1,1,'unpaid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no',NULL,1,37221.00,NULL,NULL,NULL,NULL,NULL,'629b27dcb2942638539665a1a6c775cf','after_discount',1,NULL,'INV#015','0',NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',2,NULL,NULL,1,NULL),(16,1,7,6,NULL,16,'2023-03-25','2023-04-04',22863.00,0,'percent',22863.00,1,1,1,'unpaid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no',NULL,1,22863.00,NULL,NULL,NULL,NULL,NULL,'c19dfc21ad804efaea0d362113476f6e','after_discount',1,NULL,'INV#016','0',NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',1,NULL,NULL,1,NULL),(17,1,7,6,NULL,17,'2023-03-02','2023-03-12',23364.00,0,'percent',23364.00,1,1,1,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'f7c99bff39d7af9601a984ad5ebf7b82','after_discount',1,NULL,'INV#017','0',NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',2,NULL,NULL,1,NULL),(18,1,7,6,NULL,18,'2023-03-04','2023-03-14',24198.00,0,'percent',24198.00,1,1,1,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'be1da7a7bb61d12e0df497b2f4302b3b','after_discount',1,NULL,'INV#018','0',NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',2,NULL,NULL,1,NULL),(19,1,8,13,NULL,19,'2023-03-10','2023-03-20',20048.00,0,'percent',20048.00,1,1,1,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'e10e900e4d88cc2deea303588d28d515','after_discount',1,NULL,'INV#019','0',NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',1,NULL,NULL,1,NULL),(20,1,9,10,NULL,20,'2023-03-15','2023-03-25',28065.00,0,'percent',28065.00,1,1,1,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'b80a25c3bbd7e69a0904b1a7412cdfce','after_discount',1,NULL,'INV#020','0',NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',1,NULL,NULL,1,NULL),(21,1,10,7,NULL,21,'2023-03-04','2023-03-14',37097.00,0,'percent',37097.00,1,1,1,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'f65267d1533053b09e68fdeda8533ae1','after_discount',1,NULL,'INV#021','0',NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',1,NULL,NULL,1,NULL);
/*!40000 ALTER TABLE `invoices` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `issues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `issues` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int unsigned DEFAULT NULL,
  `project_id` int unsigned DEFAULT NULL,
  `status` enum('pending','resolved') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `issues_company_id_foreign` (`company_id`),
  KEY `issues_user_id_foreign` (`user_id`),
  KEY `issues_project_id_foreign` (`project_id`),
  CONSTRAINT `issues_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `issues_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `issues_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `issues` WRITE;
/*!40000 ALTER TABLE `issues` DISABLE KEYS */;
/*!40000 ALTER TABLE `issues` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `job_batches`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `job_batches` (
  `id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_jobs` int NOT NULL,
  `pending_jobs` int NOT NULL,
  `failed_jobs` int NOT NULL,
  `failed_job_ids` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `cancelled_at` int DEFAULT NULL,
  `created_at` int NOT NULL,
  `finished_at` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `job_batches` WRITE;
/*!40000 ALTER TABLE `job_batches` DISABLE KEYS */;
/*!40000 ALTER TABLE `job_batches` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `job_interview_stages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `job_interview_stages` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `recruit_job_id` bigint unsigned NOT NULL,
  `recruit_interview_stage_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `job_interview_stages_recruit_job_id_foreign` (`recruit_job_id`),
  KEY `jis_recruit_interview_stage_id_foreign` (`recruit_interview_stage_id`),
  CONSTRAINT `jis_recruit_interview_stage_id_foreign` FOREIGN KEY (`recruit_interview_stage_id`) REFERENCES `recruit_interview_stages` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `job_interview_stages_recruit_job_id_foreign` FOREIGN KEY (`recruit_job_id`) REFERENCES `recruit_jobs` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `job_interview_stages` WRITE;
/*!40000 ALTER TABLE `job_interview_stages` DISABLE KEYS */;
/*!40000 ALTER TABLE `job_interview_stages` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint unsigned NOT NULL,
  `reserved_at` int unsigned DEFAULT NULL,
  `available_at` int unsigned NOT NULL,
  `created_at` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
INSERT INTO `jobs` VALUES (2,'default','{\"uuid\":\"776b4494-1442-4bbf-b196-2967c4e8a8e4\",\"displayName\":\"Illuminate\\\\Foundation\\\\Console\\\\QueuedCommand\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"Illuminate\\\\Foundation\\\\Console\\\\QueuedCommand\",\"command\":\"O:43:\\\"Illuminate\\\\Foundation\\\\Console\\\\QueuedCommand\\\":10:{s:7:\\\"\\u0000*\\u0000data\\\";a:2:{i:0;s:10:\\\"backup:run\\\";i:1;a:2:{s:9:\\\"--only-db\\\";b:1;s:23:\\\"--disable-notifications\\\";b:1;}}s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:19:\\\"chainCatchCallbacks\\\";N;s:5:\\\"delay\\\";N;s:11:\\\"afterCommit\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}',1,1680786444,1680786441,1680786441);
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `knowledge_base_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `knowledge_base_files` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `knowledge_base_id` int unsigned NOT NULL,
  `filename` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hashname` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link` text COLLATE utf8mb4_unicode_ci,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `knowledge_base_files_company_id_foreign` (`company_id`),
  KEY `knowledge_base_files_knowledge_base_id_foreign` (`knowledge_base_id`),
  KEY `knowledge_base_files_added_by_foreign` (`added_by`),
  KEY `knowledge_base_files_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `knowledge_base_files_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `knowledge_base_files_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `knowledge_base_files_knowledge_base_id_foreign` FOREIGN KEY (`knowledge_base_id`) REFERENCES `knowledge_bases` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `knowledge_base_files_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `knowledge_base_files` WRITE;
/*!40000 ALTER TABLE `knowledge_base_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `knowledge_base_files` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `knowledge_bases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `knowledge_bases` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `to` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'employee',
  `heading` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `category_id` int unsigned DEFAULT NULL,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `added_by` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `knowledge_bases_company_id_foreign` (`company_id`),
  KEY `knowledge_bases_category_id_foreign` (`category_id`),
  CONSTRAINT `knowledge_bases_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `knowledge_categories` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `knowledge_bases_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `knowledge_bases` WRITE;
/*!40000 ALTER TABLE `knowledge_bases` DISABLE KEYS */;
/*!40000 ALTER TABLE `knowledge_bases` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `knowledge_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `knowledge_categories` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `knowledge_categories_company_id_foreign` (`company_id`),
  CONSTRAINT `knowledge_categories_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `knowledge_categories` WRITE;
/*!40000 ALTER TABLE `knowledge_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `knowledge_categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `language_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `language_settings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `language_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `language_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` enum('enabled','disabled') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `flag_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `language_settings` WRITE;
/*!40000 ALTER TABLE `language_settings` DISABLE KEYS */;
INSERT INTO `language_settings` VALUES (1,'en','English','enabled',NULL,NULL,'en'),(2,'ar','Arabic','disabled',NULL,NULL,'sa'),(3,'de','German','disabled',NULL,NULL,'de'),(4,'es','Spanish','disabled',NULL,NULL,'es'),(5,'et','Estonian','disabled',NULL,NULL,'et'),(6,'fa','Farsi','disabled',NULL,NULL,'ir'),(7,'fr','French','disabled',NULL,NULL,'fr'),(8,'gr','Greek','disabled',NULL,NULL,'gr'),(9,'it','Italian','disabled',NULL,NULL,'it'),(10,'nl','Dutch','disabled',NULL,NULL,'nl'),(11,'pl','Polish','disabled',NULL,NULL,'pl'),(12,'pt','Portuguese','disabled',NULL,NULL,'pt'),(13,'pt-br','Portuguese (Brazil)','disabled',NULL,NULL,'br'),(14,'ro','Romanian','disabled',NULL,NULL,'ro'),(15,'ru','Russian','disabled',NULL,NULL,'ru'),(16,'tr','Turkish','disabled',NULL,NULL,'tr'),(17,'zh-CN','Chinese (S)','disabled',NULL,NULL,'cn'),(18,'zh-TW','Chinese (T)','disabled',NULL,NULL,'cn');
/*!40000 ALTER TABLE `language_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `lead_agents`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `lead_agents` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `status` enum('enabled','disabled') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'enabled',
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `lead_agents_company_id_foreign` (`company_id`),
  KEY `lead_agents_user_id_foreign` (`user_id`),
  KEY `lead_agents_added_by_foreign` (`added_by`),
  KEY `lead_agents_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `lead_agents_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `lead_agents_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `lead_agents_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `lead_agents_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `lead_agents` WRITE;
/*!40000 ALTER TABLE `lead_agents` DISABLE KEYS */;
INSERT INTO `lead_agents` VALUES (1,1,16,'enabled',NULL,NULL,NULL,NULL),(2,1,14,'enabled',NULL,NULL,NULL,NULL),(3,1,22,'enabled',NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `lead_agents` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `lead_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `lead_category` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `category_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `lead_category_company_id_foreign` (`company_id`),
  KEY `lead_category_added_by_foreign` (`added_by`),
  KEY `lead_category_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `lead_category_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `lead_category_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `lead_category_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `lead_category` WRITE;
/*!40000 ALTER TABLE `lead_category` DISABLE KEYS */;
/*!40000 ALTER TABLE `lead_category` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `lead_custom_forms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `lead_custom_forms` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `custom_fields_id` int unsigned DEFAULT NULL,
  `field_display_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_order` int NOT NULL,
  `status` enum('active','inactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `lead_custom_forms_company_id_foreign` (`company_id`),
  KEY `lead_custom_forms_custom_fields_id_foreign` (`custom_fields_id`),
  KEY `lead_custom_forms_added_by_foreign` (`added_by`),
  KEY `lead_custom_forms_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `lead_custom_forms_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `lead_custom_forms_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `lead_custom_forms_custom_fields_id_foreign` FOREIGN KEY (`custom_fields_id`) REFERENCES `custom_fields` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `lead_custom_forms_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `lead_custom_forms` WRITE;
/*!40000 ALTER TABLE `lead_custom_forms` DISABLE KEYS */;
INSERT INTO `lead_custom_forms` VALUES (1,1,NULL,'Name','name',1,'active',1,NULL,NULL,NULL,NULL),(2,1,NULL,'Email','email',2,'active',0,NULL,NULL,NULL,NULL),(3,1,NULL,'Company Name','company_name',3,'active',0,NULL,NULL,NULL,NULL),(4,1,NULL,'Website','website',4,'active',0,NULL,NULL,NULL,NULL),(5,1,NULL,'Address','address',5,'active',0,NULL,NULL,NULL,NULL),(6,1,NULL,'Mobile','mobile',6,'active',0,NULL,NULL,NULL,NULL),(7,1,NULL,'Message','message',7,'active',0,NULL,NULL,NULL,NULL),(8,1,NULL,'City','city',1,'active',0,NULL,NULL,NULL,NULL),(9,1,NULL,'State','state',2,'active',0,NULL,NULL,NULL,NULL),(10,1,NULL,'Country','country',3,'active',0,NULL,NULL,NULL,NULL),(11,1,NULL,'Postal Code','postal_code',4,'active',0,NULL,NULL,NULL,NULL),(12,1,NULL,'Source','source',8,'active',0,NULL,NULL,NULL,NULL),(13,1,NULL,'Product','product',9,'active',0,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `lead_custom_forms` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `lead_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `lead_files` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `lead_id` int unsigned NOT NULL,
  `user_id` int unsigned NOT NULL,
  `filename` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `hashname` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `google_url` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dropbox_link` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `lead_files_lead_id_foreign` (`lead_id`),
  KEY `lead_files_user_id_foreign` (`user_id`),
  KEY `lead_files_added_by_foreign` (`added_by`),
  KEY `lead_files_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `lead_files_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `lead_files_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `lead_files_lead_id_foreign` FOREIGN KEY (`lead_id`) REFERENCES `leads` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `lead_files_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `lead_files` WRITE;
/*!40000 ALTER TABLE `lead_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `lead_files` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `lead_follow_up`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `lead_follow_up` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `lead_id` int unsigned NOT NULL,
  `remark` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `next_follow_up_date` datetime DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `event_id` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `send_reminder` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `remind_time` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `remind_type` enum('minute','hour','day') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `lead_follow_up_lead_id_foreign` (`lead_id`),
  KEY `lead_follow_up_added_by_foreign` (`added_by`),
  KEY `lead_follow_up_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `lead_follow_up_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `lead_follow_up_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `lead_follow_up_lead_id_foreign` FOREIGN KEY (`lead_id`) REFERENCES `leads` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `lead_follow_up` WRITE;
/*!40000 ALTER TABLE `lead_follow_up` DISABLE KEYS */;
/*!40000 ALTER TABLE `lead_follow_up` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `lead_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `lead_notes` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `lead_id` int unsigned DEFAULT NULL,
  `title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `member_id` int unsigned DEFAULT NULL,
  `is_lead_show` tinyint(1) NOT NULL DEFAULT '0',
  `ask_password` tinyint(1) NOT NULL DEFAULT '0',
  `details` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `lead_notes_lead_id_foreign` (`lead_id`),
  KEY `lead_notes_member_id_foreign` (`member_id`),
  KEY `lead_notes_added_by_foreign` (`added_by`),
  KEY `lead_notes_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `lead_notes_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `lead_notes_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `lead_notes_lead_id_foreign` FOREIGN KEY (`lead_id`) REFERENCES `leads` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `lead_notes_member_id_foreign` FOREIGN KEY (`member_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `lead_notes` WRITE;
/*!40000 ALTER TABLE `lead_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `lead_notes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `lead_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `lead_products` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lead_id` int unsigned NOT NULL,
  `product_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `lead_products_lead_id_foreign` (`lead_id`),
  KEY `lead_products_product_id_foreign` (`product_id`),
  CONSTRAINT `lead_products_lead_id_foreign` FOREIGN KEY (`lead_id`) REFERENCES `leads` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `lead_products_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `lead_products` WRITE;
/*!40000 ALTER TABLE `lead_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `lead_products` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `lead_sources`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `lead_sources` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `lead_sources_type_company_id_unique` (`type`,`company_id`),
  KEY `lead_sources_company_id_foreign` (`company_id`),
  KEY `lead_sources_added_by_foreign` (`added_by`),
  KEY `lead_sources_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `lead_sources_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `lead_sources_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `lead_sources_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `lead_sources` WRITE;
/*!40000 ALTER TABLE `lead_sources` DISABLE KEYS */;
INSERT INTO `lead_sources` VALUES (1,1,'email',NULL,NULL,NULL,NULL),(2,1,'google',NULL,NULL,NULL,NULL),(3,1,'facebook',NULL,NULL,NULL,NULL),(4,1,'friend',NULL,NULL,NULL,NULL),(5,1,'direct visit',NULL,NULL,NULL,NULL),(6,1,'tv ad',NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `lead_sources` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `lead_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `lead_status` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `priority` int NOT NULL,
  `default` tinyint(1) NOT NULL,
  `label_color` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '#ff0000',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `lead_status_type_company_id_unique` (`type`,`company_id`),
  KEY `lead_status_company_id_foreign` (`company_id`),
  CONSTRAINT `lead_status_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `lead_status` WRITE;
/*!40000 ALTER TABLE `lead_status` DISABLE KEYS */;
INSERT INTO `lead_status` VALUES (1,1,'pending',1,1,'#FFE700',NULL,NULL),(2,1,'inprocess',2,0,'#009EFF',NULL,NULL),(3,1,'done',3,0,'#1FAE07',NULL,NULL);
/*!40000 ALTER TABLE `lead_status` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `lead_user_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `lead_user_notes` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL,
  `lead_note_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `lead_user_notes_user_id_foreign` (`user_id`),
  KEY `lead_user_notes_lead_note_id_foreign` (`lead_note_id`),
  CONSTRAINT `lead_user_notes_lead_note_id_foreign` FOREIGN KEY (`lead_note_id`) REFERENCES `lead_notes` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `lead_user_notes_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `lead_user_notes` WRITE;
/*!40000 ALTER TABLE `lead_user_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `lead_user_notes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `leads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `leads` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `client_id` int DEFAULT NULL,
  `source_id` int DEFAULT NULL,
  `status_id` int DEFAULT NULL,
  `column_priority` int NOT NULL,
  `agent_id` bigint unsigned DEFAULT NULL,
  `company_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `website` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `salutation` enum('mr','mrs','miss','dr','sir','madam') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `client_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cell` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `office` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `postal_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `next_follow_up` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `value` double DEFAULT '0',
  `currency_id` int unsigned DEFAULT NULL,
  `category_id` int unsigned DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `hash` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `leads_company_id_foreign` (`company_id`),
  KEY `leads_agent_id_foreign` (`agent_id`),
  KEY `leads_currency_id_foreign` (`currency_id`),
  KEY `leads_category_id_foreign` (`category_id`),
  KEY `leads_added_by_foreign` (`added_by`),
  KEY `leads_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `leads_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `leads_agent_id_foreign` FOREIGN KEY (`agent_id`) REFERENCES `lead_agents` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `leads_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `lead_category` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `leads_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `leads_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `leads_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `leads` WRITE;
/*!40000 ALTER TABLE `leads` DISABLE KEYS */;
INSERT INTO `leads` VALUES (1,1,NULL,NULL,1,0,1,'Test Lead','https://worksuite.biz','Jaipur, India',NULL,'John Doe','testing@test.com','123456789',NULL,NULL,NULL,NULL,NULL,NULL,'Quas consectetur, tempor incidunt, aliquid voluptatem, velit mollit et illum, adipisicing ea officia aliquam placeat','yes',54182,1,NULL,NULL,NULL,'c36dbc50f8523ab2c6659229030871fe','2023-04-06 06:33:18','2023-04-06 06:33:18'),(2,1,NULL,2,2,0,1,'Abshire, Powlowski and Cummerata',NULL,'9663 Schuster Shores\nBoganshire, MD 93929',NULL,'Mrs. Sandra Predovic','vjacobson@hotmail.com','71382091',NULL,NULL,NULL,NULL,NULL,NULL,'I am to see its meaning. \'And just as she could not taste theirs, and the pattern on their throne when they met in the distance, sitting sad and lonely on a little house in it about four inches deep.','yes',231117,NULL,NULL,NULL,NULL,'d0f2c11ce60087f903c2b904f7e0da58','2023-04-06 06:33:18','2023-04-06 06:33:18'),(3,1,NULL,3,3,0,3,'Pacocha Ltd',NULL,'15062 Green Valleys\nSouth Nella, IN 51513',NULL,'Prof. Tristin Durgan DVM','nelson75@murazik.com','58631205',NULL,NULL,NULL,NULL,NULL,NULL,'Seven flung down his cheeks, he went on eagerly. \'That\'s enough about lessons,\' the Gryphon replied rather impatiently: \'any shrimp could have been a holiday?\' \'Of course not,\' said the Mouse, in a.','yes',924629,NULL,NULL,NULL,NULL,'c59bfadfe9add4bc0ae5b4c34825513d','2023-04-06 06:33:18','2023-04-06 06:33:18'),(4,1,NULL,4,3,0,3,'Stokes-Kirlin',NULL,'533 Evans Stream Suite 795\nLake Caraland, OR 13886-7216',NULL,'Prof. Rosario Reinger','walter.monserrat@yahoo.com','25174016',NULL,NULL,NULL,NULL,NULL,NULL,'Seaography: then Drawling--the Drawling-master was an old crab, HE was.\' \'I never saw one, or heard of such a simple question,\' added the Dormouse. \'Fourteenth of March, I think that very few things.','yes',956786,NULL,NULL,NULL,NULL,'385677ff89495c2a0cde0c95b0d173e7','2023-04-06 06:33:18','2023-04-06 06:33:18'),(5,1,NULL,1,1,0,3,'Hudson, Keeling and Blick',NULL,'9262 Dixie Landing Apt. 652\nStarkhaven, KS 25636',NULL,'Jamel Hills','elton.powlowski@altenwerth.com','50594060',NULL,NULL,NULL,NULL,NULL,NULL,'Queen was silent. The Dormouse again took a minute or two, it was talking in a melancholy way, being quite unable to move. She soon got it out to sea as you can--\' \'Swim after them!\' screamed the.','yes',668931,NULL,NULL,NULL,NULL,'aa09c9b82a7aadfa4dc6458af0ec78af','2023-04-06 06:33:18','2023-04-06 06:33:18'),(6,1,NULL,4,2,0,2,'Fritsch-Armstrong',NULL,'5114 Zella Estates\nEast Dominicmouth, CA 68587',NULL,'Maud Ebert','melany.white@leannon.com','52379777',NULL,NULL,NULL,NULL,NULL,NULL,'March Hare went on. \'Or would you like to go down--Here, Bill! the master says you\'re to go on. \'And so these three weeks!\' \'I\'m very sorry you\'ve been annoyed,\' said Alice, \'but I know is.','yes',282153,NULL,NULL,NULL,NULL,'ae80d14ee408a06cbd7b1ee28b400a44','2023-04-06 06:33:18','2023-04-06 06:33:18'),(7,1,NULL,5,3,0,1,'Raynor, Ondricka and Hahn',NULL,'52721 Blanda Stream Suite 869\nIlaberg, PA 12642',NULL,'Leone Cole','gislason.colt@harber.net','87516495',NULL,NULL,NULL,NULL,NULL,NULL,'Geography. London is the same words as before, \'It\'s all his fancy, that: he hasn\'t got no business of MINE.\' The Queen turned crimson with fury, and, after waiting till she was appealed to by the.','yes',492053,NULL,NULL,NULL,NULL,'2770e5cd28a9eb5d9ce149c42c90cd43','2023-04-06 06:33:18','2023-04-06 06:33:18'),(8,1,NULL,1,1,0,1,'Monahan, Douglas and Smitham',NULL,'5652 Schumm Creek\nJaniceton, UT 42319',NULL,'Molly Pollich Jr.','hsauer@yahoo.com','28605753',NULL,NULL,NULL,NULL,NULL,NULL,'Mouse to Alice as she could get to the game, the Queen said severely \'Who is this?\' She said it to her usual height. It was so ordered about by mice and rabbits. I almost think I could, if I fell.','yes',85600,NULL,NULL,NULL,NULL,'6b90d80129e8a5237b110b04a3d079ff','2023-04-06 06:33:18','2023-04-06 06:33:18'),(9,1,NULL,4,2,0,1,'Hansen, McDermott and Nicolas',NULL,'4558 Gottlieb Parks Suite 008\nNew Irwinchester, DC 23246',NULL,'Tyshawn Bergstrom II','ggraham@hotmail.com','35915054',NULL,NULL,NULL,NULL,NULL,NULL,'Alice, surprised at her hands, and began:-- \'You are all dry, he is gay as a partner!\' cried the Mouse, who seemed to quiver all over with fright. \'Oh, I beg your pardon!\' she exclaimed in a Little.','yes',367561,NULL,NULL,NULL,NULL,'ef949192a5dc263e43dfae549a21a189','2023-04-06 06:33:18','2023-04-06 06:33:18'),(10,1,NULL,6,3,0,2,'Ankunding Group',NULL,'93435 Elizabeth Isle\nEmardmouth, GA 00856-2206',NULL,'Mrs. Courtney Shields','umayer@padberg.net','80895537',NULL,NULL,NULL,NULL,NULL,NULL,'I\'m a hatter.\' Here the Queen said severely \'Who is this?\' She said it to be executed for having missed their turns, and she at once in her French lesson-book. The Mouse only growled in reply.','yes',85763,NULL,NULL,NULL,NULL,'61dce9fbcae0c62ed1077625632e1ef6','2023-04-06 06:33:18','2023-04-06 06:33:18'),(11,1,NULL,3,3,0,3,'Parker, Schneider and Dare',NULL,'58061 Lorine Falls\nEast Helenafurt, AR 53534',NULL,'Noble Schinner','sylvia56@collier.com','89821815',NULL,NULL,NULL,NULL,NULL,NULL,'THE VOICE OF THE SLUGGARD,\"\' said the King. \'Shan\'t,\' said the King. The next witness would be as well as she went nearer to make ONE respectable person!\' Soon her eye fell on a summer day: The.','yes',952055,NULL,NULL,NULL,NULL,'7039f9ee3fa8b8cf9ebbac5aae4ef66c','2023-04-06 06:33:18','2023-04-06 06:33:18');
/*!40000 ALTER TABLE `leads` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `leave_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `leave_files` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `leave_id` int unsigned NOT NULL,
  `filename` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `hashname` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `leave_files_company_id_foreign` (`company_id`),
  KEY `leave_files_user_id_foreign` (`user_id`),
  KEY `leave_files_leave_id_foreign` (`leave_id`),
  KEY `leave_files_added_by_foreign` (`added_by`),
  KEY `leave_files_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `leave_files_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `leave_files_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `leave_files_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `leave_files_leave_id_foreign` FOREIGN KEY (`leave_id`) REFERENCES `leaves` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `leave_files_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `leave_files` WRITE;
/*!40000 ALTER TABLE `leave_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `leave_files` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `leave_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `leave_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `manager_permission` enum('pre-approve','approved','cannot-approve') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pre-approve',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `leave_settings_company_id_foreign` (`company_id`),
  CONSTRAINT `leave_settings_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `leave_settings` WRITE;
/*!40000 ALTER TABLE `leave_settings` DISABLE KEYS */;
INSERT INTO `leave_settings` VALUES (1,1,'pre-approve','2023-04-06 06:33:16','2023-04-06 06:33:16');
/*!40000 ALTER TABLE `leave_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `leave_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `leave_types` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `type_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `no_of_leaves` int NOT NULL DEFAULT '5',
  `paid` tinyint(1) NOT NULL DEFAULT '1',
  `monthly_limit` int NOT NULL DEFAULT '0',
  `effective_after` int DEFAULT NULL,
  `effective_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `unused_leave` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `encashed` tinyint(1) NOT NULL,
  `allowed_probation` tinyint(1) NOT NULL,
  `allowed_notice` tinyint(1) NOT NULL,
  `gender` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `marital_status` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `department` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `designation` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `role` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `leave_types_company_id_foreign` (`company_id`),
  CONSTRAINT `leave_types_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `leave_types` WRITE;
/*!40000 ALTER TABLE `leave_types` DISABLE KEYS */;
INSERT INTO `leave_types` VALUES (1,1,'Casual','#16813D',5,1,0,NULL,NULL,NULL,0,0,0,'[\"male\",\"female\",\"others\"]','[\"married\",\"unmarried\"]','[1,2,3,4,5,6]','[1,2,3,4,5]','[1,2,4]',NULL,'2023-04-06 06:34:20'),(2,1,'Sick','#DB1313',5,1,0,NULL,NULL,NULL,0,0,0,'[\"male\",\"female\",\"others\"]','[\"married\",\"unmarried\"]','[1,2,3,4,5,6]','[1,2,3,4,5]','[1,2,4]',NULL,'2023-04-06 06:34:20'),(3,1,'Earned','#B078C6',5,1,0,NULL,NULL,NULL,0,0,0,'[\"male\",\"female\",\"others\"]','[\"married\",\"unmarried\"]','[1,2,3,4,5,6]','[1,2,3,4,5]','[1,2,4]',NULL,'2023-04-06 06:34:20');
/*!40000 ALTER TABLE `leave_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `leaves`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `leaves` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `leave_type_id` int unsigned NOT NULL,
  `unique_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `duration` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `leave_date` date NOT NULL,
  `reason` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` enum('approved','pending','rejected') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `reject_reason` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `paid` tinyint(1) NOT NULL DEFAULT '0',
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `event_id` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `approved_by` int unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  `half_day_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `manager_status_permission` enum('pre-approve','approved') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `approve_reason` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `leaves_company_id_foreign` (`company_id`),
  KEY `leaves_user_id_foreign` (`user_id`),
  KEY `leaves_leave_type_id_foreign` (`leave_type_id`),
  KEY `leaves_leave_date_index` (`leave_date`),
  KEY `leaves_added_by_foreign` (`added_by`),
  KEY `leaves_last_updated_by_foreign` (`last_updated_by`),
  KEY `leaves_approved_by_foreign` (`approved_by`),
  CONSTRAINT `leaves_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `leaves_approved_by_foreign` FOREIGN KEY (`approved_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `leaves_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `leaves_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `leaves_leave_type_id_foreign` FOREIGN KEY (`leave_type_id`) REFERENCES `leave_types` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `leaves_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `leaves` WRITE;
/*!40000 ALTER TABLE `leaves` DISABLE KEYS */;
INSERT INTO `leaves` VALUES (1,1,16,2,NULL,'single','2023-04-06','Majesty,\' said Two, in a moment. \'Let\'s go on crying in this affair, He trusts to you how it was good practice to say it any longer than that,\' said the Hatter, \'I cut some more of the singers in.','approved',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL,NULL),(2,1,16,2,NULL,'single','2023-02-02','OLD, FATHER WILLIAM,\"\' said the Mock Turtle. \'She can\'t explain MYSELF, I\'m afraid, sir\' said Alice, as she did not get hold of this sort of use in the pool as it lasted.) \'Then the words \'DRINK.','rejected',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL,NULL),(3,1,16,2,NULL,'single','2023-01-05','Then came a little bird as soon as she could, for the Duchess said in a few minutes to see if she had a large one, but it all seemed quite natural to Alice to herself, \'Why, they\'re only a mouse.','pending',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL,NULL),(4,1,16,2,NULL,'single','2023-01-03','I\'ll eat it,\' said Alice. \'Oh, don\'t bother ME,\' said the Lory positively refused to tell me who YOU are, first.\' \'Why?\' said the Duck. \'Found IT,\' the Mouse only growled in reply. \'Please come back.','approved',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL,NULL),(5,1,16,2,NULL,'single','2023-04-06','IT. It\'s HIM.\' \'I don\'t see how he did it,) he did it,) he did not like to go from here?\' \'That depends a good way off, panting, with its head, it WOULD twist itself round and round goes the clock.','approved',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL,NULL),(6,1,16,2,NULL,'single','2023-04-03','ME,\' said the King. On this the White Rabbit, who said in a game of play with a kind of thing never happened, and now here I am now? That\'ll be a great crash, as if she had plenty of time as she.','approved',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL,NULL),(7,1,16,2,NULL,'single','2023-04-02','I eat or drink under the door; so either way I\'ll get into her head. Still she went on growing, and, as she ran. \'How surprised he\'ll be when he sneezes: He only does it to make out at the Queen.','pending',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL,NULL),(8,1,16,2,NULL,'single','2023-03-03','Where CAN I have ordered\'; and she felt that she knew she had somehow fallen into it: there was no one else seemed inclined to say it over) \'--yes, that\'s about the right word) \'--but I shall have.','pending',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL,NULL),(9,1,16,2,NULL,'single','2023-03-03','I\'m not used to queer things happening. While she was not here before,\' said the Dormouse; \'--well in.\' This answer so confused poor Alice, and she went on eagerly: \'There is such a new idea to.','approved',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL,NULL),(10,1,16,2,NULL,'single','2023-02-03','Mock Turtle sighed deeply, and began, in a fight with another dig of her sharp little chin. \'I\'ve a right to think,\' said Alice to herself, \'to be going messages for a little before she came upon a.','rejected',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL,NULL);
/*!40000 ALTER TABLE `leaves` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `log_time_for`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `log_time_for` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `log_time_for` enum('project','task') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'project',
  `auto_timer_stop` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `approval_required` tinyint(1) NOT NULL,
  `tracker_reminder` tinyint(1) NOT NULL,
  `timelog_report` tinyint(1) NOT NULL,
  `daily_report_roles` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `time` time DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `log_time_for_company_id_foreign` (`company_id`),
  CONSTRAINT `log_time_for_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `log_time_for` WRITE;
/*!40000 ALTER TABLE `log_time_for` DISABLE KEYS */;
INSERT INTO `log_time_for` VALUES (1,1,'project','no',0,0,0,NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16',NULL);
/*!40000 ALTER TABLE `log_time_for` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `ltm_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ltm_translations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `status` int NOT NULL DEFAULT '0',
  `locale` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `group` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `key` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `ltm_translations` WRITE;
/*!40000 ALTER TABLE `ltm_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ltm_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `menu_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `main_menu` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `default_main_menu` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `setting_menu` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `default_setting_menu` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `menu_settings` WRITE;
/*!40000 ALTER TABLE `menu_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `menu_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `menus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menus` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `translate_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `route` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `module` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `setting_menu` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `menus` WRITE;
/*!40000 ALTER TABLE `menus` DISABLE KEYS */;
/*!40000 ALTER TABLE `menus` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `message_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `message_settings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `allow_client_admin` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `allow_client_employee` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `restrict_client` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `send_sound_notification` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `message_settings_company_id_foreign` (`company_id`),
  CONSTRAINT `message_settings_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `message_settings` WRITE;
/*!40000 ALTER TABLE `message_settings` DISABLE KEYS */;
INSERT INTO `message_settings` VALUES (1,1,'no','no','no','2023-04-06 06:33:16','2023-04-06 06:33:16',0);
/*!40000 ALTER TABLE `message_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=782 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'2014_04_02_193005_create_translations_table',1),(2,'2014_10_12_000000_create_users_table',1),(3,'2014_10_12_100000_create_password_resets_table',1),(4,'2016_06_20_112951_create_user_chat_table',1),(5,'2017_03_23_110416_add_column_users_table',1),(6,'2017_03_23_111036_create_client_details_table',1),(7,'2017_03_23_112028_create_client_contacts_table',1),(8,'2017_03_23_112353_create_employee_details_table',1),(9,'2017_03_23_114438_create_organisation_settings_table',1),(10,'2017_03_23_122646_create_project_category_table',1),(11,'2017_03_23_123601_create_projects_table',1),(12,'2017_03_23_125424_create_project_members_table',1),(13,'2017_03_23_125625_create_project_time_logs_table',1),(14,'2017_03_23_130413_create_project_files_table',1),(15,'2017_03_24_051800_create_tasks_table',1),(16,'2017_03_24_054355_create_notices_table',1),(17,'2017_03_24_055005_create_conversation_table',1),(18,'2017_03_24_055539_create_conversation_reply_table',1),(19,'2017_03_24_055859_create_invoices_table',1),(20,'2017_03_24_060421_create_invoice_items_table',1),(21,'2017_03_24_060751_create_quotations_table',1),(22,'2017_03_24_061241_create_quotation_items_table',1),(23,'2017_03_24_061505_create_sticky_notes_table',1),(24,'2017_03_24_064541_create_issues_table',1),(25,'2017_03_29_123858_entrust_setup_tables',1),(26,'2017_04_04_193158_AddColumnsProjectFilesTable',1),(27,'2017_04_05_063103_change_clientid_projectid_invoice_table',1),(28,'2017_04_06_051401_add_discount_column_invoice_table',1),(29,'2017_04_06_054728_add_status_column_issues_table',1),(30,'2017_04_08_152902_add_total_hours_column_time_log_table',1),(31,'2017_04_18_095809_create_project_activity_table',1),(32,'2017_04_18_103815_create_user_activities_table',1),(33,'2017_04_19_101519_create_email_notification_settings_table',1),(34,'2017_04_20_185211_add_colour_column_sticky_notes_table',1),(35,'2017_04_28_114154_create_notifications_table',1),(36,'2017_05_03_131016_add_project_completion_field_projects',1),(37,'2017_05_03_174333_create_currencies_table',1),(38,'2017_05_05_124330_create_module_settings_table',1),(39,'2017_05_05_233111_add_status_column_invoices',1),(40,'2017_05_11_140502_add_currency_symbol_column_invoices',1),(41,'2017_05_11_170244_add_currency_id_column_organisation_settings_table',1),(42,'2017_05_22_172748_add_timezone_column_settings_table',1),(43,'2017_05_24_120216_create_smtp_settings_table',1),(44,'2017_05_31_112158_create_universal_search_table',1),(45,'2017_06_22_131112_add_locale_organisation_settings_table',1),(46,'2017_07_13_091922_add_calculate_task_progress_column_project_table',1),(47,'2017_07_20_093528_on_delete_setnull_timelog',1),(48,'2017_07_21_120958_create_theme_settings_table',1),(49,'2017_07_24_113657_add_link_color_column_theme_settings_table',1),(50,'2017_07_24_123050_add_login_background_organisation_settings_table',1),(51,'2017_07_27_101351_add_column_type_invoice_items_table',1),(52,'2017_07_28_102010_create_estimates_table',1),(53,'2017_07_28_103230_create_estimate_items_table',1),(54,'2017_08_04_064431_create_payments_table',1),(55,'2017_08_05_103940_create_payment_gateway_credential_table',1),(56,'2017_08_08_055908_add_enable_paypal_column_payment_gateway_table',1),(57,'2017_08_09_054230_create_expenses_table',1),(58,'2017_08_21_065430_add_exchange_rate_column_currency_table',1),(59,'2017_08_21_131318_create_invoice_setting_table',1),(60,'2017_08_22_055908_add_expense_email_setting_to_email_notification_setting_table',1),(61,'2017_08_28_110759_add_recurring_columns_in_invoice_table',1),(62,'2017_08_30_061016_add_plan_id_to_payments_table',1),(63,'2017_08_30_093400_create_settings_table',1),(64,'2017_08_30_123956_add_slack_username_column_employee_details_table',1),(65,'2017_08_30_133725_add_send_slack_column_email_notification_settings_table',1),(66,'2017_09_01_060715_add_stipe_column_to_payment_credentials_table',1),(67,'2017_09_01_090124_add_customer_id_column_to_payments_table',1),(68,'2017_09_02_084049_add_locale_column_users_table',1),(69,'2017_09_14_095429_create_ticket_reply_templates_table',1),(70,'2017_09_14_095815_create_ticket_types_table',1),(71,'2017_09_14_100400_create_ticket_groups_table',1),(72,'2017_09_14_100530_create_ticket_tag_list_table',1),(73,'2017_09_14_114900_create_ticket_channels_table',1),(74,'2017_09_14_115003_create_ticket_agent_groups_table',1),(75,'2017_09_14_115004_create_tickets_table',1),(76,'2017_09_14_115005_create_ticket_tags_table',1),(77,'2017_09_18_064917_add_status_column_ticket_agent_group_table',1),(78,'2017_09_24_101700_create_ticket_replies_table',1),(79,'2017_09_25_060229_drop_description_column_ticket_table',1),(80,'2017_09_25_072611_add_deleted_at_column_tickets',1),(81,'2017_09_25_072627_add_deleted_at_column_ticket_reply',1),(82,'2017_10_03_094922_ticket_notification_migration',1),(83,'2017_10_03_134003_add_latitude_longitude_column',1),(84,'2017_10_12_111741_create_attendance_setting_table',1),(85,'2017_10_13_051909_create_attendance_table',1),(86,'2017_10_26_051335_add_mail_from_email_column_smtp_settings_table',1),(87,'2017_10_26_112253_add_office_open_days_column_attendance_settings_table',1),(88,'2017_11_01_054603_add_columns_to_client_details',1),(89,'2017_11_02_045542_change_on_cascade_project_members',1),(90,'2017_11_07_054438_add_project_admin_column_project_table',1),(91,'2017_11_07_125619_remove_project_admin_role',1),(92,'2017_11_08_045549_make_project_id_nullable_tasks_table',1),(93,'2017_11_09_071318_create_taskboard_columns_table',1),(94,'2017_11_09_092817_add_column_tasks_table',1),(95,'2017_11_20_070830_create_custom_fields_table',1),(96,'2017_11_20_071758_create_custom_fields__data_table',1),(97,'2017_11_22_071535_create_events_table',1),(98,'2017_11_23_065323_add_cryptocurrency_columns',1),(99,'2017_11_24_103957_create_event_attendees_table',1),(100,'2017_12_07_034433_change cascade users in time log table',1),(101,'2017_12_12_071823_create_modules_table',1),(102,'2017_12_12_073501_add_module_id_column_permissions_table',1),(103,'2017_12_21_114839_change_upload_folder',1),(104,'2017_12_28_112910_create_leave_types_table',1),(105,'2017_12_30_184422_create_leaves_table',1),(106,'2018_01_02_122442_add_leaves_notification_setting',1),(107,'2018_01_05_062543_add_user_css_column_theme_settings',1),(108,'2018_01_09_180937_add_task_completed_notification_setting',1),(109,'2018_01_29_073527_create_message_setting_table',1),(110,'2018_04_12_100452_add_dropbox_link_column_project_files_table',1),(111,'2018_04_12_123243_create_file_storage_table',1),(112,'2018_04_13_072732_create_groups_table',1),(113,'2018_04_13_092757_create_employee_groups_table',1),(114,'2018_04_17_113657_set_attendance_late_column_default',1),(115,'2018_05_07_065407_alter_invoice_id_null_payments',1),(116,'2018_05_07_065557_add_currency_id_column_payments_table',1),(117,'2018_05_08_064539_add_note_column_invoices',1),(118,'2018_05_15_072536_add_project_id_column_payments',1),(119,'2018_05_28_094515_set_gateway_column_null_payments_table',1),(120,'2018_05_29_070343_change_completed_on_column_to_datetime',1),(121,'2018_05_29_114402_populate_file_storage_settings_table',1),(122,'2018_05_30_051128_add_google_url_to_project_files_table',1),(123,'2018_06_05_092136_create_sub_tasks_table',1),(124,'2018_06_06_091511_create_task_comments_table',1),(125,'2018_06_11_054204_create_push_subscriptions_table',1),(126,'2018_06_14_094059_create_taxes_table',1),(127,'2018_06_18_065034_add_tax_id_column_invoice_items_table',1),(128,'2018_06_18_071442_add_discount_column_invoice_items_table',1),(129,'2018_06_21_052408_change_default_taskboard_columns',1),(130,'2018_06_26_160023_add_leave_count_column_leave_types_table',1),(131,'2018_06_27_072813_add_leaves_start_from_column',1),(132,'2018_06_27_075233_add_joining_date_column',1),(133,'2018_06_27_113713_add_gender_column_users_table',1),(134,'2018_06_28_054604_add_client_view_task_column_project_table',1),(135,'2018_06_28_191256_create_language_settings_table',1),(136,'2018_06_29_060331_add_active_theme_column_settings',1),(137,'2018_06_29_081128_add_manual_timelog_column_project_timelog',1),(138,'2018_06_29_104709_seed_languages',1),(139,'2018_08_02_121259_add_minutes_column_time_log_table',1),(140,'2018_08_22_103829_add_leaves_module',1),(141,'2018_08_22_104302_add_leaves_permissions',1),(142,'2018_08_27_114329_add_module_list_in_module_settings',1),(143,'2018_08_30_065158_add_status_column_users_table',1),(144,'2018_08_31_095814_create_lead_table',1),(145,'2018_08_31_095815_create_lead_source_table',1),(146,'2018_08_31_095815_create_lead_status_table',1),(147,'2018_08_31_095816_create_lead_follow_up_table',1),(148,'2018_09_04_095158_alter_lead_table',1),(149,'2018_09_04_095816_add_lead_module',1),(150,'2018_09_05_102010_create_proposal_table',1),(151,'2018_09_05_113230_create_proposal_items_table',1),(152,'2018_09_07_051239_alter_lead_website_table',1),(153,'2018_09_15_174026_add_default_lead_settings',1),(154,'2018_09_17_045718_add_leads_permission',1),(155,'2018_09_19_091643_add_remarks_to_payments_table',1),(156,'2018_09_19_100708_create_products_table',1),(157,'2018_09_21_095816_create_offline_payment_method_table',1),(158,'2018_09_25_065158_alter_payment_table',1),(159,'2018_09_28_110029_create_log_time_for_table',1),(160,'2018_09_28_965158_alter_project_time_log_table',1),(161,'2018_10_08_091643_alter_project_table',1),(162,'2018_10_08_110029_create_lead_files_table',1),(163,'2018_10_10_110029_create_holidays_table',1),(164,'2018_10_10_123601_create_project_templates_table',1),(165,'2018_10_10_125424_create_project_template_members_table',1),(166,'2018_10_10_135816_add_holiday_module',1),(167,'2018_10_10_251800_create_project_template_tasks_table',1),(168,'2018_10_16_095816_add_holiday_module_detail',1),(169,'2018_10_17_081757_remove_config_datatable_file',1),(170,'2018_10_17_965158_alter_leads_address_table',1),(171,'2018_10_17_965168_alter_leads_phone_table',1),(172,'2018_10_18_091643_alter_attendance_setting_table',1),(173,'2018_10_19_045718_add_holidays_permission',1),(174,'2018_10_20_094413_add_products_module',1),(175,'2018_10_20_094504_add_products_permissions',1),(176,'2018_10_21_051239_alter_holiday_website_table',1),(177,'2018_10_24_071300_add_file_column_to_invoices_table',1),(178,'2018_10_24_965158_alter_employee_detail_table',1),(179,'2018_10_29_965158_alter_attendance_setting_default_table',1),(180,'2018_11_10_071300_alter_user_table',1),(181,'2018_11_10_122646_create_task_category_table',1),(182,'2018_11_30_965158_alter_invoice_item_table',1),(183,'2018_12_12_965158_alter_invoice_estimate_response_table',1),(184,'2018_12_14_094504_add_expenses_permissions',1),(185,'2018_12_14_194504_add_expenses_permissions_detail',1),(186,'2018_12_20_1065158_alter_company_setting_table',1),(187,'2018_12_20_965158_alter_estimate_quantity_table',1),(188,'2018_12_27_074504_check_verify_purchase_file',1),(189,'2018_12_28_075730_create_push_notification_settings_table',1),(190,'2018_12_28_082056_add_send_push_column_email_notification_table',1),(191,'2018_12_28_123245_add_onesignal_player_id_column_users_table',1),(192,'2019_01_02_1065158_alter_module_setting_table',1),(193,'2019_01_02_2065158_insert_module_setting_client_table',1),(194,'2019_01_04_110029_create_employee_docs_table',1),(195,'2019_01_21_1065158_alter_task_creator_table',1),(196,'2019_02_06_1065158_alter_attendance_check_table',1),(197,'2019_02_11_1065158_alter_log_time_for_table',1),(198,'2019_02_12_2065158_insert_module_setting_client_task_table',1),(199,'2019_02_13_110029_create_skills_table',1),(200,'2019_02_13_130029_create_employee_skills_table',1),(201,'2019_02_15_1065158_alter_employee_end_date_table',1),(202,'2019_02_15_1165158_alter_custom_status_table',1),(203,'2019_02_20_074848_create_jobs_table',1),(204,'2019_02_22_1165158_add_company_currency_api_google_api',1),(205,'2019_03_11_965158_alter_expenses_quantity_table',1),(206,'2019_04_03_965158_alter_project_deadline_table',1),(207,'2019_04_04_074848_alter_invoice_setting_table',1),(208,'2019_04_04_075848_alter_client_Details_table',1),(209,'2019_04_10_075848_alter_setting_task_table',1),(210,'2019_04_10_122921_add_weather_key_column',1),(211,'2019_04_12_100242_add_columns_projects_table',1),(212,'2019_04_15_115700_add_budget_columns_projects_table',1),(213,'2019_04_17_070105_create_project_milestones_table',1),(214,'2019_04_23_062017_add_item_summary_column_invoice_item_table',1),(215,'2019_04_23_083812_add_invoice_created_column_project_milestones_table',1),(216,'2019_04_23_101747_add_milestone_id_column_tasks_table',1),(217,'2019_06_04_180628_change_project_budget_field_type',1),(218,'2019_06_07_070913_add_tax_id_column_estimate_items_table',1),(219,'2019_06_07_080053_add_discount_column_estimates_table',1),(220,'2019_07_01_192543_change_size_price_in_double',1),(221,'2019_07_02_072314_add_description_column_products_table',1),(222,'2019_07_15_110127_add_project_id_column_in_expenses_table',1),(223,'2019_08_13_073129_update_settings_add_envato_key',1),(224,'2019_08_13_073129_update_settings_add_support_key',1),(225,'2019_08_16_080219_change_price_size_proposal',1),(226,'2019_08_17_072443_add_datepicker_format_column_in_settings',1),(227,'2019_08_19_000000_create_failed_jobs_table',1),(228,'2019_08_19_085009_add_google_recaptcha_columns_in_organisation_settings_table',1),(229,'2019_08_19_120826_add_app_debug_column_in_organisation_settings_table',1),(230,'2019_08_22_055908_add_invoice_email_setting_to_email_notification_setting_table',1),(231,'2019_08_22_121805_add_external_link_column_project_files_table',1),(232,'2019_08_26_120718_add_offline_method_id_column_payments_table',1),(233,'2019_08_28_081847_update_smtp_setting_verified',1),(234,'2019_08_29_140115_make_smtp_type_nullable',1),(235,'2019_08_30_102114_add_reminder_fields_in_events_table',1),(236,'2019_09_03_103533_add_razorpay_column',1),(237,'2019_09_04_115714_add_recurring_task_id_column_in_tasks_table',1),(238,'2019_09_05_061308_create_project_settings_table',1),(239,'2019_09_09_045256_add_estimate_number_column_in_estimates_table',1),(240,'2019_09_09_081030_add_rounded_theme_column',1),(241,'2019_09_09_115714_add_cron_job_message_hide_table',1),(242,'2019_09_10_1074848_create_designation_table',1),(243,'2019_09_10_111909_add_columns_in_invoice_settings_table',1),(244,'2019_09_10_115714_add_team_field_employee_table',1),(245,'2019_09_10_161408_create_credit_note_table',1),(246,'2019_09_10_161418_create_credit_note_item_table',1),(247,'2019_09_10_161428_add_credit_note_column_in_invoices_table',1),(248,'2019_09_14_074854_add_status_column_projects_table',1),(249,'2019_09_16_101138_create_gdpr_settings_table',1),(250,'2019_09_17_091214_create_removal_requests_table',1),(251,'2019_09_18_191957_add_payments_module_clients',1),(252,'2019_09_25_095015_create_removal_requests_lead_table',1),(253,'2019_09_25_183130_create_dashboard_widgets_table',1),(254,'2019_09_27_212735_add_timelog_module_clients',1),(255,'2019_10_04_101818_add_paypal_mode_in_payment_gateway_credentials_table',1),(256,'2019_10_10_115133_alter_status_column_in_estimates_table',1),(257,'2019_10_14_060314_create_accept_estimates_table',1),(258,'2019_10_14_090840_alter_project_id_column_in_invoices_table',1),(259,'2019_10_14_110606_add_estimate_id_column_in_invoices_table',1),(260,'2019_10_15_052931_create_contract_types_table',1),(261,'2019_10_15_052932_create_contracts_table',1),(262,'2019_10_15_084310_add_contract_module_in_module_settings',1),(263,'2019_10_15_115655_create_contract_signs_table',1),(264,'2019_10_15_120940_create_invoice_credit_note_pivot_table',1),(265,'2019_10_17_051544_create_contract_discussions_table',1),(266,'2019_10_18_045028_alter_credit_note_status_in_credit_notes_table',1),(267,'2019_10_21_130413_create_task_files_table',1),(268,'2019_10_21_230413_create_ticket_files_table',1),(269,'2019_10_22_063419_add_dependent_task_id_in_tasks_table',1),(270,'2019_10_23_122412_create_contract_renews_table',1),(271,'2019_10_24_045038_add_column_module_type_in_universal_search_table',1),(272,'2019_10_24_120220_add_origin_amount_column_in_contracts_table',1),(273,'2019_10_30_045045_add_column_invoice_item_table',1),(274,'2019_10_30_122412_create_lead_agent_table',1),(275,'2019_10_31_045055_add_column_credit_note_item_table',1),(276,'2019_10_31_045065_add_column_estimate_item_table',1),(277,'2019_11_01_045075_add_column_products_table',1),(278,'2019_11_01_142619_add_column_to_in_notices_table',1),(279,'2019_11_05_082637_add_client_id_in_invoices_table',1),(280,'2019_11_07_082637_add_purchase_allow_in_product_table',1),(281,'2019_11_12_054145_add_system_update_column_in_organisation_settings_table',1),(282,'2019_11_13_054155_add_employee_id_column_in_employee_details_table',1),(283,'2019_11_14_054145_add_discount_column_in_proposal_table',1),(284,'2019_11_14_064145_add_tax_column_in_proposal_item_table',1),(285,'2019_11_21_064155_add_task_module_in_module_setting_table',1),(286,'2019_12_01_115133_alter_invoice_status_table',1),(287,'2019_12_09_171149_make_taxes_nullable_propsal_items_table',1),(288,'2019_12_18_115133_alter_proposal_items_table',1),(289,'2019_12_19_115850_add_timelogs_client_modules',1),(290,'2019_12_20_143625_add_logo_background_color_column_settings_table',1),(291,'2020_01_09_100241_add_client_id_credit_note_table',1),(292,'2020_01_09_105514_set_default_status_credit_note_open',1),(293,'2020_01_09_121406_add_task_reminder_columns',1),(294,'2020_01_22_122009_add_is_private_column_tasks_table',1),(295,'2020_01_23_062328_create_task_history_table',1),(296,'2020_01_24_134008_add_default_task_status_column_organisation_settings',1),(297,'2020_01_27_122145_create_pusher_settings_table',1),(298,'2020_02_01_101914_update_settings_review',1),(299,'2020_02_04_061753_add_team_id_field_in_projects_table',1),(300,'2020_02_04_132100_add_contracts_permission',1),(301,'2020_02_10_093726_create_table_menu',1),(302,'2020_02_14_102832_create_task_users_table',1),(303,'2020_02_17_143257_add_slug_email_notification_table',1),(304,'2020_02_21_121956_update_storage_settings_to_local',1),(305,'2020_02_24_060416_update_invoice_setting_logo',1),(306,'2020_03_11_054833_add_shipping_address_field_in_client_details_table',1),(307,'2020_03_11_085729_add_show_shipping_field_in_invoices_table',1),(308,'2020_03_17_411909_alter_invocie_number_in_invoice_table',1),(309,'2020_03_19_112832_create_project_template_task_users_table',1),(310,'2020_03_20_2065158_insert_modules_setting_client_table',1),(311,'2020_03_23_185549_make_message_nullable_ticket_reply_table',1),(312,'2020_04_06_130331_create_discussion_categories_table',1),(313,'2020_04_06_132027_create_discussions_table',1),(314,'2020_04_06_133759_create_discussion_replies_table',1),(315,'2020_04_08_094325_add_best_answer_id_discussions_table',1),(316,'2020_04_08_125803_add_discussion_reply_email_notification_settings_table',1),(317,'2020_04_09_102411_add_last_reply_by_discussions_table',1),(318,'2020_04_12_2065158_insert_contract_employee_modules_setting_table',1),(319,'2020_04_14_144941_add_last_login_column_users_table',1),(320,'2020_04_20_083724_add_hourly_rate_project_timelogs',1),(321,'2020_04_20_114349_add_hourly_rate_project_members',1),(322,'2020_04_20_173833_add_project_id_value_for_tasks_timelogs',1),(323,'2020_04_23_124301_add_billable_column_tasks_table',1),(324,'2020_04_24_115049_add_approved_invoice_id_column_project_time_logs',1),(325,'2020_04_24_122510_add_approval_required_column_log_time_for',1),(326,'2020_05_13_070505_change_earning_by_minutes_timelogs',1),(327,'2020_05_13_113533_add_receipt_column_payments_table',1),(328,'2020_05_19_114539_add_custom_field_groups',1),(329,'2020_05_20_131017_change_project_team_id_cascade',1),(330,'2020_05_21_041143_create_social_auth_settings_table',1),(331,'2020_05_26_084027_add_column_expenses_table',1),(332,'2020_05_30_093624_add_send_status_column_invoices_table',1),(333,'2020_06_01_080620_add_send_status_column_estimates_table',1),(334,'2020_06_02_160923_add_email_notifications_column_users_table',1),(335,'2020_06_15_100530_create_task_tag_list_table',1),(336,'2020_06_15_116005_create_task_tags_table',1),(337,'2020_06_16_160933_alter_date_format_table',1),(338,'2020_06_20_030225_alter_task_tags_to_label_table',1),(339,'2020_06_26_131840_add_column_priority_column_leads_table',1),(340,'2020_06_29_141051_create_sessions_table',1),(341,'2020_07_06_171614_add_phone_country_code_column_users_table',1),(342,'2020_07_07_2065158_insert_module_setting_client_expense_payment_table',1),(343,'2020_07_08_2065258_enter_lead_status_id_table',1),(344,'2020_07_08_2931840_add_column_category_id_in_template_task_table',1),(345,'2020_07_15_112558_add_default_currency_projects',1),(346,'2020_07_16_583130_alter_dashboard_widgets_table',1),(347,'2020_07_21_583130_add_due_amount_column_in_invoice_table',1),(348,'2020_08_13_114705_set_task_category_id_column_null',1),(349,'2020_08_19_051839_create_employee_leave_quotas_table',1),(350,'2020_08_25_081839_add_columns_in_notices_table',1),(351,'2020_08_25_081839_alter_leads_value_table',1),(352,'2020_08_28_081839_add_columns_parent_in_invoice_table',1),(353,'2020_09_17_114705_set_credit_note_amount',1),(354,'2020_09_17_196005_create_task_notes_table',1),(355,'2020_09_18_104145_add_estimate_fields_tasks_table',1),(356,'2020_09_24_522646_create_expenses_category_table',1),(357,'2020_09_28_054230_create_expenses_recurring_table',1),(358,'2020_10_06_522646_create_product_category_table',1),(359,'2020_10_07_522646_create_pinned_table',1),(360,'2020_10_15_054230_create_invoice_recurring_table',1),(361,'2020_10_20_094043_add_dashboard_clock_column_organisation_setting_table',1),(362,'2020_10_29_111515_add_companylogo_address_column_in_contracts_table',1),(363,'2020_11_02_130413_create_contract_files_table',1),(364,'2020_11_17_115634_add_lead_custom_field_group',1),(365,'2020_11_18_065533_create_lead_custom_forms_table',1),(366,'2020_11_18_083624_add_city_state_to_client_details',1),(367,'2020_11_18_090244_add_city_state_to_leads_table',1),(368,'2020_11_19_063807_add_city_state_column_in_contracts_table',1),(369,'2020_11_19_091349_alter_country_cell_column_in_client_details',1),(370,'2020_11_20_104942_create_lead_category_table',1),(371,'2020_11_23_052427_add_category_id_column_in_leads_table',1),(372,'2020_11_25_114705_cancel_status_estimate',1),(373,'2020_11_27_092136_create_project_template_sub_tasks_table',1),(374,'2020_12_01_092136_create_notice_view_table',1),(375,'2020_12_02_055908_add_product_purchase_email_notification_setting_table',1),(376,'2020_12_03_065533_create_ticket_custom_forms_table',1),(377,'2020_12_04_114305_create_client_category_table',1),(378,'2020_12_08_075308_create_project_rating_table',1),(379,'2020_12_08_082101_add_paid_column_in_leave_types',1),(380,'2020_12_08_110140_add_paid_column_in_leaves_table',1),(381,'2020_12_21_072055_create_permission_types_table',1),(382,'2020_12_21_072058_create_user_permissions_table',1),(383,'2020_12_21_132255_add_user_permisisons',1),(384,'2020_12_22_071337_add_owned_by_added_by_last_updated_by_columns',1),(385,'2020_12_28_200000_add_two_factor_columns_to_users_table',1),(386,'2020_12_30_101513_add_owned_by_added_by_last_updated_by_columns_projects',1),(387,'2021_01_11_110041_add_owned_by_added_by_last_updated_by_columns_tasks',1),(388,'2021_01_18_084827_add_estimate_terms_column_invoice_settings',1),(389,'2021_01_19_060745_add_slug_new_product_purchase_in_email_notification_table',1),(390,'2021_01_29_152503_lead_custom_field_name_change',1),(391,'2021_02_05_055908_add_lead_proposal_email_setting',1),(392,'2021_02_05_114041_create_user_taskboard_settings_table',1),(393,'2021_02_08_115655_create_proposal_signs_table',1),(394,'2021_02_15_085425_modify_status_column_in_projects_table',1),(395,'2021_02_15_135533_alter_lead_custom_forms_table',1),(396,'2021_02_16_082106_add_mobile_column_in_tickets_table',1),(397,'2021_02_16_100313_add_added_by_last_updated_by_columns_to_events_table',1),(398,'2021_02_16_102604_add_added_by_last_updated_by_columns_to_products_table',1),(399,'2021_02_16_102906_add_added_by_last_updated_by_columns_to_notices_table',1),(400,'2021_02_17_122943_change_client_details_foreign_table',1),(401,'2021_02_19_102125_add_salutation_column_to_leads_table',1),(402,'2021_02_20_185545_add_owned_by_added_by_last_updated_by_columns_invoices',1),(403,'2021_02_22_101316_add_owned_by_added_by_last_updated_by_columns_payments',1),(404,'2021_02_23_173243_add_column_length_column',1),(405,'2021_02_24_084749_add_owned_by_added_by_last_updated_by_columns_estimates',1),(406,'2021_02_25_052941_add_owned_by_added_by_last_updated_by_columns_leads',1),(407,'2021_02_26_092320_create_currency_format_settings_table',1),(408,'2021_02_26_092817_add_sac_code_invoice_table',1),(409,'2021_02_27_070155_add_added_by_last_updated_by_columns_to_leaves_table',1),(410,'2021_02_28_095653_add_owned_by_added_by_last_updated_by_columns_expenses',1),(411,'2021_03_01_133056_create_user_leadboard_settings_table',1),(412,'2021_03_03_071758_add_owned_by_added_by_last_updated_by_columns_tinelogs',1),(413,'2021_03_03_130641_add_moment_format_column_settings_table',1),(414,'2021_03_04_060745_add_new_for_null_slug_email_notification_table',1),(415,'2021_03_08_022302_add_added_by_last_updated_by_columns_to_holidays_table',1),(416,'2021_03_09_123344_add_owned_by_added_by_last_updated_by_columns_contracts',1),(417,'2021_03_11_070400_update_contract_type_cascade',1),(418,'2021_03_15_112622_add_owned_by_added_by_last_updated_by_columns_attendance',1),(419,'2021_03_15_145533_add_last_cron_run_in_organisation_settings_table',1),(420,'2021_03_19_091501_add_favicon_in_organisation_settings_table',1),(421,'2021_03_19_123557_add_owned_by_added_by_last_updated_by_columns_tickets',1),(422,'2021_04_06_111105_sync_default_role_permission',1),(423,'2021_04_08_021853_add_owned_by_added_by_last_updated_by_columns_invoice_recurring',1),(424,'2021_04_14_080502_add_decription_column_in_proposals_table',1),(425,'2021_05_01_220324_add_dashboard_permissions',1),(426,'2021_05_03_055859_add_owned_by_added_by_last_updated_by_columns_credit_notes_table',1),(427,'2021_05_17_133302_reset_theme_default_colors',1),(428,'2021_05_26_102905_craete_client_notes_table',1),(429,'2021_05_30_174638_craete_project_notes_table',1),(430,'2021_05_31_050747_add_send_reminder_in_invoice_setting_table',1),(431,'2021_05_31_102117_task_share_unique_hash',1),(432,'2021_06_03_104606_add_owned_by_added_by_last_updated_by_columns_project_ratings',1),(433,'2021_06_07_132858_create_user_invitations_table',1),(434,'2021_06_08_072201_add_close_date_in_ticket_table',1),(435,'2021_06_09_101110_remove_visible_rating_employee_column_from_projects_table',1),(436,'2021_06_16_185748_add_dark_theme_column_users_table',1),(437,'2021_06_24_185748_add_column_payment_gateway_credentials_table',1),(438,'2021_06_29_104606_add_manage_project_template_permission',1),(439,'2021_07_07_093528_alter_userid_on_project_template_member',1),(440,'2021_07_20_102117_invoice_client_fix',1),(441,'2021_07_23_181545_add_status_column_to_slack_settings_table',1),(442,'2021_07_25_041851_add_report_permissions',1),(443,'2021_08_04_171200_add_mail_connection_column_email_settings',1),(444,'2021_08_06_085318_remove_on_delete_cascade_from_category_id_on_products_table',1),(445,'2021_08_10_081641_change_default_value_of_paypal_and_stripe_on_payment_gateway_credentials_table',1),(446,'2021_08_10_092728_add_allowed_permission_column_permissions_table',1),(447,'2021_08_10_092728_alter_allowed_permission_column_permissions_table',1),(448,'2021_08_13_094921_change_notification_notifications_table',1),(449,'2021_08_16_161256_set_discussion_category_id_null_on_category_delete',1),(450,'2021_08_17_095756_change_details_columns_type_to_longtext_on_client_note_and_project_note_tables',1),(451,'2021_08_19_174641_change_text_longtext',1),(452,'2021_08_20_100009_change_hourly_rate_double',1),(453,'2021_08_20_121027_add_dashboard_module_permission',1),(454,'2021_08_23_125630_create_orders_table',1),(455,'2021_08_26_120755_add_order_id_column_to_payments_table',1),(456,'2021_08_27_100840_add_order_id_to_invoices_table',1),(457,'2021_08_31_071303_add_failed_status_on_payments_table',1),(458,'2021_09_01_124609_add_order_module_and_permissions',1),(459,'2021_09_02_080343_add_hash_columns',1),(460,'2021_09_02_182736_add_notice_module_clients',1),(461,'2021_09_03_182020_add_default_permissions',1),(462,'2021_09_06_182020_change_dashboard_widget_name',1),(463,'2021_09_07_084452_delete_notices_module_from_client',1),(464,'2021_09_08_142150_add_payment_gateway_response_column_to_payment_table',1),(465,'2021_09_09_085024_add_taskboard_message_pusher_settings',1),(466,'2021_09_14_162221_add_payload_id_to_payments_table',1),(467,'2021_09_15_072728_copy_credit_notes_invoice_table_data_to_payments_table',1),(468,'2021_09_15_190915_add_column_calculate_tax',1),(469,'2021_09_17_115037_remove_credit_notes_invoice_table',1),(470,'2021_09_20_095509_alter_and_add_payment_gateways_credentials',1),(471,'2021_09_22_045939_change_subtask_in_notifications_table',1),(472,'2021_09_22_085009_change_google_recaptcha_columns_in_organisation_settings_table',1),(473,'2021_09_24_083220_add_currency_id_to_contracts_table',1),(474,'2021_09_24_100722_add_view_hourly_rate_permission',1),(475,'2021_09_29_071418_add_salutation_column_on_users_table',1),(476,'2021_09_29_075245_add_lead_status_change_permission',1),(477,'2021_09_30_130413_attendance_setting_alert',1),(478,'2021_10_01_074809_add_leave_change_permission',1),(479,'2021_10_03_190531_add_sidebar_logo_style_column_global_settings',1),(480,'2021_10_04_045942_add_2fa_columns_on_users_table',1),(481,'2021_10_04_130413_create_expenses_category_roles_table',1),(482,'2021_10_05_064140_change_date_null_in_task_table',1),(483,'2021_10_05_130413_custom_field_group_change_table',1),(484,'2021_10_06_130413_create_sub_task_files_table',1),(485,'2021_10_11_092617_add_session_driver_column_organisation_settings',1),(486,'2021_10_12_062814_change_authenticate_via_column',1),(487,'2021_10_12_073058_make_email_nullable_users_table',1),(488,'2021_10_12_121613_add_approve_reject_leaves_permissions',1),(489,'2021_10_13_103621_add_client_signup_columns_settings_table',1),(490,'2021_10_14_073904_add_admin_approval_column_users_table',1),(491,'2021_10_16_113306_add_two_factor_confirmed_column_users_table',1),(492,'2021_10_18_131815_allow_gender_null',1),(493,'2021_10_21_104332_add_employee_owned_permissions',1),(494,'2021_10_26_175349_change_ticket_permissions',1),(495,'2021_10_28_120427_add_recurring_columns_tasks',1),(496,'2021_11_11_145726_add_allowed_file_types_column',1),(497,'2021_11_13_063519_add_paystack_to_payment_gateway_credentials',1),(498,'2021_11_16_105840_change_product_sub_cat_relation',1),(499,'2021_11_17_111317_add_mollie_to_payment_gateway_credentials',1),(500,'2021_11_17_173210_create_company_addresses_table',1),(501,'2021_11_18_053337_add_tax_calculation_msg_to_invoice_settings_table',1),(502,'2021_11_19_115843_add_project_type_column_projects',1),(503,'2021_11_22_114532_move_gst_to_compane_address',1),(504,'2021_11_24_093356_add_payfast_to_payment_gateway_credentials',1),(505,'2021_11_24_093619_create_invoice_item_images_table',1),(506,'2021_11_25_134531_fix_timelog_time',1),(507,'2021_11_26_063416_add_authorize_to_payment_gateway_credentials',1),(508,'2021_11_29_060348_create_discussion_files_table',1),(509,'2021_11_30_063441_add_square_to_payment_gateway_credentials',1),(510,'2021_12_08_100451_add_image_column_to_products_table',1),(511,'2021_12_10_112406_add_permission_sync_column_users_table',1),(512,'2021_12_13_070928_add_proposal_items_images_table',1),(513,'2021_12_14_112039_add_location_column_company_addresses',1),(514,'2021_12_15_090905_create_recurring_invoice_item_images_table',1),(515,'2021_12_15_112911_add_recurring_expense_permission',1),(516,'2021_12_17_041814_create_job_batches_table',1),(517,'2021_12_20_053945_add_order_item_image_table',1),(518,'2021_12_21_044934_add_google_event_id_to_several_tables',1),(519,'2021_12_21_064709_add_title_field_in_client_contact_table',1),(520,'2021_12_21_121710_create_google_calendar_modules_table',1),(521,'2021_12_23_102347_change_clock_out_ip_make_nullable_to_attendances_table',1),(522,'2021_12_24_045226_add_paystack_mode_to_payment_gateway_credentials',1),(523,'2021_12_24_085109_add_save_location_column_attendance_settings',1),(524,'2021_12_27_065645_create_knowledgebase_categories_table',1),(525,'2021_12_27_090829_create_knowledge_bases_table',1),(526,'2021_12_28_112808_add_module_knowledgebase_and_permissions',1),(527,'2021_12_29_124232_add_lead_notes_table',1),(528,'2021_12_30_082542_add_added_by_column_knowledge_base_table',1),(529,'2022_01_03_090136_add_downloadable_to_products_table',1),(530,'2022_01_03_103014_create_database_backup_settings_table',1),(531,'2022_01_03_125020_add_product_id_to_order_items_table',1),(532,'2022_01_06_053854_set_product_description_to_nullable_in_products_table',1),(533,'2022_01_06_093627_add_default_permission_to_knowledge_bases_table',1),(534,'2022_01_11_104355_create_translate_settings_table',1),(535,'2022_01_13_080729_add_flutterwave_to_payment_gateway_credentials',1),(536,'2022_01_14_122713_add_change_role_permission',1),(537,'2022_01_15_055907_create_product_files_table',1),(538,'2022_01_19_112914_create_client_docs_table',1),(539,'2022_01_31_090302_add_missing_permissions_to_admin_role',1),(540,'2022_01_31_111358_change_reference_column_to_lead_notes_table',1),(541,'2022_02_01_104951_add_role_permissions_settings_permission',1),(542,'2022_02_01_113853_fix_permission_types',1),(543,'2022_02_03_065848_add_order_notification_to_email_notification_settings_table',1),(544,'2022_02_03_095618_change_quantity_type_in_order_items_table',1),(545,'2022_02_06_150726_add_product_custom_field_group',1),(546,'2022_02_07_175605_create_project_time_log_breaks_table',1),(547,'2022_02_09_084910_add_two_columns_in_sub_tasks_table',1),(548,'2022_02_10_083543_add_description_column_to_estimates_table',1),(549,'2022_02_11_182041_change_discussion_category_permission',1),(550,'2022_02_14_061344_add_birth_date_in_employee_detail_table',1),(551,'2022_02_14_101407_add_data_in_dashboard_widgets_table',1),(552,'2022_02_14_133011_remove_edit_project_file_permission',1),(553,'2022_02_14_180229_make_lead_email_nullable',1),(554,'2022_02_15_111216_update_notice_permissions',1),(555,'2022_02_15_151924_remove_product_file_permission',1),(556,'2022_02_16_063017_add_user_notification_to_email_notification_settings_table',1),(557,'2022_02_16_072041_remove_lead_file_permission',1),(558,'2022_02_16_173650_add_english_language',1),(559,'2022_02_17_083521_update_order_status_to_orders_table',1),(560,'2022_02_18_102942_create_emergency_contacts_table',1),(561,'2022_02_21_061830_add_emergency_contact_module_and_permission',1),(562,'2022_02_22_170153_add_item_summary_column_credit_note',1),(563,'2022_02_24_070325_add_allowed_file_size_global',1),(564,'2022_02_25_095712_add_discout_to_orders_table',1),(565,'2022_03_01_173825_add_approve_expense_permission',1),(566,'2022_03_03_024807_modify_signature_column_on_proposal_signs_table',1),(567,'2022_03_04_055054_add_few_fields_in_lead_follow_up_table',1),(568,'2022_03_07_053249_add_flutterwave_webhook_secret_hash_to_payment_gateway_credentials_table',1),(569,'2022_03_08_063640_add_added_by_and_updated_by_columns_to_ticket_agent_groups_table',1),(570,'2022_03_09_060457_add_several_fields_to_lead_custom_forms_table',1),(571,'2022_03_10_094321_add_unassigned_task_permission',1),(572,'2022_03_15_104220_add_several_fields_to_invoice_settings_table',1),(573,'2022_03_16_060139_add_missing_hash_in_invoices_table',1),(574,'2022_03_16_093939_change_chat_length',1),(575,'2022_03_22_101553_remove_html_tags_in_products',1),(576,'2022_03_28_081634_create_ticket_email_settings_table',1),(577,'2022_03_30_075758_add_imap_columns_tickets_table',1),(578,'2022_04_06_050532_create_files_table',1),(579,'2022_04_11_094350_add_company_address_id_to_orders_table',1),(580,'2022_04_20_173756_change_milestone_cost_limit',1),(581,'2022_04_21_074927_add_currency_key_version_column',1),(582,'2022_04_22_054036_add_view_earning_permission_timelogs',1),(583,'2022_04_22_102709_create_employee_shifts_table',1),(584,'2022_04_25_085447_ad_missing_admin_permissions',1),(585,'2022_05_03_180927_add_soft_delete_tax',1),(586,'2022_05_04_060741_fix_delete_cacade_recur_invoice',1),(587,'2022_05_06_065647_create_employee_shift_change_requests_table',1),(588,'2022_05_06_100620_add_location_column_in_attendance',1),(589,'2022_05_17_095236_add_show_clock_in_button_in_attendace_table',1),(590,'2022_05_23_062159_add_project_show_in_invoice_setting_table',1),(591,'2022_05_25_064410_add_column_employee_details_table',1),(592,'2022_05_25_072526_add_custom_fields_id_to_lead_custom_form_table',1),(593,'2022_05_27_002220_add_custom_fields_id_to_ticket_custom_form_table',1),(594,'2022_05_31_070019_add_ticket_to_custom_field_groups',1),(595,'2022_06_09_114831_add_view_shift_roster_permission',1),(596,'2022_06_13_084344_add_google_calender_status_to_users_table',1),(597,'2022_06_20_102221_add_private_dashboard_type_to_dashboard_widgets_table',1),(598,'2022_06_20_102234_add_date_in_project_milestones_table',1),(599,'2022_06_20_202945_add_shift_time_columns_attendance_table',1),(600,'2022_06_21_051915_add_reminder_and_send_reminder_after_column_to_invoice_settings_table',1),(601,'2022_06_22_072625_add_shift_time_columns_employee_shift_schedule_table',1),(602,'2022_06_23_124453_add_default_status_in_calendar_view_employee_details_table',1),(603,'2022_06_24_084953_add_project_id_column_to_task_label_list',1),(604,'2022_06_28_045956_add_column_to_message_setting_table',1),(605,'2022_07_01_063756_add_app_name_column_organisation_settings_table',1),(606,'2022_07_01_111241_add_parent_id_column_to_teams',1),(607,'2022_07_04_092625_change_date_format_in_organization_setting_table',1),(608,'2022_07_11_051015_add_timelog_to_cutom_field_groups',1),(609,'2022_07_13_115914_add_remark_column_shift',1),(610,'2022_07_13_191406_add_custom_invoice_number_column_invoices',1),(611,'2022_07_14_203040_remove_dashboards_employee_type',1),(612,'2022_07_19_144705_add_week_timelog_widget_setting_private_dashboard',1),(613,'2022_07_22_073943_update_settings_add_license_type',1),(614,'2022_07_24_115433_add_expense_report_permission',1),(615,'2022_07_25_122923_add_task_soft_delete',1),(616,'2022_07_25_141508_add_today_attendance_widget_hr_dashbaord',1),(617,'2022_07_28_043824_add_export_column_custom_fields_table',1),(618,'2022_07_28_175448_create_knowledge_base_files_table',1),(619,'2022_07_29_101111_add_indexes_to_table_columns',1),(620,'2022_08_01_104602_add_columns_to_employee_details',1),(621,'2022_08_02_113623_add_external_link_column_knowledge_base_files_table',1),(622,'2022_08_02_121434_add_timestamps_knowledge_base_files_table',1),(623,'2022_08_03_103344_add_auto_clock_in_column_to_attendance_settings_table',1),(624,'2022_08_04_075744_add_approved_columns_on_leaves',1),(625,'2022_08_04_122512_add_columns_in_leave_types',1),(626,'2022_08_04_184937_add_half_day_type_in_leaves_table',1),(627,'2018_01_01_000000_create_worksuite_new_table',1),(628,'2019_10_01_184956_create_salary_groups_table',2),(629,'2019_10_07_191322_create_salary_components_table',2),(630,'2019_10_07_192042_create_salary_tds_table_table',2),(631,'2019_10_10_114655_create_salary_group_components_table',2),(632,'2019_10_10_115749_create_employee_salary_groups_table',2),(633,'2019_10_18_095840_create_salary_slips_table',2),(634,'2019_10_18_111743_create_employee_monthly_salary_table',2),(635,'2019_10_22_124159_add_columns_salary_slips_table',2),(636,'2019_10_23_181854_create_payroll_settings_table',2),(637,'2019_10_30_121810_add_tds_column_salary_slips_table',2),(638,'2019_11_13_084620_add_gross_salary_column_salary_slips_table',2),(639,'2019_11_21_122601_add_purchase_code_column_payroll_settings_table',2),(640,'2020_01_12_070130_create_asset_types_table',2),(641,'2020_01_12_070306_create_assets_table',2),(642,'2020_01_12_084528_create_asset_lending_history_table',2),(643,'2020_01_31_121040_api_settings',2),(644,'2020_02_01_085612_create_devices_table',2),(645,'2020_02_21_181854_create_asset_settings_table',2),(646,'2020_02_22_181854_add_column_image_in_assets_table',2),(647,'2020_02_28_161803_add_asset_module_modules_table',2),(648,'2020_03_08_065037_add_lender_column',2),(649,'2020_04_09_071616_update_rest_setting_firebase',2),(650,'2020_07_07_085510_create_twilio_settings_table',2),(651,'2020_07_07_105427_add_send_twilio_column_email_notification_table',2),(652,'2020_09_01_051350_create_zoom_meetings_table',2),(653,'2020_09_01_074717_create_user_zoom_meeting_table',2),(654,'2020_09_07_100311_create_zoomsetting_table',2),(655,'2020_10_08_131930_create_zoom_module_permissions_and_module_setting',2),(656,'2020_10_22_074251_add_meeting_app_column_settings_table',2),(657,'2020_10_26_084054_add_columns_zoom_meetings_table',2),(658,'2020_11_06_042430_add_purchase_code_column_zoom_settings',2),(659,'2020_12_17_101924_create_zoom_category_table',2),(660,'2020_12_17_113841_add_category_id_zoom_meetings_table',2),(661,'2021_01_05_121040_application_settings',2),(662,'2021_06_16_123557_add_owned_by_columns_sms_settings',2),(663,'2021_08_11_123557_add_owned_by_columns_assets',2),(664,'2021_08_25_092728_alter_allowed_permission_column_in_asset_permissions_table',2),(665,'2021_08_25_092728_alter_allowed_permission_column_in_payroll_permissions_table',2),(666,'2021_08_28_123557_add_owned_by_columns_payrolls',2),(667,'2021_08_28_123557_add_owned_by_columns_zoom',2),(668,'2021_09_12_061155_payroll_custom_field_table',2),(669,'2021_09_15_123557_add_owned_by_columns_rest_api_settings',2),(670,'2021_09_21_073111_create_payroll_cycle_table',2),(671,'2021_09_21_081203_create_employee_payroll_cycle_table',2),(672,'2021_10_21_063316_add_allowed_permissions',2),(673,'2021_11_30_070320_create_recruit_skills',2),(674,'2021_12_13_165351_add_telegram_columns_settings',2),(675,'2022_02_16_124407_fix_payroll_permissions',2),(676,'2022_03_29_090843_create_sms_notification_settings_table',2),(677,'2022_04_20_170146_add_admin_permissions',2),(678,'2022_07_04_111754_add_project_short_code_column_project_table',2),(679,'2022_07_14_063826_contract_templates',2),(680,'2022_07_18_082515_add_column_in_recruit_job_applications_table',2),(681,'2022_07_22_042424_create_proposal_templates_table',2),(682,'2022_08_03_101616_create_event_files_table',2),(683,'2022_08_12_000000_create_other_migration_till_date_table',2),(684,'2022_08_13_070443_add_task_unique_id_column_tasks_table',2),(685,'2022_08_18_071222_alter_in_salary_components_table',2),(686,'2022_08_18_120924_create_task_settings_table',2),(687,'2022_08_19_100314_add_leave_widget_in_dashboard_widget_table',2),(688,'2022_08_19_115209_create_project_status_settings_table',2),(689,'2022_08_22_104028_knowledge_heading_missing',2),(690,'2022_08_23_065943_change_status_type_projects_table',2),(691,'2022_08_24_093601_add_column_in_employee_monthly_salaries_table',2),(692,'2022_08_24_095802_create_employee_variable_commponent_salaries_table',2),(693,'2022_08_24_122345_add_lead_widget_in_dashboard_widget_table',2),(694,'2022_08_25_085025_add_other_location_to_attendances_table',2),(695,'2022_08_25_123713_add_work_from_home_widget_in_dashboard_widgets_table',2),(696,'2022_08_26_042542_remove_on_delete_cascade_from_invoice_recurring_id_to_invoices',2),(697,'2022_08_26_053139_add_parent_id_column_designation_table',2),(698,'2022_08_29_064339_add_added_by_to_project_template',2),(699,'2022_08_29_103443_add_flag_code_column_to_language_settings',2),(700,'2022_09_00_000000_create_company_table',2),(701,'2022_09_01_000000_add_company_id_in_all_table',2),(702,'2022_09_01_000000_create_payroll_global_settings',2),(703,'2022_09_01_000000_create_recruit_global_settings',2),(704,'2022_09_01_000000_create_zoom_global_settings',2),(705,'2022_09_01_060824_create_appreciations_table',2),(706,'2022_09_01_083053_create_global_settings_table',2),(707,'2022_09_02_000000_add_company_id_assets_module_table',2),(708,'2022_09_02_000000_add_company_id_payroll_module_table',2),(709,'2022_09_02_000000_add_company_id_restapi_module_table',2),(710,'2022_09_02_000000_add_company_id_sms_module_table',2),(711,'2022_09_02_000000_add_company_id_zoom_module_table',2),(712,'2022_09_02_151515_create_flags_table',2),(713,'2022_09_05_064405_add_miro_board_column_in_project_table',2),(714,'2022_09_07_172743_add_lead_status_column_to_permissions',2),(715,'2022_09_13_075642_add_customised_permission_column',2),(716,'2022_09_13_075642_create_leave_settings_table',2),(717,'2022_09_15_051422_add_column_in_payroll_settings_table',2),(718,'2022_09_15_061628_create_recruit_job_category',2),(719,'2022_09_16_071005_add_headcount_and_joining_vs_attrition_widget_in_dashboard_widget_table',2),(720,'2022_09_16_105720_update_permission_of_client_and_employee_document',2),(721,'2022_09_19_124014_add_delete_approve_leave_in_permission_table',2),(722,'2022_09_20_045836_add_bank_account_module_in_module_table',2),(723,'2022_09_21_061658_add_column_weekly_in_salary_components_table',2),(724,'2022_09_23_053942_update_type_of_hsn_sac_code_to_proposal_template_items',2),(725,'2022_09_23_181722_add_approve_reason_column_to_leaves_table',2),(726,'2022_10_01_000000_add_company_id_recruit_module_table',2),(727,'2022_10_09_155207_add_custom_year_to_companies_table',2),(728,'2022_10_18_061658_add_column_fixed_salary_slip_table',2),(729,'2022_10_31_130459_order_with_order_number',2),(730,'2022_11_03_115958_add_auto_clock_in_location_to_attendance_settings_table',2),(731,'2022_11_16_122431_add_contract_note_to_contracts_table',2),(732,'2022_11_23_070556_show_new_webhook_alert',2),(733,'2022_11_24_071222_alter_currency_id_payroll_setting_table',2),(734,'2022_11_25_083742_add_company_id_for_null_values',2),(735,'2022_12_01_070705_create_leave_files_table',2),(736,'2022_12_05_062331_create_emoji_address_ticket_widget_table',2),(737,'2022_12_12_113800_add_wasabi_hash_test_payfast',2),(738,'2022_12_13_071454_add_currency_id_in_currency_format_table',2),(739,'2022_12_13_112213_add_new_fields_in_employee_details_table',2),(740,'2022_12_21_071222_add_currency_id_column_in_salary_slip_table',2),(741,'2022_12_28_112213_add_new_fields_in_companies_table',2),(742,'2022_12_29_061634_add_column_in_invoice_table',2),(743,'2022_12_29_084526_create_subscriptions_table',2),(744,'2022_12_30_045028_add_number_separator_to_invoice_settings_table',2),(745,'2022_12_30_090615_move_google_map_key',2),(746,'2023_01_01_071222_fix_currency_id_column_in_salary_slip_table',2),(747,'2023_01_01_071222_payroll_cycle_insert_users_table',2),(748,'2023_01_01_071222_salary_tds_company_table',2),(749,'2023_01_05_084453_add_column_in_log_time_table',2),(750,'2023_01_06_072523_create_zoom_meeting_notes_table',2),(751,'2023_01_09_162235_create_estimate_templates_table',2),(752,'2023_01_10_100953_create_custom_questions_table',2),(753,'2023_01_20_052539_create_unit_types_table',2),(754,'2023_01_23_082501_add_column_in_recruit_settings_table',2),(755,'2023_01_23_122023_add_column_in_invoice_recurring_table',2),(756,'2023_01_24_102526_add_secret_token_coloumn_in_zoom_setting_table',2),(757,'2023_01_31_072924_add_settings_to_email_notification_settings',2),(758,'2023_02_01_085841_add_company_sign_contracts_table',2),(759,'2023_02_02_112041_add_column_in_recruit_settings_table',2),(760,'2023_02_03_121345_create_recruit_salary_structure_table',2),(761,'2023_02_04_064358_create_lead_products_table',2),(762,'2023_02_07_122807_create_quick_books_settings_table',2),(763,'2023_02_09_083357_create_passprt_and_visa_table',2),(764,'2023_02_13_045833_add_report_column_in_log_time_table',2),(765,'2023_02_15_045950_add_unit_id_orders_table',2),(766,'2023_02_15_121548_add_data_in_ticket_custom_forms_table',2),(767,'2023_02_16_064145_create_zoom_notification_settings_table',2),(768,'2023_02_17_052112_add_permissions_for_lead_report',2),(769,'2023_03_14_064145_create_zoom_notification_settings_1.table',2),(770,'2023_03_16_105629_add_manage_ticket_group_field_in_permission_table',2),(771,'2023_03_17_045842_lead_custom_field',2),(772,'2023_03_21_090422_add_order_prefix_in_invoice_settings_table',2),(773,'2023_03_23_064221_add_country_phonecode_column_in_users_table',2),(774,'2023_03_24_073030_add_payment_columns_in_invoices_table',2),(775,'2023_03_24_081626_add_permission_for_sales_report',2),(776,'2023_03_29_072032_create_order_carts_table',2),(777,'2023_03_31_071222_expenses_id_column_in_salary_slip_table',2),(778,'2023_03_31_123237_fix_timelog_project_id',2),(779,'2023_04_04_090201_add_column_fixed_allowance_in_employee_monthly_salaries_table',2),(780,'2023_04_04_101429_google_calendar_keys_move_to_global_settings',2),(781,'2023_02_27_081104_add_column_in_leave_type_table',3);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `module_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `module_settings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `module_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` enum('active','deactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` enum('admin','employee','client') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'admin',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `module_settings_company_id_foreign` (`company_id`),
  CONSTRAINT `module_settings_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=74 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `module_settings` WRITE;
/*!40000 ALTER TABLE `module_settings` DISABLE KEYS */;
INSERT INTO `module_settings` VALUES (1,1,'clients','active','admin',NULL,NULL),(2,1,'projects','active','admin',NULL,NULL),(3,1,'tickets','active','admin',NULL,NULL),(4,1,'invoices','active','admin',NULL,NULL),(5,1,'estimates','active','admin',NULL,NULL),(6,1,'events','active','admin',NULL,NULL),(7,1,'messages','active','admin',NULL,NULL),(8,1,'tasks','active','admin',NULL,NULL),(9,1,'timelogs','active','admin',NULL,NULL),(10,1,'contracts','active','admin',NULL,NULL),(11,1,'notices','active','admin',NULL,NULL),(12,1,'payments','active','admin',NULL,NULL),(13,1,'orders','active','admin',NULL,NULL),(14,1,'knowledgebase','active','admin',NULL,NULL),(15,1,'employees','active','admin',NULL,NULL),(16,1,'attendance','active','admin',NULL,NULL),(17,1,'expenses','active','admin',NULL,NULL),(18,1,'leaves','active','admin',NULL,NULL),(19,1,'leads','active','admin',NULL,NULL),(20,1,'holidays','active','admin',NULL,NULL),(21,1,'products','active','admin',NULL,NULL),(22,1,'reports','active','admin',NULL,NULL),(23,1,'settings','active','admin',NULL,NULL),(24,1,'bankaccount','active','admin',NULL,NULL),(25,1,'clients','active','employee',NULL,NULL),(26,1,'projects','active','employee',NULL,NULL),(27,1,'tickets','active','employee',NULL,NULL),(28,1,'invoices','active','employee',NULL,NULL),(29,1,'estimates','active','employee',NULL,NULL),(30,1,'events','active','employee',NULL,NULL),(31,1,'messages','active','employee',NULL,NULL),(32,1,'tasks','active','employee',NULL,NULL),(33,1,'timelogs','active','employee',NULL,NULL),(34,1,'contracts','active','employee',NULL,NULL),(35,1,'notices','active','employee',NULL,NULL),(36,1,'payments','active','employee',NULL,NULL),(37,1,'orders','active','employee',NULL,NULL),(38,1,'knowledgebase','active','employee',NULL,NULL),(39,1,'employees','active','employee',NULL,NULL),(40,1,'attendance','active','employee',NULL,NULL),(41,1,'expenses','active','employee',NULL,NULL),(42,1,'leaves','active','employee',NULL,NULL),(43,1,'leads','active','employee',NULL,NULL),(44,1,'holidays','active','employee',NULL,NULL),(45,1,'products','active','employee',NULL,NULL),(46,1,'reports','active','employee',NULL,NULL),(47,1,'settings','active','employee',NULL,NULL),(48,1,'bankaccount','active','employee',NULL,NULL),(49,1,'clients','active','client',NULL,NULL),(50,1,'projects','active','client',NULL,NULL),(51,1,'tickets','active','client',NULL,NULL),(52,1,'invoices','active','client',NULL,NULL),(53,1,'estimates','active','client',NULL,NULL),(54,1,'events','active','client',NULL,NULL),(55,1,'messages','active','client',NULL,NULL),(56,1,'tasks','active','client',NULL,NULL),(57,1,'timelogs','active','client',NULL,NULL),(58,1,'contracts','active','client',NULL,NULL),(59,1,'notices','active','client',NULL,NULL),(60,1,'payments','active','client',NULL,NULL),(61,1,'orders','active','client',NULL,NULL),(62,1,'knowledgebase','active','client',NULL,NULL),(63,1,'asset','active','employee','2023-04-06 06:33:16','2023-04-06 06:33:16'),(64,1,'asset','active','admin','2023-04-06 06:33:16','2023-04-06 06:33:16'),(65,1,'payroll','active','admin','2023-04-06 06:33:16','2023-04-06 06:33:16'),(66,1,'payroll','active','employee','2023-04-06 06:33:16','2023-04-06 06:33:16'),(67,1,'recruit','active','employee','2023-04-06 06:33:16','2023-04-06 06:33:16'),(68,1,'recruit','active','admin','2023-04-06 06:33:16','2023-04-06 06:33:16'),(69,1,'restapi','active','admin','2023-04-06 06:33:16','2023-04-06 06:33:16'),(70,1,'sms','active','admin','2023-04-06 06:33:16','2023-04-06 06:33:16'),(71,1,'zoom','active','admin','2023-04-06 06:33:16','2023-04-06 06:33:16'),(72,1,'zoom','active','employee','2023-04-06 06:33:16','2023-04-06 06:33:16'),(73,1,'zoom','active','client','2023-04-06 06:33:16','2023-04-06 06:33:16');
/*!40000 ALTER TABLE `module_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `modules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `modules` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `module_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `modules` WRITE;
/*!40000 ALTER TABLE `modules` DISABLE KEYS */;
INSERT INTO `modules` VALUES (1,'asset',NULL,'2023-04-06 06:33:05','2023-04-06 06:33:05'),(2,'zoom','User can view the meetings assigned to him as default even without any permission.','2023-04-06 06:33:05','2023-04-06 06:33:08'),(3,'restapi',NULL,'2023-04-06 06:33:05','2023-04-06 06:33:08'),(4,'sms',NULL,'2023-04-06 06:33:05','2023-04-06 06:33:05'),(5,'recruit',NULL,'2023-04-06 06:33:06','2023-04-06 06:33:06'),(6,'payroll',NULL,'2023-04-06 06:33:08','2023-04-06 06:33:08'),(7,'clients',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(8,'employees',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(9,'projects','User can view the basic details of projects assigned to him even without any permission.','2023-04-06 06:33:16','2023-04-06 06:33:16'),(10,'attendance','User can view his own attendance even without any permission.','2023-04-06 06:33:16','2023-04-06 06:33:16'),(11,'tasks','User can view the tasks assigned to him even without any permission.','2023-04-06 06:33:16','2023-04-06 06:33:16'),(12,'estimates',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(13,'invoices',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(14,'payments',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(15,'timelogs',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(16,'tickets','User can view the tickets generated by him as default even without any permission.','2023-04-06 06:33:16','2023-04-06 06:33:16'),(17,'events','User can view the events to be attended by him as default even without any permission.','2023-04-06 06:33:16','2023-04-06 06:33:16'),(18,'notices',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(19,'leaves','User can view the leaves applied by him as default even without any permission.','2023-04-06 06:33:16','2023-04-06 06:33:16'),(20,'leads',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(21,'holidays',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(22,'products',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(23,'expenses','User can view and add(self expenses) the expenses as default even without any permission.','2023-04-06 06:33:16','2023-04-06 06:33:16'),(24,'contracts','User can view all contracts','2023-04-06 06:33:16','2023-04-06 06:33:16'),(25,'reports','User can manage permission of particular report','2023-04-06 06:33:16','2023-04-06 06:33:16'),(26,'settings','User can manage settings','2023-04-06 06:33:16','2023-04-06 06:33:16'),(27,'dashboards',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(28,'orders',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(29,'knowledgebase',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(30,'bankaccount',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(31,'messages',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16');
/*!40000 ALTER TABLE `modules` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `notice_views`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `notice_views` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `notice_id` int unsigned NOT NULL,
  `user_id` int unsigned NOT NULL,
  `read` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notice_views_company_id_foreign` (`company_id`),
  KEY `notice_views_notice_id_foreign` (`notice_id`),
  KEY `notice_views_user_id_foreign` (`user_id`),
  CONSTRAINT `notice_views_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `notice_views_notice_id_foreign` FOREIGN KEY (`notice_id`) REFERENCES `notices` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `notice_views_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `notice_views` WRITE;
/*!40000 ALTER TABLE `notice_views` DISABLE KEYS */;
/*!40000 ALTER TABLE `notice_views` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `notices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `notices` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `to` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'employee',
  `heading` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `department_id` int unsigned DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notices_company_id_foreign` (`company_id`),
  KEY `notices_department_id_foreign` (`department_id`),
  KEY `notices_added_by_foreign` (`added_by`),
  KEY `notices_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `notices_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `notices_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `notices_department_id_foreign` FOREIGN KEY (`department_id`) REFERENCES `teams` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `notices_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `notices` WRITE;
/*!40000 ALTER TABLE `notices` DISABLE KEYS */;
INSERT INTO `notices` VALUES (1,1,'employee','White Rabbit was still in existence; \'and now for the White Rabbit.','Dodo, a Lory and an Eaglet, and several other curious creatures. Alice led the way, and the m--\' But here, to Alice\'s side as she was walking by the officers of the reeds--the rattling teacups would change to dull reality--the grass would be only rustling in the other. \'I beg your pardon,\' said Alice to herself. \'Shy, they seem to put everything upon Bill! I wouldn\'t be so proud as all that.\' \'Well, it\'s got no sorrow, you know. But do cats eat bats, I wonder?\' And here poor Alice began to repeat it, when a sharp hiss made her feel very uneasy: to be a grin, and she hurried out of its little eyes, but it was over at last, and managed to swallow a morsel of the Lobster; I heard him declare, \"You have baked me too brown, I must have been that,\' said the Dormouse, after thinking a minute or two, and the shrill voice of thunder, and people began running when they liked, and left off sneezing by this time, sat down again in a moment. \'Let\'s go on in these words: \'Yes, we went to school.',NULL,NULL,NULL,'2023-03-13 11:04:35','2023-04-06 06:33:18'),(2,1,'employee','Lory, with a sigh: \'he taught Laughing and Grief, they used to queer.','King. \'When did you do lessons?\' said Alice, who was a queer-shaped little creature, and held out its arms folded, frowning like a wild beast, screamed \'Off with his head!\' or \'Off with their heads off?\' shouted the Queen said to one of the sort!\' said Alice. \'Who\'s making personal remarks now?\' the Hatter with a round face, and large eyes full of tears, but said nothing. \'This here young lady,\' said the Dormouse, not choosing to notice this last remark that had a little nervous about this; \'for it might not escape again, and she went on without attending to her; \'but those serpents! There\'s no pleasing them!\' Alice was only the pepper that had fallen into the earth. Let me see: I\'ll give them a railway station.) However, she soon found herself lying on the top of his Normans--\" How are you thinking of?\' \'I beg pardon, your Majesty,\' said Alice thoughtfully: \'but then--I shouldn\'t be hungry for it, he was in a deep voice, \'What are tarts made of?\' \'Pepper, mostly,\' said the King. \'I.',NULL,NULL,NULL,'2023-04-09 18:30:00','2023-04-06 06:33:18'),(3,1,'employee','French mouse, come over with William the Conqueror.\' (For, with all.','King, \'that saves a world of trouble, you know, as we were. My notion was that you think I should be raving mad after all! I almost wish I\'d gone to see what I could shut up like telescopes: this time she found her way through the door, and knocked. \'There\'s no sort of way, \'Do cats eat bats, I wonder?\' Alice guessed who it was, even before she came upon a Gryphon, lying fast asleep in the back. At last the Mock Turtle said with a deep sigh, \'I was a good deal to come out among the distant green leaves. As there seemed to rise like a wild beast, screamed \'Off with their heads down and looked at each other for some way, and the fall NEVER come to an end! \'I wonder how many miles I\'ve fallen by this time). \'Don\'t grunt,\' said Alice; \'I can\'t help that,\' said the Dodo solemnly presented the thimble, saying \'We beg your pardon!\' said the Gryphon, before Alice could see this, as she stood still where she was, and waited. When the pie was all very well as she passed; it was sneezing and.',NULL,NULL,NULL,'2023-03-07 00:15:13','2023-04-06 06:33:18'),(4,1,'employee','There could be no use going back to them, and considered a little.','I\'LL soon make you a couple?\' \'You are all dry, he is gay as a boon, Was kindly permitted to pocket the spoon: While the Panther received knife and fork with a whiting. Now you know.\' \'I DON\'T know,\' said Alice in a soothing tone: \'don\'t be angry about it. And yet I don\'t like them!\' When the pie was all finished, the Owl, as a cushion, resting their elbows on it, for she was quite silent for a baby: altogether Alice did not at all a proper way of settling all difficulties, great or small. \'Off with her friend. When she got to grow to my jaw, Has lasted the rest of it appeared. \'I don\'t much care where--\' said Alice. \'Well, I never knew so much contradicted in her life, and had to sing this:-- \'Beautiful Soup, so rich and green, Waiting in a voice sometimes choked with sobs, to sing you a present of everything I\'ve said as yet.\' \'A cheap sort of meaning in it,\' said Alice, \'but I know is, it would like the right size, that it might appear to others that what you would have this cat.',NULL,NULL,NULL,'2023-04-07 18:30:00','2023-04-06 06:33:18'),(5,1,'employee','Mabel, I\'ll stay down here with me! There are no mice in the pool.','I can do without lobsters, you know. Come on!\' So they couldn\'t see it?\' So she began thinking over all she could get to twenty at that rate! However, the Multiplication Table doesn\'t signify: let\'s try the first witness,\' said the King, and the Queen, and Alice looked very uncomfortable. The moment Alice appeared, she was now more than that, if you wouldn\'t have come here.\' Alice didn\'t think that proved it at last, and managed to put down her flamingo, and began bowing to the end: then stop.\' These were the two creatures got so close to her that she was up to the tarts on the glass table and the fan, and skurried away into the Dormouse\'s place, and Alice was more than three.\' \'Your hair wants cutting,\' said the Hatter. He had been found and handed them round as prizes. There was nothing on it were white, but there were any tears. No, there were three gardeners who were giving it something out of a muchness?\' \'Really, now you ask me,\' said Alice, and she hurried out of a.',NULL,NULL,NULL,'2023-03-09 15:21:41','2023-04-06 06:33:18'),(6,1,'employee','Alice looked very anxiously into her eyes--and still as she could.','Mock Turtle replied, counting off the top of the players to be full of the accident, all except the King, rubbing his hands; \'so now let the jury--\' \'If any one left alive!\' She was a body to cut it off from: that he shook his head off outside,\' the Queen shrieked out. \'Behead that Dormouse! Turn that Dormouse out of its voice. \'Back to land again, and we put a white one in by mistake; and if I like being that person, I\'ll come up: if not, I\'ll stay down here with me! There are no mice in the chimney as she spoke, but no result seemed to Alice severely. \'What are you thinking of?\' \'I beg your pardon!\' cried Alice in a trembling voice, \'--and I hadn\'t cried so much!\' Alas! it was only sobbing,\' she thought, \'it\'s sure to make SOME change in my own tears! That WILL be a very respectful tone, but frowning and making faces at him as he found it very much,\' said the Gryphon. \'The reason is,\' said the Gryphon replied rather crossly: \'of course you know why it\'s called a whiting?\' \'I never.',NULL,NULL,NULL,'2023-03-26 17:33:14','2023-04-06 06:33:18'),(7,1,'employee','Cat. \'Do you know the song, she kept fanning herself all the right.','Alice\'s head. \'Is that the pebbles were all shaped like the three gardeners at it, busily painting them red. Alice thought she might as well go back, and see that she began nibbling at the number of changes she had put on one knee as he fumbled over the list, feeling very curious to see if she were saying lessons, and began staring at the moment, \'My dear! I shall have some fun now!\' thought Alice. One of the Mock Turtle replied, counting off the subjects on his flappers, \'--Mystery, ancient and modern, with Seaography: then Drawling--the Drawling-master was an old crab, HE was.\' \'I never could abide figures!\' And with that she did not at all comfortable, and it set to work shaking him and punching him in the pool, \'and she sits purring so nicely by the hedge!\' then silence, and then at the moment, \'My dear! I wish you were down here till I\'m somebody else\"--but, oh dear!\' cried Alice, quite forgetting her promise. \'Treacle,\' said the Mock Turtle. \'Hold your tongue!\' said the Lory.',NULL,NULL,NULL,'2023-04-10 18:30:00','2023-04-06 06:33:18'),(8,1,'employee','I\'ll stay down here till I\'m somebody else\"--but, oh dear!\' cried.','I\'m mad. You\'re mad.\' \'How do you call him Tortoise, if he thought it over here,\' said the King said, turning to the Gryphon. \'They can\'t have anything to say, she simply bowed, and took the hookah into its eyes again, to see if she had peeped into the air off all its feet at the mouth with strings: into this they slipped the guinea-pig, head first, and then unrolled the parchment scroll, and read as follows:-- \'The Queen of Hearts, carrying the King\'s crown on a little worried. \'Just about as she said this, she noticed that they had been looking at it gloomily: then he dipped it into his plate. Alice did not quite like the look of the game, the Queen never left off staring at the end of the house, and have next to her. \'I wish I could not even room for her. \'I can tell you what year it is?\' \'Of course it is,\' said the Cat. \'--so long as I get it home?\' when it saw mine coming!\' \'How do you know about it, you know.\' \'I DON\'T know,\' said Alice very meekly: \'I\'m growing.\' \'You\'ve no.',NULL,NULL,NULL,'2023-03-15 15:12:49','2023-04-06 06:33:18'),(9,1,'employee','Footman, and began staring at the sides of the country is, you know.','Queen\'s shrill cries to the Knave. The Knave did so, very carefully, with one of the party went back to the door, and knocked. \'There\'s no such thing!\' Alice was very provoking to find it out, we should all have our heads cut off, you know. Come on!\' \'Everybody says \"come on!\" here,\' thought Alice, and she could not swim. He sent them word I had not gone (We know it to speak good English); \'now I\'m opening out like the look of the creature, but on second thoughts she decided on going into the garden. Then she went on. \'I do,\' Alice said nothing; she had put the Dormouse said--\' the Hatter asked triumphantly. Alice did not like to show you! A little bright-eyed terrier, you know, as we were. My notion was that she had been of late much accustomed to usurpation and conquest. Edwin and Morcar, the earls of Mercia and Northumbria, declared for him: and even Stigand, the patriotic archbishop of Canterbury, found it so quickly that the reason and all that,\' he said do. Alice looked at Two.',NULL,NULL,NULL,'2023-04-05 18:30:00','2023-04-06 06:33:18'),(10,1,'employee','For instance, if you drink much from a Caterpillar The Caterpillar.','Owl, as a partner!\' cried the Mouse, who seemed to be a book written about me, that there ought! And when I get SOMEWHERE,\' Alice added as an unusually large saucepan flew close by her. There was a general chorus of voices asked. \'Why, SHE, of course,\' he said to herself. \'Of the mushroom,\' said the King triumphantly, pointing to the general conclusion, that wherever you go to law: I will just explain to you to sit down without being invited,\' said the Mock Turtle replied, counting off the subjects on his spectacles and looked at poor Alice, who had been jumping about like that!\' But she waited patiently. \'Once,\' said the Duchess. An invitation from the time he had come back in their mouths. So they got thrown out to be listening, so she tried hard to whistle to it; but she got back to finish his story. CHAPTER IV. The Rabbit started violently, dropped the white kid gloves while she remembered having seen in her head, she tried hard to whistle to it; but she had wept when she got to.',NULL,NULL,NULL,'2023-02-11 05:39:18','2023-04-06 06:33:18');
/*!40000 ALTER TABLE `notices` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `notifications` (
  `id` char(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `notifiable_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `notifiable_id` bigint unsigned NOT NULL,
  `data` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notifications_notifiable_type_notifiable_id_index` (`notifiable_type`,`notifiable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `notifications` WRITE;
/*!40000 ALTER TABLE `notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `notifications` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `offer_letter_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `offer_letter_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `recruit_job_offer_letter_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `recruit_job_offer_file_id` int unsigned DEFAULT NULL,
  `details` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `offer_letter_histories_user_id_foreign` (`user_id`),
  KEY `offer_letter_histories_recruit_job_offer_letter_id_foreign` (`recruit_job_offer_letter_id`),
  KEY `offer_letter_histories_recruit_job_offer_file_id_foreign` (`recruit_job_offer_file_id`),
  CONSTRAINT `offer_letter_histories_recruit_job_offer_file_id_foreign` FOREIGN KEY (`recruit_job_offer_file_id`) REFERENCES `recruit_job_offer_files` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `offer_letter_histories_recruit_job_offer_letter_id_foreign` FOREIGN KEY (`recruit_job_offer_letter_id`) REFERENCES `recruit_job_offer_letter` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `offer_letter_histories_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `offer_letter_histories` WRITE;
/*!40000 ALTER TABLE `offer_letter_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `offer_letter_histories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `offline_payment_methods`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `offline_payment_methods` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `status` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'yes',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `offline_payment_methods_company_id_foreign` (`company_id`),
  CONSTRAINT `offline_payment_methods_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `offline_payment_methods` WRITE;
/*!40000 ALTER TABLE `offline_payment_methods` DISABLE KEYS */;
/*!40000 ALTER TABLE `offline_payment_methods` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `order_carts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_carts` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int unsigned NOT NULL,
  `client_id` int unsigned DEFAULT NULL,
  `item_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `type` enum('item','discount','tax') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'item',
  `quantity` double(16,2) NOT NULL,
  `unit_price` double(16,2) NOT NULL,
  `amount` double(16,2) NOT NULL,
  `taxes` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hsn_sac_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `order_carts_product_id_foreign` (`product_id`),
  KEY `order_carts_client_id_foreign` (`client_id`),
  CONSTRAINT `order_carts_client_id_foreign` FOREIGN KEY (`client_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `order_carts_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `order_carts` WRITE;
/*!40000 ALTER TABLE `order_carts` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_carts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `order_item_images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_item_images` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint unsigned DEFAULT NULL,
  `external_link` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `order_item_images_order_item_id_index` (`order_item_id`),
  CONSTRAINT `order_item_images_order_item_id_foreign` FOREIGN KEY (`order_item_id`) REFERENCES `order_items` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `order_item_images` WRITE;
/*!40000 ALTER TABLE `order_item_images` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_item_images` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `order_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `product_id` int unsigned DEFAULT NULL,
  `item_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `item_summary` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `type` enum('item','discount','tax') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'item',
  `quantity` double(16,2) NOT NULL,
  `unit_price` int NOT NULL,
  `amount` double(8,2) NOT NULL,
  `hsn_sac_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `taxes` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `order_items_order_id_foreign` (`order_id`),
  KEY `order_items_product_id_foreign` (`product_id`),
  CONSTRAINT `order_items_order_id_foreign` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `order_items_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `order_items` WRITE;
/*!40000 ALTER TABLE `order_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_items` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `orders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_number` bigint DEFAULT NULL,
  `company_id` int unsigned DEFAULT NULL,
  `client_id` int unsigned DEFAULT NULL,
  `order_date` date NOT NULL,
  `sub_total` double(8,2) NOT NULL,
  `discount` double NOT NULL DEFAULT '0',
  `discount_type` enum('percent','fixed') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'percent',
  `total` double(8,2) NOT NULL,
  `status` enum('pending','on-hold','failed','processing','completed','canceled','refunded') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `currency_id` int unsigned DEFAULT NULL,
  `show_shipping_address` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `note` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `company_address_id` bigint unsigned DEFAULT NULL,
  `custom_order_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `unit_id` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `orders_company_id_foreign` (`company_id`),
  KEY `orders_client_id_foreign` (`client_id`),
  KEY `orders_currency_id_foreign` (`currency_id`),
  KEY `orders_added_by_foreign` (`added_by`),
  KEY `orders_last_updated_by_foreign` (`last_updated_by`),
  KEY `orders_company_address_id_foreign` (`company_address_id`),
  KEY `orders_unit_id_foreign` (`unit_id`),
  CONSTRAINT `orders_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `orders_client_id_foreign` FOREIGN KEY (`client_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `orders_company_address_id_foreign` FOREIGN KEY (`company_address_id`) REFERENCES `company_addresses` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `orders_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `orders_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `orders_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `orders_unit_id_foreign` FOREIGN KEY (`unit_id`) REFERENCES `unit_types` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `orders` WRITE;
/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `passport_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `passport_details` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned DEFAULT NULL,
  `country_id` int unsigned DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `passport_number` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `issue_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `passport_details_company_id_foreign` (`company_id`),
  KEY `passport_details_user_id_foreign` (`user_id`),
  KEY `passport_details_added_by_foreign` (`added_by`),
  KEY `passport_details_country_id_foreign` (`country_id`),
  CONSTRAINT `passport_details_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `passport_details_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `passport_details_country_id_foreign` FOREIGN KEY (`country_id`) REFERENCES `countries` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `passport_details_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `passport_details` WRITE;
/*!40000 ALTER TABLE `passport_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `passport_details` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `password_resets` (
  `email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`),
  KEY `password_resets_token_index` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `password_resets` WRITE;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `payment_gateway_credentials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payment_gateway_credentials` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `paypal_client_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paypal_secret` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paypal_status` enum('active','deactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'deactive',
  `live_stripe_client_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `live_stripe_secret` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `live_stripe_webhook_secret` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `stripe_status` enum('active','deactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'deactive',
  `live_razorpay_key` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `live_razorpay_secret` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `razorpay_status` enum('active','inactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'inactive',
  `paypal_mode` enum('sandbox','live') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'sandbox',
  `sandbox_paypal_client_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sandbox_paypal_secret` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `test_stripe_client_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `test_stripe_secret` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `test_razorpay_key` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `test_razorpay_secret` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `test_stripe_webhook_secret` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `stripe_mode` enum('test','live') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'test',
  `razorpay_mode` enum('test','live') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'test',
  `paystack_key` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paystack_secret` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paystack_merchant_email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paystack_status` enum('active','deactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'deactive',
  `paystack_mode` enum('sandbox','live') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'sandbox',
  `test_paystack_key` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `test_paystack_secret` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `test_paystack_merchant_email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paystack_payment_url` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'https://api.paystack.co',
  `mollie_api_key` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mollie_status` enum('active','deactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'deactive',
  `payfast_merchant_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payfast_merchant_key` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payfast_passphrase` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payfast_mode` enum('sandbox','live') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'sandbox',
  `payfast_status` enum('active','deactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'deactive',
  `authorize_api_login_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `authorize_transaction_key` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `authorize_environment` enum('sandbox','live') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'sandbox',
  `authorize_status` enum('active','deactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'deactive',
  `square_application_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `square_access_token` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `square_location_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `square_environment` enum('sandbox','production') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'sandbox',
  `square_status` enum('active','deactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'deactive',
  `flutterwave_status` enum('active','deactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'deactive',
  `flutterwave_mode` enum('sandbox','live') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'sandbox',
  `test_flutterwave_key` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `test_flutterwave_secret` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `test_flutterwave_hash` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `live_flutterwave_key` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `live_flutterwave_secret` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `live_flutterwave_hash` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `flutterwave_webhook_secret_hash` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `test_payfast_merchant_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `test_payfast_merchant_key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `test_payfast_passphrase` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `payment_gateway_credentials_company_id_foreign` (`company_id`),
  CONSTRAINT `payment_gateway_credentials_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `payment_gateway_credentials` WRITE;
/*!40000 ALTER TABLE `payment_gateway_credentials` DISABLE KEYS */;
INSERT INTO `payment_gateway_credentials` VALUES (1,1,NULL,NULL,'deactive',NULL,NULL,NULL,'deactive',NULL,NULL,'inactive','sandbox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'test','test',NULL,NULL,NULL,'deactive','sandbox',NULL,NULL,NULL,'https://api.paystack.co',NULL,'deactive',NULL,NULL,NULL,'sandbox','deactive',NULL,NULL,'sandbox','deactive',NULL,NULL,NULL,'sandbox','deactive','deactive','sandbox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16',NULL,NULL,NULL);
/*!40000 ALTER TABLE `payment_gateway_credentials` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payments` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `project_id` int unsigned DEFAULT NULL,
  `invoice_id` int unsigned DEFAULT NULL,
  `order_id` bigint unsigned DEFAULT NULL,
  `credit_notes_id` int unsigned DEFAULT NULL,
  `amount` double NOT NULL,
  `gateway` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `currency_id` int unsigned DEFAULT NULL,
  `default_currency_id` int unsigned DEFAULT NULL,
  `exchange_rate` double DEFAULT NULL,
  `plan_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `event_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` enum('complete','pending','failed') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `paid_on` datetime DEFAULT NULL,
  `remarks` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `offline_method_id` int unsigned DEFAULT NULL,
  `bill` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `payment_gateway_response` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci COMMENT 'null = success',
  `payload_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `bank_account_id` int unsigned DEFAULT NULL,
  `quickbooks_payment_id` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `payments_plan_id_unique` (`plan_id`),
  UNIQUE KEY `payments_event_id_company_id_unique` (`event_id`,`company_id`),
  UNIQUE KEY `payments_transaction_id_company_id_unique` (`transaction_id`,`company_id`),
  KEY `payments_company_id_foreign` (`company_id`),
  KEY `payments_project_id_foreign` (`project_id`),
  KEY `payments_invoice_id_foreign` (`invoice_id`),
  KEY `payments_order_id_foreign` (`order_id`),
  KEY `payments_credit_notes_id_foreign` (`credit_notes_id`),
  KEY `payments_currency_id_foreign` (`currency_id`),
  KEY `payments_paid_on_index` (`paid_on`),
  KEY `payments_offline_method_id_foreign` (`offline_method_id`),
  KEY `payments_added_by_foreign` (`added_by`),
  KEY `payments_last_updated_by_foreign` (`last_updated_by`),
  KEY `payments_bank_account_id_foreign` (`bank_account_id`),
  KEY `payments_default_currency_id_foreign` (`default_currency_id`),
  CONSTRAINT `payments_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `payments_bank_account_id_foreign` FOREIGN KEY (`bank_account_id`) REFERENCES `bank_accounts` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `payments_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `payments_credit_notes_id_foreign` FOREIGN KEY (`credit_notes_id`) REFERENCES `credit_notes` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `payments_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `payments_default_currency_id_foreign` FOREIGN KEY (`default_currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `payments_invoice_id_foreign` FOREIGN KEY (`invoice_id`) REFERENCES `invoices` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `payments_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `payments_offline_method_id_foreign` FOREIGN KEY (`offline_method_id`) REFERENCES `offline_payment_methods` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `payments_order_id_foreign` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `payments_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `payments` WRITE;
/*!40000 ALTER TABLE `payments` DISABLE KEYS */;
INSERT INTO `payments` VALUES (1,1,1,1,NULL,NULL,58266,'Bank Transfer','c4ca4238a0b923820dcc509a6f75849b',1,1,1,NULL,NULL,NULL,'complete','2023-04-03 08:20:47',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',2,NULL),(2,1,3,7,NULL,NULL,55086,'Bank Transfer','8f14e45fceea167a5a36dedd4bea2543',1,1,1,NULL,NULL,NULL,'complete','2023-04-05 20:14:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',2,NULL),(3,1,4,8,NULL,NULL,11655,'Bank Transfer','c9f0f895fb98ab9159f51fd0297e236d',1,1,1,NULL,NULL,NULL,'complete','2023-04-04 21:54:17',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',2,NULL),(4,1,4,9,NULL,NULL,61408,'Bank Transfer','45c48cce2e2d7fbdea1afc51c7c6ad26',1,1,1,NULL,NULL,NULL,'complete','2023-04-04 16:36:47',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',1,NULL),(5,1,5,10,NULL,NULL,29974,'Bank Transfer','d3d9446802a44259755d38e6d163e820',1,1,1,NULL,NULL,NULL,'complete','2023-04-02 19:11:46',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',2,NULL),(6,1,6,13,NULL,NULL,30536,'Bank Transfer','c51ce410c124a10e0db5e4b97fc2af39',1,1,1,NULL,NULL,NULL,'complete','2023-04-06 18:57:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',1,NULL),(7,1,7,17,NULL,NULL,23364,'Bank Transfer','70efdf2ec9b086079795c442636b55fb',1,1,1,NULL,NULL,NULL,'complete','2023-04-05 02:08:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',2,NULL),(8,1,7,18,NULL,NULL,24198,'Bank Transfer','6f4922f45568161a8cdf4ad2299f6d23',1,1,1,NULL,NULL,NULL,'complete','2023-04-01 19:27:13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',2,NULL),(9,1,8,19,NULL,NULL,20048,'Bank Transfer','1f0e3dad99908345f7439f8ffabdffc4',1,1,1,NULL,NULL,NULL,'complete','2023-04-03 18:07:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',1,NULL),(10,1,9,20,NULL,NULL,28065,'Bank Transfer','98f13708210194c475687be6106a3b84',1,1,1,NULL,NULL,NULL,'complete','2023-04-05 12:37:26',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',1,NULL),(11,1,10,21,NULL,NULL,37097,'Bank Transfer','3c59dc048e8850243be8079a5c74d079',1,1,1,NULL,NULL,NULL,'complete','2023-04-01 16:54:34',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',1,NULL);
/*!40000 ALTER TABLE `payments` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `payroll_cycles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payroll_cycles` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `cycle` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` enum('active','inactive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `payroll_cycles` WRITE;
/*!40000 ALTER TABLE `payroll_cycles` DISABLE KEYS */;
INSERT INTO `payroll_cycles` VALUES (1,'monthly','active','2023-04-06 06:33:05','2023-04-06 06:33:05'),(2,'weekly','active','2023-04-06 06:33:05','2023-04-06 06:33:05'),(3,'biweekly','active','2023-04-06 06:33:05','2023-04-06 06:33:05'),(4,'semimonthly','active','2023-04-06 06:33:05','2023-04-06 06:33:05');
/*!40000 ALTER TABLE `payroll_cycles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `payroll_global_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payroll_global_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `purchase_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `license_type` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `supported_until` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `payroll_global_settings` WRITE;
/*!40000 ALTER TABLE `payroll_global_settings` DISABLE KEYS */;
INSERT INTO `payroll_global_settings` VALUES (1,NULL,NULL,NULL,'2023-04-06 06:33:08','2023-04-06 06:33:08');
/*!40000 ALTER TABLE `payroll_global_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `payroll_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payroll_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `tds_salary` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tds_status` tinyint(1) NOT NULL,
  `finance_month` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '04',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `extra_fields` text COLLATE utf8mb4_unicode_ci,
  `semi_monthly_start` int DEFAULT '1',
  `semi_monthly_end` int DEFAULT '30',
  `currency_id` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `payroll_settings_company_id_foreign` (`company_id`),
  KEY `payroll_settings_currency_id_foreign` (`currency_id`),
  CONSTRAINT `payroll_settings_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `payroll_settings_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `payroll_settings` WRITE;
/*!40000 ALTER TABLE `payroll_settings` DISABLE KEYS */;
INSERT INTO `payroll_settings` VALUES (1,1,'',0,'04','2023-04-06 06:33:16','2023-04-06 06:33:16',NULL,1,30,NULL);
/*!40000 ALTER TABLE `payroll_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `permission_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `permission_role` (
  `permission_id` int unsigned NOT NULL,
  `role_id` int unsigned NOT NULL,
  `permission_type_id` bigint unsigned NOT NULL DEFAULT '5',
  PRIMARY KEY (`permission_id`,`role_id`),
  KEY `permission_role_role_id_foreign` (`role_id`),
  KEY `permission_role_permission_type_id_foreign` (`permission_type_id`),
  CONSTRAINT `permission_role_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `permission_role_permission_type_id_foreign` FOREIGN KEY (`permission_type_id`) REFERENCES `permission_types` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `permission_role_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `permission_role` WRITE;
/*!40000 ALTER TABLE `permission_role` DISABLE KEYS */;
INSERT INTO `permission_role` VALUES (115,2,1),(116,2,1),(125,2,1),(125,3,1),(128,2,1),(128,3,1),(129,2,1),(129,3,1),(166,2,1),(168,2,1),(169,2,1),(176,2,1),(179,2,1),(180,2,1),(183,2,1),(183,3,1),(184,2,1),(184,3,1),(187,2,1),(187,3,1),(188,2,1),(188,3,1),(211,2,1),(213,2,1),(218,2,1),(218,3,1),(220,3,1),(221,2,1),(221,3,1),(235,2,1),(241,2,1),(243,2,1),(254,2,1),(259,2,1),(260,2,1),(286,2,1),(288,2,1),(289,2,1),(111,2,2),(119,2,2),(119,3,2),(163,2,2),(167,3,2),(196,3,2),(200,3,2),(207,3,2),(212,3,2),(228,2,2),(228,3,2),(232,2,2),(232,3,2),(295,3,2),(348,3,2),(167,2,3),(212,2,3),(219,2,3),(219,3,3),(220,2,3),(236,2,3),(242,2,3),(270,2,3),(287,2,3),(1,1,4),(2,1,4),(3,1,4),(4,1,4),(5,1,4),(6,1,4),(7,1,4),(8,1,4),(9,1,4),(10,1,4),(11,1,4),(12,1,4),(13,1,4),(14,1,4),(15,1,4),(16,1,4),(17,1,4),(18,1,4),(19,1,4),(20,1,4),(21,1,4),(22,1,4),(23,1,4),(24,1,4),(25,1,4),(26,1,4),(27,1,4),(28,1,4),(29,1,4),(30,1,4),(31,1,4),(32,1,4),(33,1,4),(34,1,4),(35,1,4),(36,1,4),(37,1,4),(38,1,4),(39,1,4),(40,1,4),(41,1,4),(42,1,4),(43,1,4),(44,1,4),(45,1,4),(46,1,4),(47,1,4),(48,1,4),(49,1,4),(50,1,4),(51,1,4),(52,1,4),(53,1,4),(54,1,4),(55,1,4),(56,1,4),(57,1,4),(58,1,4),(59,1,4),(60,1,4),(61,1,4),(62,1,4),(63,1,4),(64,1,4),(65,1,4),(66,1,4),(67,1,4),(68,1,4),(69,1,4),(70,1,4),(71,1,4),(72,1,4),(73,1,4),(74,1,4),(75,1,4),(76,1,4),(77,1,4),(78,1,4),(79,1,4),(80,1,4),(81,1,4),(82,1,4),(83,1,4),(84,1,4),(85,1,4),(86,1,4),(87,1,4),(88,1,4),(89,1,4),(90,1,4),(91,1,4),(92,1,4),(93,1,4),(94,1,4),(95,1,4),(96,1,4),(97,1,4),(98,1,4),(99,1,4),(100,1,4),(101,1,4),(102,1,4),(102,2,4),(103,1,4),(104,1,4),(105,1,4),(106,1,4),(107,1,4),(108,1,4),(109,1,4),(110,1,4),(111,1,4),(112,1,4),(113,1,4),(114,1,4),(114,2,4),(115,1,4),(116,1,4),(117,1,4),(117,2,4),(118,1,4),(119,1,4),(120,1,4),(121,1,4),(122,1,4),(123,1,4),(123,2,4),(123,3,4),(124,1,4),(124,2,4),(124,3,4),(125,1,4),(126,1,4),(126,2,4),(126,3,4),(127,1,4),(127,2,4),(127,3,4),(128,1,4),(129,1,4),(130,1,4),(131,1,4),(132,1,4),(133,1,4),(134,1,4),(135,1,4),(135,2,4),(135,3,4),(136,1,4),(137,1,4),(138,1,4),(139,1,4),(140,1,4),(141,1,4),(142,1,4),(143,1,4),(144,1,4),(144,2,4),(144,3,4),(145,1,4),(146,1,4),(146,2,4),(146,3,4),(147,1,4),(147,3,4),(148,1,4),(149,1,4),(149,3,4),(150,1,4),(151,1,4),(152,1,4),(152,2,4),(152,3,4),(153,1,4),(154,1,4),(155,1,4),(156,1,4),(157,1,4),(158,1,4),(159,1,4),(160,1,4),(161,1,4),(162,1,4),(163,1,4),(164,1,4),(165,1,4),(166,1,4),(167,1,4),(168,1,4),(169,1,4),(170,1,4),(171,1,4),(172,1,4),(173,1,4),(174,1,4),(174,2,4),(174,3,4),(175,1,4),(175,2,4),(176,1,4),(177,1,4),(177,2,4),(177,3,4),(178,1,4),(178,2,4),(179,1,4),(180,1,4),(181,1,4),(181,2,4),(181,3,4),(182,1,4),(182,2,4),(182,3,4),(183,1,4),(184,1,4),(185,1,4),(185,2,4),(185,3,4),(186,1,4),(186,2,4),(186,3,4),(187,1,4),(188,1,4),(189,1,4),(190,1,4),(191,1,4),(192,1,4),(193,1,4),(194,1,4),(195,1,4),(196,1,4),(197,1,4),(198,1,4),(199,1,4),(200,1,4),(201,1,4),(202,1,4),(203,1,4),(204,1,4),(205,1,4),(206,1,4),(207,1,4),(208,1,4),(209,1,4),(210,1,4),(211,1,4),(212,1,4),(213,1,4),(214,1,4),(215,1,4),(216,1,4),(217,1,4),(218,1,4),(219,1,4),(220,1,4),(221,1,4),(222,1,4),(223,1,4),(224,1,4),(225,1,4),(226,1,4),(227,1,4),(228,1,4),(229,1,4),(230,1,4),(231,1,4),(232,1,4),(233,1,4),(234,1,4),(235,1,4),(236,1,4),(237,1,4),(238,1,4),(239,1,4),(240,1,4),(241,1,4),(242,1,4),(243,1,4),(244,1,4),(245,1,4),(246,1,4),(247,1,4),(248,1,4),(249,1,4),(250,1,4),(251,1,4),(252,1,4),(253,1,4),(254,1,4),(255,1,4),(255,2,4),(256,1,4),(257,1,4),(257,2,4),(258,1,4),(258,2,4),(259,1,4),(260,1,4),(261,1,4),(262,1,4),(263,1,4),(264,1,4),(265,1,4),(266,1,4),(267,1,4),(268,1,4),(269,1,4),(270,1,4),(271,1,4),(272,1,4),(273,1,4),(274,1,4),(275,1,4),(276,1,4),(277,1,4),(277,2,4),(278,1,4),(279,1,4),(280,1,4),(281,1,4),(281,3,4),(282,1,4),(283,1,4),(284,1,4),(285,1,4),(286,1,4),(287,1,4),(288,1,4),(289,1,4),(290,1,4),(291,1,4),(292,1,4),(293,1,4),(294,1,4),(295,1,4),(296,1,4),(297,1,4),(298,1,4),(299,1,4),(300,1,4),(300,3,4),(301,1,4),(302,1,4),(302,3,4),(303,1,4),(304,1,4),(305,1,4),(305,3,4),(306,1,4),(307,1,4),(308,1,4),(309,1,4),(310,1,4),(311,1,4),(312,1,4),(313,1,4),(314,1,4),(315,1,4),(316,1,4),(317,1,4),(318,1,4),(319,1,4),(320,1,4),(321,1,4),(322,1,4),(323,1,4),(324,1,4),(325,1,4),(326,1,4),(327,1,4),(328,1,4),(329,1,4),(330,1,4),(331,1,4),(332,1,4),(333,1,4),(334,1,4),(335,1,4),(336,1,4),(337,1,4),(338,1,4),(339,1,4),(340,1,4),(341,1,4),(342,1,4),(343,1,4),(344,1,4),(345,1,4),(346,1,4),(347,1,4),(347,3,4),(348,1,4),(349,1,4),(350,1,4),(351,1,4),(352,1,4),(353,1,4),(354,1,4),(355,1,4),(356,1,4),(357,1,4),(358,1,4),(359,1,4),(360,1,4),(361,1,4),(1,2,5),(1,3,5),(1,4,5),(2,2,5),(2,3,5),(2,4,5),(3,2,5),(3,3,5),(3,4,5),(4,2,5),(4,3,5),(4,4,5),(5,2,5),(5,3,5),(5,4,5),(6,2,5),(6,3,5),(6,4,5),(7,2,5),(7,3,5),(7,4,5),(8,2,5),(8,3,5),(8,4,5),(9,2,5),(9,3,5),(9,4,5),(10,2,5),(10,3,5),(10,4,5),(11,2,5),(11,3,5),(11,4,5),(12,2,5),(12,3,5),(12,4,5),(13,2,5),(13,3,5),(13,4,5),(14,2,5),(14,3,5),(14,4,5),(15,2,5),(15,3,5),(15,4,5),(16,2,5),(16,3,5),(16,4,5),(17,2,5),(17,3,5),(17,4,5),(18,2,5),(18,3,5),(18,4,5),(19,2,5),(19,3,5),(19,4,5),(20,2,5),(20,3,5),(20,4,5),(21,2,5),(21,3,5),(21,4,5),(22,2,5),(22,3,5),(22,4,5),(23,2,5),(23,3,5),(23,4,5),(24,2,5),(24,3,5),(24,4,5),(25,2,5),(25,3,5),(25,4,5),(26,2,5),(26,3,5),(26,4,5),(27,2,5),(27,3,5),(27,4,5),(28,2,5),(28,3,5),(28,4,5),(29,2,5),(29,3,5),(29,4,5),(30,2,5),(30,3,5),(30,4,5),(31,2,5),(31,3,5),(31,4,5),(32,2,5),(32,3,5),(32,4,5),(33,2,5),(33,3,5),(33,4,5),(34,2,5),(34,3,5),(34,4,5),(35,2,5),(35,3,5),(35,4,5),(36,2,5),(36,3,5),(36,4,5),(37,2,5),(37,3,5),(37,4,5),(38,2,5),(38,3,5),(38,4,5),(39,2,5),(39,3,5),(39,4,5),(40,2,5),(40,3,5),(40,4,5),(41,2,5),(41,3,5),(41,4,5),(42,2,5),(42,3,5),(42,4,5),(43,2,5),(43,3,5),(43,4,5),(44,2,5),(44,3,5),(44,4,5),(45,2,5),(45,3,5),(45,4,5),(46,2,5),(46,3,5),(46,4,5),(47,2,5),(47,3,5),(47,4,5),(48,2,5),(48,3,5),(48,4,5),(49,2,5),(49,3,5),(49,4,5),(50,2,5),(50,3,5),(50,4,5),(51,2,5),(51,3,5),(51,4,5),(52,2,5),(52,3,5),(52,4,5),(53,2,5),(53,3,5),(53,4,5),(54,2,5),(54,3,5),(54,4,5),(55,2,5),(55,3,5),(55,4,5),(56,2,5),(56,3,5),(56,4,5),(57,2,5),(57,3,5),(57,4,5),(58,2,5),(58,3,5),(58,4,5),(59,2,5),(59,3,5),(59,4,5),(60,2,5),(60,3,5),(60,4,5),(61,2,5),(61,3,5),(61,4,5),(62,2,5),(62,3,5),(62,4,5),(63,2,5),(63,3,5),(63,4,5),(64,2,5),(64,3,5),(64,4,5),(65,2,5),(65,3,5),(65,4,5),(66,2,5),(66,3,5),(66,4,5),(67,2,5),(67,3,5),(67,4,5),(68,2,5),(68,3,5),(68,4,5),(69,2,5),(69,3,5),(69,4,5),(70,2,5),(70,3,5),(70,4,5),(71,2,5),(71,3,5),(71,4,5),(72,2,5),(72,3,5),(72,4,5),(73,2,5),(73,3,5),(73,4,5),(74,2,5),(74,3,5),(74,4,5),(75,2,5),(75,3,5),(75,4,5),(76,2,5),(76,3,5),(76,4,5),(77,2,5),(77,3,5),(77,4,5),(78,2,5),(78,3,5),(78,4,5),(79,2,5),(79,3,5),(79,4,5),(80,2,5),(80,3,5),(80,4,5),(81,2,5),(81,3,5),(81,4,5),(82,2,5),(82,3,5),(82,4,5),(83,2,5),(83,3,5),(83,4,5),(84,2,5),(84,3,5),(84,4,5),(85,2,5),(85,3,5),(85,4,5),(86,2,5),(86,3,5),(86,4,5),(87,2,5),(87,3,5),(87,4,5),(88,2,5),(88,3,5),(88,4,5),(89,2,5),(89,3,5),(89,4,5),(90,2,5),(90,3,5),(90,4,5),(91,2,5),(91,3,5),(91,4,5),(92,2,5),(92,3,5),(92,4,5),(93,2,5),(93,3,5),(93,4,5),(94,2,5),(94,3,5),(94,4,5),(95,2,5),(95,3,5),(95,4,5),(96,2,5),(96,3,5),(96,4,5),(97,2,5),(97,3,5),(97,4,5),(98,2,5),(98,3,5),(98,4,5),(99,2,5),(99,3,5),(99,4,5),(100,2,5),(100,3,5),(100,4,5),(101,2,5),(101,3,5),(101,4,5),(102,3,5),(102,4,5),(103,2,5),(103,3,5),(103,4,5),(104,2,5),(104,3,5),(104,4,5),(105,2,5),(105,3,5),(105,4,5),(106,2,5),(106,3,5),(106,4,5),(107,2,5),(107,3,5),(107,4,5),(108,2,5),(108,3,5),(108,4,5),(109,2,5),(109,3,5),(109,4,5),(110,2,5),(110,3,5),(110,4,5),(111,3,5),(111,4,5),(112,2,5),(112,3,5),(112,4,5),(113,2,5),(113,3,5),(113,4,5),(114,3,5),(114,4,5),(115,3,5),(115,4,5),(116,3,5),(116,4,5),(117,3,5),(117,4,5),(118,2,5),(118,3,5),(118,4,5),(119,4,5),(120,2,5),(120,3,5),(120,4,5),(121,2,5),(121,3,5),(121,4,5),(122,2,5),(122,3,5),(122,4,5),(123,4,5),(124,4,5),(125,4,5),(126,4,5),(127,4,5),(128,4,5),(129,4,5),(130,2,5),(130,3,5),(130,4,5),(131,2,5),(131,3,5),(131,4,5),(132,2,5),(132,3,5),(132,4,5),(133,2,5),(133,3,5),(133,4,5),(134,2,5),(134,3,5),(134,4,5),(135,4,5),(136,2,5),(136,3,5),(136,4,5),(137,2,5),(137,3,5),(137,4,5),(138,2,5),(138,3,5),(138,4,5),(139,2,5),(139,3,5),(139,4,5),(140,2,5),(140,3,5),(140,4,5),(141,2,5),(141,3,5),(141,4,5),(142,2,5),(142,3,5),(142,4,5),(143,2,5),(143,3,5),(143,4,5),(144,4,5),(145,2,5),(145,3,5),(145,4,5),(146,4,5),(147,2,5),(147,4,5),(148,2,5),(148,3,5),(148,4,5),(149,2,5),(149,4,5),(150,2,5),(150,3,5),(150,4,5),(151,2,5),(151,3,5),(151,4,5),(152,4,5),(153,2,5),(153,3,5),(153,4,5),(154,2,5),(154,3,5),(154,4,5),(155,2,5),(155,3,5),(155,4,5),(156,2,5),(156,3,5),(156,4,5),(157,2,5),(157,3,5),(157,4,5),(158,2,5),(158,3,5),(158,4,5),(159,2,5),(159,3,5),(159,4,5),(160,2,5),(160,3,5),(160,4,5),(161,2,5),(161,3,5),(161,4,5),(162,2,5),(162,3,5),(162,4,5),(163,3,5),(163,4,5),(164,2,5),(164,3,5),(164,4,5),(165,2,5),(165,3,5),(165,4,5),(166,3,5),(166,4,5),(167,4,5),(168,3,5),(168,4,5),(169,3,5),(169,4,5),(170,2,5),(170,3,5),(170,4,5),(171,2,5),(171,3,5),(171,4,5),(172,2,5),(172,3,5),(172,4,5),(173,2,5),(173,3,5),(173,4,5),(174,4,5),(175,3,5),(175,4,5),(176,3,5),(176,4,5),(177,4,5),(178,3,5),(178,4,5),(179,3,5),(179,4,5),(180,3,5),(180,4,5),(181,4,5),(182,4,5),(183,4,5),(184,4,5),(185,4,5),(186,4,5),(187,4,5),(188,4,5),(189,2,5),(189,3,5),(189,4,5),(190,2,5),(190,3,5),(190,4,5),(191,2,5),(191,3,5),(191,4,5),(192,2,5),(192,3,5),(192,4,5),(193,2,5),(193,3,5),(193,4,5),(194,2,5),(194,3,5),(194,4,5),(195,2,5),(195,3,5),(195,4,5),(196,2,5),(196,4,5),(197,2,5),(197,3,5),(197,4,5),(198,2,5),(198,3,5),(198,4,5),(199,2,5),(199,3,5),(199,4,5),(200,2,5),(200,4,5),(201,2,5),(201,3,5),(201,4,5),(202,2,5),(202,3,5),(202,4,5),(203,2,5),(203,3,5),(203,4,5),(204,2,5),(204,3,5),(204,4,5),(205,2,5),(205,3,5),(205,4,5),(206,2,5),(206,3,5),(206,4,5),(207,2,5),(207,4,5),(208,2,5),(208,3,5),(208,4,5),(209,2,5),(209,3,5),(209,4,5),(210,2,5),(210,3,5),(210,4,5),(211,3,5),(211,4,5),(212,4,5),(213,3,5),(213,4,5),(214,2,5),(214,3,5),(214,4,5),(215,2,5),(215,3,5),(215,4,5),(216,2,5),(216,3,5),(216,4,5),(217,2,5),(217,3,5),(217,4,5),(218,4,5),(219,4,5),(220,4,5),(221,4,5),(222,2,5),(222,3,5),(222,4,5),(223,2,5),(223,3,5),(223,4,5),(224,2,5),(224,3,5),(224,4,5),(225,2,5),(225,3,5),(225,4,5),(226,2,5),(226,3,5),(226,4,5),(227,2,5),(227,3,5),(227,4,5),(228,4,5),(229,2,5),(229,3,5),(229,4,5),(230,2,5),(230,3,5),(230,4,5),(231,2,5),(231,3,5),(231,4,5),(232,4,5),(233,2,5),(233,3,5),(233,4,5),(234,2,5),(234,3,5),(234,4,5),(235,3,5),(235,4,5),(236,3,5),(236,4,5),(237,2,5),(237,3,5),(237,4,5),(238,2,5),(238,3,5),(238,4,5),(239,2,5),(239,3,5),(239,4,5),(240,2,5),(240,3,5),(240,4,5),(241,3,5),(241,4,5),(242,3,5),(242,4,5),(243,3,5),(243,4,5),(244,2,5),(244,3,5),(244,4,5),(245,2,5),(245,3,5),(245,4,5),(246,2,5),(246,3,5),(246,4,5),(247,2,5),(247,3,5),(247,4,5),(248,2,5),(248,3,5),(248,4,5),(249,2,5),(249,3,5),(249,4,5),(250,2,5),(250,3,5),(250,4,5),(251,2,5),(251,3,5),(251,4,5),(252,2,5),(252,3,5),(252,4,5),(253,2,5),(253,3,5),(253,4,5),(254,3,5),(254,4,5),(255,3,5),(255,4,5),(256,2,5),(256,3,5),(256,4,5),(257,3,5),(257,4,5),(258,3,5),(258,4,5),(259,3,5),(259,4,5),(260,3,5),(260,4,5),(261,2,5),(261,3,5),(261,4,5),(262,2,5),(262,3,5),(262,4,5),(263,2,5),(263,3,5),(263,4,5),(264,2,5),(264,3,5),(264,4,5),(265,2,5),(265,3,5),(265,4,5),(266,2,5),(266,3,5),(266,4,5),(267,2,5),(267,3,5),(267,4,5),(268,2,5),(268,3,5),(268,4,5),(269,2,5),(269,3,5),(269,4,5),(270,3,5),(270,4,5),(271,2,5),(271,3,5),(271,4,5),(272,2,5),(272,3,5),(272,4,5),(273,2,5),(273,3,5),(273,4,5),(274,2,5),(274,3,5),(274,4,5),(275,2,5),(275,3,5),(275,4,5),(276,2,5),(276,3,5),(276,4,5),(277,3,5),(277,4,5),(278,2,5),(278,3,5),(278,4,5),(279,2,5),(279,3,5),(279,4,5),(280,2,5),(280,3,5),(280,4,5),(281,2,5),(281,4,5),(282,2,5),(282,3,5),(282,4,5),(283,2,5),(283,3,5),(283,4,5),(284,2,5),(284,3,5),(284,4,5),(285,2,5),(285,3,5),(285,4,5),(286,3,5),(286,4,5),(287,3,5),(287,4,5),(288,3,5),(288,4,5),(289,3,5),(289,4,5),(290,2,5),(290,3,5),(290,4,5),(291,2,5),(291,3,5),(291,4,5),(292,2,5),(292,3,5),(292,4,5),(293,2,5),(293,3,5),(293,4,5),(294,2,5),(294,3,5),(294,4,5),(295,2,5),(295,4,5),(296,2,5),(296,3,5),(296,4,5),(297,2,5),(297,3,5),(297,4,5),(298,2,5),(298,3,5),(298,4,5),(299,2,5),(299,3,5),(299,4,5),(300,2,5),(300,4,5),(301,2,5),(301,3,5),(301,4,5),(302,2,5),(302,4,5),(303,2,5),(303,3,5),(303,4,5),(304,2,5),(304,3,5),(304,4,5),(305,2,5),(305,4,5),(306,2,5),(306,3,5),(306,4,5),(307,2,5),(307,3,5),(307,4,5),(308,2,5),(308,3,5),(308,4,5),(309,2,5),(309,3,5),(309,4,5),(310,2,5),(310,3,5),(310,4,5),(311,2,5),(311,3,5),(311,4,5),(312,2,5),(312,3,5),(312,4,5),(313,2,5),(313,3,5),(313,4,5),(314,2,5),(314,3,5),(314,4,5),(315,2,5),(315,3,5),(315,4,5),(316,2,5),(316,3,5),(316,4,5),(317,2,5),(317,3,5),(317,4,5),(318,2,5),(318,3,5),(318,4,5),(319,2,5),(319,3,5),(319,4,5),(320,2,5),(320,3,5),(320,4,5),(321,2,5),(321,3,5),(321,4,5),(322,2,5),(322,3,5),(322,4,5),(323,2,5),(323,3,5),(323,4,5),(324,2,5),(324,3,5),(324,4,5),(325,2,5),(325,3,5),(325,4,5),(326,2,5),(326,3,5),(326,4,5),(327,2,5),(327,3,5),(327,4,5),(328,2,5),(328,3,5),(328,4,5),(329,2,5),(329,3,5),(329,4,5),(330,2,5),(330,3,5),(330,4,5),(331,2,5),(331,3,5),(331,4,5),(332,2,5),(332,3,5),(332,4,5),(333,2,5),(333,3,5),(333,4,5),(334,2,5),(334,3,5),(334,4,5),(335,2,5),(335,3,5),(335,4,5),(336,2,5),(336,3,5),(336,4,5),(337,2,5),(337,3,5),(337,4,5),(338,2,5),(338,3,5),(338,4,5),(339,2,5),(339,3,5),(339,4,5),(340,2,5),(340,3,5),(340,4,5),(341,2,5),(341,3,5),(341,4,5),(342,2,5),(342,3,5),(342,4,5),(343,2,5),(343,3,5),(343,4,5),(344,2,5),(344,3,5),(344,4,5),(345,2,5),(345,3,5),(345,4,5),(346,2,5),(346,3,5),(346,4,5),(347,2,5),(347,4,5),(348,2,5),(348,4,5),(349,2,5),(349,3,5),(349,4,5),(350,2,5),(350,3,5),(350,4,5),(351,2,5),(351,3,5),(351,4,5),(352,2,5),(352,3,5),(352,4,5),(353,2,5),(353,3,5),(353,4,5),(354,2,5),(354,3,5),(354,4,5),(355,2,5),(355,3,5),(355,4,5),(356,2,5),(356,3,5),(356,4,5),(357,2,5),(357,3,5),(357,4,5),(358,2,5),(358,3,5),(358,4,5),(359,2,5),(359,3,5),(359,4,5),(360,2,5),(360,3,5),(360,4,5),(361,2,5),(361,3,5),(361,4,5);
/*!40000 ALTER TABLE `permission_role` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `permission_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `permission_types` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `permission_types` WRITE;
/*!40000 ALTER TABLE `permission_types` DISABLE KEYS */;
INSERT INTO `permission_types` VALUES (1,'added',NULL,NULL),(2,'owned',NULL,NULL),(3,'both',NULL,NULL),(4,'all',NULL,NULL),(5,'none',NULL,NULL);
/*!40000 ALTER TABLE `permission_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `permissions` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `display_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `module_id` int unsigned NOT NULL,
  `is_custom` tinyint(1) NOT NULL DEFAULT '0',
  `allowed_permissions` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `permissions_name_module_id_unique` (`name`,`module_id`),
  KEY `permissions_module_id_foreign` (`module_id`),
  CONSTRAINT `permissions_module_id_foreign` FOREIGN KEY (`module_id`) REFERENCES `modules` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=362 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `permissions` WRITE;
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
INSERT INTO `permissions` VALUES (1,'add_asset','Add Asset',NULL,1,0,'{\"all\":4, \"none\":5}',NULL,'2023-04-06 06:33:05'),(2,'view_asset','View Asset',NULL,1,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}',NULL,'2023-04-06 06:33:05'),(3,'edit_asset','Edit Asset',NULL,1,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}',NULL,'2023-04-06 06:33:05'),(4,'delete_asset','Delete Asset',NULL,1,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}',NULL,'2023-04-06 06:33:05'),(5,'add_zoom_meetings','Add Meetings',NULL,2,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:05','2023-04-06 06:33:05'),(6,'view_zoom_meetings','View Meetings',NULL,2,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:05','2023-04-06 06:33:05'),(7,'edit_zoom_meetings','Edit Meetings',NULL,2,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:05','2023-04-06 06:33:05'),(8,'delete_zoom_meetings','Delete Meetings',NULL,2,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:05','2023-04-06 06:33:05'),(9,'add_assets_type','Add Assets Type',NULL,1,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:05','2023-04-06 06:33:05'),(10,'edit_assets_type','Edit Assets Type',NULL,1,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:05','2023-04-06 06:33:05'),(11,'view_assets_type','View Assets Type',NULL,1,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:05','2023-04-06 06:33:05'),(12,'delete_assets_type','Delete Assets Type',NULL,1,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:05','2023-04-06 06:33:05'),(13,'edit_assets_history','Edit Assets History',NULL,1,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:05','2023-04-06 06:33:05'),(14,'delete_assets_history','Delete Assets History',NULL,1,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:05','2023-04-06 06:33:05'),(15,'view_assets_history','View Assets History',NULL,1,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:05','2023-04-06 06:33:05'),(16,'manage_zoom_category','Manage Zoom category',NULL,2,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:05','2023-04-06 06:33:05'),(17,'manage_test_push_notification','Manage Test Push Notification',NULL,3,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:05','2023-04-06 06:33:05'),(18,'manage_rest_api_settings','Manage Rest Api Settings',NULL,3,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:05','2023-04-06 06:33:05'),(19,'manage_sms_settings','Manage Sms Settings',NULL,4,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:05','2023-04-06 06:33:05'),(20,'manage_skill','Manage Skills',NULL,5,1,'{\"all\":4, \"none\":5}',NULL,NULL),(21,'add_job','Add Job',NULL,5,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}',NULL,NULL),(22,'view_job','View Job',NULL,5,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}',NULL,NULL),(23,'edit_job','Edit Job',NULL,5,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}',NULL,NULL),(24,'delete_job','Delete Job',NULL,5,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}',NULL,NULL),(25,'add_job_application','Add Job Application',NULL,5,1,'{\"all\":4,\"added\":1, \"none\":5}',NULL,NULL),(26,'view_job_application','View Job Application',NULL,5,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}',NULL,NULL),(27,'edit_job_application','Edit Job Application',NULL,5,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}',NULL,NULL),(28,'delete_job_application','Delete Job Application',NULL,5,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}',NULL,NULL),(29,'add_notes','Add Notes',NULL,5,1,'{\"all\":4,\"added\":1, \"none\":5}',NULL,NULL),(30,'edit_notes','Edit Notes',NULL,5,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}',NULL,NULL),(31,'delete_notes','Delete Notes',NULL,5,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}',NULL,NULL),(32,'add_application_status','Add Application Status',NULL,5,1,'{\"all\":4, \"none\":5}',NULL,NULL),(33,'edit_application_status','Edit Application Status',NULL,5,1,'{\"all\":4, \"none\":5}',NULL,NULL),(34,'delete_application_status','Delete Application Status',NULL,5,1,'{\"all\":4, \"none\":5}',NULL,NULL),(35,'change_application_status','Change Application Status',NULL,5,1,'{\"all\":4, \"none\":5}',NULL,NULL),(36,'add_interview_schedule','Add Interview Schedule',NULL,5,1,'{\"all\":4,\"added\":1, \"none\":5}',NULL,NULL),(37,'view_interview_schedule','View Interview Schedule',NULL,5,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}',NULL,NULL),(38,'edit_interview_schedule','Edit Interview Schedule',NULL,5,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}',NULL,NULL),(39,'delete_interview_schedule','Delete Interview Schedule',NULL,5,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}',NULL,NULL),(40,'reschedule_interview','Reschedule Interview',NULL,5,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}',NULL,NULL),(41,'add_recommendation_status','Add Recommendation Status',NULL,5,1,'{\"all\":4, \"none\":5}',NULL,NULL),(42,'edit_recommendation_status','Edit Recommendation Status',NULL,5,1,'{\"all\":4, \"none\":5}',NULL,NULL),(43,'delete_recommendation_status','Delete Recommendation Status',NULL,5,1,'{\"all\":4, \"none\":5}',NULL,NULL),(44,'add_recruiter','Add Recruiter',NULL,5,1,'{\"all\":4, \"none\":5}',NULL,NULL),(45,'edit_recruiter','Edit Recruiter',NULL,5,1,'{\"all\":4, \"none\":5}',NULL,NULL),(46,'delete_recruiter','Delete Recruiter',NULL,5,1,'{\"all\":4, \"none\":5}',NULL,NULL),(47,'add_offer_letter','Add Offer Letter',NULL,5,1,'{\"all\":4,\"added\":1, \"none\":5}',NULL,NULL),(48,'view_offer_letter','View Offer Letter',NULL,5,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}',NULL,NULL),(49,'edit_offer_letter','Edit Offer Letter',NULL,5,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}',NULL,NULL),(50,'delete_offer_letter','Delete Offer Letter',NULL,5,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}',NULL,NULL),(51,'add_footer_link','Add Footer Link',NULL,5,1,'{\"all\":4, \"none\":5}',NULL,NULL),(52,'edit_footer_link','Edit Footer Link',NULL,5,1,'{\"all\":4, \"none\":5}',NULL,NULL),(53,'delete_footer_link','Delete Footer Link',NULL,5,1,'{\"all\":4, \"none\":5}',NULL,NULL),(54,'view_report','View Report',NULL,5,1,'{\"all\":4, \"none\":5}',NULL,NULL),(55,'recruit_settings','Recruit Settings',NULL,5,1,'{\"all\":4, \"none\":5}',NULL,NULL),(56,'manage_salary_payment_method','Manage Salary Payment Method',NULL,6,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:08','2023-04-06 06:33:08'),(57,'manage_salary_component','Manage Salary Component',NULL,6,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:08','2023-04-06 06:33:08'),(58,'manage_salary_group','Manage Salary Group',NULL,6,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:08','2023-04-06 06:33:08'),(59,'manage_salary_tds','Manage Salary Tds',NULL,6,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:08','2023-04-06 06:33:08'),(60,'manage_employee_salary','Manage Employee Salary',NULL,6,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:08','2023-04-06 06:33:08'),(61,'add_payroll','Add Payroll',NULL,6,0,'{\"all\":4, \"none\":5}','2023-04-06 06:33:08','2023-04-06 06:33:08'),(62,'view_payroll','View Payroll',NULL,6,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:08','2023-04-06 06:33:08'),(63,'edit_payroll','Edit Payroll',NULL,6,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:08','2023-04-06 06:33:08'),(64,'delete_payroll','Delete Payroll',NULL,6,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:08','2023-04-06 06:33:08'),(65,'manage_job_category','Manage Job Category',NULL,5,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:10','2023-04-06 06:33:10'),(66,'manage_job_sub_category','Manage Job Sub Category',NULL,5,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:10','2023-04-06 06:33:10'),(67,'view_dashboard','View Dashboard',NULL,5,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:15','2023-04-06 06:33:15'),(68,'add_clients','Add Clients',NULL,7,0,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(69,'view_clients','View Clients',NULL,7,0,'{\"all\":4, \"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(70,'edit_clients','Edit Clients',NULL,7,0,'{\"all\":4, \"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(71,'delete_clients','Delete Clients',NULL,7,0,'{\"all\":4, \"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(72,'manage_client_category','Manage Client Category',NULL,7,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(73,'manage_client_subcategory','Manage Client Subcategory',NULL,7,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(74,'add_client_contacts','Add Client Contacts',NULL,7,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(75,'view_client_contacts','View Client Contacts',NULL,7,1,'{\"all\":4, \"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(76,'edit_client_contacts','Edit Client Contacts',NULL,7,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(77,'delete_client_contacts','Delete Client Contacts',NULL,7,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(78,'add_client_note','Add Client Note',NULL,7,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(79,'view_client_note','View Client Note',NULL,7,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(80,'edit_client_note','Edit Client Note',NULL,7,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(81,'delete_client_note','Delete Client Note',NULL,7,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(82,'add_client_document','Add Client Document',NULL,7,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(83,'view_client_document','View Client Document',NULL,7,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(84,'edit_client_document','Edit Client Document',NULL,7,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(85,'delete_client_document','Delete Client Document',NULL,7,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(86,'add_employees','Add Employees',NULL,8,0,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(87,'view_employees','View Employees',NULL,8,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(88,'edit_employees','Edit Employees',NULL,8,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(89,'delete_employees','Delete Employees',NULL,8,0,'{\"all\":4, \"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(90,'add_designation','Add Designation',NULL,8,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(91,'view_designation','View Designation',NULL,8,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(92,'edit_designation','Edit Designation',NULL,8,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(93,'delete_designation','Delete Designation',NULL,8,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(94,'add_department','Add Department',NULL,8,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(95,'view_department','View Department',NULL,8,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(96,'edit_department','Edit Department',NULL,8,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(97,'delete_department','Delete Department',NULL,8,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(98,'add_documents','Add Documents',NULL,8,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(99,'view_documents','View Documents',NULL,8,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(100,'edit_documents','Edit Documents',NULL,8,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(101,'delete_documents','Delete Documents',NULL,8,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(102,'view_leaves_taken','View Leaves Taken',NULL,8,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(103,'update_leaves_quota','Update Leaves Quota',NULL,8,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(104,'view_employee_tasks','View Employee Tasks',NULL,8,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(105,'view_employee_projects','View Employee Projects',NULL,8,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(106,'view_employee_timelogs','View Employee Timelogs',NULL,8,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(107,'change_employee_role','Change Employee Role',NULL,8,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(108,'manage_emergency_contact','Manage Emergency Contact',NULL,8,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(109,'manage_award','Manage Award',NULL,8,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(110,'add_appreciation','Add Appreciation',NULL,8,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(111,'view_appreciation','View Appreciation',NULL,8,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(112,'edit_appreciation','Edit Appreciation',NULL,8,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(113,'delete_appreciation','Delete Appreciation',NULL,8,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(114,'add_immigration','Add Immigration',NULL,8,1,'{\"all\":4, \"owned\":2, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(115,'view_immigration','View Immigration',NULL,8,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(116,'edit_immigration','Edit Immigration',NULL,8,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(117,'delete_immigration','Delete Immigration',NULL,8,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(118,'add_projects','Add Projects',NULL,9,0,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(119,'view_projects','View Projects',NULL,9,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(120,'edit_projects','Edit Projects',NULL,9,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(121,'delete_projects','Delete Projects',NULL,9,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(122,'manage_project_category','Manage Project Category',NULL,9,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(123,'view_project_files','View Project Files',NULL,9,1,'{\"all\":4, \"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(124,'add_project_files','Add Project Files',NULL,9,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(125,'delete_project_files','Delete Project Files',NULL,9,1,'{\"all\":4, \"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(126,'view_project_discussions','View Project Discussions',NULL,9,1,'{\"all\":4, \"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(127,'add_project_discussions','Add Project Discussions',NULL,9,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(128,'edit_project_discussions','Edit Project Discussions',NULL,9,1,'{\"all\":4, \"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(129,'delete_project_discussions','Delete Project Discussions',NULL,9,1,'{\"all\":4, \"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(130,'manage_discussion_category','Manage Discussion Category',NULL,9,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(131,'view_project_milestones','View Project Milestones',NULL,9,1,'{\"all\":4, \"added\":1, \"owned\":2, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(132,'add_project_milestones','Add Project Milestones',NULL,9,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(133,'edit_project_milestones','Edit Project Milestones',NULL,9,1,'{\"all\":4, \"added\":1, \"owned\":2, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(134,'delete_project_milestones','Delete Project Milestones',NULL,9,1,'{\"all\":4, \"added\":1, \"owned\":2, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(135,'view_project_members','View Project Members',NULL,9,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(136,'add_project_members','Add Project Members',NULL,9,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(137,'edit_project_members','Edit Project Members',NULL,9,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(138,'delete_project_members','Delete Project Members',NULL,9,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(139,'view_project_rating','View Project Rating',NULL,9,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(140,'add_project_rating','Add Project Rating',NULL,9,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(141,'edit_project_rating','Edit Project Rating',NULL,9,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(142,'delete_project_rating','Delete Project Rating',NULL,9,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(143,'view_project_budget','View Project Budget',NULL,9,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(144,'view_project_timelogs','View Project Timelogs',NULL,9,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(145,'view_project_expenses','View Project Expenses',NULL,9,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(146,'view_project_tasks','View Project Tasks',NULL,9,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(147,'view_project_invoices','View Project Invoices',NULL,9,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(148,'view_project_burndown_chart','View Project Burndown Chart',NULL,9,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(149,'view_project_payments','View Project Payments',NULL,9,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(150,'view_project_gantt_chart','View Project Gantt Chart',NULL,9,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(151,'add_project_note','Add Project Note',NULL,9,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(152,'view_project_note','View Project Note',NULL,9,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(153,'edit_project_note','Edit Project Note',NULL,9,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(154,'delete_project_note','Delete Project Note',NULL,9,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(155,'manage_project_template','Manage Project Template',NULL,9,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(156,'view_project_template','View Project Template',NULL,9,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(157,'view_project_hourly_rates','View Project Hourly Rates',NULL,9,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(158,'create_public_project','Create Public Project',NULL,9,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(159,'view_miroboard','View Miroboard',NULL,9,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(160,'manage_employee_shifts','Manage Employee Shifts',NULL,10,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(161,'view_shift_roster','View Shift Roster',NULL,10,1,'{\"all\":4, \"owned\":2, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(162,'add_attendance','Add Attendance',NULL,10,0,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(163,'view_attendance','View Attendance',NULL,10,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(164,'edit_attendance','Edit Attendance',NULL,10,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(165,'delete_attendance','Delete Attendance',NULL,10,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(166,'add_tasks','Add Tasks',NULL,11,0,'{\"all\":4, \"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(167,'view_tasks','View Tasks',NULL,11,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(168,'edit_tasks','Edit Tasks',NULL,11,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(169,'delete_tasks','Delete Tasks',NULL,11,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(170,'view_task_category','View Task Category',NULL,11,1,'{\"all\":4, \"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(171,'add_task_category','Add Task Category',NULL,11,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(172,'edit_task_category','Edit Task Category',NULL,11,1,'{\"all\":4, \"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(173,'delete_task_category','Delete Task Category',NULL,11,1,'{\"all\":4, \"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(174,'view_task_files','View Task Files',NULL,11,1,'{\"all\":4, \"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(175,'add_task_files','Add Task Files',NULL,11,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(176,'delete_task_files','Delete Task Files',NULL,11,1,'{\"all\":4, \"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(177,'view_sub_tasks','View Sub Tasks',NULL,11,1,'{\"all\":4, \"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(178,'add_sub_tasks','Add Sub Tasks',NULL,11,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(179,'edit_sub_tasks','Edit Sub Tasks',NULL,11,1,'{\"all\":4, \"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(180,'delete_sub_tasks','Delete Sub Tasks',NULL,11,1,'{\"all\":4, \"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(181,'view_task_comments','View Task Comments',NULL,11,1,'{\"all\":4, \"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(182,'add_task_comments','Add Task Comments',NULL,11,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(183,'edit_task_comments','Edit Task Comments',NULL,11,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(184,'delete_task_comments','Delete Task Comments',NULL,11,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(185,'view_task_notes','View Task Notes',NULL,11,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(186,'add_task_notes','Add Task Notes',NULL,11,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(187,'edit_task_notes','Edit Task Notes',NULL,11,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(188,'delete_task_notes','Delete Task Notes',NULL,11,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(189,'task_labels','Task Labels',NULL,11,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(190,'change_status','Change Status',NULL,11,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(191,'send_reminder','Send Reminder',NULL,11,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(192,'add_status','Add Status',NULL,11,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(193,'view_unassigned_tasks','View Unassigned Tasks',NULL,11,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(194,'create_unassigned_tasks','Create Unassigned Tasks',NULL,11,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(195,'add_estimates','Add Estimates',NULL,12,0,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(196,'view_estimates','View Estimates',NULL,12,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(197,'edit_estimates','Edit Estimates',NULL,12,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(198,'delete_estimates','Delete Estimates',NULL,12,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(199,'add_invoices','Add Invoices',NULL,13,0,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(200,'view_invoices','View Invoices',NULL,13,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(201,'edit_invoices','Edit Invoices',NULL,13,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(202,'delete_invoices','Delete Invoices',NULL,13,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(203,'manage_tax','Manage Tax',NULL,13,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(204,'link_invoice_bank_account','Link Invoice Bank Account',NULL,13,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(205,'manage_recurring_invoice','Manage Recurring Invoice',NULL,13,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(206,'add_payments','Add Payments',NULL,14,0,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(207,'view_payments','View Payments',NULL,14,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(208,'edit_payments','Edit Payments',NULL,14,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(209,'delete_payments','Delete Payments',NULL,14,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(210,'link_payment_bank_account','Link Payment Bank Account',NULL,14,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(211,'add_timelogs','Add Timelogs',NULL,15,0,'{\"all\":4,\"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(212,'view_timelogs','View Timelogs',NULL,15,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(213,'edit_timelogs','Edit Timelogs',NULL,15,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(214,'delete_timelogs','Delete Timelogs',NULL,15,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(215,'approve_timelogs','Approve Timelogs',NULL,15,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(216,'manage_active_timelogs','Manage Active Timelogs',NULL,15,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(217,'view_timelog_earnings','View Timelog Earnings',NULL,15,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(218,'add_tickets','Add Tickets',NULL,16,0,'{\"all\":4,\"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(219,'view_tickets','View Tickets',NULL,16,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(220,'edit_tickets','Edit Tickets',NULL,16,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(221,'delete_tickets','Delete Tickets',NULL,16,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(222,'manage_ticket_type','Manage Ticket Type',NULL,16,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(223,'manage_ticket_agent','Manage Ticket Agent',NULL,16,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(224,'manage_ticket_channel','Manage Ticket Channel',NULL,16,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(225,'manage_ticket_tags','Manage Ticket Tags',NULL,16,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(226,'manage_ticket_groups','Manage Ticket Groups',NULL,16,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(227,'add_events','Add Events',NULL,17,0,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(228,'view_events','View Events',NULL,17,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(229,'edit_events','Edit Events',NULL,17,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(230,'delete_events','Delete Events',NULL,17,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(231,'add_notice','Add Notice',NULL,18,0,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(232,'view_notice','View Notice',NULL,18,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(233,'edit_notice','Edit Notice',NULL,18,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(234,'delete_notice','Delete Notice',NULL,18,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(235,'add_leave','Add Leave',NULL,19,0,'{\"all\":4, \"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(236,'view_leave','View Leave',NULL,19,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(237,'edit_leave','Edit Leave',NULL,19,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(238,'delete_leave','Delete Leave',NULL,19,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(239,'approve_or_reject_leaves','Approve Or Reject Leaves',NULL,19,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(240,'delete_approve_leaves','Delete Approve Leaves',NULL,19,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(241,'add_lead','Add Lead',NULL,20,0,'{\"all\":4, \"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(242,'view_lead','View Lead',NULL,20,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(243,'edit_lead','Edit Lead',NULL,20,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(244,'delete_lead','Delete Lead',NULL,20,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(245,'view_lead_agents','View Lead Agents',NULL,20,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(246,'add_lead_agent','Add Lead Agent',NULL,20,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(247,'edit_lead_agent','Edit Lead Agent',NULL,20,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(248,'delete_lead_agent','Delete Lead Agent',NULL,20,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(249,'view_lead_category','View Lead Category',NULL,20,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(250,'add_lead_category','Add Lead Category',NULL,20,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(251,'edit_lead_category','Edit Lead Category',NULL,20,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(252,'delete_lead_category','Delete Lead Category',NULL,20,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(253,'manage_lead_custom_forms','Manage Lead Custom Forms',NULL,20,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(254,'view_lead_files','View Lead Files',NULL,20,1,'{\"all\":4, \"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(255,'add_lead_files','Add Lead Files',NULL,20,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(256,'delete_lead_files','Delete Lead Files',NULL,20,1,'{\"all\":4, \"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(257,'view_lead_follow_up','View Lead Follow Up',NULL,20,1,'{\"all\":4, \"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(258,'add_lead_follow_up','Add Lead Follow Up',NULL,20,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(259,'edit_lead_follow_up','Edit Lead Follow Up',NULL,20,1,'{\"all\":4, \"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(260,'delete_lead_follow_up','Delete Lead Follow Up',NULL,20,1,'{\"all\":4, \"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(261,'view_lead_sources','View Lead Sources',NULL,20,1,'{\"all\":4, \"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(262,'add_lead_sources','Add Lead Sources',NULL,20,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(263,'edit_lead_sources','Edit Lead Sources',NULL,20,1,'{\"all\":4, \"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(264,'delete_lead_sources','Delete Lead Sources',NULL,20,1,'{\"all\":4, \"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(265,'view_lead_proposals','View Lead Proposals',NULL,20,1,'{\"all\":4, \"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(266,'add_lead_proposals','Add Lead Proposals',NULL,20,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(267,'edit_lead_proposals','Edit Lead Proposals',NULL,20,1,'{\"all\":4, \"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(268,'delete_lead_proposals','Delete Lead Proposals',NULL,20,1,'{\"all\":4, \"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(269,'manage_proposal_template','Manage Proposal Template',NULL,20,1,'{\"all\":4, \"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(270,'change_lead_status','Change Lead Status',NULL,20,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(271,'add_lead_note','Add Lead Note',NULL,20,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(272,'view_lead_note','View Lead Note',NULL,20,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(273,'edit_lead_note','Edit Lead Note',NULL,20,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(274,'delete_lead_note','Delete Lead Note',NULL,20,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(275,'manage_lead_status','Manage Lead Status',NULL,20,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(276,'add_holiday','Add Holiday',NULL,21,0,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(277,'view_holiday','View Holiday',NULL,21,0,'{\"all\":4, \"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(278,'edit_holiday','Edit Holiday',NULL,21,0,'{\"all\":4, \"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(279,'delete_holiday','Delete Holiday',NULL,21,0,'{\"all\":4, \"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(280,'add_product','Add Product',NULL,22,0,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(281,'view_product','View Product',NULL,22,0,'{\"all\":4, \"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(282,'edit_product','Edit Product',NULL,22,0,'{\"all\":4, \"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(283,'delete_product','Delete Product',NULL,22,0,'{\"all\":4, \"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(284,'manage_product_category','Manage Product Category',NULL,22,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(285,'manage_product_sub_category','Manage Product Sub Category',NULL,22,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(286,'add_expenses','Add Expenses',NULL,23,0,'{\"all\":4, \"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(287,'view_expenses','View Expenses',NULL,23,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(288,'edit_expenses','Edit Expenses',NULL,23,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(289,'delete_expenses','Delete Expenses',NULL,23,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(290,'manage_expense_category','Manage Expense Category',NULL,23,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(291,'manage_recurring_expense','Manage Recurring Expense',NULL,23,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(292,'approve_expenses','Approve Expenses',NULL,23,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(293,'link_expense_bank_account','Link Expense Bank Account',NULL,23,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(294,'add_contract','Add Contract',NULL,24,0,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(295,'view_contract','View Contract',NULL,24,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(296,'edit_contract','Edit Contract',NULL,24,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(297,'delete_contract','Delete Contract',NULL,24,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(298,'manage_contract_type','Manage Contract Type',NULL,24,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(299,'renew_contract','Renew Contract',NULL,24,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(300,'add_contract_discussion','Add Contract Discussion',NULL,24,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(301,'edit_contract_discussion','Edit Contract Discussion',NULL,24,1,'{\"all\":4, \"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(302,'view_contract_discussion','View Contract Discussion',NULL,24,1,'{\"all\":4, \"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(303,'delete_contract_discussion','Delete Contract Discussion',NULL,24,1,'{\"all\":4, \"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(304,'add_contract_files','Add Contract Files',NULL,24,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(305,'view_contract_files','View Contract Files',NULL,24,1,'{\"all\":4, \"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(306,'delete_contract_files','Delete Contract Files',NULL,24,1,'{\"all\":4, \"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(307,'manage_contract_template','Manage Contract Template',NULL,24,1,'{\"all\":4, \"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(308,'view_task_report','View Task Report',NULL,25,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(309,'view_time_log_report','View Time Log Report',NULL,25,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(310,'view_finance_report','View Finance Report',NULL,25,1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(311,'view_income_expense_report','View Income Vs Expense Report',NULL,25,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(312,'view_leave_report','View Leave Report',NULL,25,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(313,'view_attendance_report','View Attendance Report',NULL,25,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(314,'view_expense_report','View Expense Report',NULL,25,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(315,'view_lead_report','View Lead Report',NULL,25,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(316,'view_sales_report','View Sales Report',NULL,25,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(317,'manage_company_setting','Manage Company Setting',NULL,26,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(318,'manage_app_setting','Manage App Setting',NULL,26,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(319,'manage_notification_setting','Manage Notification Setting',NULL,26,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(320,'manage_currency_setting','Manage Currency Setting',NULL,26,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(321,'manage_payment_setting','Manage Payment Setting',NULL,26,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(322,'manage_finance_setting','Manage Finance Setting',NULL,26,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(323,'manage_ticket_setting','Manage Ticket Setting',NULL,26,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(324,'manage_project_setting','Manage Project Setting',NULL,26,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(325,'manage_attendance_setting','Manage Attendance Setting',NULL,26,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(326,'manage_leave_setting','Manage Leave Setting',NULL,26,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(327,'manage_custom_field_setting','Manage Custom Field Setting',NULL,26,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(328,'manage_message_setting','Manage Message Setting',NULL,26,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(329,'manage_storage_setting','Manage Storage Setting',NULL,26,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(330,'manage_language_setting','Manage Language Setting',NULL,26,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(331,'manage_lead_setting','Manage Lead Setting',NULL,26,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(332,'manage_time_log_setting','Manage Time Log Setting',NULL,26,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(333,'manage_task_setting','Manage Task Setting',NULL,26,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(334,'manage_social_login_setting','Manage Social Login Setting',NULL,26,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(335,'manage_security_setting','Manage Security Setting',NULL,26,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(336,'manage_gdpr_setting','Manage Gdpr Setting',NULL,26,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(337,'manage_theme_setting','Manage Theme Setting',NULL,26,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(338,'manage_role_permission_setting','Manage Role Permission Setting',NULL,26,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(339,'manage_module_setting','Manage Module Setting',NULL,26,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(340,'manage_google_calendar_setting','Manage Google Calendar Setting',NULL,26,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(341,'view_overview_dashboard','View Overview Dashboard',NULL,27,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(342,'view_project_dashboard','View Project Dashboard',NULL,27,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(343,'view_client_dashboard','View Client Dashboard',NULL,27,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(344,'view_hr_dashboard','View Hr Dashboard',NULL,27,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(345,'view_ticket_dashboard','View Ticket Dashboard',NULL,27,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(346,'view_finance_dashboard','View Finance Dashboard',NULL,27,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(347,'add_order','Add Order',NULL,28,0,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(348,'view_order','View Order',NULL,28,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(349,'edit_order','Edit Order',NULL,28,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(350,'delete_order','Delete Order',NULL,28,0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(351,'add_knowledgebase','Add Knowledgebase',NULL,29,0,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(352,'view_knowledgebase','View Knowledgebase',NULL,29,0,'{\"all\":4,\"added\":1,\"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(353,'edit_knowledgebase','Edit Knowledgebase',NULL,29,0,'{\"all\":4,\"added\":1,\"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(354,'delete_knowledgebase','Delete Knowledgebase',NULL,29,0,'{\"all\":4,\"added\":1,\"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(355,'add_bankaccount','Add Bankaccount',NULL,30,0,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(356,'view_bankaccount','View Bankaccount',NULL,30,0,'{\"all\":4,\"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(357,'edit_bankaccount','Edit Bankaccount',NULL,30,0,'{\"all\":4,\"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(358,'delete_bankaccount','Delete Bankaccount',NULL,30,0,'{\"all\":4,\"added\":1, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(359,'add_bank_transfer','Add Bank Transfer',NULL,30,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(360,'add_bank_deposit','Add Bank Deposit',NULL,30,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16'),(361,'add_bank_withdraw','Add Bank Withdraw',NULL,30,1,'{\"all\":4, \"none\":5}','2023-04-06 06:33:16','2023-04-06 06:33:16');
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pinned`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pinned` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `project_id` int unsigned DEFAULT NULL,
  `task_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pinned_company_id_foreign` (`company_id`),
  KEY `pinned_project_id_foreign` (`project_id`),
  KEY `pinned_task_id_foreign` (`task_id`),
  KEY `pinned_user_id_foreign` (`user_id`),
  CONSTRAINT `pinned_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `pinned_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `pinned_task_id_foreign` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `pinned_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pinned` WRITE;
/*!40000 ALTER TABLE `pinned` DISABLE KEYS */;
/*!40000 ALTER TABLE `pinned` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `product_category` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `category_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_category_company_id_foreign` (`company_id`),
  CONSTRAINT `product_category_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_category` WRITE;
/*!40000 ALTER TABLE `product_category` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_category` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `product_files` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `product_id` int unsigned NOT NULL,
  `filename` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hashname` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_files_product_id_foreign` (`product_id`),
  KEY `product_files_added_by_foreign` (`added_by`),
  KEY `product_files_last_updated_by_foreign` (`last_updated_by`),
  KEY `product_files_company_id_foreign` (`company_id`),
  CONSTRAINT `product_files_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `product_files_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `product_files_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `product_files_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_files` WRITE;
/*!40000 ALTER TABLE `product_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_files` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_sub_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `product_sub_category` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `category_id` bigint unsigned NOT NULL,
  `category_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_sub_category_company_id_foreign` (`company_id`),
  KEY `product_sub_category_category_id_foreign` (`category_id`),
  CONSTRAINT `product_sub_category_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `product_category` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `product_sub_category_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_sub_category` WRITE;
/*!40000 ALTER TABLE `product_sub_category` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_sub_category` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `price` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `taxes` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `allow_purchase` tinyint(1) NOT NULL DEFAULT '0',
  `downloadable` tinyint(1) NOT NULL DEFAULT '0',
  `downloadable_file` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `category_id` bigint unsigned DEFAULT NULL,
  `sub_category_id` bigint unsigned DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `hsn_sac_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `default_image` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `unit_id` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `products_company_id_foreign` (`company_id`),
  KEY `products_category_id_foreign` (`category_id`),
  KEY `products_sub_category_id_foreign` (`sub_category_id`),
  KEY `products_added_by_foreign` (`added_by`),
  KEY `products_last_updated_by_foreign` (`last_updated_by`),
  KEY `products_unit_id_foreign` (`unit_id`),
  CONSTRAINT `products_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `products_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `product_category` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `products_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `products_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `products_sub_category_id_foreign` FOREIGN KEY (`sub_category_id`) REFERENCES `product_sub_category` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `products_unit_id_foreign` FOREIGN KEY (`unit_id`) REFERENCES `unit_types` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (1,1,'Smartphone Case','384',NULL,1,0,NULL,'Dolorem dolores et similique cum quam enim architecto. Consequatur similique et est dolore veniam doloremque reprehenderit. Exercitationem ut nesciunt nostrum aliquid est.',NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',1),(2,1,'Men\'s Leather Wallet','875',NULL,1,0,NULL,'Delectus asperiores libero nam et numquam voluptatum dolores. Quia provident debitis culpa dolores inventore. Rerum mollitia tenetur est repellat cumque tenetur. Odio odit impedit consequatur doloremque tempore.',NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',1),(3,1,'Smart Thermostat','198',NULL,1,0,NULL,'Harum hic id fuga odit omnis et unde. Voluptas labore soluta ratione eaque id facilis. In et debitis velit dignissimos possimus laboriosam beatae. Voluptatum sit qui voluptatibus possimus optio natus consequatur maiores. Tempore aut eveniet explicabo.',NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',1),(4,1,'Essential Oil Diffuser','137',NULL,1,0,NULL,'Dignissimos quia voluptas tempora dignissimos qui dolor. Ipsam ullam et aut deleniti et. Sunt possimus nulla voluptas quis. Non molestias veniam sunt sed aperiam.',NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',1),(5,1,'Unisex Sunglasses','349',NULL,1,0,NULL,'Est aliquam nesciunt dolore et. Quo aliquid quos nobis laboriosam. Quos non magnam qui optio molestias id.',NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',1),(6,1,'Women\'s Fashion Handbag','256',NULL,1,0,NULL,'Delectus neque et totam ut deleniti at iusto. Autem esse fugit labore harum sed. Qui esse modi recusandae sit aut voluptates non.',NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',1),(7,1,'Smart Thermostat','526',NULL,1,0,NULL,'Eveniet tempore nesciunt eum accusamus. Placeat fugit libero aut vero veritatis quia. Rerum blanditiis placeat praesentium delectus vitae.',NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',1),(8,1,'Gaming Headset','845',NULL,1,0,NULL,'Eius ut officia quo quis pariatur possimus cupiditate doloribus. Ut quod temporibus temporibus eum porro porro. Doloribus fugit fuga quidem expedita cupiditate molestiae. Corporis in tenetur incidunt voluptas atque.',NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',1),(9,1,'Smart Smoke Detector','491',NULL,1,0,NULL,'Aspernatur placeat quo repellendus officia incidunt magnam dolorem. Error accusantium nesciunt ratione vel.',NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',1),(10,1,'Air Purifier','632',NULL,1,0,NULL,'Esse accusantium laboriosam dolor quis quidem dolorum unde. Perspiciatis eos deleniti nihil tempora quae id. Ut molestias illo incidunt aut.',NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',1);
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `project_activity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_activity` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `project_id` int unsigned NOT NULL,
  `activity` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_activity_project_id_foreign` (`project_id`),
  KEY `project_activity_created_at_index` (`created_at`),
  CONSTRAINT `project_activity_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=53 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `project_activity` WRITE;
/*!40000 ALTER TABLE `project_activity` DISABLE KEYS */;
INSERT INTO `project_activity` VALUES (1,1,'Weather forecasting system added as new project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(2,1,'New member added to the project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(3,1,'New member added to the project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(4,1,'New task added to the project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(5,1,'New task added to the project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(6,2,'Opinion mining for social networking platforms added as new project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(7,2,'New member added to the project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(8,2,'New member added to the project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(9,2,'New task added to the project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(10,2,'New task added to the project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(11,3,'E-learning platform for language courses added as new project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(12,3,'New member added to the project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(13,3,'New member added to the project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(14,3,'New member added to the project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(15,3,'New task added to the project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(16,3,'New task added to the project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(17,3,'New task added to the project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(18,4,'Create Design of worksuite added as new project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(19,4,'New member added to the project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(20,4,'New member added to the project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(21,4,'New task added to the project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(22,4,'New task added to the project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(23,5,'Digital marketing and advertising service added as new project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(24,5,'New member added to the project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(25,5,'New member added to the project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(26,5,'New member added to the project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(27,5,'New task added to the project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(28,5,'New task added to the project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(29,5,'New task added to the project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(30,6,'Bug tracker added as new project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(31,6,'New member added to the project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(32,6,'New member added to the project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(33,6,'New member added to the project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(34,6,'New task added to the project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(35,6,'New task added to the project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(36,6,'New task added to the project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(37,7,'Financial planning and budgeting tool added as new project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(38,7,'New member added to the project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(39,7,'New member added to the project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(40,7,'New member added to the project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(41,7,'New task added to the project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(42,7,'New task added to the project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(43,7,'New task added to the project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(44,8,'Project management and team collaboration tool added as new project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(45,8,'New member added to the project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(46,8,'New task added to the project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(47,9,'Artificial intelligence (AI) and machine learning (ML) development service added as new project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(48,9,'New member added to the project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(49,9,'New task added to the project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(50,10,'Weather forecasting system added as new project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(51,10,'New member added to the project.','2023-04-06 06:33:18','2023-04-06 06:33:18'),(52,10,'New task added to the project.','2023-04-06 06:33:18','2023-04-06 06:33:18');
/*!40000 ALTER TABLE `project_activity` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `project_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_category` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `category_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_category_company_id_foreign` (`company_id`),
  KEY `project_category_added_by_foreign` (`added_by`),
  KEY `project_category_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `project_category_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `project_category_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `project_category_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `project_category` WRITE;
/*!40000 ALTER TABLE `project_category` DISABLE KEYS */;
INSERT INTO `project_category` VALUES (1,1,'Laravel',NULL,NULL,NULL,NULL),(2,1,'Vuejs',NULL,NULL,NULL,NULL),(3,1,'React',NULL,NULL,NULL,NULL),(4,1,'Zend',NULL,NULL,NULL,NULL),(5,1,'CakePhp',NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `project_category` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `project_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_files` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `project_id` int unsigned NOT NULL,
  `filename` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `hashname` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `google_url` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dropbox_link` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_files_company_id_foreign` (`company_id`),
  KEY `project_files_user_id_foreign` (`user_id`),
  KEY `project_files_project_id_foreign` (`project_id`),
  KEY `project_files_added_by_foreign` (`added_by`),
  KEY `project_files_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `project_files_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `project_files_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `project_files_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `project_files_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `project_files_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `project_files` WRITE;
/*!40000 ALTER TABLE `project_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_files` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `project_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_members` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL,
  `project_id` int unsigned NOT NULL,
  `hourly_rate` double NOT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_members_user_id_foreign` (`user_id`),
  KEY `project_members_project_id_foreign` (`project_id`),
  KEY `project_members_added_by_foreign` (`added_by`),
  KEY `project_members_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `project_members_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `project_members_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `project_members_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `project_members_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `project_members` WRITE;
/*!40000 ALTER TABLE `project_members` DISABLE KEYS */;
INSERT INTO `project_members` VALUES (1,18,1,24,1,1,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(2,15,1,40,1,1,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(3,21,2,49,1,1,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(4,23,2,93,1,1,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(5,14,3,61,1,1,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(6,23,3,93,1,1,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(7,21,3,49,1,1,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(8,21,4,49,1,1,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(9,15,4,40,1,1,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(10,18,5,24,1,1,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(11,1,5,20,1,1,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(12,15,5,40,1,1,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(13,23,6,93,1,1,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(14,14,6,61,1,1,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(15,19,6,51,1,1,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(16,22,7,38,1,1,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(17,2,7,51,1,1,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(18,16,7,95,1,1,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(19,17,8,91,1,1,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(20,19,9,51,1,1,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(21,17,10,91,1,1,'2023-04-06 06:33:18','2023-04-06 06:33:18');
/*!40000 ALTER TABLE `project_members` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `project_milestones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_milestones` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `project_id` int unsigned DEFAULT NULL,
  `currency_id` int unsigned DEFAULT NULL,
  `milestone_title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `summary` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cost` double(16,2) NOT NULL,
  `status` enum('complete','incomplete') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'incomplete',
  `invoice_created` tinyint(1) NOT NULL,
  `invoice_id` int DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_milestones_project_id_foreign` (`project_id`),
  KEY `project_milestones_currency_id_foreign` (`currency_id`),
  KEY `project_milestones_added_by_foreign` (`added_by`),
  KEY `project_milestones_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `project_milestones_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `project_milestones_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `project_milestones_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `project_milestones_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `project_milestones` WRITE;
/*!40000 ALTER TABLE `project_milestones` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_milestones` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `project_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_notes` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `project_id` int unsigned DEFAULT NULL,
  `title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `client_id` int unsigned DEFAULT NULL,
  `is_client_show` tinyint(1) NOT NULL DEFAULT '0',
  `ask_password` tinyint(1) NOT NULL DEFAULT '0',
  `details` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_notes_project_id_foreign` (`project_id`),
  KEY `project_notes_client_id_foreign` (`client_id`),
  KEY `project_notes_added_by_foreign` (`added_by`),
  KEY `project_notes_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `project_notes_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `project_notes_client_id_foreign` FOREIGN KEY (`client_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `project_notes_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `project_notes_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `project_notes` WRITE;
/*!40000 ALTER TABLE `project_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_notes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `project_ratings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_ratings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `project_id` int unsigned NOT NULL,
  `rating` double NOT NULL DEFAULT '0',
  `comment` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `user_id` int unsigned NOT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_ratings_project_id_foreign` (`project_id`),
  KEY `project_ratings_user_id_foreign` (`user_id`),
  KEY `project_ratings_added_by_foreign` (`added_by`),
  KEY `project_ratings_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `project_ratings_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `project_ratings_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `project_ratings_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `project_ratings_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `project_ratings` WRITE;
/*!40000 ALTER TABLE `project_ratings` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_ratings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `project_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `send_reminder` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `remind_time` int NOT NULL,
  `remind_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `remind_to` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '["admins","members"]',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_settings_company_id_foreign` (`company_id`),
  CONSTRAINT `project_settings_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `project_settings` WRITE;
/*!40000 ALTER TABLE `project_settings` DISABLE KEYS */;
INSERT INTO `project_settings` VALUES (1,1,'no',5,'days','[\"admins\",\"members\"]','2023-04-06 06:33:16','2023-04-06 06:33:16');
/*!40000 ALTER TABLE `project_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `project_status_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_status_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `status_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` enum('active','inactive') COLLATE utf8mb4_unicode_ci NOT NULL,
  `default_status` enum('1','0') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_status_settings_company_id_foreign` (`company_id`),
  CONSTRAINT `project_status_settings_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `project_status_settings` WRITE;
/*!40000 ALTER TABLE `project_status_settings` DISABLE KEYS */;
INSERT INTO `project_status_settings` VALUES (1,1,'in progress','#00b5ff','active','1',NULL,NULL),(2,1,'not started','#616e80','active','0',NULL,NULL),(3,1,'on hold','#f5c308','active','0',NULL,NULL),(4,1,'canceled','#d21010','active','0',NULL,NULL),(5,1,'finished','#679c0d','active','0',NULL,NULL);
/*!40000 ALTER TABLE `project_status_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `project_template_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_template_members` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL,
  `project_template_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_template_members_user_id_foreign` (`user_id`),
  KEY `project_template_members_project_template_id_foreign` (`project_template_id`),
  CONSTRAINT `project_template_members_project_template_id_foreign` FOREIGN KEY (`project_template_id`) REFERENCES `project_templates` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `project_template_members_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `project_template_members` WRITE;
/*!40000 ALTER TABLE `project_template_members` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_template_members` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `project_template_sub_tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_template_sub_tasks` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `project_template_task_id` int unsigned NOT NULL,
  `title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `start_date` datetime DEFAULT NULL,
  `due_date` datetime DEFAULT NULL,
  `status` enum('incomplete','complete') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'incomplete',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_template_sub_tasks_project_template_task_id_foreign` (`project_template_task_id`),
  CONSTRAINT `project_template_sub_tasks_project_template_task_id_foreign` FOREIGN KEY (`project_template_task_id`) REFERENCES `project_template_tasks` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `project_template_sub_tasks` WRITE;
/*!40000 ALTER TABLE `project_template_sub_tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_template_sub_tasks` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `project_template_task_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_template_task_users` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `project_template_task_id` int unsigned NOT NULL,
  `user_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_template_task_users_project_template_task_id_foreign` (`project_template_task_id`),
  KEY `project_template_task_users_user_id_foreign` (`user_id`),
  CONSTRAINT `project_template_task_users_project_template_task_id_foreign` FOREIGN KEY (`project_template_task_id`) REFERENCES `project_template_tasks` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `project_template_task_users_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `project_template_task_users` WRITE;
/*!40000 ALTER TABLE `project_template_task_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_template_task_users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `project_template_tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_template_tasks` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `heading` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `project_template_id` int unsigned NOT NULL,
  `priority` enum('low','medium','high') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'medium',
  `project_template_task_category_id` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_template_tasks_project_template_id_foreign` (`project_template_id`),
  KEY `project_template_tasks_project_template_task_category_id_foreign` (`project_template_task_category_id`),
  CONSTRAINT `project_template_tasks_project_template_id_foreign` FOREIGN KEY (`project_template_id`) REFERENCES `project_templates` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `project_template_tasks_project_template_task_category_id_foreign` FOREIGN KEY (`project_template_task_category_id`) REFERENCES `task_category` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `project_template_tasks` WRITE;
/*!40000 ALTER TABLE `project_template_tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_template_tasks` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `project_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_templates` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `project_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `category_id` int unsigned DEFAULT NULL,
  `client_id` int unsigned DEFAULT NULL,
  `project_summary` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `notes` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `feedback` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `client_view_task` enum('enable','disable') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'disable',
  `allow_client_notification` enum('enable','disable') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'disable',
  `manual_timelog` enum('enable','disable') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'disable',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `added_by` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `project_templates_company_id_foreign` (`company_id`),
  KEY `project_templates_category_id_foreign` (`category_id`),
  KEY `project_templates_client_id_foreign` (`client_id`),
  CONSTRAINT `project_templates_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `project_category` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `project_templates_client_id_foreign` FOREIGN KEY (`client_id`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `project_templates_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `project_templates` WRITE;
/*!40000 ALTER TABLE `project_templates` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `project_time_log_breaks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_time_log_breaks` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `project_time_log_id` int unsigned DEFAULT NULL,
  `start_time` datetime NOT NULL,
  `end_time` datetime DEFAULT NULL,
  `reason` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_hours` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_minutes` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_time_log_breaks_company_id_foreign` (`company_id`),
  KEY `project_time_log_breaks_project_time_log_id_foreign` (`project_time_log_id`),
  KEY `project_time_log_breaks_start_time_index` (`start_time`),
  KEY `project_time_log_breaks_end_time_index` (`end_time`),
  KEY `project_time_log_breaks_added_by_foreign` (`added_by`),
  KEY `project_time_log_breaks_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `project_time_log_breaks_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `project_time_log_breaks_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `project_time_log_breaks_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `project_time_log_breaks_project_time_log_id_foreign` FOREIGN KEY (`project_time_log_id`) REFERENCES `project_time_logs` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `project_time_log_breaks` WRITE;
/*!40000 ALTER TABLE `project_time_log_breaks` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_time_log_breaks` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `project_time_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_time_logs` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `project_id` int unsigned DEFAULT NULL,
  `task_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `start_time` datetime NOT NULL,
  `end_time` datetime DEFAULT NULL,
  `memo` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_hours` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_minutes` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `edited_by_user` int unsigned DEFAULT NULL,
  `hourly_rate` int NOT NULL,
  `earnings` int NOT NULL,
  `approved` tinyint(1) NOT NULL DEFAULT '1',
  `approved_by` int unsigned DEFAULT NULL,
  `invoice_id` int unsigned DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `total_break_minutes` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_time_logs_company_id_foreign` (`company_id`),
  KEY `project_time_logs_project_id_foreign` (`project_id`),
  KEY `project_time_logs_task_id_foreign` (`task_id`),
  KEY `project_time_logs_user_id_foreign` (`user_id`),
  KEY `project_time_logs_start_time_index` (`start_time`),
  KEY `project_time_logs_end_time_index` (`end_time`),
  KEY `project_time_logs_edited_by_user_foreign` (`edited_by_user`),
  KEY `project_time_logs_approved_by_foreign` (`approved_by`),
  KEY `project_time_logs_invoice_id_foreign` (`invoice_id`),
  KEY `project_time_logs_added_by_foreign` (`added_by`),
  KEY `project_time_logs_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `project_time_logs_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `project_time_logs_approved_by_foreign` FOREIGN KEY (`approved_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `project_time_logs_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `project_time_logs_edited_by_user_foreign` FOREIGN KEY (`edited_by_user`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `project_time_logs_invoice_id_foreign` FOREIGN KEY (`invoice_id`) REFERENCES `invoices` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `project_time_logs_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `project_time_logs_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `project_time_logs_task_id_foreign` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `project_time_logs_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `project_time_logs` WRITE;
/*!40000 ALTER TABLE `project_time_logs` DISABLE KEYS */;
INSERT INTO `project_time_logs` VALUES (1,1,1,2,18,'2023-04-01 12:00:18','2023-04-01 15:00:18','working onvel','3','180',NULL,24,72,1,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(2,1,1,2,18,'2023-03-30 10:00:57','2023-03-30 15:00:57','working onsed','5','300',NULL,24,120,1,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(3,1,2,4,21,'2023-02-21 23:33:05','2023-02-22 04:33:05','working onnon','5','300',NULL,49,245,1,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(4,1,2,4,21,'2023-04-09 00:00:00','2023-04-09 05:00:00','working onveniam','5','300',NULL,49,245,1,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(5,1,3,7,14,'2023-04-07 00:00:00','2023-04-07 02:00:00','working ondolore','2','120',NULL,61,122,1,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(6,1,3,7,14,'2023-04-10 00:00:00','2023-04-10 04:00:00','working ondicta','4','240',NULL,61,244,1,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(7,1,3,7,14,'2023-01-04 05:49:07','2023-01-04 08:49:07','working onquis','3','180',NULL,61,183,1,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(8,1,4,9,21,'2023-04-09 00:00:00','2023-04-09 02:00:00','working onsed','2','120',NULL,49,98,1,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(9,1,4,9,21,'2023-03-13 06:53:45','2023-03-13 07:53:45','working onodio','1','60',NULL,49,49,1,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(10,1,5,12,18,'2023-04-07 00:00:00','2023-04-07 05:00:00','working ondignissimos','5','300',NULL,24,120,1,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(11,1,5,12,18,'2023-04-07 00:00:00','2023-04-07 02:00:00','working onin','2','120',NULL,24,48,1,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(12,1,5,12,18,'2023-04-09 00:00:00','2023-04-09 05:00:00','working onveritatis','5','300',NULL,24,120,1,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(13,1,6,15,23,'2023-04-10 00:00:00','2023-04-10 04:00:00','working ondistinctio','4','240',NULL,93,372,1,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(14,1,6,15,23,'2023-04-12 00:00:00','2023-04-12 02:00:00','working onaperiam','2','120',NULL,93,186,1,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(15,1,6,15,23,'2023-04-08 00:00:00','2023-04-08 04:00:00','working onexercitationem','4','240',NULL,93,372,1,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(16,1,7,18,22,'2023-03-25 15:40:12','2023-03-25 16:40:12','working onin','1','60',NULL,38,38,1,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(17,1,7,18,22,'2023-03-26 05:52:28','2023-03-26 09:52:28','working ondolorum','4','240',NULL,38,152,1,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(18,1,7,18,22,'2023-04-11 00:00:00','2023-04-11 02:00:00','working onmodi','2','120',NULL,38,76,1,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(19,1,8,19,17,'2023-04-08 00:00:00','2023-04-08 01:00:00','working onnecessitatibus','1','60',NULL,91,91,1,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(20,1,9,20,19,'2023-04-12 00:00:00','2023-04-12 02:00:00','working onqui','2','120',NULL,51,102,1,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(21,1,10,21,17,'2023-02-11 15:24:20','2023-02-11 18:24:20','working onea','3','180',NULL,91,273,1,NULL,NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18');
/*!40000 ALTER TABLE `project_time_logs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `project_user_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_user_notes` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL,
  `project_note_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_user_notes_user_id_foreign` (`user_id`),
  KEY `project_user_notes_project_note_id_foreign` (`project_note_id`),
  CONSTRAINT `project_user_notes_project_note_id_foreign` FOREIGN KEY (`project_note_id`) REFERENCES `project_notes` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `project_user_notes_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `project_user_notes` WRITE;
/*!40000 ALTER TABLE `project_user_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_user_notes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `projects` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `project_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `project_short_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `project_summary` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `project_admin` int unsigned DEFAULT NULL,
  `start_date` date NOT NULL,
  `deadline` date DEFAULT NULL,
  `notes` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `category_id` int unsigned DEFAULT NULL,
  `client_id` int unsigned DEFAULT NULL,
  `team_id` int unsigned DEFAULT NULL,
  `feedback` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `manual_timelog` enum('enable','disable') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'disable',
  `client_view_task` enum('enable','disable') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'disable',
  `allow_client_notification` enum('enable','disable') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'disable',
  `completion_percent` tinyint NOT NULL,
  `calculate_task_progress` enum('true','false') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'true',
  `project_budget` double(20,2) DEFAULT NULL,
  `currency_id` int unsigned DEFAULT NULL,
  `hours_allocated` double(8,2) DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'in progress',
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `hash` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `public` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `enable_miroboard` tinyint(1) NOT NULL DEFAULT '0',
  `miro_board_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `client_access` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `projects_company_id_foreign` (`company_id`),
  KEY `projects_project_admin_foreign` (`project_admin`),
  KEY `projects_category_id_foreign` (`category_id`),
  KEY `projects_client_id_foreign` (`client_id`),
  KEY `projects_team_id_foreign` (`team_id`),
  KEY `projects_currency_id_foreign` (`currency_id`),
  KEY `projects_added_by_foreign` (`added_by`),
  KEY `projects_last_updated_by_foreign` (`last_updated_by`),
  KEY `projects_deleted_at_index` (`deleted_at`),
  CONSTRAINT `projects_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `projects_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `project_category` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `projects_client_id_foreign` FOREIGN KEY (`client_id`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `projects_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `projects_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `projects_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `projects_project_admin_foreign` FOREIGN KEY (`project_admin`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `projects_team_id_foreign` FOREIGN KEY (`team_id`) REFERENCES `teams` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `projects` WRITE;
/*!40000 ALTER TABLE `projects` DISABLE KEYS */;
INSERT INTO `projects` VALUES (1,1,'Weather forecasting system','WFS','Et labore ipsa dolor tempore. Ad et amet recusandae sunt. Iure perferendis dolorum distinctio porro natus odio.',NULL,'2023-02-06','2023-06-06','Ab rem ipsa suscipit et quidem non. Voluptatem earum eos ea sequi cum rerum perferendis aut. Rem modi voluptas explicabo.',5,6,NULL,'For instance, if you could manage it?) \'And what an ignorant little girl or a serpent?\' \'It matters a good deal worse off than before, as the March Hare. \'I didn\'t know how to begin.\' He looked at.','disable','disable','disable',65,'false',NULL,1,NULL,'in progress',1,NULL,'c766d384f9b244abf588705424393964',0,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL,0,NULL,0),(2,1,'Opinion mining for social networking platforms','OMFSNP','Ipsa corrupti cupiditate dolores modi corporis. Dolores enim hic et sunt. Repudiandae ab aut saepe nemo consectetur consequatur et. Est qui non asperiores.',NULL,'2022-12-06','2023-04-06','Dolorem sunt dicta quo ut et ab impedit. Est et quaerat eaque magni accusantium. Et saepe et totam ducimus tempore.',1,10,NULL,'I was going to say,\' said the Dodo could not think of nothing better to say than his first speech. \'You should learn not to make out what it was talking in his throat,\' said the Hatter. \'You might.','disable','disable','disable',46,'false',NULL,1,NULL,'in progress',1,NULL,'b2f54481d5ea6534440d9e8dfa7249d1',0,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL,0,NULL,0),(3,1,'E-learning platform for language courses','EPFLC','Dolor qui dolorem quibusdam natus at illum corrupti. Maiores error aut necessitatibus illo fugit magni error. Quis quisquam eaque quis assumenda. Veritatis harum eius quaerat harum voluptates sit.',NULL,'2022-11-06','2023-03-06','Neque in odit et asperiores officiis quae nobis et. Repellat at incidunt voluptatem doloribus temporibus. Voluptatem quibusdam ea tenetur. Perferendis illum aut voluptatem ad rerum.',5,5,NULL,'Alice after it, and finding it very hard indeed to make it stop. \'Well, I\'d hardly finished the goose, with the birds hurried off at once, in a game of play with a sigh: \'it\'s always tea-time, and.','disable','disable','disable',89,'false',NULL,1,NULL,'in progress',1,NULL,'7cf12e7095d511a25f1ae20bef2f2940',0,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL,0,NULL,0),(4,1,'Create Design of worksuite','CDOW','Eius voluptate et minus sed aspernatur enim. Voluptatem aut in numquam impedit mollitia minus.',NULL,'2023-01-06','2023-05-06','Aut itaque magni nihil et. Eius suscipit corporis quia mollitia. Velit expedita dolores perspiciatis quaerat voluptatibus voluptatem. Magni et voluptate maiores distinctio cumque voluptatem.',3,11,NULL,'Alice as he fumbled over the verses on his knee, and looking at everything that Alice could hardly hear the Rabbit coming to look at it!\' This speech caused a remarkable sensation among the trees, a.','disable','disable','disable',71,'false',NULL,1,NULL,'in progress',1,NULL,'3aa93fd38d10487d2e00ea37df0c6ad7',0,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL,0,NULL,0),(5,1,'Digital marketing and advertising service','DMAAS','Libero quia nesciunt qui et accusantium. Officiis quod cum impedit eius fugit. Omnis hic et assumenda nostrum.',NULL,'2023-03-06','2023-07-06','Laboriosam sed molestiae optio reprehenderit doloribus omnis accusamus. Est sit explicabo non officiis. Aperiam quos sunt mollitia et omnis doloribus quo.',1,3,NULL,'She was a most extraordinary noise going on between the executioner, the King, rubbing his hands; \'so now let the jury--\' \'If any one left alive!\' She was walking hand in hand with Dinah, and saying.','disable','disable','disable',89,'false',NULL,1,NULL,'in progress',1,NULL,'39dd23735b9aa1b4b786add80cd28b05',0,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL,0,NULL,0),(6,1,'Bug tracker','BT','Corrupti eos porro quas ut facere velit. Illo non tempora non expedita autem vel debitis. Ut eligendi iure modi incidunt voluptas inventore totam. Laboriosam asperiores est ipsam recusandae.',NULL,'2022-11-06','2023-03-06','Consequatur aut esse eos excepturi. Occaecati vel excepturi corporis vitae quidem corporis et. Quis enim eligendi minima esse quia impedit ea.',3,12,NULL,'Writhing, of course, I meant,\' the King say in a great crowd assembled about them--all sorts of things, and she, oh! she knows such a pleasant temper, and thought to herself. \'Of the mushroom,\' said.','disable','disable','disable',84,'false',NULL,1,NULL,'in progress',1,NULL,'5cf56bb1a7059882926260dca16fd59f',0,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL,0,NULL,0),(7,1,'Financial planning and budgeting tool','FPABT','Qui rem tempora inventore fuga qui numquam corrupti. Ut nam officiis eos blanditiis dolor corrupti. At nobis eos est ut molestiae harum voluptate pariatur. Quae voluptatum culpa dolor et quod.',NULL,'2023-02-06','2023-06-06','Debitis distinctio et aspernatur nisi ab non dolore quasi. Adipisci minima et quae temporibus eos est qui. Et quam molestias voluptate sed autem sint ea. Aut sequi qui distinctio praesentium.',5,6,NULL,'Pigeon; \'but I haven\'t had a VERY good opportunity for croqueting one of the crowd below, and there stood the Queen till she had not gone (We know it was getting quite crowded with the end of his.','disable','disable','disable',48,'false',NULL,1,NULL,'in progress',1,NULL,'20249a9a7d4c5d254897af5c12998444',0,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL,0,NULL,0),(8,1,'Project management and team collaboration tool','PMATCT','Adipisci veniam quod voluptates voluptatum quos quos dolor quia. Natus culpa animi consequatur non labore eos molestiae. Quae in id architecto distinctio nam. Excepturi harum quo et.',NULL,'2023-02-06','2023-06-06','Incidunt pariatur esse vero omnis tempora et. Omnis et praesentium rerum aliquid illo. Dolorem ut hic dicta repudiandae perspiciatis tempora.',3,13,NULL,'Alice)--\'and perhaps you haven\'t found it very much,\' said Alice; \'I daresay it\'s a French mouse, come over with fright. \'Oh, I know!\' exclaimed Alice, who always took a minute or two sobs choked.','disable','disable','disable',74,'false',NULL,1,NULL,'in progress',1,NULL,'c5bf9c7ad19ef4f17ae15c64576e1db8',0,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL,0,NULL,0),(9,1,'Artificial intelligence (AI) and machine learning (ML) development service','AI(AML(DS','Illo reiciendis earum in dolorem perspiciatis. Quia voluptatibus aut accusantium quod et. Incidunt id nemo iste fuga.',NULL,'2023-02-06','2023-06-06','Qui incidunt in iusto sint fuga et omnis. Tempore laudantium aut et fugit.',5,10,NULL,'Alice said; but was dreadfully puzzled by the officers of the window, I only knew how to begin.\' For, you see, so many tea-things are put out here?\' she asked. \'Yes, that\'s it,\' said Five, \'and I\'ll.','disable','disable','disable',83,'false',NULL,1,NULL,'in progress',1,NULL,'7828617ed0dd2a1f978535a13b8f849f',0,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL,0,NULL,0),(10,1,'Weather forecasting system','WFS','Minus iste et reprehenderit excepturi. Rerum blanditiis perferendis eos nam itaque quae. Aspernatur porro qui repellat sed commodi expedita ipsa provident. Voluptas est eos id animi quidem consequatur neque.',NULL,'2022-10-06','2023-02-06','Quis beatae ut mollitia. Omnis sint velit quod incidunt deserunt.',3,7,NULL,'She said it to be a lesson to you to learn?\' \'Well, there was the first verse,\' said the Duchess, as she couldn\'t answer either question, it didn\'t much matter which way she put one arm out of that.','disable','disable','disable',81,'false',NULL,1,NULL,'in progress',1,NULL,'3e1acb377239a0f32e5b44764c4add9f',0,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL,0,NULL,0);
/*!40000 ALTER TABLE `projects` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `proposal_item_images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `proposal_item_images` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `proposal_item_id` int unsigned NOT NULL,
  `filename` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `hashname` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `proposal_item_images_proposal_item_id_foreign` (`proposal_item_id`),
  CONSTRAINT `proposal_item_images_proposal_item_id_foreign` FOREIGN KEY (`proposal_item_id`) REFERENCES `proposal_items` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `proposal_item_images` WRITE;
/*!40000 ALTER TABLE `proposal_item_images` DISABLE KEYS */;
/*!40000 ALTER TABLE `proposal_item_images` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `proposal_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `proposal_items` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `proposal_id` int unsigned NOT NULL,
  `item_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` enum('item','discount','tax') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'item',
  `quantity` double(16,2) NOT NULL,
  `unit_price` double(16,2) NOT NULL,
  `amount` double(16,2) NOT NULL,
  `item_summary` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `taxes` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hsn_sac_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `proposal_items_proposal_id_foreign` (`proposal_id`),
  CONSTRAINT `proposal_items_proposal_id_foreign` FOREIGN KEY (`proposal_id`) REFERENCES `proposals` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `proposal_items` WRITE;
/*!40000 ALTER TABLE `proposal_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `proposal_items` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `proposal_signs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `proposal_signs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `proposal_id` int unsigned NOT NULL,
  `full_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `signature` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `proposal_signs_proposal_id_foreign` (`proposal_id`),
  CONSTRAINT `proposal_signs_proposal_id_foreign` FOREIGN KEY (`proposal_id`) REFERENCES `proposals` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `proposal_signs` WRITE;
/*!40000 ALTER TABLE `proposal_signs` DISABLE KEYS */;
/*!40000 ALTER TABLE `proposal_signs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `proposal_template_item_images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `proposal_template_item_images` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `proposal_template_item_id` int unsigned NOT NULL,
  `filename` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `hashname` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `proposal_template_item_images_company_id_foreign` (`company_id`),
  KEY `proposal_template_item_images_proposal_template_item_id_foreign` (`proposal_template_item_id`),
  CONSTRAINT `proposal_template_item_images_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `proposal_template_item_images_proposal_template_item_id_foreign` FOREIGN KEY (`proposal_template_item_id`) REFERENCES `proposal_template_items` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `proposal_template_item_images` WRITE;
/*!40000 ALTER TABLE `proposal_template_item_images` DISABLE KEYS */;
/*!40000 ALTER TABLE `proposal_template_item_images` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `proposal_template_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `proposal_template_items` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `proposal_template_id` bigint unsigned NOT NULL,
  `hsn_sac_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` enum('item','discount','tax') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'item',
  `quantity` tinyint NOT NULL,
  `unit_price` double NOT NULL,
  `amount` double NOT NULL,
  `item_summary` text COLLATE utf8mb4_unicode_ci,
  `taxes` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `proposal_template_items_company_id_foreign` (`company_id`),
  KEY `proposal_template_items_proposal_template_id_foreign` (`proposal_template_id`),
  CONSTRAINT `proposal_template_items_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `proposal_template_items_proposal_template_id_foreign` FOREIGN KEY (`proposal_template_id`) REFERENCES `proposal_templates` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `proposal_template_items` WRITE;
/*!40000 ALTER TABLE `proposal_template_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `proposal_template_items` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `proposal_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `proposal_templates` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sub_total` double NOT NULL,
  `total` double NOT NULL,
  `currency_id` int unsigned DEFAULT NULL,
  `discount_type` enum('percent','fixed') COLLATE utf8mb4_unicode_ci NOT NULL,
  `discount` double NOT NULL,
  `invoice_convert` tinyint(1) NOT NULL DEFAULT '0',
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `client_comment` text COLLATE utf8mb4_unicode_ci,
  `signature_approval` tinyint(1) NOT NULL DEFAULT '1',
  `hash` text COLLATE utf8mb4_unicode_ci,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `unit_id` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `proposal_templates_company_id_foreign` (`company_id`),
  KEY `proposal_templates_added_by_foreign` (`added_by`),
  KEY `proposal_templates_last_updated_by_foreign` (`last_updated_by`),
  KEY `proposal_templates_currency_id_foreign` (`currency_id`),
  KEY `proposal_templates_unit_id_foreign` (`unit_id`),
  CONSTRAINT `proposal_templates_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `proposal_templates_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `proposal_templates_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `proposal_templates_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `proposal_templates_unit_id_foreign` FOREIGN KEY (`unit_id`) REFERENCES `unit_types` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `proposal_templates` WRITE;
/*!40000 ALTER TABLE `proposal_templates` DISABLE KEYS */;
/*!40000 ALTER TABLE `proposal_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `proposals`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `proposals` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `lead_id` int unsigned NOT NULL,
  `valid_till` date NOT NULL,
  `sub_total` double(16,2) NOT NULL,
  `total` double(16,2) NOT NULL,
  `currency_id` int unsigned DEFAULT NULL,
  `discount_type` enum('percent','fixed') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `discount` double NOT NULL,
  `invoice_convert` tinyint(1) NOT NULL DEFAULT '0',
  `status` enum('declined','accepted','waiting') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'waiting',
  `note` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `client_comment` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `signature_approval` tinyint(1) NOT NULL DEFAULT '1',
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `hash` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `calculate_tax` enum('after_discount','before_discount') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'after_discount',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `last_viewed` timestamp NULL DEFAULT NULL,
  `ip_address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `unit_id` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `proposals_company_id_foreign` (`company_id`),
  KEY `proposals_lead_id_foreign` (`lead_id`),
  KEY `proposals_currency_id_foreign` (`currency_id`),
  KEY `proposals_added_by_foreign` (`added_by`),
  KEY `proposals_last_updated_by_foreign` (`last_updated_by`),
  KEY `proposals_unit_id_foreign` (`unit_id`),
  CONSTRAINT `proposals_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `proposals_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `proposals_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `proposals_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `proposals_lead_id_foreign` FOREIGN KEY (`lead_id`) REFERENCES `leads` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `proposals_unit_id_foreign` FOREIGN KEY (`unit_id`) REFERENCES `unit_types` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `proposals` WRITE;
/*!40000 ALTER TABLE `proposals` DISABLE KEYS */;
/*!40000 ALTER TABLE `proposals` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `purpose_consent`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purpose_consent` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `purpose_consent` WRITE;
/*!40000 ALTER TABLE `purpose_consent` DISABLE KEYS */;
/*!40000 ALTER TABLE `purpose_consent` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `purpose_consent_leads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purpose_consent_leads` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `lead_id` int unsigned NOT NULL,
  `purpose_consent_id` int unsigned NOT NULL,
  `status` enum('agree','disagree') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'agree',
  `ip` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `updated_by_id` int unsigned DEFAULT NULL,
  `additional_description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `purpose_consent_leads_lead_id_foreign` (`lead_id`),
  KEY `purpose_consent_leads_purpose_consent_id_foreign` (`purpose_consent_id`),
  KEY `purpose_consent_leads_updated_by_id_foreign` (`updated_by_id`),
  CONSTRAINT `purpose_consent_leads_lead_id_foreign` FOREIGN KEY (`lead_id`) REFERENCES `leads` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `purpose_consent_leads_purpose_consent_id_foreign` FOREIGN KEY (`purpose_consent_id`) REFERENCES `purpose_consent` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `purpose_consent_leads_updated_by_id_foreign` FOREIGN KEY (`updated_by_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `purpose_consent_leads` WRITE;
/*!40000 ALTER TABLE `purpose_consent_leads` DISABLE KEYS */;
/*!40000 ALTER TABLE `purpose_consent_leads` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `purpose_consent_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purpose_consent_users` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `client_id` int unsigned NOT NULL,
  `purpose_consent_id` int unsigned NOT NULL,
  `status` enum('agree','disagree') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'agree',
  `ip` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `updated_by_id` int unsigned NOT NULL,
  `additional_description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `purpose_consent_users_client_id_foreign` (`client_id`),
  KEY `purpose_consent_users_purpose_consent_id_foreign` (`purpose_consent_id`),
  KEY `purpose_consent_users_updated_by_id_foreign` (`updated_by_id`),
  CONSTRAINT `purpose_consent_users_client_id_foreign` FOREIGN KEY (`client_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `purpose_consent_users_purpose_consent_id_foreign` FOREIGN KEY (`purpose_consent_id`) REFERENCES `purpose_consent` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `purpose_consent_users_updated_by_id_foreign` FOREIGN KEY (`updated_by_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `purpose_consent_users` WRITE;
/*!40000 ALTER TABLE `purpose_consent_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `purpose_consent_users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `push_notification_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `push_notification_settings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `onesignal_app_id` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `onesignal_rest_api_key` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `notification_logo` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` enum('active','inactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'inactive',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `push_notification_settings` WRITE;
/*!40000 ALTER TABLE `push_notification_settings` DISABLE KEYS */;
INSERT INTO `push_notification_settings` VALUES (1,NULL,NULL,NULL,'inactive','2023-04-06 06:33:16','2023-04-06 06:33:16');
/*!40000 ALTER TABLE `push_notification_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `push_subscriptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `push_subscriptions` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `endpoint` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `public_key` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `auth_token` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `push_subscriptions_endpoint_company_id_unique` (`endpoint`,`company_id`),
  KEY `push_subscriptions_company_id_foreign` (`company_id`),
  KEY `push_subscriptions_user_id_index` (`user_id`),
  CONSTRAINT `push_subscriptions_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `push_subscriptions_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `push_subscriptions` WRITE;
/*!40000 ALTER TABLE `push_subscriptions` DISABLE KEYS */;
/*!40000 ALTER TABLE `push_subscriptions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pusher_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pusher_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `pusher_app_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pusher_app_key` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pusher_app_secret` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pusher_cluster` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `force_tls` tinyint(1) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `taskboard` tinyint(1) NOT NULL DEFAULT '1',
  `messages` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pusher_settings` WRITE;
/*!40000 ALTER TABLE `pusher_settings` DISABLE KEYS */;
INSERT INTO `pusher_settings` VALUES (1,NULL,NULL,NULL,NULL,0,0,1,0,'2023-04-06 06:33:16','2023-04-06 06:33:16');
/*!40000 ALTER TABLE `pusher_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `quick_books_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `quick_books_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `sandbox_client_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sandbox_client_secret` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_secret` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `access_token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `refresh_token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `realmid` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sync_type` enum('one_way','two_way') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'one_way',
  `environment` enum('Development','Production') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Production',
  `status` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `quick_books_settings_company_id_foreign` (`company_id`),
  CONSTRAINT `quick_books_settings_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `quick_books_settings` WRITE;
/*!40000 ALTER TABLE `quick_books_settings` DISABLE KEYS */;
INSERT INTO `quick_books_settings` VALUES (1,1,'','','','','','','','one_way','Production',0,'2023-04-06 06:33:16','2023-04-06 06:33:16');
/*!40000 ALTER TABLE `quick_books_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `quotation_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotation_items` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `quotation_id` int unsigned NOT NULL,
  `item_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `quantity` int NOT NULL,
  `unit_price` int NOT NULL,
  `amount` double(8,2) NOT NULL,
  `hsn_sac_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `quotation_items_quotation_id_foreign` (`quotation_id`),
  CONSTRAINT `quotation_items_quotation_id_foreign` FOREIGN KEY (`quotation_id`) REFERENCES `quotations` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `quotation_items` WRITE;
/*!40000 ALTER TABLE `quotation_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `quotation_items` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `quotations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `business_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `sub_total` double(8,2) NOT NULL,
  `total` double(8,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `quotations_company_id_foreign` (`company_id`),
  CONSTRAINT `quotations_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `quotations` WRITE;
/*!40000 ALTER TABLE `quotations` DISABLE KEYS */;
/*!40000 ALTER TABLE `quotations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `recruit_applicant_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `recruit_applicant_notes` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL,
  `recruit_job_application_id` int unsigned NOT NULL,
  `note_text` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `recruit_applicant_notes_user_id_foreign` (`user_id`),
  KEY `recruit_applicant_notes_recruit_job_application_id_foreign` (`recruit_job_application_id`),
  CONSTRAINT `recruit_applicant_notes_recruit_job_application_id_foreign` FOREIGN KEY (`recruit_job_application_id`) REFERENCES `recruit_job_applications` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `recruit_applicant_notes_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `recruit_applicant_notes` WRITE;
/*!40000 ALTER TABLE `recruit_applicant_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `recruit_applicant_notes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `recruit_application_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `recruit_application_files` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `recruit_job_application_id` int unsigned NOT NULL,
  `filename` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `hashname` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `recruit_application_files_added_by_foreign` (`added_by`),
  KEY `recruit_application_files_last_updated_by_foreign` (`last_updated_by`),
  KEY `recruit_application_files_recruit_job_application_id_foreign` (`recruit_job_application_id`),
  CONSTRAINT `recruit_application_files_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `recruit_application_files_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `recruit_application_files_recruit_job_application_id_foreign` FOREIGN KEY (`recruit_job_application_id`) REFERENCES `recruit_job_applications` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `recruit_application_files` WRITE;
/*!40000 ALTER TABLE `recruit_application_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `recruit_application_files` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `recruit_application_skills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `recruit_application_skills` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `recruit_job_application_id` int unsigned NOT NULL,
  `recruit_skill_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `recruit_application_skills_recruit_job_application_id_foreign` (`recruit_job_application_id`),
  KEY `recruit_application_skills_recruit_skill_id_foreign` (`recruit_skill_id`),
  CONSTRAINT `recruit_application_skills_recruit_job_application_id_foreign` FOREIGN KEY (`recruit_job_application_id`) REFERENCES `recruit_job_applications` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `recruit_application_skills_recruit_skill_id_foreign` FOREIGN KEY (`recruit_skill_id`) REFERENCES `recruit_skills` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `recruit_application_skills` WRITE;
/*!40000 ALTER TABLE `recruit_application_skills` DISABLE KEYS */;
/*!40000 ALTER TABLE `recruit_application_skills` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `recruit_application_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `recruit_application_status` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `position` int NOT NULL,
  `recruit_application_status_category_id` bigint unsigned DEFAULT NULL,
  `action` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ras_recruit_application_status_category_id_foreign` (`recruit_application_status_category_id`),
  KEY `recruit_application_status_company_id_foreign` (`company_id`),
  CONSTRAINT `ras_recruit_application_status_category_id_foreign` FOREIGN KEY (`recruit_application_status_category_id`) REFERENCES `recruit_application_status_categories` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `recruit_application_status_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `recruit_application_status` WRITE;
/*!40000 ALTER TABLE `recruit_application_status` DISABLE KEYS */;
INSERT INTO `recruit_application_status` VALUES (1,1,'applied','applied','#2b2b2b',1,1,'yes','2023-04-06 06:33:16','2023-04-06 06:33:16'),(2,1,'phone screen','phone_screen','#f1e52e',2,2,'yes','2023-04-06 06:33:16','2023-04-06 06:33:16'),(3,1,'interview','interview','#3d8ee8',3,3,'yes','2023-04-06 06:33:16','2023-04-06 06:33:16'),(4,1,'hired','hired','#32ac16',4,4,'yes','2023-04-06 06:33:16','2023-04-06 06:33:16'),(5,1,'rejected','rejected','#ee1127',5,5,'no','2023-04-06 06:33:16','2023-04-06 06:33:16');
/*!40000 ALTER TABLE `recruit_application_status` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `recruit_application_status_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `recruit_application_status_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `recruit_application_status_categories_company_id_foreign` (`company_id`),
  CONSTRAINT `recruit_application_status_categories_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `recruit_application_status_categories` WRITE;
/*!40000 ALTER TABLE `recruit_application_status_categories` DISABLE KEYS */;
INSERT INTO `recruit_application_status_categories` VALUES (1,1,'applied','2023-04-06 06:33:16','2023-04-06 06:33:16'),(2,1,'shortlist','2023-04-06 06:33:16','2023-04-06 06:33:16'),(3,1,'interview','2023-04-06 06:33:16','2023-04-06 06:33:16'),(4,1,'hired','2023-04-06 06:33:16','2023-04-06 06:33:16'),(5,1,'rejected','2023-04-06 06:33:16','2023-04-06 06:33:16'),(6,1,'others','2023-04-06 06:33:16','2023-04-06 06:33:16');
/*!40000 ALTER TABLE `recruit_application_status_categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `recruit_candidate_database`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `recruit_candidate_database` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `recruit_job_id` bigint unsigned NOT NULL,
  `location_id` bigint unsigned NOT NULL,
  `Job_applied_on` date NOT NULL,
  `skills` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `job_application_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `recruit_candidate_database_company_id_foreign` (`company_id`),
  CONSTRAINT `recruit_candidate_database_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `recruit_candidate_database` WRITE;
/*!40000 ALTER TABLE `recruit_candidate_database` DISABLE KEYS */;
/*!40000 ALTER TABLE `recruit_candidate_database` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `recruit_candidate_follow_ups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `recruit_candidate_follow_ups` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `recruit_job_application_id` int unsigned DEFAULT NULL,
  `remark` longtext COLLATE utf8mb4_unicode_ci,
  `next_follow_up_date` datetime DEFAULT NULL,
  `send_reminder` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `remind_time` text COLLATE utf8mb4_unicode_ci,
  `remind_type` enum('minute','hour','day') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'incomplete',
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `recruit_candidate_follow_ups_recruit_job_application_id_foreign` (`recruit_job_application_id`),
  KEY `recruit_candidate_follow_ups_added_by_foreign` (`added_by`),
  KEY `recruit_candidate_follow_ups_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `recruit_candidate_follow_ups_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `recruit_candidate_follow_ups_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `recruit_candidate_follow_ups_recruit_job_application_id_foreign` FOREIGN KEY (`recruit_job_application_id`) REFERENCES `recruit_job_applications` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `recruit_candidate_follow_ups` WRITE;
/*!40000 ALTER TABLE `recruit_candidate_follow_ups` DISABLE KEYS */;
/*!40000 ALTER TABLE `recruit_candidate_follow_ups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `recruit_custom_questions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `recruit_custom_questions` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `category` enum('job_application','job_offer') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'job_application',
  `question` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` enum('enable','disable') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'disable',
  `type` enum('text','number','password','textarea','select','radio','date','checkbox','file') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'text',
  `required` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `values` varchar(5000) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `column_priority` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `recruit_custom_questions_company_id_foreign` (`company_id`),
  CONSTRAINT `recruit_custom_questions_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `recruit_custom_questions` WRITE;
/*!40000 ALTER TABLE `recruit_custom_questions` DISABLE KEYS */;
/*!40000 ALTER TABLE `recruit_custom_questions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `recruit_email_notification_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `recruit_email_notification_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `setting_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `send_email` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `recruit_email_notification_settings_company_id_foreign` (`company_id`),
  CONSTRAINT `recruit_email_notification_settings_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `recruit_email_notification_settings` WRITE;
/*!40000 ALTER TABLE `recruit_email_notification_settings` DISABLE KEYS */;
INSERT INTO `recruit_email_notification_settings` VALUES (1,1,'New Job/Added by Admin','yes','new-jobadded-by-admin','2023-04-06 06:33:16','2023-04-06 06:33:16'),(2,1,'New Job Application/Added by Admin','yes','new-job-applicationadded-by-admin','2023-04-06 06:33:16','2023-04-06 06:33:16'),(3,1,'New Interview Schedule/Added by Admin','yes','new-interview-scheduleadded-by-admin','2023-04-06 06:33:16','2023-04-06 06:33:16'),(4,1,'New Offer Letter/Added by Admin','yes','new-offer-letteradded-by-admin','2023-04-06 06:33:16','2023-04-06 06:33:16'),(5,1,'Notification to Recruiter','yes','notification-to-recruiter','2023-04-06 06:33:16','2023-04-06 06:33:16');
/*!40000 ALTER TABLE `recruit_email_notification_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `recruit_footer_links`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `recruit_footer_links` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `recruit_footer_links_company_id_foreign` (`company_id`),
  CONSTRAINT `recruit_footer_links_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `recruit_footer_links` WRITE;
/*!40000 ALTER TABLE `recruit_footer_links` DISABLE KEYS */;
/*!40000 ALTER TABLE `recruit_footer_links` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `recruit_global_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `recruit_global_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `purchase_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `license_type` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `supported_until` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `recruit_global_settings` WRITE;
/*!40000 ALTER TABLE `recruit_global_settings` DISABLE KEYS */;
INSERT INTO `recruit_global_settings` VALUES (1,NULL,NULL,NULL,'2023-04-06 06:33:08','2023-04-06 06:33:08');
/*!40000 ALTER TABLE `recruit_global_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `recruit_interview_comments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `recruit_interview_comments` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `recruit_interview_schedule_id` int unsigned NOT NULL,
  `user_id` int unsigned NOT NULL,
  `comment` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `recruit_interview_comments_user_id_foreign` (`user_id`),
  KEY `recruit_interview_comments_recruit_interview_schedule_id_foreign` (`recruit_interview_schedule_id`),
  CONSTRAINT `recruit_interview_comments_recruit_interview_schedule_id_foreign` FOREIGN KEY (`recruit_interview_schedule_id`) REFERENCES `recruit_interview_schedules` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `recruit_interview_comments_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `recruit_interview_comments` WRITE;
/*!40000 ALTER TABLE `recruit_interview_comments` DISABLE KEYS */;
/*!40000 ALTER TABLE `recruit_interview_comments` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `recruit_interview_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `recruit_interview_employees` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `recruit_interview_schedule_id` int unsigned NOT NULL,
  `user_id` int unsigned NOT NULL,
  `user_accept_status` enum('accept','refuse','waiting') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'waiting',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `recruit_interview_employees_user_id_foreign` (`user_id`),
  KEY `rie_recruit_interview_schedule_id_foreign` (`recruit_interview_schedule_id`),
  CONSTRAINT `recruit_interview_employees_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `rie_recruit_interview_schedule_id_foreign` FOREIGN KEY (`recruit_interview_schedule_id`) REFERENCES `recruit_interview_schedules` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `recruit_interview_employees` WRITE;
/*!40000 ALTER TABLE `recruit_interview_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `recruit_interview_employees` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `recruit_interview_evaluations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `recruit_interview_evaluations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `recruit_recommendation_status_id` int unsigned DEFAULT NULL,
  `recruit_interview_schedule_id` int unsigned DEFAULT NULL,
  `recruit_interview_stage_id` int unsigned DEFAULT NULL,
  `recruit_job_application_id` int unsigned DEFAULT NULL,
  `submitted_by` int unsigned DEFAULT NULL,
  `details` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `recruit_interview_evaluations_submitted_by_foreign` (`submitted_by`),
  KEY `rie_recruit_recommendation_status_id_foreign` (`recruit_recommendation_status_id`),
  KEY `riev_recruit_interview_schedule_id_foreign` (`recruit_interview_schedule_id`),
  KEY `rie_recruit_interview_stage_id_foreign` (`recruit_interview_stage_id`),
  KEY `rie_recruit_job_application_id_foreign` (`recruit_job_application_id`),
  KEY `recruit_interview_evaluations_company_id_foreign` (`company_id`),
  CONSTRAINT `recruit_interview_evaluations_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `recruit_interview_evaluations_submitted_by_foreign` FOREIGN KEY (`submitted_by`) REFERENCES `users` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `rie_recruit_interview_stage_id_foreign` FOREIGN KEY (`recruit_interview_stage_id`) REFERENCES `recruit_interview_stages` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `rie_recruit_job_application_id_foreign` FOREIGN KEY (`recruit_job_application_id`) REFERENCES `recruit_job_applications` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `rie_recruit_recommendation_status_id_foreign` FOREIGN KEY (`recruit_recommendation_status_id`) REFERENCES `recruit_recommendation_statuses` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `riev_recruit_interview_schedule_id_foreign` FOREIGN KEY (`recruit_interview_schedule_id`) REFERENCES `recruit_interview_schedules` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `recruit_interview_evaluations` WRITE;
/*!40000 ALTER TABLE `recruit_interview_evaluations` DISABLE KEYS */;
/*!40000 ALTER TABLE `recruit_interview_evaluations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `recruit_interview_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `recruit_interview_files` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL,
  `recruit_interview_schedule_id` int unsigned NOT NULL,
  `filename` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `google_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hashname` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dropbox_link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `recruit_interview_files_user_id_foreign` (`user_id`),
  KEY `recruit_interview_files_added_by_foreign` (`added_by`),
  KEY `recruit_interview_files_last_updated_by_foreign` (`last_updated_by`),
  KEY `rif_recruit_interview_schedule_id_foreign` (`recruit_interview_schedule_id`),
  CONSTRAINT `recruit_interview_files_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `recruit_interview_files_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `recruit_interview_files_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `rif_recruit_interview_schedule_id_foreign` FOREIGN KEY (`recruit_interview_schedule_id`) REFERENCES `recruit_interview_schedules` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `recruit_interview_files` WRITE;
/*!40000 ALTER TABLE `recruit_interview_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `recruit_interview_files` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `recruit_interview_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `recruit_interview_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `recruit_interview_schedule_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `recruit_interview_file_id` int unsigned DEFAULT NULL,
  `details` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `recruit_interview_histories_user_id_foreign` (`user_id`),
  KEY `rih_recruit_interview_schedule_id_foreign` (`recruit_interview_schedule_id`),
  KEY `recruit_interview_histories_recruit_interview_file_id_foreign` (`recruit_interview_file_id`),
  CONSTRAINT `recruit_interview_histories_recruit_interview_file_id_foreign` FOREIGN KEY (`recruit_interview_file_id`) REFERENCES `recruit_interview_files` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `recruit_interview_histories_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `rih_recruit_interview_schedule_id_foreign` FOREIGN KEY (`recruit_interview_schedule_id`) REFERENCES `recruit_interview_schedules` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `recruit_interview_histories` WRITE;
/*!40000 ALTER TABLE `recruit_interview_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `recruit_interview_histories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `recruit_interview_schedules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `recruit_interview_schedules` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `recruit_job_application_id` int unsigned NOT NULL,
  `interview_type` enum('in person','video','phone') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'in person',
  `schedule_date` datetime DEFAULT NULL,
  `status` enum('rejected','hired','pending','canceled','completed') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `user_accept_status` enum('accept','refuse','waiting') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'waiting',
  `meeting_id` int DEFAULT NULL,
  `video_type` enum('zoom','other') COLLATE utf8mb4_unicode_ci DEFAULT 'other',
  `remind_type_all` enum('day','hour','minute') COLLATE utf8mb4_unicode_ci NOT NULL,
  `notify_c` tinyint(1) NOT NULL DEFAULT '0',
  `remind_time_all` int DEFAULT NULL,
  `send_reminder_all` tinyint(1) NOT NULL DEFAULT '0',
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `other_link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remarks` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `recruit_interview_stage_id` int unsigned DEFAULT NULL,
  `parent_id` int unsigned DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `recruit_interview_schedules_parent_id_foreign` (`parent_id`),
  KEY `recruit_interview_schedules_added_by_foreign` (`added_by`),
  KEY `recruit_interview_schedules_last_updated_by_foreign` (`last_updated_by`),
  KEY `recruit_interview_schedules_recruit_job_application_id_foreign` (`recruit_job_application_id`),
  KEY `recruit_interview_schedules_recruit_interview_stage_id_foreign` (`recruit_interview_stage_id`),
  KEY `recruit_interview_schedules_company_id_foreign` (`company_id`),
  CONSTRAINT `recruit_interview_schedules_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `recruit_interview_schedules_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `recruit_interview_schedules_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `recruit_interview_schedules_parent_id_foreign` FOREIGN KEY (`parent_id`) REFERENCES `recruit_interview_schedules` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `recruit_interview_schedules_recruit_interview_stage_id_foreign` FOREIGN KEY (`recruit_interview_stage_id`) REFERENCES `recruit_interview_stages` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `recruit_interview_schedules_recruit_job_application_id_foreign` FOREIGN KEY (`recruit_job_application_id`) REFERENCES `recruit_job_applications` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `recruit_interview_schedules` WRITE;
/*!40000 ALTER TABLE `recruit_interview_schedules` DISABLE KEYS */;
/*!40000 ALTER TABLE `recruit_interview_schedules` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `recruit_interview_stages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `recruit_interview_stages` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `recruit_interview_stages_company_id_foreign` (`company_id`),
  CONSTRAINT `recruit_interview_stages_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `recruit_interview_stages` WRITE;
/*!40000 ALTER TABLE `recruit_interview_stages` DISABLE KEYS */;
INSERT INTO `recruit_interview_stages` VALUES (1,1,'HR round','2023-04-06 06:33:16','2023-04-06 06:33:16'),(2,1,'Technical round','2023-04-06 06:33:16','2023-04-06 06:33:16'),(3,1,'Manager round','2023-04-06 06:33:16','2023-04-06 06:33:16');
/*!40000 ALTER TABLE `recruit_interview_stages` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `recruit_job_addresses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `recruit_job_addresses` (
  `recruit_job_id` bigint unsigned NOT NULL,
  `company_address_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  KEY `recruit_job_addresses_recruit_job_id_foreign` (`recruit_job_id`),
  KEY `recruit_job_addresses_company_address_id_foreign` (`company_address_id`),
  CONSTRAINT `recruit_job_addresses_company_address_id_foreign` FOREIGN KEY (`company_address_id`) REFERENCES `company_addresses` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `recruit_job_addresses_recruit_job_id_foreign` FOREIGN KEY (`recruit_job_id`) REFERENCES `recruit_jobs` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `recruit_job_addresses` WRITE;
/*!40000 ALTER TABLE `recruit_job_addresses` DISABLE KEYS */;
/*!40000 ALTER TABLE `recruit_job_addresses` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `recruit_job_alerts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `recruit_job_alerts` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `recruit_work_experience_id` bigint unsigned DEFAULT NULL,
  `recruit_job_type_id` bigint unsigned DEFAULT NULL,
  `recruit_job_category_id` int unsigned NOT NULL,
  `location_id` bigint unsigned DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `hashname` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `recruit_job_alerts_company_id_foreign` (`company_id`),
  KEY `recruit_job_alerts_recruit_work_experience_id_foreign` (`recruit_work_experience_id`),
  KEY `recruit_job_alerts_recruit_job_type_id_foreign` (`recruit_job_type_id`),
  KEY `recruit_job_alerts_recruit_job_category_id_foreign` (`recruit_job_category_id`),
  KEY `recruit_job_alerts_location_id_foreign` (`location_id`),
  CONSTRAINT `recruit_job_alerts_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `recruit_job_alerts_location_id_foreign` FOREIGN KEY (`location_id`) REFERENCES `company_addresses` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `recruit_job_alerts_recruit_job_category_id_foreign` FOREIGN KEY (`recruit_job_category_id`) REFERENCES `recruit_job_categories` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `recruit_job_alerts_recruit_job_type_id_foreign` FOREIGN KEY (`recruit_job_type_id`) REFERENCES `recruit_job_types` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `recruit_job_alerts_recruit_work_experience_id_foreign` FOREIGN KEY (`recruit_work_experience_id`) REFERENCES `recruit_work_experiences` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `recruit_job_alerts` WRITE;
/*!40000 ALTER TABLE `recruit_job_alerts` DISABLE KEYS */;
/*!40000 ALTER TABLE `recruit_job_alerts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `recruit_job_applications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `recruit_job_applications` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `full_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_of_birth` date DEFAULT NULL,
  `gender` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_experience` enum('fresher','0-1','1-2','2-3','3-4','4-5','5-6','6-7','7-8','8-9','9-10','10-11','11-12','12-13','13-14','over-15') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `current_location` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `current_ctc` double DEFAULT NULL,
  `currenct_ctc_rate` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `expected_ctc` double DEFAULT NULL,
  `expected_ctc_rate` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `notice_period` enum('15','30','45','60','75','90','over-90') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `photo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `resume` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `column_priority` int DEFAULT NULL,
  `remark` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rejection_remark` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cover_letter` mediumtext COLLATE utf8mb4_unicode_ci,
  `job_type` enum('part time','full time','internship') COLLATE utf8mb4_unicode_ci DEFAULT 'full time',
  `recruit_job_id` bigint unsigned NOT NULL,
  `recruit_application_status_id` int unsigned DEFAULT NULL,
  `location_id` bigint unsigned NOT NULL,
  `application_sources` enum('careerWebsite','addedByUser') COLLATE utf8mb4_unicode_ci NOT NULL,
  `application_source_id` int unsigned DEFAULT NULL,
  `recruit_job_file_id` int unsigned DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `recruit_job_applications_location_id_foreign` (`location_id`),
  KEY `recruit_job_applications_added_by_foreign` (`added_by`),
  KEY `recruit_job_applications_last_updated_by_foreign` (`last_updated_by`),
  KEY `recruit_job_applications_recruit_job_id_foreign` (`recruit_job_id`),
  KEY `recruit_job_applications_recruit_application_status_id_foreign` (`recruit_application_status_id`),
  KEY `recruit_job_applications_application_source_id_foreign` (`application_source_id`),
  KEY `recruit_job_applications_recruit_job_file_id_foreign` (`recruit_job_file_id`),
  KEY `recruit_job_applications_company_id_foreign` (`company_id`),
  CONSTRAINT `recruit_job_applications_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `recruit_job_applications_application_source_id_foreign` FOREIGN KEY (`application_source_id`) REFERENCES `application_sources` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `recruit_job_applications_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `recruit_job_applications_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `recruit_job_applications_location_id_foreign` FOREIGN KEY (`location_id`) REFERENCES `company_addresses` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `recruit_job_applications_recruit_application_status_id_foreign` FOREIGN KEY (`recruit_application_status_id`) REFERENCES `recruit_application_status` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `recruit_job_applications_recruit_job_file_id_foreign` FOREIGN KEY (`recruit_job_file_id`) REFERENCES `recruit_job_files` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `recruit_job_applications_recruit_job_id_foreign` FOREIGN KEY (`recruit_job_id`) REFERENCES `recruit_jobs` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `recruit_job_applications` WRITE;
/*!40000 ALTER TABLE `recruit_job_applications` DISABLE KEYS */;
/*!40000 ALTER TABLE `recruit_job_applications` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `recruit_job_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `recruit_job_categories` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `category_name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `recruit_job_categories_company_id_foreign` (`company_id`),
  CONSTRAINT `recruit_job_categories_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `recruit_job_categories` WRITE;
/*!40000 ALTER TABLE `recruit_job_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `recruit_job_categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `recruit_job_custom_answers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `recruit_job_custom_answers` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `recruit_job_offer_letter_id` int unsigned DEFAULT NULL,
  `recruit_job_application_id` int unsigned DEFAULT NULL,
  `recruit_job_id` bigint unsigned NOT NULL,
  `recruit_job_question_id` int unsigned NOT NULL,
  `answer` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `filename` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `hashname` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `recruit_job_custom_answers_recruit_job_offer_letter_id_foreign` (`recruit_job_offer_letter_id`),
  KEY `recruit_job_custom_answers_recruit_job_application_id_foreign` (`recruit_job_application_id`),
  KEY `recruit_job_custom_answers_recruit_job_id_foreign` (`recruit_job_id`),
  KEY `recruit_job_custom_answers_recruit_job_question_id_foreign` (`recruit_job_question_id`),
  CONSTRAINT `recruit_job_custom_answers_recruit_job_application_id_foreign` FOREIGN KEY (`recruit_job_application_id`) REFERENCES `recruit_job_applications` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `recruit_job_custom_answers_recruit_job_id_foreign` FOREIGN KEY (`recruit_job_id`) REFERENCES `recruit_jobs` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `recruit_job_custom_answers_recruit_job_offer_letter_id_foreign` FOREIGN KEY (`recruit_job_offer_letter_id`) REFERENCES `recruit_job_offer_letter` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `recruit_job_custom_answers_recruit_job_question_id_foreign` FOREIGN KEY (`recruit_job_question_id`) REFERENCES `recruit_custom_questions` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `recruit_job_custom_answers` WRITE;
/*!40000 ALTER TABLE `recruit_job_custom_answers` DISABLE KEYS */;
/*!40000 ALTER TABLE `recruit_job_custom_answers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `recruit_job_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `recruit_job_files` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL,
  `recruit_job_id` bigint unsigned NOT NULL,
  `filename` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `google_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hashname` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dropbox_link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `recruit_job_files_user_id_foreign` (`user_id`),
  KEY `recruit_job_files_added_by_foreign` (`added_by`),
  KEY `recruit_job_files_last_updated_by_foreign` (`last_updated_by`),
  KEY `recruit_job_files_recruit_job_id_foreign` (`recruit_job_id`),
  CONSTRAINT `recruit_job_files_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `recruit_job_files_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `recruit_job_files_recruit_job_id_foreign` FOREIGN KEY (`recruit_job_id`) REFERENCES `recruit_jobs` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `recruit_job_files_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `recruit_job_files` WRITE;
/*!40000 ALTER TABLE `recruit_job_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `recruit_job_files` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `recruit_job_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `recruit_job_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `recruit_job_id` bigint unsigned DEFAULT NULL,
  `recruit_job_application_id` int unsigned DEFAULT NULL,
  `recruit_job_offer_letter_id` int unsigned DEFAULT NULL,
  `recruit_interview_schedule_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `details` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `recruit_job_histories_user_id_foreign` (`user_id`),
  KEY `recruit_job_histories_recruit_job_id_foreign` (`recruit_job_id`),
  KEY `recruit_job_histories_recruit_job_application_id_foreign` (`recruit_job_application_id`),
  KEY `recruit_job_histories_recruit_job_offer_letter_id_foreign` (`recruit_job_offer_letter_id`),
  KEY `recruit_job_histories_recruit_interview_schedule_id_foreign` (`recruit_interview_schedule_id`),
  CONSTRAINT `recruit_job_histories_recruit_interview_schedule_id_foreign` FOREIGN KEY (`recruit_interview_schedule_id`) REFERENCES `recruit_interview_schedules` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `recruit_job_histories_recruit_job_application_id_foreign` FOREIGN KEY (`recruit_job_application_id`) REFERENCES `recruit_job_applications` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `recruit_job_histories_recruit_job_id_foreign` FOREIGN KEY (`recruit_job_id`) REFERENCES `recruit_jobs` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `recruit_job_histories_recruit_job_offer_letter_id_foreign` FOREIGN KEY (`recruit_job_offer_letter_id`) REFERENCES `recruit_job_offer_letter` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `recruit_job_histories_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `recruit_job_histories` WRITE;
/*!40000 ALTER TABLE `recruit_job_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `recruit_job_histories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `recruit_job_offer_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `recruit_job_offer_files` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `recruit_job_offer_letter_id` int unsigned NOT NULL,
  `filename` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `hashname` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `recruit_job_offer_files_added_by_foreign` (`added_by`),
  KEY `recruit_job_offer_files_last_updated_by_foreign` (`last_updated_by`),
  KEY `recruit_job_offer_files_recruit_job_offer_letter_id_foreign` (`recruit_job_offer_letter_id`),
  CONSTRAINT `recruit_job_offer_files_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `recruit_job_offer_files_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `recruit_job_offer_files_recruit_job_offer_letter_id_foreign` FOREIGN KEY (`recruit_job_offer_letter_id`) REFERENCES `recruit_job_offer_letter` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `recruit_job_offer_files` WRITE;
/*!40000 ALTER TABLE `recruit_job_offer_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `recruit_job_offer_files` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `recruit_job_offer_letter`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `recruit_job_offer_letter` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `recruit_job_application_id` int unsigned DEFAULT NULL,
  `recruit_job_id` bigint unsigned DEFAULT NULL,
  `employee_id` int unsigned DEFAULT NULL,
  `job_expire` date NOT NULL,
  `expected_joining_date` date NOT NULL,
  `comp_amount` double DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pay_according` enum('hour','day','week','month','year') COLLATE utf8mb4_unicode_ci NOT NULL,
  `sign_require` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `add_structure` int NOT NULL DEFAULT '0',
  `sign_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `decline_reason` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hash` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip_address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `offer_accept_at` timestamp NULL DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `recruit_job_offer_letter_added_by_foreign` (`added_by`),
  KEY `recruit_job_offer_letter_last_updated_by_foreign` (`last_updated_by`),
  KEY `recruit_job_offer_letter_employee_id_foreign` (`employee_id`),
  KEY `recruit_job_offer_letter_recruit_job_application_id_foreign` (`recruit_job_application_id`),
  KEY `recruit_job_offer_letter_recruit_job_id_foreign` (`recruit_job_id`),
  KEY `recruit_job_offer_letter_company_id_foreign` (`company_id`),
  CONSTRAINT `recruit_job_offer_letter_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `recruit_job_offer_letter_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `recruit_job_offer_letter_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `recruit_job_offer_letter_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `recruit_job_offer_letter_recruit_job_application_id_foreign` FOREIGN KEY (`recruit_job_application_id`) REFERENCES `recruit_job_applications` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `recruit_job_offer_letter_recruit_job_id_foreign` FOREIGN KEY (`recruit_job_id`) REFERENCES `recruit_jobs` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `recruit_job_offer_letter` WRITE;
/*!40000 ALTER TABLE `recruit_job_offer_letter` DISABLE KEYS */;
/*!40000 ALTER TABLE `recruit_job_offer_letter` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `recruit_job_offer_questions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `recruit_job_offer_questions` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `recruit_custom_question_id` int unsigned NOT NULL,
  `recruit_job_offer_letter_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `recruit_job_offer_questions_recruit_custom_question_id_foreign` (`recruit_custom_question_id`),
  KEY `recruit_job_offer_questions_recruit_job_offer_letter_id_foreign` (`recruit_job_offer_letter_id`),
  CONSTRAINT `recruit_job_offer_questions_recruit_custom_question_id_foreign` FOREIGN KEY (`recruit_custom_question_id`) REFERENCES `recruit_custom_questions` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `recruit_job_offer_questions_recruit_job_offer_letter_id_foreign` FOREIGN KEY (`recruit_job_offer_letter_id`) REFERENCES `recruit_job_offer_letter` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `recruit_job_offer_questions` WRITE;
/*!40000 ALTER TABLE `recruit_job_offer_questions` DISABLE KEYS */;
/*!40000 ALTER TABLE `recruit_job_offer_questions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `recruit_job_questions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `recruit_job_questions` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `recruit_custom_question_id` int unsigned NOT NULL,
  `recruit_job_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `recruit_job_questions_recruit_custom_question_id_foreign` (`recruit_custom_question_id`),
  KEY `recruit_job_questions_recruit_job_id_foreign` (`recruit_job_id`),
  CONSTRAINT `recruit_job_questions_recruit_custom_question_id_foreign` FOREIGN KEY (`recruit_custom_question_id`) REFERENCES `recruit_custom_questions` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `recruit_job_questions_recruit_job_id_foreign` FOREIGN KEY (`recruit_job_id`) REFERENCES `recruit_jobs` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `recruit_job_questions` WRITE;
/*!40000 ALTER TABLE `recruit_job_questions` DISABLE KEYS */;
/*!40000 ALTER TABLE `recruit_job_questions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `recruit_job_skills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `recruit_job_skills` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `recruit_job_id` bigint unsigned NOT NULL,
  `recruit_skill_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `recruit_job_skills_recruit_job_id_foreign` (`recruit_job_id`),
  KEY `recruit_job_skills_recruit_skill_id_foreign` (`recruit_skill_id`),
  CONSTRAINT `recruit_job_skills_recruit_job_id_foreign` FOREIGN KEY (`recruit_job_id`) REFERENCES `recruit_jobs` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `recruit_job_skills_recruit_skill_id_foreign` FOREIGN KEY (`recruit_skill_id`) REFERENCES `recruit_skills` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `recruit_job_skills` WRITE;
/*!40000 ALTER TABLE `recruit_job_skills` DISABLE KEYS */;
/*!40000 ALTER TABLE `recruit_job_skills` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `recruit_job_sub_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `recruit_job_sub_categories` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `recruit_job_category_id` int unsigned NOT NULL,
  `sub_category_name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `recruit_job_sub_categories_company_id_foreign` (`company_id`),
  KEY `recruit_job_sub_categories_recruit_job_category_id_foreign` (`recruit_job_category_id`),
  CONSTRAINT `recruit_job_sub_categories_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `recruit_job_sub_categories_recruit_job_category_id_foreign` FOREIGN KEY (`recruit_job_category_id`) REFERENCES `recruit_job_categories` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `recruit_job_sub_categories` WRITE;
/*!40000 ALTER TABLE `recruit_job_sub_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `recruit_job_sub_categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `recruit_job_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `recruit_job_types` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `job_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `recruit_job_types_company_id_foreign` (`company_id`),
  CONSTRAINT `recruit_job_types_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `recruit_job_types` WRITE;
/*!40000 ALTER TABLE `recruit_job_types` DISABLE KEYS */;
INSERT INTO `recruit_job_types` VALUES (1,1,'Full time','2023-04-06 06:33:16','2023-04-06 06:33:16'),(2,1,'Part time','2023-04-06 06:33:16','2023-04-06 06:33:16'),(3,1,'On Contract','2023-04-06 06:33:16','2023-04-06 06:33:16'),(4,1,'Internship','2023-04-06 06:33:16','2023-04-06 06:33:16'),(5,1,'Trainee','2023-04-06 06:33:16','2023-04-06 06:33:16');
/*!40000 ALTER TABLE `recruit_job_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `recruit_jobboard_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `recruit_jobboard_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL,
  `recruit_application_status_id` int unsigned NOT NULL,
  `collapsed` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `recruit_jobboard_settings_user_id_foreign` (`user_id`),
  KEY `recruit_jobboard_settings_recruit_application_status_id_foreign` (`recruit_application_status_id`),
  CONSTRAINT `recruit_jobboard_settings_recruit_application_status_id_foreign` FOREIGN KEY (`recruit_application_status_id`) REFERENCES `recruit_application_status` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `recruit_jobboard_settings_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `recruit_jobboard_settings` WRITE;
/*!40000 ALTER TABLE `recruit_jobboard_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `recruit_jobboard_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `recruit_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `recruit_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `recruit_job_type_id` bigint unsigned DEFAULT NULL,
  `job_description` longtext COLLATE utf8mb4_unicode_ci,
  `total_positions` int NOT NULL,
  `remaining_openings` int NOT NULL,
  `department_id` int unsigned DEFAULT NULL,
  `recruiter_id` int NOT NULL,
  `job_type` enum('part time','full time') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'full time',
  `start_date` datetime NOT NULL,
  `end_date` datetime DEFAULT NULL,
  `status` enum('open','closed') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `currency_id` int unsigned DEFAULT NULL,
  `recruit_job_category_id` int unsigned DEFAULT NULL,
  `recruit_job_sub_category_id` int unsigned DEFAULT NULL,
  `remote_job` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `disclose_salary` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `meta_details` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_photo_require` tinyint(1) NOT NULL DEFAULT '0',
  `is_resume_require` tinyint(1) NOT NULL DEFAULT '0',
  `is_dob_require` tinyint(1) NOT NULL DEFAULT '0',
  `is_gender_require` tinyint(1) NOT NULL DEFAULT '0',
  `recruit_work_experience_id` bigint unsigned DEFAULT NULL,
  `pay_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `start_amount` double NOT NULL,
  `end_amount` double DEFAULT NULL,
  `pay_according` enum('hour','day','week','month','year') COLLATE utf8mb4_unicode_ci NOT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `recruit_jobs_department_id_foreign` (`department_id`),
  KEY `recruit_jobs_added_by_foreign` (`added_by`),
  KEY `recruit_jobs_last_updated_by_foreign` (`last_updated_by`),
  KEY `recruit_jobs_recruit_job_sub_category_id_foreign` (`recruit_job_sub_category_id`),
  KEY `recruit_jobs_recruit_job_category_id_foreign` (`recruit_job_category_id`),
  KEY `recruit_jobs_currency_id_foreign` (`currency_id`),
  KEY `recruit_jobs_recruit_job_type_id_foreign` (`recruit_job_type_id`),
  KEY `recruit_jobs_recruit_work_experience_id_foreign` (`recruit_work_experience_id`),
  KEY `recruit_jobs_company_id_foreign` (`company_id`),
  CONSTRAINT `recruit_jobs_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `recruit_jobs_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `recruit_jobs_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `recruit_jobs_department_id_foreign` FOREIGN KEY (`department_id`) REFERENCES `teams` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `recruit_jobs_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `recruit_jobs_recruit_job_category_id_foreign` FOREIGN KEY (`recruit_job_category_id`) REFERENCES `recruit_job_categories` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `recruit_jobs_recruit_job_sub_category_id_foreign` FOREIGN KEY (`recruit_job_sub_category_id`) REFERENCES `recruit_job_sub_categories` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `recruit_jobs_recruit_job_type_id_foreign` FOREIGN KEY (`recruit_job_type_id`) REFERENCES `recruit_job_types` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `recruit_jobs_recruit_work_experience_id_foreign` FOREIGN KEY (`recruit_work_experience_id`) REFERENCES `recruit_work_experiences` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `recruit_jobs` WRITE;
/*!40000 ALTER TABLE `recruit_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `recruit_jobs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `recruit_recommendation_statuses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `recruit_recommendation_statuses` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `recruit_recommendation_statuses_added_by_foreign` (`added_by`),
  KEY `recruit_recommendation_statuses_last_updated_by_foreign` (`last_updated_by`),
  KEY `recruit_recommendation_statuses_company_id_foreign` (`company_id`),
  CONSTRAINT `recruit_recommendation_statuses_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `recruit_recommendation_statuses_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `recruit_recommendation_statuses_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `recruit_recommendation_statuses` WRITE;
/*!40000 ALTER TABLE `recruit_recommendation_statuses` DISABLE KEYS */;
/*!40000 ALTER TABLE `recruit_recommendation_statuses` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `recruit_salary_structures`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `recruit_salary_structures` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `recruit_job_application_id` int unsigned DEFAULT NULL,
  `recruit_job_offer_letter_id` int unsigned DEFAULT NULL,
  `salary_json` text COLLATE utf8mb4_unicode_ci,
  `annual_salary` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `basic_salary` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `basic_value_type` enum('fixed','ctc_percent') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `fixed_allowance` double NOT NULL DEFAULT '0',
  `date` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `recruit_salary_structures_company_id_foreign` (`company_id`),
  KEY `recruit_salary_structures_recruit_job_application_id_foreign` (`recruit_job_application_id`),
  KEY `recruit_salary_structures_recruit_job_offer_letter_id_foreign` (`recruit_job_offer_letter_id`),
  CONSTRAINT `recruit_salary_structures_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `recruit_salary_structures_recruit_job_application_id_foreign` FOREIGN KEY (`recruit_job_application_id`) REFERENCES `recruit_job_applications` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `recruit_salary_structures_recruit_job_offer_letter_id_foreign` FOREIGN KEY (`recruit_job_offer_letter_id`) REFERENCES `recruit_job_offer_letter` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `recruit_salary_structures` WRITE;
/*!40000 ALTER TABLE `recruit_salary_structures` DISABLE KEYS */;
/*!40000 ALTER TABLE `recruit_salary_structures` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `recruit_selected_salary_components`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `recruit_selected_salary_components` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `rss_id` int unsigned DEFAULT NULL,
  `salary_component_id` bigint unsigned DEFAULT NULL,
  `component_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `component_type` enum('earning','deduction') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `component_value` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value_type` enum('fixed','percent','basic_percent','variable') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'variable',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `recruit_selected_salary_components_company_id_foreign` (`company_id`),
  KEY `recruit_selected_salary_components_rss_id_foreign` (`rss_id`),
  KEY `recruit_selected_salary_components_salary_component_id_foreign` (`salary_component_id`),
  CONSTRAINT `recruit_selected_salary_components_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `recruit_selected_salary_components_rss_id_foreign` FOREIGN KEY (`rss_id`) REFERENCES `recruit_salary_structures` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `recruit_selected_salary_components_salary_component_id_foreign` FOREIGN KEY (`salary_component_id`) REFERENCES `salary_components` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `recruit_selected_salary_components` WRITE;
/*!40000 ALTER TABLE `recruit_selected_salary_components` DISABLE KEYS */;
/*!40000 ALTER TABLE `recruit_selected_salary_components` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `recruit_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `recruit_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `about` longtext COLLATE utf8mb4_unicode_ci,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'bg-image',
  `background_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `background_color` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_setting` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `form_settings` longtext COLLATE utf8mb4_unicode_ci,
  `legal_term` longtext COLLATE utf8mb4_unicode_ci,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `favicon` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_website` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `career_site` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `offer_letter_reminder` int NOT NULL,
  `job_alert_status` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `application_restriction` int NOT NULL DEFAULT '180',
  `google_recaptcha_status` enum('active','deactive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'deactive',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `recruit_settings` WRITE;
/*!40000 ALTER TABLE `recruit_settings` DISABLE KEYS */;
INSERT INTO `recruit_settings` VALUES (1,1,'<header>\n      <h5 >Dummy Company</h5>\n      <p>A leader in innovative solutions</p>\n    </header>\n    <main class=\"mt-2\">\n      <h5 class=\"mt-2\">About Us</h5>\n      <p>Dummy Company was founded in 2020 with a mission to provide innovative solutions for a better tomorrow. We have a team of experts in various fields who work together to bring cutting-edge products and services to market. Our focus on quality and customer satisfaction has made us a trusted name in the industry.</p>\n      <h5 class=\"mt-2\">Our Products and Services</h5>\n      <ul>\n        <li>Product 1: A revolutionary new technology that improves efficiency and productivity</li>\n        <li>Product 2: A user-friendly platform that simplifies complex processes</li>\n        <li>Service 1: Customized consulting services to help businesses stay ahead of the curve</li>\n        <li>Service 2: Training and support to ensure the successful adoption of our products</li>\n      </ul>\n      <h5 class=\"mt-2\">Our Team</h5>\n      <p>Dummy Company is powered by a talented and dedicated team of professionals. Our team members bring a diverse set of skills and experiences to the table, allowing us to tackle complex challenges and deliver solutions that truly make a difference. We are committed to fostering a positive and collaborative work environment where everyone has the opportunity to grow and succeed.</p>\n    </main>\n    <footer>','bg-image',NULL,NULL,'{\"1\":{\"id\":1,\"name\":\"applied\",\"status\":true},\"2\":{\"id\":2,\"name\":\"phone screen\",\"status\":true},\"3\":{\"id\":3,\"name\":\"interview\",\"status\":true},\"4\":{\"id\":4,\"name\":\"hired\",\"status\":true},\"5\":{\"id\":5,\"name\":\"rejected\",\"status\":true}}','{\"1\":{\"id\":1,\"name\":\"email\",\"slug\":\"Email\",\"status\":false},\"2\":{\"id\":2,\"name\":\"phone\",\"slug\":\"Phone\",\"status\":false},\"3\":{\"id\":3,\"name\":\"gender\",\"slug\":\"Gender\",\"status\":false},\"4\":{\"id\":4,\"name\":\"total_experience\",\"slug\":\"Total Experience\",\"status\":false},\"5\":{\"id\":5,\"name\":\"current_location\",\"slug\":\"Current location\",\"status\":false},\"6\":{\"id\":6,\"name\":\"current_ctc\",\"slug\":\"Current Ctc\",\"status\":false},\"7\":{\"id\":7,\"name\":\"expected_ctc\",\"slug\":\"Expected Ctc\",\"status\":false},\"8\":{\"id\":8,\"name\":\"notice_period\",\"slug\":\"Notice Period\",\"status\":false},\"9\":{\"id\":9,\"name\":\"application_source\",\"slug\":\"Source\",\"status\":false},\"10\":{\"id\":10,\"name\":\"status\",\"slug\":\"Status\",\"status\":false},\"11\":{\"id\":11,\"name\":\"cover_letter\",\"slug\":\"Cover letter\",\"status\":false}}','If any provision of these Terms and Conditions is held to be invalid or unenforceable, the provision shall be removed (or interpreted, if possible, in a manner as to be enforceable), and the remaining provisions shall be enforced. Headings are for reference purposes only and in no way define, limit, construe or describe the scope or extent of such section. Our failure to act with respect to a breach by you or others does not waive our right to act with respect to subsequent or similar breaches. These Terms and Conditions set forth the entire understanding and agreement between us with respect to the subject matter contained herein and supersede any other agreement, proposals and communications, written or oral, between our representatives and you with respect to the subject matter hereof, including any terms and conditions on any of customer\'s documents or purchase orders.<br>No Joint Venture, No Derogation of Rights. You agree that no joint venture, partnership, employment, or agency relationship exists between you and us as a result of these Terms and Conditions or your use of the Site. Our performance of these Terms and Conditions is subject to existing laws and legal process, and nothing contained herein is in derogation of our right to comply with governmental, court and law enforcement requests or requirements relating to your use of the Site or information provided to or gathered by us with respect to such use.',NULL,NULL,'Worksuite','https://worksuite.biz','yes',0,'no','2023-04-06 06:33:16','2023-04-06 06:33:16',180,'deactive');
/*!40000 ALTER TABLE `recruit_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `recruit_skills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `recruit_skills` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `recruit_skills_company_id_foreign` (`company_id`),
  CONSTRAINT `recruit_skills_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `recruit_skills` WRITE;
/*!40000 ALTER TABLE `recruit_skills` DISABLE KEYS */;
/*!40000 ALTER TABLE `recruit_skills` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `recruit_work_experiences`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `recruit_work_experiences` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `work_experience` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `recruit_work_experiences_company_id_foreign` (`company_id`),
  CONSTRAINT `recruit_work_experiences_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `recruit_work_experiences` WRITE;
/*!40000 ALTER TABLE `recruit_work_experiences` DISABLE KEYS */;
INSERT INTO `recruit_work_experiences` VALUES (1,1,'fresher','2023-04-06 06:33:16','2023-04-06 06:33:16'),(2,1,'0-1 years','2023-04-06 06:33:16','2023-04-06 06:33:16'),(3,1,'1-3 years','2023-04-06 06:33:16','2023-04-06 06:33:16'),(4,1,'3-5 years','2023-04-06 06:33:16','2023-04-06 06:33:16'),(5,1,'5+ years','2023-04-06 06:33:16','2023-04-06 06:33:16');
/*!40000 ALTER TABLE `recruit_work_experiences` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `recruiters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `recruiters` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `status` enum('enabled','disabled') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'enabled',
  `added_by` int unsigned NOT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `recruiters_user_id_foreign` (`user_id`),
  KEY `recruiters_added_by_foreign` (`added_by`),
  KEY `recruiters_last_updated_by_foreign` (`last_updated_by`),
  KEY `recruiters_company_id_foreign` (`company_id`),
  CONSTRAINT `recruiters_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `recruiters_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `recruiters_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `recruiters_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `recruiters` WRITE;
/*!40000 ALTER TABLE `recruiters` DISABLE KEYS */;
/*!40000 ALTER TABLE `recruiters` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `removal_requests`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `removal_requests` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int unsigned DEFAULT NULL,
  `status` enum('pending','approved','rejected') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `removal_requests_company_id_foreign` (`company_id`),
  KEY `removal_requests_user_id_foreign` (`user_id`),
  CONSTRAINT `removal_requests_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `removal_requests_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `removal_requests` WRITE;
/*!40000 ALTER TABLE `removal_requests` DISABLE KEYS */;
/*!40000 ALTER TABLE `removal_requests` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `removal_requests_lead`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `removal_requests_lead` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `lead_id` int unsigned DEFAULT NULL,
  `status` enum('pending','approved','rejected') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `removal_requests_lead_company_id_foreign` (`company_id`),
  KEY `removal_requests_lead_lead_id_foreign` (`lead_id`),
  CONSTRAINT `removal_requests_lead_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `removal_requests_lead_lead_id_foreign` FOREIGN KEY (`lead_id`) REFERENCES `leads` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `removal_requests_lead` WRITE;
/*!40000 ALTER TABLE `removal_requests_lead` DISABLE KEYS */;
/*!40000 ALTER TABLE `removal_requests_lead` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `rest_api_application_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `rest_api_application_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `app_key` int NOT NULL,
  `app_secret` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `authorized_employee_id` int unsigned DEFAULT NULL,
  `status` enum('enabled','disabled') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'enabled',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `rest_api_application_settings_app_key_unique` (`app_key`),
  KEY `rest_api_application_settings_authorized_employee_id_foreign` (`authorized_employee_id`),
  CONSTRAINT `rest_api_application_settings_authorized_employee_id_foreign` FOREIGN KEY (`authorized_employee_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `rest_api_application_settings` WRITE;
/*!40000 ALTER TABLE `rest_api_application_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `rest_api_application_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `rest_api_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `rest_api_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `purchase_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `supported_until` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `fcm_key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `rest_api_settings_added_by_foreign` (`added_by`),
  KEY `rest_api_settings_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `rest_api_settings_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `rest_api_settings_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `rest_api_settings` WRITE;
/*!40000 ALTER TABLE `rest_api_settings` DISABLE KEYS */;
INSERT INTO `rest_api_settings` VALUES (1,NULL,NULL,'2023-04-06 06:33:05','2023-04-06 06:33:05',NULL,NULL,NULL);
/*!40000 ALTER TABLE `rest_api_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `role_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_user` (
  `user_id` int unsigned NOT NULL,
  `role_id` int unsigned NOT NULL,
  PRIMARY KEY (`user_id`,`role_id`),
  KEY `role_user_role_id_foreign` (`role_id`),
  CONSTRAINT `role_user_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `role_user_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `role_user` WRITE;
/*!40000 ALTER TABLE `role_user` DISABLE KEYS */;
INSERT INTO `role_user` VALUES (1,1),(1,2),(2,2),(14,2),(15,2),(16,2),(17,2),(18,2),(19,2),(20,2),(21,2),(22,2),(23,2),(3,3),(4,3),(5,3),(6,3),(7,3),(8,3),(9,3),(10,3),(11,3),(12,3),(13,3);
/*!40000 ALTER TABLE `role_user` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `roles` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `display_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_name_company_id_unique` (`name`,`company_id`),
  KEY `roles_company_id_foreign` (`company_id`),
  CONSTRAINT `roles_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,1,'admin','App Administrator','Admin is allowed to manage everything of the app.','2023-04-06 06:33:16','2023-04-06 06:33:16'),(2,1,'employee','Employee','Employee can see tasks and projects assigned to him.','2023-04-06 06:33:16','2023-04-06 06:33:16'),(3,1,'client','Client','Client can see own tasks and projects.','2023-04-06 06:33:16','2023-04-06 06:33:16'),(4,1,'manager','Manager',NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `salary_components`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `salary_components` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `component_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `component_type` enum('earning','deduction') COLLATE utf8mb4_unicode_ci NOT NULL,
  `component_value` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value_type` enum('fixed','percent','basic_percent','variable') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `weekly_value` double NOT NULL DEFAULT '0',
  `biweekly_value` double NOT NULL DEFAULT '0',
  `semimonthly_value` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `salary_components_company_id_foreign` (`company_id`),
  CONSTRAINT `salary_components_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `salary_components` WRITE;
/*!40000 ALTER TABLE `salary_components` DISABLE KEYS */;
/*!40000 ALTER TABLE `salary_components` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `salary_group_components`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `salary_group_components` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `salary_group_id` bigint unsigned NOT NULL,
  `salary_component_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `salary_group_components_salary_group_id_foreign` (`salary_group_id`),
  KEY `salary_group_components_salary_component_id_foreign` (`salary_component_id`),
  KEY `salary_group_components_company_id_foreign` (`company_id`),
  CONSTRAINT `salary_group_components_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `salary_group_components_salary_component_id_foreign` FOREIGN KEY (`salary_component_id`) REFERENCES `salary_components` (`id`) ON DELETE CASCADE,
  CONSTRAINT `salary_group_components_salary_group_id_foreign` FOREIGN KEY (`salary_group_id`) REFERENCES `salary_groups` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `salary_group_components` WRITE;
/*!40000 ALTER TABLE `salary_group_components` DISABLE KEYS */;
/*!40000 ALTER TABLE `salary_group_components` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `salary_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `salary_groups` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `group_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `salary_groups_company_id_foreign` (`company_id`),
  CONSTRAINT `salary_groups_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `salary_groups` WRITE;
/*!40000 ALTER TABLE `salary_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `salary_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `salary_payment_methods`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `salary_payment_methods` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `payment_method` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `default` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `salary_payment_methods_company_id_foreign` (`company_id`),
  CONSTRAINT `salary_payment_methods_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `salary_payment_methods` WRITE;
/*!40000 ALTER TABLE `salary_payment_methods` DISABLE KEYS */;
INSERT INTO `salary_payment_methods` VALUES (1,1,'Bank Transfer',1,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(2,1,'Cash',0,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(3,1,'Cheque',0,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(4,1,'PayPal',0,'2023-04-06 06:33:16','2023-04-06 06:33:16');
/*!40000 ALTER TABLE `salary_payment_methods` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `salary_slips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `salary_slips` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `currency_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `salary_group_id` bigint unsigned DEFAULT NULL,
  `basic_salary` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `net_salary` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `month` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `year` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `paid_on` date DEFAULT NULL,
  `status` enum('generated','review','locked','paid') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'generated',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `salary_json` text COLLATE utf8mb4_unicode_ci,
  `extra_json` text COLLATE utf8mb4_unicode_ci,
  `expense_claims` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `pay_days` int NOT NULL,
  `salary_payment_method_id` bigint unsigned DEFAULT NULL,
  `tds` double(16,2) NOT NULL,
  `monthly_salary` double(16,2) NOT NULL,
  `gross_salary` double(16,2) NOT NULL,
  `total_deductions` double(16,2) NOT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `salary_from` datetime DEFAULT NULL,
  `salary_to` datetime DEFAULT NULL,
  `payroll_cycle_id` bigint unsigned DEFAULT NULL,
  `fixed_allowance` double NOT NULL DEFAULT '0',
  `expenses_created` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `salary_slips_user_id_foreign` (`user_id`),
  KEY `salary_slips_salary_group_id_foreign` (`salary_group_id`),
  KEY `salary_slips_salary_payment_method_id_foreign` (`salary_payment_method_id`),
  KEY `salary_slips_added_by_foreign` (`added_by`),
  KEY `salary_slips_last_updated_by_foreign` (`last_updated_by`),
  KEY `salary_slips_payroll_cycle_id_foreign` (`payroll_cycle_id`),
  KEY `salary_slips_company_id_foreign` (`company_id`),
  KEY `salary_slips_currency_id_foreign` (`currency_id`),
  CONSTRAINT `salary_slips_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `salary_slips_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `salary_slips_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `salary_slips_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `salary_slips_payroll_cycle_id_foreign` FOREIGN KEY (`payroll_cycle_id`) REFERENCES `payroll_cycles` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `salary_slips_salary_group_id_foreign` FOREIGN KEY (`salary_group_id`) REFERENCES `salary_groups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `salary_slips_salary_payment_method_id_foreign` FOREIGN KEY (`salary_payment_method_id`) REFERENCES `salary_payment_methods` (`id`) ON DELETE SET NULL,
  CONSTRAINT `salary_slips_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `salary_slips` WRITE;
/*!40000 ALTER TABLE `salary_slips` DISABLE KEYS */;
/*!40000 ALTER TABLE `salary_slips` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `salary_tds`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `salary_tds` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `salary_from` double(16,2) NOT NULL,
  `salary_to` double(16,2) NOT NULL,
  `salary_percent` double(5,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `salary_tds_company_id_foreign` (`company_id`),
  CONSTRAINT `salary_tds_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `salary_tds` WRITE;
/*!40000 ALTER TABLE `salary_tds` DISABLE KEYS */;
/*!40000 ALTER TABLE `salary_tds` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sessions` (
  `id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `ip_address` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `payload` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sessions_user_id_index` (`user_id`),
  KEY `sessions_last_activity_index` (`last_activity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sessions` WRITE;
/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `skills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `skills` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `skills_company_id_foreign` (`company_id`),
  CONSTRAINT `skills_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `skills` WRITE;
/*!40000 ALTER TABLE `skills` DISABLE KEYS */;
/*!40000 ALTER TABLE `skills` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `slack_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `slack_settings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `slack_webhook` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `slack_logo` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` enum('active','inactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'inactive',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `slack_settings_company_id_foreign` (`company_id`),
  CONSTRAINT `slack_settings_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `slack_settings` WRITE;
/*!40000 ALTER TABLE `slack_settings` DISABLE KEYS */;
INSERT INTO `slack_settings` VALUES (1,1,NULL,NULL,'inactive','2023-04-06 06:33:16','2023-04-06 06:33:16');
/*!40000 ALTER TABLE `slack_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sms_notification_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sms_notification_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `setting_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `send_sms` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `whatsapp_template` longtext COLLATE utf8mb4_unicode_ci,
  `msg91_template` longtext COLLATE utf8mb4_unicode_ci,
  `msg91_flow_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sms_notification_settings_company_id_foreign` (`company_id`),
  CONSTRAINT `sms_notification_settings_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=62 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sms_notification_settings` WRITE;
/*!40000 ALTER TABLE `sms_notification_settings` DISABLE KEYS */;
INSERT INTO `sms_notification_settings` VALUES (1,NULL,'Test Sms Notification','test-sms-notification','yes','This is whatsapp test message.','This is msg91 test message.',NULL,'2023-04-06 06:33:08','2023-04-06 06:33:08'),(2,1,'Attendance Reminder','attendance-reminder','no','You forgot to mark your today attendance. Kindly clock-in to avoid being marked as absent.','You forgot to mark your today attendance. Kindly clock-in to avoid being marked as absent.',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(3,1,'Follow Up Reminder','follow-up-reminder','no','Follow Up Reminder for Lead # {{1}}. Next Follow Up Date : {{2}}. Remark : {{3}}','Follow Up Reminder for Lead # ##lead_id##. Next Follow Up Date : ##follow_up_date##. Remark : ##remark##',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(4,1,'Auto Task Reminder','auto-task-reminder','no','Auto Task Reminder for Task # {{1}}. Task Heading : {{2}}. Due Date : {{3}}','Auto Task Reminder for Task # ##task_id##. Task Heading : ##heading##. Due Date : ##due_date##',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(5,1,'Contract Signed','contract-signed','no','Contract Signed for Contract # {{1}} by {{2}}.','Contract Signed for Contract # ##contract## by ##client##.',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(6,1,'Estimate Declined','estimate-declined','no','Estimate has been declined. Kindly check the estimate # {{1}}.','Estimate has been declined. Kindly check the estimate # ##estimate_number##.',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(7,1,'Event Invite','event-invite','no','Event Invitation.\nEvent Name : {{1}}. Event Start Date : {{2}}.\nEvent End Date : {{3}}.\nEvent Venue : {{4}}','Event Invitation.\nEvent Name : ##event_name##. Event Start Date : ##event_start_date##.\nEvent End Date : ##event_end_date##.\nEvent Venue : ##event_location##',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(8,1,'Event Reminder','event-reminder','no','Event Reminder.\nEvent Name : {{1}}. Event Start Date : {{2}}.\nEvent End Date : {{3}}.\nEvent Venue : {{4}}','Event Reminder.\nEvent Name : ##event_name##. Event Start Date : ##event_start_date##.\nEvent End Date : ##event_end_date##.\nEvent Venue : ##event_location##',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(9,1,'Recurring Expense Status Updated','recurring-expense-status-updated','no','Recurring Expense Status Updated.\nExpense Name : {{1}}. Expense Status : {{2}}.','Recurring Expense Status Updated.\nExpense Name : ##expense_name##. Expense Status : ##expense_status##.',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(10,1,'New file uploaded to Project','new-file-uploaded-to-project','no','New file uploaded to Project # {{1}}. \nFile Name : {{2}}\nDate : {{3}}','New file uploaded to Project # ##project_name##. \nFile Name : ##file_name##\nDate : ##date##',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(11,1,'Payment Received','payment-received','no','This is a confirmation message for {{1}} payment # {{2}}','This is a confirmation message for ##payment_type## payment # ##number##',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(12,1,'Payment Reminder','payment-reminder','no','This is to remind you about the due date of the following project invoice payment {{1}} which is {{2}}','This is to remind you about the due date of the following project invoice payment ##invoice_number## which is ##due_date##',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(13,1,'Project Reminder','project-reminder','no','This is to remind you about the due date of the following projects which is {{1}}','This is to remind you about the due date of the following projects which is ##due_date##',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(14,1,'Proposal Approved','proposal-approved','no','Proposal has been accepted!\nA new Proposal has been accepted and signed.\nApproved By : {{1}}.\nProposal Status : {{2}}.','Proposal has been accepted!\nA new Proposal has been accepted and signed.\nApproved By : ##name##.\nProposal Status : ##status##.',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(15,1,'Proposal Rejected','proposal-rejected','no','Proposal has been declined by lead!\nA new Proposal has been declined.\nRejected : {{1}}.\nProposal Status : {{2}}.','Proposal has been declined by lead!\nA new Proposal has been declined.\nRejected : ##comment##.\nProposal Status : ##status##.',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(16,1,'Recurring Invoice Status Updated','recurring-invoice-status-updated','no','Your recurring invoice status updated to {{1}}.','Your recurring invoice status updated to ##status##.',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(17,1,'Invoice Reminder','invoice-reminder','no','Invoice Reminder - {{1}}\nThis is to remind you about the due date of the following invoice which is {{2}}.','Invoice Reminder - ##invoice_number##\nThis is to remind you about the due date of the following invoice which is ##due_date##.',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(18,1,'New Expense - Added by Admin','new-expense-added-by-admin','no','New Expense submitted by {{1}}. Expense details: {{2}} - {{3}}','New Expense submitted by ##name##. Expense details: ##item_name## - ##price##',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(19,1,'New Expense - Added by Member','new-expense-added-by-member','no','New Expense submitted. Expense details: {{1}} - {{2}}','New Expense submitted. Expense details: ##item_name## - ##price##',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(20,1,'Invoice Created','invoice-created','no','New Invoice Received - Invoice No. is {{1}}','New Invoice Received - Invoice No. is ##invoice_number##',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(21,1,'Invoice Updated','invoice-updated','no','Invoice has been updated. Please check the invoice {{1}}','Invoice has been updated. Please check the invoice ##invoice_number##',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(22,1,'Lead Notification','lead-notification','no','New Lead Received. Lead Details: {{1}}','New Lead Received. Lead Details: ##lead_name##',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(23,1,'New Leave Application','new-leave-application','no','A Leave application applied.\nOn Date: {{1}}','A Leave application applied.\nOn Date: ##leave_date##',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(24,1,'New Leave Request','new-leave-request','no','New leave request received by {{1}}.\nOn Date: {{2}}\nReason: {{3}}','New leave request received by ##name##.\nOn Date: ##leave_date##\nReason: ##reason##',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(25,1,'Leave Approved','leave-approved','no','A Leave application approved.\nOn Date: {{1}}','A Leave application approved.\nOn Date: ##leave_date##',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(26,1,'Leave Rejected','leave-rejected','no','A Leave application rejected.\nOn Date: {{1}}','A Leave application rejected.\nOn Date: ##leave_date##',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(27,1,'Leave Updated','leave-updated','no','A Leave application status updated.\nStatus: {{1}}','A Leave application status updated.\nStatus: ##status##',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(28,1,'Multiple Leave Application','multiple-leave-application','no','Multiple leave application received by {{1}}.\nReason: {{2}}','Multiple leave application received by ##name##.\nReason: ##reason##',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(29,1,'New Multiple Leave Application','new-multiple-leave-application','no','New multiple leave application received by {{1}}.\nReason: {{2}}\nLeave Type: {{3}}','New multiple leave application received by ##name##.\nReason: ##reason##\nLeave Type: ##leave_type##',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(30,1,'New Task','new-task','no','New Task Assigned to You.\nTask Details: {{1}}\nTask ID: {{2}}\nDue Date: {{3}}','New Task Assigned to You.\nTask Details: ##heading##\nTask ID: ##task_id##\nDue Date: ##due_date##',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(31,1,'New Order','new-order','no','New Order Received.\nOrder Number: {{1}}.\nLogin now to view the order.','New Order Received.\nOrder Number: ##order_number##.\nLogin now to view the order.',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(32,1,'Order Updated','order-updated','no','Order Updated.\nOrder Number: {{1}}.\nLogin now to view the order.','Order Updated.\nOrder Number: ##order_number##.\nLogin now to view the order.',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(33,1,'New Payment','new-payment','no','Payment Received!\nA new Payment has been done. Login now to view the Payment.','Payment Received!\nA new Payment has been done. Login now to view the Payment.',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(34,1,'New Product Purchase','new-product-purchase','no','New Product Purchase\nA new product purchase has been made. Login now to view the purchase.','New Product Purchase\nA new product purchase has been made. Login now to view the purchase.',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(35,1,'New Project','new-project','no','New Project Added\nA new project added with name - {{1}}. Login now to view the project.','New Project Added\nA new project added with name - ##project_name##. Login now to view the project.',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(36,1,'New Proposal','new-proposal','no','New Proposal Received\nA new proposal has been received. Login now to view the proposal.','New Proposal Received\nA new proposal has been received. Login now to view the proposal.',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(37,1,'New Recurring Invoice','new-recurring-invoice','no','A new recurring invoice has been submitted.','A new recurring invoice has been submitted.',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(38,1,'New Ticket Reply','new-ticket-reply','no','New ticket reply received\nYou have received a reply on Ticket###ticket_number##','New ticket reply received\nYou have received a reply on Ticket###ticket_number##',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(39,1,'New Ticket Request','new-ticket-request','no','New support ticket is has been generated for you. Login to view the ticket.','New support ticket is has been generated for you. Login to view the ticket.',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(40,1,'Task Updated','task-updated','no','Task updated\nTask Details: {{1}}\nTask ID: {{2}}\nDue Date: {{3}}','Task updated\nTask Details: ##heading##\nTask ID: ##task_id##\nDue Date: ##due_date##',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(41,1,'Task Completed Client','task-completed-client','no','Task marked as completed.\nTask Details: {{1}}\nTask ID: {{2}}','Task marked as completed.\nTask Details: ##heading##\nTask ID: ##task_id##',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(42,1,'Task Completed','task-completed','no','Task marked as completed.\nTask Details: {{1}}\nTask ID: {{2}}\nProject: {{3}}','Task marked as completed.\nTask Details: ##heading##\nTask ID: ##task_id##\nProject: ##project##',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(43,1,'New Client Task','new-client-task','no','New Task Generated - Task Heading is {{1}}','New Task Generated - Task Heading is ##heading##',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(44,1,'Task Update Client','task-update-client','no','Task updated\nTask Details: {{1}}\nTask ID: {{2}}','Task updated\nTask Details: ##heading##\nTask ID: ##task_id##',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(45,1,'New Notice Published','new-notice-published','no','New Notice Published - Notice is: {{1}}','New Notice Published - Notice is: ##heading##',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(46,1,'New Support Ticket Request','new-support-ticket-request','no','New Support Ticket Requested\nTicket ID: {{1}}\nTicket Subject: {{2}}\nTicket Requested By: {{3}}','New Support Ticket Requested\nTicket ID: ##ticket_id##\nTicket Subject: ##subject##\nTicket Requested By: ##ticket_requester_name##',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(47,1,'Agent Ticket','agent-ticket','no','You have been assigned a ticket\nTicket ID: {{1}}\nTicket Subject: {{2}}','You have been assigned a ticket\nTicket ID: ##ticket_id##\nTicket Subject: ##subject##',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(48,1,'Employee Assign to Project','employee-assign-to-project','no','New Project Assigned\nYou have been added as a member to the project - {{1}}','New Project Assigned\nYou have been added as a member to the project - ##project_name##',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(49,1,'User Join Via Invitation','user-join-via-invitation','no','New user joined via link.\nNew account has been created successfully via invitation link. Following are the details-\nName: {{1}}\nEmail: {{2}}\nPhone: {{3}}','New user joined via link.\nNew account has been created successfully via invitation link. Following are the details-\nName: ##name##\nEmail: ##email##\nPhone: ##phone##',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(50,1,'Notice Updated','notice-updated','no','Notice has been updated. Login to view the notice.\nNotice Heading: {{1}}','Notice has been updated. Login to view the notice.\nNotice Heading: ##heading##',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(51,1,'Removal Request Admin Notification','removal-request-admin-notification','no','New removal request has been received','New removal request has been received',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(52,1,'Removal Request Approved','removal-request-approved','no','Your removal request has been approved','Your removal request has been approved',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(53,1,'Removal Request Reject','removal-request-reject','no','Your removal request has been rejected','Your removal request has been rejected',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(54,1,'Removal Request Approved Lead','removal-request-approved-lead','no','Your removal request for lead has been approved','Your removal request for lead has been approved',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(55,1,'Removal Request Reject Lead','removal-request-reject-lead','no','Your removal request for lead has been rejected','Your removal request for lead has been rejected',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(56,1,'Sub Task Assignee Added','sub-task-assignee-added','no','Sub Task assigned to you.\nTask Details: {{1}}\nProject: {{2}}','Sub Task assigned to you.\nTask Details: ##title##\nProject: ##project##',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(57,1,'Sub Task Completed','sub-task-completed','no','Sub Task marked as completed.\nTask Details: {{1}}\nProject: {{2}}','Sub Task marked as completed.\nTask Details: ##title##\nProject: ##project##',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(58,1,'Task Comment','task-comment','no','New comment on task.\nTask Details: {{1}}\nTask ID: {{2}}\nProject: {{3}}','New comment on task.\nTask Details: ##heading##\nTask ID: ##task_id##\nProject: ##project##',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(59,1,'Task Note','task-note','no','New note added for task - {{1}}\nTask ID: {{2}}\nProject: {{3}}','New note added for task - ##heading##\nTask ID: ##task_id##\nProject: ##project##',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(60,1,'Task Reminder','task-reminder','no','Reminder for assigned task - {{1}}\nTask ID: {{2}}\nDate: {{3}}','Reminder for assigned task - ##heading##\nTask ID: ##task_id##\nDate: ##date##',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(61,1,'User Registrationadded By Admin','user-registrationadded-by-admin','no','New user added.\nNew account has been created successfully via invitation link. Following are the details-\nName: {{1}}\nEmail: {{2}}\nPhone: {{3}}','New user added.\nNew account has been created successfully via invitation link. Following are the details-\nName: ##name##\nEmail: ##email##\nPhone: ##phone##',NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16');
/*!40000 ALTER TABLE `sms_notification_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sms_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sms_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `account_sid` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `auth_token` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `from_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(1) NOT NULL,
  `whatapp_from_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `whatsapp_status` tinyint(1) NOT NULL,
  `nexmo_api_key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nexmo_api_secret` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nexmo_from_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nexmo_status` tinyint(1) NOT NULL,
  `msg91_auth_key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `msg91_from` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `msg91_status` tinyint(1) NOT NULL,
  `purchase_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `supported_until` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `telegram_status` tinyint(1) NOT NULL DEFAULT '0',
  `telegram_bot_token` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sms_settings_added_by_foreign` (`added_by`),
  KEY `sms_settings_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `sms_settings_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `sms_settings_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sms_settings` WRITE;
/*!40000 ALTER TABLE `sms_settings` DISABLE KEYS */;
INSERT INTO `sms_settings` VALUES (1,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,0,NULL,NULL,0,NULL,NULL,'2023-04-06 06:33:05','2023-04-06 06:33:05',NULL,NULL,0,NULL);
/*!40000 ALTER TABLE `sms_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `smtp_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `smtp_settings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `mail_driver` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'smtp',
  `mail_host` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'smtp.gmail.com',
  `mail_port` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '587',
  `mail_username` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'youremail@gmail.com',
  `mail_password` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'your password',
  `mail_from_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'your name',
  `mail_from_email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'from@email.com',
  `mail_encryption` enum('ssl','tls','starttls') COLLATE utf8mb4_unicode_ci DEFAULT 'tls',
  `verified` tinyint(1) NOT NULL DEFAULT '0',
  `mail_connection` enum('sync','database') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'sync',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `smtp_settings` WRITE;
/*!40000 ALTER TABLE `smtp_settings` DISABLE KEYS */;
INSERT INTO `smtp_settings` VALUES (1,'smtp','smtp.gmail.com','465','myemail@gmail.com','mypassword','Worksuite','from@email.com','ssl',0,'sync','2023-04-06 06:33:16','2023-04-06 06:33:16');
/*!40000 ALTER TABLE `smtp_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `social_auth_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `social_auth_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `facebook_client_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `facebook_secret_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `facebook_status` enum('enable','disable') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'disable',
  `google_client_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `google_secret_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `google_status` enum('enable','disable') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'disable',
  `twitter_client_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `twitter_secret_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `twitter_status` enum('enable','disable') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'disable',
  `linkedin_client_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `linkedin_secret_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `linkedin_status` enum('enable','disable') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'disable',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `social_auth_settings` WRITE;
/*!40000 ALTER TABLE `social_auth_settings` DISABLE KEYS */;
INSERT INTO `social_auth_settings` VALUES (1,NULL,NULL,'disable',NULL,NULL,'disable',NULL,NULL,'disable',NULL,NULL,'disable','2023-04-06 06:33:16','2023-04-06 06:33:16');
/*!40000 ALTER TABLE `social_auth_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `socials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `socials` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned DEFAULT NULL,
  `social_id` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `social_service` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `socials` WRITE;
/*!40000 ALTER TABLE `socials` DISABLE KEYS */;
/*!40000 ALTER TABLE `socials` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sticky_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sticky_notes` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `note_text` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `colour` enum('blue','yellow','red','gray','purple','green') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'blue',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sticky_notes_company_id_foreign` (`company_id`),
  KEY `sticky_notes_user_id_foreign` (`user_id`),
  CONSTRAINT `sticky_notes_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `sticky_notes_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sticky_notes` WRITE;
/*!40000 ALTER TABLE `sticky_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `sticky_notes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sub_task_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sub_task_files` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned DEFAULT NULL,
  `sub_task_id` int unsigned NOT NULL,
  `filename` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `google_url` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hashname` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dropbox_link` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sub_task_files_user_id_foreign` (`user_id`),
  KEY `sub_task_files_sub_task_id_foreign` (`sub_task_id`),
  CONSTRAINT `sub_task_files_sub_task_id_foreign` FOREIGN KEY (`sub_task_id`) REFERENCES `sub_tasks` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `sub_task_files_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sub_task_files` WRITE;
/*!40000 ALTER TABLE `sub_task_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `sub_task_files` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sub_tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sub_tasks` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `task_id` int unsigned NOT NULL,
  `title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `due_date` datetime DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `status` enum('incomplete','complete') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'incomplete',
  `assigned_to` int unsigned DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sub_tasks_task_id_foreign` (`task_id`),
  KEY `sub_tasks_assigned_to_foreign` (`assigned_to`),
  KEY `sub_tasks_added_by_foreign` (`added_by`),
  KEY `sub_tasks_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `sub_tasks_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `sub_tasks_assigned_to_foreign` FOREIGN KEY (`assigned_to`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `sub_tasks_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `sub_tasks_task_id_foreign` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sub_tasks` WRITE;
/*!40000 ALTER TABLE `sub_tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `sub_tasks` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `subscription_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `subscription_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `subscription_id` bigint unsigned NOT NULL,
  `stripe_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `stripe_product` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `stripe_price` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `quantity` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `subscription_items_subscription_id_stripe_price_unique` (`subscription_id`,`stripe_price`),
  UNIQUE KEY `subscription_items_stripe_id_unique` (`stripe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `subscription_items` WRITE;
/*!40000 ALTER TABLE `subscription_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `subscription_items` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `subscriptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `subscriptions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `stripe_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `stripe_status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `stripe_price` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `quantity` int DEFAULT NULL,
  `trial_ends_at` timestamp NULL DEFAULT NULL,
  `ends_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `subscriptions_stripe_id_unique` (`stripe_id`),
  KEY `subscriptions_company_id_foreign` (`company_id`),
  KEY `subscriptions_user_id_stripe_status_index` (`user_id`,`stripe_status`),
  CONSTRAINT `subscriptions_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `subscriptions_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `subscriptions` WRITE;
/*!40000 ALTER TABLE `subscriptions` DISABLE KEYS */;
/*!40000 ALTER TABLE `subscriptions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `task_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_category` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `category_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `task_category_company_id_foreign` (`company_id`),
  KEY `task_category_added_by_foreign` (`added_by`),
  KEY `task_category_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `task_category_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `task_category_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `task_category_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `task_category` WRITE;
/*!40000 ALTER TABLE `task_category` DISABLE KEYS */;
/*!40000 ALTER TABLE `task_category` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `task_comment_emoji`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_comment_emoji` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned DEFAULT NULL,
  `comment_id` int unsigned DEFAULT NULL,
  `emoji_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `task_comment_emoji_user_id_foreign` (`user_id`),
  KEY `task_comment_emoji_comment_id_foreign` (`comment_id`),
  CONSTRAINT `task_comment_emoji_comment_id_foreign` FOREIGN KEY (`comment_id`) REFERENCES `task_comments` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `task_comment_emoji_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `task_comment_emoji` WRITE;
/*!40000 ALTER TABLE `task_comment_emoji` DISABLE KEYS */;
/*!40000 ALTER TABLE `task_comment_emoji` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `task_comments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_comments` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `comment` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int unsigned NOT NULL,
  `task_id` int unsigned NOT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `task_comments_user_id_foreign` (`user_id`),
  KEY `task_comments_task_id_foreign` (`task_id`),
  KEY `task_comments_added_by_foreign` (`added_by`),
  KEY `task_comments_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `task_comments_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `task_comments_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `task_comments_task_id_foreign` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `task_comments_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `task_comments` WRITE;
/*!40000 ALTER TABLE `task_comments` DISABLE KEYS */;
/*!40000 ALTER TABLE `task_comments` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `task_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_files` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL,
  `task_id` int unsigned NOT NULL,
  `filename` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `google_url` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hashname` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dropbox_link` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `task_files_user_id_foreign` (`user_id`),
  KEY `task_files_task_id_foreign` (`task_id`),
  KEY `task_files_added_by_foreign` (`added_by`),
  KEY `task_files_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `task_files_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `task_files_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `task_files_task_id_foreign` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `task_files_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `task_files` WRITE;
/*!40000 ALTER TABLE `task_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `task_files` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `task_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_history` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `task_id` int unsigned NOT NULL,
  `sub_task_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `details` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `board_column_id` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `task_history_task_id_foreign` (`task_id`),
  KEY `task_history_sub_task_id_foreign` (`sub_task_id`),
  KEY `task_history_user_id_foreign` (`user_id`),
  KEY `task_history_board_column_id_foreign` (`board_column_id`),
  CONSTRAINT `task_history_board_column_id_foreign` FOREIGN KEY (`board_column_id`) REFERENCES `taskboard_columns` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `task_history_sub_task_id_foreign` FOREIGN KEY (`sub_task_id`) REFERENCES `sub_tasks` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `task_history_task_id_foreign` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `task_history_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `task_history` WRITE;
/*!40000 ALTER TABLE `task_history` DISABLE KEYS */;
/*!40000 ALTER TABLE `task_history` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `task_label_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_label_list` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `project_id` int unsigned DEFAULT NULL,
  `label_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `task_label_list_company_id_foreign` (`company_id`),
  KEY `task_label_list_project_id_foreign` (`project_id`),
  CONSTRAINT `task_label_list_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `task_label_list_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `task_label_list` WRITE;
/*!40000 ALTER TABLE `task_label_list` DISABLE KEYS */;
/*!40000 ALTER TABLE `task_label_list` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `task_labels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_labels` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `label_id` int unsigned NOT NULL,
  `task_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `task_labels_label_id_foreign` (`label_id`),
  KEY `task_tags_task_id_foreign` (`task_id`),
  CONSTRAINT `task_labels_label_id_foreign` FOREIGN KEY (`label_id`) REFERENCES `task_label_list` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `task_tags_task_id_foreign` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `task_labels` WRITE;
/*!40000 ALTER TABLE `task_labels` DISABLE KEYS */;
/*!40000 ALTER TABLE `task_labels` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `task_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_notes` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `task_id` int unsigned NOT NULL,
  `user_id` int DEFAULT NULL,
  `note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `task_notes_task_id_foreign` (`task_id`),
  KEY `task_notes_added_by_foreign` (`added_by`),
  KEY `task_notes_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `task_notes_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `task_notes_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `task_notes_task_id_foreign` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `task_notes` WRITE;
/*!40000 ALTER TABLE `task_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `task_notes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `task_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `task_category` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `project` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `start_date` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `due_date` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `assigned_to` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `assigned_by` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `description` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `label` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `status` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `priority` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `make_private` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `time_estimate` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `hours_logged` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `custom_fields` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `copy_task_link` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `files` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `sub_task` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `comments` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `time_logs` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `notes` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `history` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `task_settings_company_id_foreign` (`company_id`),
  CONSTRAINT `task_settings_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `task_settings` WRITE;
/*!40000 ALTER TABLE `task_settings` DISABLE KEYS */;
INSERT INTO `task_settings` VALUES (1,1,'yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','2023-04-06 06:33:16','2023-04-06 06:33:16');
/*!40000 ALTER TABLE `task_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `task_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_users` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `task_id` int unsigned NOT NULL,
  `user_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `task_users_task_id_foreign` (`task_id`),
  KEY `task_users_user_id_foreign` (`user_id`),
  CONSTRAINT `task_users_task_id_foreign` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `task_users_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `task_users` WRITE;
/*!40000 ALTER TABLE `task_users` DISABLE KEYS */;
INSERT INTO `task_users` VALUES (1,1,18,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(2,2,18,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(3,3,21,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(4,4,23,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(5,5,14,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(6,6,21,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(7,7,14,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(8,8,15,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(9,9,21,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(10,10,1,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(11,11,18,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(12,12,18,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(13,13,23,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(14,14,14,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(15,15,23,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(16,16,16,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(17,17,2,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(18,18,22,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(19,19,17,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(20,20,19,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(21,21,17,'2023-04-06 06:33:18','2023-04-06 06:33:18');
/*!40000 ALTER TABLE `task_users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `taskboard_columns`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `taskboard_columns` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `column_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `label_color` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `priority` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `taskboard_columns_column_name_company_id_unique` (`column_name`,`company_id`),
  KEY `taskboard_columns_company_id_foreign` (`company_id`),
  CONSTRAINT `taskboard_columns_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `taskboard_columns` WRITE;
/*!40000 ALTER TABLE `taskboard_columns` DISABLE KEYS */;
INSERT INTO `taskboard_columns` VALUES (1,1,'Incomplete','incomplete','#d21010',1,NULL,NULL),(2,1,'To Do','to_do','#f5c308',2,NULL,NULL),(3,1,'Doing','doing','#00b5ff',3,NULL,NULL),(4,1,'Completed','completed','#679c0d',4,NULL,NULL);
/*!40000 ALTER TABLE `taskboard_columns` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tasks` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `task_short_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_id` int unsigned DEFAULT NULL,
  `heading` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `due_date` date DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `project_id` int unsigned DEFAULT NULL,
  `task_category_id` int unsigned DEFAULT NULL,
  `priority` enum('low','medium','high') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'medium',
  `status` enum('incomplete','completed') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'incomplete',
  `board_column_id` int unsigned DEFAULT '1',
  `column_priority` int NOT NULL,
  `completed_on` datetime DEFAULT NULL,
  `created_by` int unsigned DEFAULT NULL,
  `recurring_task_id` int unsigned DEFAULT NULL,
  `dependent_task_id` int unsigned DEFAULT NULL,
  `milestone_id` int unsigned DEFAULT NULL,
  `is_private` tinyint(1) NOT NULL DEFAULT '0',
  `billable` tinyint(1) NOT NULL DEFAULT '1',
  `estimate_hours` int NOT NULL,
  `estimate_minutes` int NOT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `hash` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `repeat` tinyint(1) NOT NULL DEFAULT '0',
  `repeat_complete` tinyint(1) NOT NULL DEFAULT '0',
  `repeat_count` int DEFAULT NULL,
  `repeat_type` enum('day','week','month','year') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'day',
  `repeat_cycles` int DEFAULT NULL,
  `event_id` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tasks_company_id_foreign` (`company_id`),
  KEY `tasks_due_date_index` (`due_date`),
  KEY `tasks_project_id_foreign` (`project_id`),
  KEY `tasks_task_category_id_foreign` (`task_category_id`),
  KEY `tasks_board_column_id_foreign` (`board_column_id`),
  KEY `tasks_created_by_foreign` (`created_by`),
  KEY `tasks_recurring_task_id_foreign` (`recurring_task_id`),
  KEY `tasks_dependent_task_id_foreign` (`dependent_task_id`),
  KEY `tasks_milestone_id_foreign` (`milestone_id`),
  KEY `tasks_added_by_foreign` (`added_by`),
  KEY `tasks_last_updated_by_foreign` (`last_updated_by`),
  KEY `tasks_deleted_at_index` (`deleted_at`),
  CONSTRAINT `tasks_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `tasks_board_column_id_foreign` FOREIGN KEY (`board_column_id`) REFERENCES `taskboard_columns` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `tasks_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `tasks_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `tasks_dependent_task_id_foreign` FOREIGN KEY (`dependent_task_id`) REFERENCES `tasks` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `tasks_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `tasks_milestone_id_foreign` FOREIGN KEY (`milestone_id`) REFERENCES `project_milestones` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `tasks_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `tasks_recurring_task_id_foreign` FOREIGN KEY (`recurring_task_id`) REFERENCES `tasks` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `tasks_task_category_id_foreign` FOREIGN KEY (`task_category_id`) REFERENCES `task_category` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `tasks` WRITE;
/*!40000 ALTER TABLE `tasks` DISABLE KEYS */;
INSERT INTO `tasks` VALUES (1,'WFS-1',1,'Alice noticed with.','Ugh, Serpent!\' \'But I\'m NOT a serpent!\' said Alice to herself, \'Which way? Which way?\', holding her hand again, and did not like to see what was coming. It was the Cat went on, \'\"--found it.','2023-04-03','2023-04-02',1,NULL,'medium','completed',1,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'1bc36f054582a5a0fa6814e6d3f2329f',0,0,NULL,'day',NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL),(2,'WFS-2',1,'RED rose-tree, and.','Gryphon never learnt it.\' \'Hadn\'t time,\' said the Duchess, who seemed to think about it, so she began looking at Alice the moment she quite forgot how to begin.\' For, you see, as they lay sprawling.','2023-03-18','2023-03-15',1,NULL,'high','completed',4,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'eb69d751930e24adfe97097a026f8f6c',0,0,NULL,'day',NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL),(3,'OMFSNP-3',1,'Duchess: \'and the.','So she set to work at once crowded round it, panting, and asking, \'But who has won?\' This question the Dodo managed it.) First it marked out a box of comfits, (luckily the salt water had not gone.','2023-01-27','2023-01-25',2,NULL,'high','completed',2,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'666cb05ed70541e027d8269d47581174',0,0,NULL,'day',NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL),(4,'OMFSNP-4',1,'I hadn\'t mentioned.','King said to herself; \'the March Hare will be the right words,\' said poor Alice, \'to speak to this mouse? Everything is so out-of-the-way down here, that I should like to see if he would not allow.','2023-03-12','2023-03-08',2,NULL,'medium','completed',1,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'43693007465e82d5180f4542c47303d8',0,0,NULL,'day',NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL),(5,'EPFLC-5',1,'Queen! The Queen!\'.','March Hare,) \'--it was at in all directions, tumbling up against each other; however, they got thrown out to sea!\" But the insolence of his great wig.\' The judge, by the prisoner to--to somebody.\'.','2023-03-28','2023-03-24',3,NULL,'high','completed',4,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'7661bee1bcbd908e42e38993a29da512',0,0,NULL,'day',NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL),(6,'EPFLC-6',1,'Alice again, in a.','Alice remarked. \'Right, as usual,\' said the Hatter: \'it\'s very easy to take out of its mouth, and addressed her in an undertone to the Queen. \'It proves nothing of tumbling down stairs! How brave.','2023-04-03','2023-03-28',3,NULL,'medium','incomplete',2,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'f35339cbd8da7affb6da27e037abdb40',0,0,NULL,'day',NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL),(7,'EPFLC-7',1,'I\'ve finished.\' So.','I should be free of them were animals, and some of the cakes, and was delighted to find that her shoulders were nowhere to be sure, she had asked it aloud; and in THAT direction,\' the Cat went on.','2023-03-16','2023-03-08',3,NULL,'high','incomplete',4,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'4dcf10a20d4198b865c614043a655176',0,0,NULL,'day',NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL),(8,'CDOW-8',1,'Gryphon. \'We can.','Queen, \'Really, my dear, and that he had never heard before, \'Sure then I\'m here! Digging for apples, indeed!\' said the March Hare was said to herself \'That\'s quite enough--I hope I shan\'t grow any.','2023-01-21','2023-01-12',4,NULL,'medium','completed',3,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'7f022272b1f2639a720a725f678cc686',0,0,NULL,'day',NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL),(9,'CDOW-9',1,'Poor Alice! It was.','Don\'t be all day about it!\' Last came a little different. But if I\'m Mabel, I\'ll stay down here with me! There are no mice in the prisoner\'s handwriting?\' asked another of the house, quite.','2023-03-21','2023-03-13',4,NULL,'low','completed',3,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'b3556c2ee9be733beb23baa1c458c077',0,0,NULL,'day',NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL),(10,'DMAAS-10',1,'Let me see: four.','Alice looked up, and reduced the answer to shillings and pence. \'Take off your hat,\' the King triumphantly, pointing to Alice severely. \'What are tarts made of?\' \'Pepper, mostly,\' said the King.','2023-03-28','2023-03-24',5,NULL,'medium','incomplete',2,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'dc6353fe0094a3a5b0ec14cb5cb956ad',0,0,NULL,'day',NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL),(11,'DMAAS-11',1,'Dodo in an angry.','Alice waited till the puppy\'s bark sounded quite faint in the direction in which case it would like the largest telescope that ever was! Good-bye, feet!\' (for when she had gone through that day.','2023-01-17','2023-01-14',5,NULL,'high','incomplete',4,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'6416def9f30f99f126f09f834e79ccd6',0,0,NULL,'day',NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL),(12,'DMAAS-12',1,'Queen. \'Sentence.','Presently the Rabbit say, \'A barrowful will do, to begin lessons: you\'d only have to beat them off, and had to stop and untwist it. After a while she remembered that she hardly knew what she was.','2023-03-21','2023-03-20',5,NULL,'low','completed',2,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'a1f5f529e030ba41c6d113b0a3cb55ac',0,0,NULL,'day',NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL),(13,'BT-13',1,'Alice as he spoke.','Alice. \'Why?\' \'IT DOES THE BOOTS AND SHOES.\' the Gryphon repeated impatiently: \'it begins \"I passed by his face only, she would have made a memorandum of the cupboards as she tucked her arm.','2023-03-30','2023-03-29',6,NULL,'medium','incomplete',2,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'93db868dc2b322c9ba7945312282b649',0,0,NULL,'day',NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL),(14,'BT-14',1,'For some minutes.','Alice, \'a great girl like you,\' (she might well say this), \'to go on crying in this way! Stop this moment, and fetch me a pair of white kid gloves in one hand and a large dish of tarts upon it: they.','2023-04-02','2023-03-30',6,NULL,'medium','completed',4,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'e9c698d2a15b0e28c9756dc88751bd04',0,0,NULL,'day',NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL),(15,'BT-15',1,'Alice, thinking it.','I\'ll eat it,\' said Alice. \'It goes on, you know,\' the Hatter asked triumphantly. Alice did not seem to encourage the witness at all: he kept shifting from one end of the trees had a VERY unpleasant.','2023-03-19','2023-03-09',6,NULL,'high','incomplete',1,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'a9f3abb1ccb84851324be7a463feb92c',0,0,NULL,'day',NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL),(16,'FPABT-16',1,'Duchess was VERY.','I wonder?\' As she said to herself, \'in my going out altogether, like a thunderstorm. \'A fine day, your Majesty!\' the soldiers shouted in reply. \'Please come back and see after some executions I have.','2023-04-03','2023-03-29',7,NULL,'low','incomplete',3,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'c36ab18b89bed8a79b3f798601dcbe42',0,0,NULL,'day',NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL),(17,'FPABT-17',1,'Wonderland, though.','Cheshire cats always grinned; in fact, a sort of present!\' thought Alice. \'I don\'t quite understand you,\' she said, \'and see whether it\'s marked \"poison\" or not\'; for she had brought herself down to.','2023-03-14','2023-03-06',7,NULL,'medium','incomplete',1,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'2621357cbf827b2e6a0b669c3e5833de',0,0,NULL,'day',NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL),(18,'FPABT-18',1,'Mock Turtle went.','How she longed to change the subject. \'Ten hours the first figure,\' said the Mock Turtle: \'why, if a dish or kettle had been would have made a rush at the moment, \'My dear! I wish you wouldn\'t.','2023-03-19','2023-03-11',7,NULL,'medium','completed',2,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'79fda361ace7fc37c5c5db08930d6979',0,0,NULL,'day',NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL),(19,'PMATCT-19',1,'IS his business!\'.','First, because I\'m on the floor: in another moment down went Alice like the Mock Turtle is.\' \'It\'s the oldest rule in the lock, and to hear her try and repeat something now. Tell her to begin.\' He.','2023-03-21','2023-03-12',8,NULL,'medium','incomplete',3,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'bb0d89716c4788272f75fe71bf5b2b5e',0,0,NULL,'day',NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL),(20,'AI(AML(DS-20',1,'AT ALL. Soup does.','Tell her to begin.\' For, you see, so many lessons to learn! Oh, I shouldn\'t want YOURS: I don\'t put my arm round your waist,\' the Duchess to play with, and oh! ever so many tea-things are put out.','2023-03-22','2023-03-12',9,NULL,'high','completed',3,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'0938192206627719307b25a139691867',0,0,NULL,'day',NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL),(21,'WFS-21',1,'Alice, \'or perhaps.','If I or she fell very slowly, for she was playing against herself, for this curious child was very fond of beheading people here; the great wonder is, that there\'s any one of the crowd below, and.','2023-03-10','2023-03-05',10,NULL,'low','completed',3,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'1e39aa14fe5aef4621eedf57ffbd193c',0,0,NULL,'day',NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18',NULL);
/*!40000 ALTER TABLE `tasks` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `taxes` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `tax_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `rate_percent` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `taxes_company_id_foreign` (`company_id`),
  CONSTRAINT `taxes_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `taxes` WRITE;
/*!40000 ALTER TABLE `taxes` DISABLE KEYS */;
INSERT INTO `taxes` VALUES (1,1,'GST','10',NULL,NULL,NULL),(2,1,'CGST','18',NULL,NULL,NULL),(3,1,'VAT','10',NULL,NULL,NULL),(4,1,'IGST','10',NULL,NULL,NULL),(5,1,'UTGST','10',NULL,NULL,NULL);
/*!40000 ALTER TABLE `taxes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `teams`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `teams` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `team_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` int unsigned DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `teams_company_id_foreign` (`company_id`),
  KEY `teams_added_by_foreign` (`added_by`),
  KEY `teams_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `teams_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `teams_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `teams_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `teams` WRITE;
/*!40000 ALTER TABLE `teams` DISABLE KEYS */;
INSERT INTO `teams` VALUES (1,1,'Marketing',NULL,NULL,NULL,NULL,NULL),(2,1,'Sales',NULL,NULL,NULL,NULL,NULL),(3,1,'Human Resources',NULL,NULL,NULL,NULL,NULL),(4,1,'Public Relations',NULL,NULL,NULL,NULL,NULL),(5,1,'Research',NULL,NULL,NULL,NULL,NULL),(6,1,'Finance',NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `teams` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `theme_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `theme_settings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `panel` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `header_color` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `sidebar_color` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `sidebar_text_color` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_color` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '#ffffff',
  `user_css` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `sidebar_theme` enum('dark','light') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'dark',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `theme_settings_company_id_foreign` (`company_id`),
  CONSTRAINT `theme_settings_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `theme_settings` WRITE;
/*!40000 ALTER TABLE `theme_settings` DISABLE KEYS */;
INSERT INTO `theme_settings` VALUES (1,1,'admin','#1d82f5','#171F29','#99A5B5','#F7FAFF',NULL,'dark',NULL,NULL),(2,1,'project_admin','#1d82f5','#171F29','#99A5B5','#F7FAFF',NULL,'dark',NULL,NULL),(3,1,'employee','#1d82f5','#171F29','#99A5B5','#F7FAFF',NULL,'dark',NULL,NULL),(4,1,'client','#1d82f5','#171F29','#99A5B5','#F7FAFF',NULL,'dark',NULL,NULL);
/*!40000 ALTER TABLE `theme_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `ticket_agent_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ticket_agent_groups` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `agent_id` int unsigned NOT NULL,
  `group_id` int unsigned DEFAULT NULL,
  `status` enum('enabled','disabled') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'enabled',
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ticket_agent_groups_company_id_foreign` (`company_id`),
  KEY `ticket_agent_groups_agent_id_foreign` (`agent_id`),
  KEY `ticket_agent_groups_group_id_foreign` (`group_id`),
  KEY `ticket_agent_groups_added_by_foreign` (`added_by`),
  KEY `ticket_agent_groups_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `ticket_agent_groups_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ticket_agent_groups_agent_id_foreign` FOREIGN KEY (`agent_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ticket_agent_groups_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ticket_agent_groups_group_id_foreign` FOREIGN KEY (`group_id`) REFERENCES `ticket_groups` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ticket_agent_groups_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `ticket_agent_groups` WRITE;
/*!40000 ALTER TABLE `ticket_agent_groups` DISABLE KEYS */;
INSERT INTO `ticket_agent_groups` VALUES (1,1,18,3,'enabled',NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(2,1,2,3,'enabled',NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(3,1,19,5,'enabled',NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(4,1,14,2,'enabled',NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(5,1,1,4,'enabled',NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18');
/*!40000 ALTER TABLE `ticket_agent_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `ticket_channels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ticket_channels` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `channel_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ticket_channels_channel_name_company_id_unique` (`channel_name`,`company_id`),
  KEY `ticket_channels_company_id_foreign` (`company_id`),
  CONSTRAINT `ticket_channels_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `ticket_channels` WRITE;
/*!40000 ALTER TABLE `ticket_channels` DISABLE KEYS */;
INSERT INTO `ticket_channels` VALUES (1,1,'Email',NULL,NULL),(2,1,'Phone',NULL,NULL),(3,1,'Twitter',NULL,NULL),(4,1,'Facebook',NULL,NULL);
/*!40000 ALTER TABLE `ticket_channels` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `ticket_custom_forms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ticket_custom_forms` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `custom_fields_id` int unsigned DEFAULT NULL,
  `field_display_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'text',
  `field_order` int NOT NULL,
  `status` enum('active','inactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ticket_custom_forms_company_id_foreign` (`company_id`),
  KEY `ticket_custom_forms_custom_fields_id_foreign` (`custom_fields_id`),
  CONSTRAINT `ticket_custom_forms_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ticket_custom_forms_custom_fields_id_foreign` FOREIGN KEY (`custom_fields_id`) REFERENCES `custom_fields` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `ticket_custom_forms` WRITE;
/*!40000 ALTER TABLE `ticket_custom_forms` DISABLE KEYS */;
INSERT INTO `ticket_custom_forms` VALUES (1,1,NULL,'Name','name','text',1,'active',0,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(2,1,NULL,'Email','email','text',2,'active',0,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(3,1,NULL,'Ticket Subject','ticket_subject','text',3,'active',0,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(4,1,NULL,'Ticket Description','ticket_description','textarea',4,'active',0,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(5,1,NULL,'Type','type','select',5,'active',0,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(6,1,NULL,'Priority','priority','select',6,'active',0,'2023-04-06 06:33:16','2023-04-06 06:33:16'),(7,1,NULL,'Assign Group','assign_group','select',7,'active',0,'2023-04-06 06:33:16','2023-04-06 06:33:16');
/*!40000 ALTER TABLE `ticket_custom_forms` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `ticket_email_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ticket_email_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `mail_username` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_password` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_from_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_from_email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `imap_host` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `imap_port` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `imap_encryption` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(1) NOT NULL,
  `verified` tinyint(1) NOT NULL,
  `sync_interval` int NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ticket_email_settings_company_id_foreign` (`company_id`),
  CONSTRAINT `ticket_email_settings_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `ticket_email_settings` WRITE;
/*!40000 ALTER TABLE `ticket_email_settings` DISABLE KEYS */;
INSERT INTO `ticket_email_settings` VALUES (1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,1,'2023-04-06 06:33:16','2023-04-06 06:33:16');
/*!40000 ALTER TABLE `ticket_email_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `ticket_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ticket_files` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL,
  `ticket_reply_id` int unsigned NOT NULL,
  `filename` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `google_url` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hashname` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dropbox_link` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ticket_files_user_id_foreign` (`user_id`),
  KEY `ticket_files_ticket_reply_id_foreign` (`ticket_reply_id`),
  CONSTRAINT `ticket_files_ticket_reply_id_foreign` FOREIGN KEY (`ticket_reply_id`) REFERENCES `ticket_replies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ticket_files_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `ticket_files` WRITE;
/*!40000 ALTER TABLE `ticket_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `ticket_files` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `ticket_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ticket_groups` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `group_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ticket_groups_company_id_foreign` (`company_id`),
  CONSTRAINT `ticket_groups_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `ticket_groups` WRITE;
/*!40000 ALTER TABLE `ticket_groups` DISABLE KEYS */;
INSERT INTO `ticket_groups` VALUES (1,1,'Legal',NULL,NULL),(2,1,'Installation',NULL,NULL),(3,1,'Spam',NULL,NULL),(4,1,'Very Important',NULL,NULL),(5,1,'Technical',NULL,NULL);
/*!40000 ALTER TABLE `ticket_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `ticket_replies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ticket_replies` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `ticket_id` int unsigned NOT NULL,
  `user_id` int unsigned NOT NULL,
  `message` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `imap_message_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `imap_message_uid` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `imap_in_reply_to` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ticket_replies_ticket_id_foreign` (`ticket_id`),
  KEY `ticket_replies_user_id_foreign` (`user_id`),
  CONSTRAINT `ticket_replies_ticket_id_foreign` FOREIGN KEY (`ticket_id`) REFERENCES `tickets` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ticket_replies_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `ticket_replies` WRITE;
/*!40000 ALTER TABLE `ticket_replies` DISABLE KEYS */;
INSERT INTO `ticket_replies` VALUES (1,1,1,'I shall see it again, but it was the first.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(2,1,2,'White Rabbit as he came, \'Oh! the Duchess.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(3,1,2,'Alice, as she could do to come once a week: HE.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(4,1,2,'Gryphon. \'They can\'t have anything to say, she.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(5,1,16,'Alice. \'And where HAVE my shoulders got to? And.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(6,2,16,'Caterpillar, just as if he had to pinch it to be.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(7,2,1,'Hatter. This piece of it now in sight, hurrying.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(8,2,1,'Dormouse. \'Don\'t talk nonsense,\' said Alice very.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(9,2,1,'The adventures first,\' said the Pigeon; \'but I.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(10,2,2,'But here, to Alice\'s side as she spoke; \'either.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(11,3,2,'Which shall sing?\' \'Oh, YOU sing,\' said the.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(12,3,1,'Alice, \'a great girl like you,\' (she might well.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(13,3,1,'Presently she began very cautiously: \'But I.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(14,3,16,'And the Gryphon went on. Her listeners were.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(15,3,2,'The Footman seemed to be said. At last the Dodo.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(16,4,16,'Hatter. Alice felt dreadfully puzzled. The.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(17,4,1,'THAT direction,\' the Cat remarked. \'Don\'t be.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(18,4,1,'Come on!\' So they sat down, and the Dormouse.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(19,4,16,'Queen said to the dance. So they couldn\'t see.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(20,4,16,'Alice felt that there was a dispute going on.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(21,5,16,'CAN all that green stuff be?\' said Alice. \'And.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(22,5,2,'King said to herself, being rather proud of it.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(23,5,2,'Fish-Footman was gone, and, by the soldiers, who.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(24,5,1,'AT ALL. Soup does very well to introduce some.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(25,5,16,'Said the mouse to the company generally, \'You.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(26,6,2,'Duchess; \'and the moral of that is--\"The more.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(27,6,1,'Let me see: I\'ll give them a new idea to Alice.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(28,6,1,'Alice could only hear whispers now and then.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(29,6,1,'You gave us three or more; They all made of.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(30,6,2,'I\'ve said as yet.\' \'A cheap sort of idea that.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(31,7,2,'Alice. \'Come on, then!\' roared the Queen, and in.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(32,7,2,'Though they were gardeners, or soldiers, or.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(33,7,2,'Nile On every golden scale! \'How cheerfully he.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(34,7,1,'They had not gone much farther before she gave.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(35,7,1,'Duchess, it had no reason to be rude, so she set.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(36,8,2,'VERY unpleasant state of mind, she turned to the.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(37,8,1,'King said to herself, \'after such a subject! Our.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(38,8,16,'Alice loudly. \'The idea of the window, and on it.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(39,8,1,'Alice had been all the jelly-fish out of the.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(40,8,16,'They are waiting on the slate. \'Herald, read the.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(41,9,16,'So they began solemnly dancing round and look up.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(42,9,1,'When the pie was all dark overhead; before her.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(43,9,2,'King. The White Rabbit blew three blasts on the.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(44,9,2,'Lory. Alice replied in a low trembling voice.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(45,9,2,'Dormouse!\' And they pinched it on both sides of.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(46,10,16,'I know all sorts of things--I can\'t remember.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(47,10,2,'Hatter, \'or you\'ll be telling me next that you.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(48,10,16,'Mock Turtle replied in a day did you do either!\'.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(49,10,1,'Mock Turtle\'s Story \'You can\'t think how glad I.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18'),(50,10,1,'Heads below!\' (a loud crash)--\'Now, who did.',NULL,NULL,NULL,NULL,'2023-04-06 06:33:18','2023-04-06 06:33:18');
/*!40000 ALTER TABLE `ticket_replies` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `ticket_reply_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ticket_reply_templates` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `reply_heading` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `reply_text` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ticket_reply_templates_company_id_foreign` (`company_id`),
  CONSTRAINT `ticket_reply_templates_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `ticket_reply_templates` WRITE;
/*!40000 ALTER TABLE `ticket_reply_templates` DISABLE KEYS */;
/*!40000 ALTER TABLE `ticket_reply_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `ticket_tag_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ticket_tag_list` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `tag_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ticket_tag_list_company_id_foreign` (`company_id`),
  CONSTRAINT `ticket_tag_list_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `ticket_tag_list` WRITE;
/*!40000 ALTER TABLE `ticket_tag_list` DISABLE KEYS */;
/*!40000 ALTER TABLE `ticket_tag_list` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `ticket_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ticket_tags` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `tag_id` int unsigned NOT NULL,
  `ticket_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ticket_tags_company_id_foreign` (`company_id`),
  KEY `ticket_tags_tag_id_foreign` (`tag_id`),
  KEY `ticket_tags_ticket_id_foreign` (`ticket_id`),
  CONSTRAINT `ticket_tags_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ticket_tags_tag_id_foreign` FOREIGN KEY (`tag_id`) REFERENCES `ticket_tag_list` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ticket_tags_ticket_id_foreign` FOREIGN KEY (`ticket_id`) REFERENCES `tickets` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `ticket_tags` WRITE;
/*!40000 ALTER TABLE `ticket_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `ticket_tags` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `ticket_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ticket_types` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ticket_types_type_company_id_unique` (`type`,`company_id`),
  KEY `ticket_types_company_id_foreign` (`company_id`),
  CONSTRAINT `ticket_types_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `ticket_types` WRITE;
/*!40000 ALTER TABLE `ticket_types` DISABLE KEYS */;
INSERT INTO `ticket_types` VALUES (1,1,'Bug',NULL,NULL),(2,1,'Suggestion',NULL,NULL),(3,1,'Question',NULL,NULL),(4,1,'Sales',NULL,NULL),(5,1,'Code',NULL,NULL),(6,1,'Management',NULL,NULL),(7,1,'Problem',NULL,NULL),(8,1,'Incident',NULL,NULL),(9,1,'Feature Request',NULL,NULL);
/*!40000 ALTER TABLE `ticket_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `tickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tickets` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `ticket_number` bigint DEFAULT NULL,
  `company_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `subject` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` enum('open','pending','resolved','closed') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `priority` enum('low','medium','high','urgent') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'medium',
  `agent_id` int unsigned DEFAULT NULL,
  `channel_id` int unsigned DEFAULT NULL,
  `type_id` int unsigned DEFAULT NULL,
  `group_id` int unsigned DEFAULT NULL,
  `close_date` date DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `mobile` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country_id` int unsigned DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tickets_company_id_foreign` (`company_id`),
  KEY `tickets_user_id_foreign` (`user_id`),
  KEY `tickets_agent_id_foreign` (`agent_id`),
  KEY `tickets_channel_id_foreign` (`channel_id`),
  KEY `tickets_type_id_foreign` (`type_id`),
  KEY `tickets_country_id_foreign` (`country_id`),
  KEY `tickets_added_by_foreign` (`added_by`),
  KEY `tickets_last_updated_by_foreign` (`last_updated_by`),
  KEY `tickets_updated_at_index` (`updated_at`),
  KEY `tickets_group_id_foreign` (`group_id`),
  CONSTRAINT `tickets_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `tickets_agent_id_foreign` FOREIGN KEY (`agent_id`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `tickets_channel_id_foreign` FOREIGN KEY (`channel_id`) REFERENCES `ticket_channels` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `tickets_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `tickets_country_id_foreign` FOREIGN KEY (`country_id`) REFERENCES `countries` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `tickets_group_id_foreign` FOREIGN KEY (`group_id`) REFERENCES `ticket_groups` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `tickets_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `tickets_type_id_foreign` FOREIGN KEY (`type_id`) REFERENCES `ticket_types` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `tickets_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `tickets` WRITE;
/*!40000 ALTER TABLE `tickets` DISABLE KEYS */;
INSERT INTO `tickets` VALUES (1,1,1,16,'Minima ducimus quia.','pending','low',2,2,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-02-14 19:08:15','2023-04-06 06:33:18'),(2,2,1,16,'Doloribus.','pending','high',2,2,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-01-08 02:36:23','2023-04-06 06:33:18'),(3,3,1,16,'Deserunt voluptates.','resolved','high',2,2,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-03-19 03:35:39','2023-04-06 06:33:18'),(4,4,1,16,'Rerum itaque.','pending','medium',2,2,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-12 18:30:00','2023-04-06 06:33:18'),(5,5,1,16,'Omnis delectus.','pending','high',2,2,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-06 18:30:00','2023-04-06 06:33:18'),(6,6,1,16,'Ullam soluta ipsam.','open','high',2,2,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-03-15 04:23:50','2023-04-06 06:33:18'),(7,7,1,16,'Sed laborum at quos.','open','low',2,2,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-03-06 07:55:19','2023-04-06 06:33:18'),(8,8,1,16,'Accusamus molestiae.','closed','medium',2,2,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-05 18:30:00','2023-04-06 06:33:18'),(9,9,1,16,'Ipsa laboriosam.','resolved','urgent',2,2,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-01-23 20:07:11','2023-04-06 06:33:18'),(10,10,1,16,'Fuga fuga ut aut.','closed','low',2,2,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-03-28 16:33:59','2023-04-06 06:33:18');
/*!40000 ALTER TABLE `tickets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `translate_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `translate_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `google_key` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `translate_settings` WRITE;
/*!40000 ALTER TABLE `translate_settings` DISABLE KEYS */;
INSERT INTO `translate_settings` VALUES (1,NULL,'2023-04-06 06:33:16','2023-04-06 06:33:16');
/*!40000 ALTER TABLE `translate_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `unit_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `unit_types` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `unit_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `default` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `unit_types_company_id_foreign` (`company_id`),
  CONSTRAINT `unit_types_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `unit_types` WRITE;
/*!40000 ALTER TABLE `unit_types` DISABLE KEYS */;
INSERT INTO `unit_types` VALUES (1,1,'Qty\\hrs',1,'2023-04-06 06:33:16','2023-04-06 06:33:16');
/*!40000 ALTER TABLE `unit_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `universal_search`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `universal_search` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `searchable_id` int NOT NULL,
  `module_type` enum('ticket','invoice','notice','proposal','task','creditNote','client','employee','project','estimate','lead') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `route_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `universal_search_company_id_foreign` (`company_id`),
  CONSTRAINT `universal_search_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=126 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `universal_search` WRITE;
/*!40000 ALTER TABLE `universal_search` DISABLE KEYS */;
INSERT INTO `universal_search` VALUES (1,1,1,NULL,'Shyann Witting','employees.show','2023-04-06 06:33:16','2023-04-06 06:33:16'),(2,1,2,NULL,'Mariela Waters III','employees.show','2023-04-06 06:33:16','2023-04-06 06:33:16'),(3,1,3,NULL,'Bessie Rogahn','clients.show','2023-04-06 06:33:16','2023-04-06 06:33:16'),(4,1,4,NULL,'Reymundo Hagenes','clients.show','2023-04-06 06:33:17','2023-04-06 06:33:17'),(5,1,5,NULL,'Amanda Wilderman','clients.show','2023-04-06 06:33:17','2023-04-06 06:33:17'),(6,1,6,NULL,'Rowan Hodkiewicz','clients.show','2023-04-06 06:33:17','2023-04-06 06:33:17'),(7,1,7,NULL,'Emilie Bogisich','clients.show','2023-04-06 06:33:17','2023-04-06 06:33:17'),(8,1,8,NULL,'Raven Runolfsson','clients.show','2023-04-06 06:33:17','2023-04-06 06:33:17'),(9,1,9,NULL,'Cleora Feil','clients.show','2023-04-06 06:33:17','2023-04-06 06:33:17'),(10,1,10,NULL,'Prof. Bennie Dach II','clients.show','2023-04-06 06:33:17','2023-04-06 06:33:17'),(11,1,11,NULL,'Manuela Stark','clients.show','2023-04-06 06:33:17','2023-04-06 06:33:17'),(12,1,12,NULL,'Myra Quitzon','clients.show','2023-04-06 06:33:17','2023-04-06 06:33:17'),(13,1,13,NULL,'Mona Larson','clients.show','2023-04-06 06:33:17','2023-04-06 06:33:17'),(14,1,14,NULL,'Effie Rohan','employees.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(15,1,15,NULL,'Gloria Eichmann','employees.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(16,1,16,NULL,'Dr. Patsy Zemlak DVM','employees.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(17,1,17,NULL,'Mr. Pedro Moore III','employees.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(18,1,18,NULL,'Kian Bernhard','employees.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(19,1,19,NULL,'Jeremy O\'Kon','employees.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(20,1,20,NULL,'Arnaldo Kunde','employees.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(21,1,21,NULL,'Janae Kautzer Jr.','employees.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(22,1,22,NULL,'Dedric Koelpin','employees.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(23,1,23,NULL,'Isobel Batz','employees.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(24,1,1,NULL,'Weather forecasting system','projects.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(25,1,1,NULL,'Alice noticed with.','tasks.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(26,1,2,NULL,'RED rose-tree, and.','tasks.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(27,1,1,NULL,'Invoice INV#001','invoices.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(28,1,2,NULL,'Invoice INV#002','invoices.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(29,1,2,NULL,'Opinion mining for social networking platforms','projects.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(30,1,3,NULL,'Duchess: \'and the.','tasks.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(31,1,4,NULL,'I hadn\'t mentioned.','tasks.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(32,1,3,NULL,'Invoice INV#003','invoices.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(33,1,4,NULL,'Invoice INV#004','invoices.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(34,1,3,NULL,'E-learning platform for language courses','projects.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(35,1,5,NULL,'Queen! The Queen!\'.','tasks.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(36,1,6,NULL,'Alice again, in a.','tasks.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(37,1,7,NULL,'I\'ve finished.\' So.','tasks.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(38,1,5,NULL,'Invoice INV#005','invoices.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(39,1,6,NULL,'Invoice INV#006','invoices.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(40,1,7,NULL,'Invoice INV#007','invoices.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(41,1,4,NULL,'Create Design of worksuite','projects.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(42,1,8,NULL,'Gryphon. \'We can.','tasks.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(43,1,9,NULL,'Poor Alice! It was.','tasks.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(44,1,8,NULL,'Invoice INV#008','invoices.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(45,1,9,NULL,'Invoice INV#009','invoices.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(46,1,5,NULL,'Digital marketing and advertising service','projects.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(47,1,10,NULL,'Let me see: four.','tasks.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(48,1,11,NULL,'Dodo in an angry.','tasks.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(49,1,12,NULL,'Queen. \'Sentence.','tasks.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(50,1,10,NULL,'Invoice INV#010','invoices.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(51,1,11,NULL,'Invoice INV#011','invoices.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(52,1,12,NULL,'Invoice INV#012','invoices.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(53,1,6,NULL,'Bug tracker','projects.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(54,1,13,NULL,'Alice as he spoke.','tasks.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(55,1,14,NULL,'For some minutes.','tasks.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(56,1,15,NULL,'Alice, thinking it.','tasks.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(57,1,13,NULL,'Invoice INV#013','invoices.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(58,1,14,NULL,'Invoice INV#014','invoices.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(59,1,15,NULL,'Invoice INV#015','invoices.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(60,1,7,NULL,'Financial planning and budgeting tool','projects.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(61,1,16,NULL,'Duchess was VERY.','tasks.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(62,1,17,NULL,'Wonderland, though.','tasks.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(63,1,18,NULL,'Mock Turtle went.','tasks.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(64,1,16,NULL,'Invoice INV#016','invoices.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(65,1,17,NULL,'Invoice INV#017','invoices.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(66,1,18,NULL,'Invoice INV#018','invoices.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(67,1,8,NULL,'Project management and team collaboration tool','projects.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(68,1,19,NULL,'IS his business!\'.','tasks.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(69,1,19,NULL,'Invoice INV#019','invoices.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(70,1,9,NULL,'Artificial intelligence (AI) and machine learning (ML) development service','projects.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(71,1,20,NULL,'AT ALL. Soup does.','tasks.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(72,1,20,NULL,'Invoice INV#020','invoices.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(73,1,10,NULL,'Weather forecasting system','projects.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(74,1,21,NULL,'Alice, \'or perhaps.','tasks.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(75,1,21,NULL,'Invoice INV#021','invoices.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(76,1,1,NULL,'Ticket: Minima ducimus quia.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(77,1,1,NULL,'Ticket: Minima ducimus quia.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(78,1,1,NULL,'Ticket: Minima ducimus quia.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(79,1,1,NULL,'Ticket: Minima ducimus quia.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(80,1,1,NULL,'Ticket: Minima ducimus quia.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(81,1,2,NULL,'Ticket: Doloribus.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(82,1,2,NULL,'Ticket: Doloribus.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(83,1,2,NULL,'Ticket: Doloribus.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(84,1,2,NULL,'Ticket: Doloribus.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(85,1,2,NULL,'Ticket: Doloribus.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(86,1,3,NULL,'Ticket: Deserunt voluptates.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(87,1,3,NULL,'Ticket: Deserunt voluptates.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(88,1,3,NULL,'Ticket: Deserunt voluptates.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(89,1,3,NULL,'Ticket: Deserunt voluptates.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(90,1,3,NULL,'Ticket: Deserunt voluptates.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(91,1,4,NULL,'Ticket: Rerum itaque.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(92,1,4,NULL,'Ticket: Rerum itaque.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(93,1,4,NULL,'Ticket: Rerum itaque.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(94,1,4,NULL,'Ticket: Rerum itaque.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(95,1,4,NULL,'Ticket: Rerum itaque.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(96,1,5,NULL,'Ticket: Omnis delectus.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(97,1,5,NULL,'Ticket: Omnis delectus.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(98,1,5,NULL,'Ticket: Omnis delectus.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(99,1,5,NULL,'Ticket: Omnis delectus.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(100,1,5,NULL,'Ticket: Omnis delectus.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(101,1,6,NULL,'Ticket: Ullam soluta ipsam.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(102,1,6,NULL,'Ticket: Ullam soluta ipsam.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(103,1,6,NULL,'Ticket: Ullam soluta ipsam.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(104,1,6,NULL,'Ticket: Ullam soluta ipsam.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(105,1,6,NULL,'Ticket: Ullam soluta ipsam.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(106,1,7,NULL,'Ticket: Sed laborum at quos.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(107,1,7,NULL,'Ticket: Sed laborum at quos.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(108,1,7,NULL,'Ticket: Sed laborum at quos.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(109,1,7,NULL,'Ticket: Sed laborum at quos.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(110,1,7,NULL,'Ticket: Sed laborum at quos.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(111,1,8,NULL,'Ticket: Accusamus molestiae.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(112,1,8,NULL,'Ticket: Accusamus molestiae.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(113,1,8,NULL,'Ticket: Accusamus molestiae.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(114,1,8,NULL,'Ticket: Accusamus molestiae.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(115,1,8,NULL,'Ticket: Accusamus molestiae.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(116,1,9,NULL,'Ticket: Ipsa laboriosam.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(117,1,9,NULL,'Ticket: Ipsa laboriosam.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(118,1,9,NULL,'Ticket: Ipsa laboriosam.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(119,1,9,NULL,'Ticket: Ipsa laboriosam.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(120,1,9,NULL,'Ticket: Ipsa laboriosam.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(121,1,10,NULL,'Ticket: Fuga fuga ut aut.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(122,1,10,NULL,'Ticket: Fuga fuga ut aut.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(123,1,10,NULL,'Ticket: Fuga fuga ut aut.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(124,1,10,NULL,'Ticket: Fuga fuga ut aut.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18'),(125,1,10,NULL,'Ticket: Fuga fuga ut aut.','tickets.show','2023-04-06 06:33:18','2023-04-06 06:33:18');
/*!40000 ALTER TABLE `universal_search` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `user_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_activities` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `activity` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_activities_company_id_foreign` (`company_id`),
  KEY `user_activities_user_id_foreign` (`user_id`),
  KEY `user_activities_created_at_index` (`created_at`),
  CONSTRAINT `user_activities_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `user_activities_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `user_activities` WRITE;
/*!40000 ALTER TABLE `user_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_activities` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `user_invitations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_invitations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `invitation_type` enum('email','link') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'email',
  `email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invitation_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` enum('active','inactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `email_restriction` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_invitations_company_id_foreign` (`company_id`),
  KEY `user_invitations_user_id_foreign` (`user_id`),
  CONSTRAINT `user_invitations_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `user_invitations_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `user_invitations` WRITE;
/*!40000 ALTER TABLE `user_invitations` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_invitations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `user_leadboard_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_leadboard_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `board_column_id` int unsigned NOT NULL,
  `collapsed` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_leadboard_settings_company_id_foreign` (`company_id`),
  KEY `user_leadboard_settings_user_id_foreign` (`user_id`),
  KEY `user_leadboard_settings_board_column_id_foreign` (`board_column_id`),
  CONSTRAINT `user_leadboard_settings_board_column_id_foreign` FOREIGN KEY (`board_column_id`) REFERENCES `lead_status` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `user_leadboard_settings_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `user_leadboard_settings_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `user_leadboard_settings` WRITE;
/*!40000 ALTER TABLE `user_leadboard_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_leadboard_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `user_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_permissions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL,
  `permission_id` int unsigned NOT NULL,
  `permission_type_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_permissions_user_id_foreign` (`user_id`),
  KEY `user_permissions_permission_id_foreign` (`permission_id`),
  KEY `user_permissions_permission_type_id_foreign` (`permission_type_id`),
  CONSTRAINT `user_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `user_permissions_permission_type_id_foreign` FOREIGN KEY (`permission_type_id`) REFERENCES `permission_types` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `user_permissions_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8665 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `user_permissions` WRITE;
/*!40000 ALTER TABLE `user_permissions` DISABLE KEYS */;
INSERT INTO `user_permissions` VALUES (1,1,1,4,NULL,NULL),(2,1,2,4,NULL,NULL),(3,1,3,4,NULL,NULL),(4,1,4,4,NULL,NULL),(5,1,5,4,NULL,NULL),(6,1,6,4,NULL,NULL),(7,1,7,4,NULL,NULL),(8,1,8,4,NULL,NULL),(9,1,9,4,NULL,NULL),(10,1,10,4,NULL,NULL),(11,1,11,4,NULL,NULL),(12,1,12,4,NULL,NULL),(13,1,13,4,NULL,NULL),(14,1,14,4,NULL,NULL),(15,1,15,4,NULL,NULL),(16,1,16,4,NULL,NULL),(17,1,17,4,NULL,NULL),(18,1,18,4,NULL,NULL),(19,1,19,4,NULL,NULL),(20,1,20,4,NULL,NULL),(21,1,21,4,NULL,NULL),(22,1,22,4,NULL,NULL),(23,1,23,4,NULL,NULL),(24,1,24,4,NULL,NULL),(25,1,25,4,NULL,NULL),(26,1,26,4,NULL,NULL),(27,1,27,4,NULL,NULL),(28,1,28,4,NULL,NULL),(29,1,29,4,NULL,NULL),(30,1,30,4,NULL,NULL),(31,1,31,4,NULL,NULL),(32,1,32,4,NULL,NULL),(33,1,33,4,NULL,NULL),(34,1,34,4,NULL,NULL),(35,1,35,4,NULL,NULL),(36,1,36,4,NULL,NULL),(37,1,37,4,NULL,NULL),(38,1,38,4,NULL,NULL),(39,1,39,4,NULL,NULL),(40,1,40,4,NULL,NULL),(41,1,41,4,NULL,NULL),(42,1,42,4,NULL,NULL),(43,1,43,4,NULL,NULL),(44,1,44,4,NULL,NULL),(45,1,45,4,NULL,NULL),(46,1,46,4,NULL,NULL),(47,1,47,4,NULL,NULL),(48,1,48,4,NULL,NULL),(49,1,49,4,NULL,NULL),(50,1,50,4,NULL,NULL),(51,1,51,4,NULL,NULL),(52,1,52,4,NULL,NULL),(53,1,53,4,NULL,NULL),(54,1,54,4,NULL,NULL),(55,1,55,4,NULL,NULL),(56,1,56,4,NULL,NULL),(57,1,57,4,NULL,NULL),(58,1,58,4,NULL,NULL),(59,1,59,4,NULL,NULL),(60,1,60,4,NULL,NULL),(61,1,61,4,NULL,NULL),(62,1,62,4,NULL,NULL),(63,1,63,4,NULL,NULL),(64,1,64,4,NULL,NULL),(65,1,65,4,NULL,NULL),(66,1,66,4,NULL,NULL),(67,1,67,4,NULL,NULL),(68,1,68,4,NULL,NULL),(69,1,69,4,NULL,NULL),(70,1,70,4,NULL,NULL),(71,1,71,4,NULL,NULL),(72,1,72,4,NULL,NULL),(73,1,73,4,NULL,NULL),(74,1,74,4,NULL,NULL),(75,1,75,4,NULL,NULL),(76,1,76,4,NULL,NULL),(77,1,77,4,NULL,NULL),(78,1,78,4,NULL,NULL),(79,1,79,4,NULL,NULL),(80,1,80,4,NULL,NULL),(81,1,81,4,NULL,NULL),(82,1,82,4,NULL,NULL),(83,1,83,4,NULL,NULL),(84,1,84,4,NULL,NULL),(85,1,85,4,NULL,NULL),(86,1,86,4,NULL,NULL),(87,1,87,4,NULL,NULL),(88,1,88,4,NULL,NULL),(89,1,89,4,NULL,NULL),(90,1,90,4,NULL,NULL),(91,1,91,4,NULL,NULL),(92,1,92,4,NULL,NULL),(93,1,93,4,NULL,NULL),(94,1,94,4,NULL,NULL),(95,1,95,4,NULL,NULL),(96,1,96,4,NULL,NULL),(97,1,97,4,NULL,NULL),(98,1,98,4,NULL,NULL),(99,1,99,4,NULL,NULL),(100,1,100,4,NULL,NULL),(101,1,101,4,NULL,NULL),(102,1,102,4,NULL,NULL),(103,1,103,4,NULL,NULL),(104,1,104,4,NULL,NULL),(105,1,105,4,NULL,NULL),(106,1,106,4,NULL,NULL),(107,1,107,4,NULL,NULL),(108,1,108,4,NULL,NULL),(109,1,109,4,NULL,NULL),(110,1,110,4,NULL,NULL),(111,1,111,4,NULL,NULL),(112,1,112,4,NULL,NULL),(113,1,113,4,NULL,NULL),(114,1,114,4,NULL,NULL),(115,1,115,4,NULL,NULL),(116,1,116,4,NULL,NULL),(117,1,117,4,NULL,NULL),(118,1,118,4,NULL,NULL),(119,1,119,4,NULL,NULL),(120,1,120,4,NULL,NULL),(121,1,121,4,NULL,NULL),(122,1,122,4,NULL,NULL),(123,1,123,4,NULL,NULL),(124,1,124,4,NULL,NULL),(125,1,125,4,NULL,NULL),(126,1,126,4,NULL,NULL),(127,1,127,4,NULL,NULL),(128,1,128,4,NULL,NULL),(129,1,129,4,NULL,NULL),(130,1,130,4,NULL,NULL),(131,1,131,4,NULL,NULL),(132,1,132,4,NULL,NULL),(133,1,133,4,NULL,NULL),(134,1,134,4,NULL,NULL),(135,1,135,4,NULL,NULL),(136,1,136,4,NULL,NULL),(137,1,137,4,NULL,NULL),(138,1,138,4,NULL,NULL),(139,1,139,4,NULL,NULL),(140,1,140,4,NULL,NULL),(141,1,141,4,NULL,NULL),(142,1,142,4,NULL,NULL),(143,1,143,4,NULL,NULL),(144,1,144,4,NULL,NULL),(145,1,145,4,NULL,NULL),(146,1,146,4,NULL,NULL),(147,1,147,4,NULL,NULL),(148,1,148,4,NULL,NULL),(149,1,149,4,NULL,NULL),(150,1,150,4,NULL,NULL),(151,1,151,4,NULL,NULL),(152,1,152,4,NULL,NULL),(153,1,153,4,NULL,NULL),(154,1,154,4,NULL,NULL),(155,1,155,4,NULL,NULL),(156,1,156,4,NULL,NULL),(157,1,157,4,NULL,NULL),(158,1,158,4,NULL,NULL),(159,1,159,4,NULL,NULL),(160,1,160,4,NULL,NULL),(161,1,161,4,NULL,NULL),(162,1,162,4,NULL,NULL),(163,1,163,4,NULL,NULL),(164,1,164,4,NULL,NULL),(165,1,165,4,NULL,NULL),(166,1,166,4,NULL,NULL),(167,1,167,4,NULL,NULL),(168,1,168,4,NULL,NULL),(169,1,169,4,NULL,NULL),(170,1,170,4,NULL,NULL),(171,1,171,4,NULL,NULL),(172,1,172,4,NULL,NULL),(173,1,173,4,NULL,NULL),(174,1,174,4,NULL,NULL),(175,1,175,4,NULL,NULL),(176,1,176,4,NULL,NULL),(177,1,177,4,NULL,NULL),(178,1,178,4,NULL,NULL),(179,1,179,4,NULL,NULL),(180,1,180,4,NULL,NULL),(181,1,181,4,NULL,NULL),(182,1,182,4,NULL,NULL),(183,1,183,4,NULL,NULL),(184,1,184,4,NULL,NULL),(185,1,185,4,NULL,NULL),(186,1,186,4,NULL,NULL),(187,1,187,4,NULL,NULL),(188,1,188,4,NULL,NULL),(189,1,189,4,NULL,NULL),(190,1,190,4,NULL,NULL),(191,1,191,4,NULL,NULL),(192,1,192,4,NULL,NULL),(193,1,193,4,NULL,NULL),(194,1,194,4,NULL,NULL),(195,1,195,4,NULL,NULL),(196,1,196,4,NULL,NULL),(197,1,197,4,NULL,NULL),(198,1,198,4,NULL,NULL),(199,1,199,4,NULL,NULL),(200,1,200,4,NULL,NULL),(201,1,201,4,NULL,NULL),(202,1,202,4,NULL,NULL),(203,1,203,4,NULL,NULL),(204,1,204,4,NULL,NULL),(205,1,205,4,NULL,NULL),(206,1,206,4,NULL,NULL),(207,1,207,4,NULL,NULL),(208,1,208,4,NULL,NULL),(209,1,209,4,NULL,NULL),(210,1,210,4,NULL,NULL),(211,1,211,4,NULL,NULL),(212,1,212,4,NULL,NULL),(213,1,213,4,NULL,NULL),(214,1,214,4,NULL,NULL),(215,1,215,4,NULL,NULL),(216,1,216,4,NULL,NULL),(217,1,217,4,NULL,NULL),(218,1,218,4,NULL,NULL),(219,1,219,4,NULL,NULL),(220,1,220,4,NULL,NULL),(221,1,221,4,NULL,NULL),(222,1,222,4,NULL,NULL),(223,1,223,4,NULL,NULL),(224,1,224,4,NULL,NULL),(225,1,225,4,NULL,NULL),(226,1,226,4,NULL,NULL),(227,1,227,4,NULL,NULL),(228,1,228,4,NULL,NULL),(229,1,229,4,NULL,NULL),(230,1,230,4,NULL,NULL),(231,1,231,4,NULL,NULL),(232,1,232,4,NULL,NULL),(233,1,233,4,NULL,NULL),(234,1,234,4,NULL,NULL),(235,1,235,4,NULL,NULL),(236,1,236,4,NULL,NULL),(237,1,237,4,NULL,NULL),(238,1,238,4,NULL,NULL),(239,1,239,4,NULL,NULL),(240,1,240,4,NULL,NULL),(241,1,241,4,NULL,NULL),(242,1,242,4,NULL,NULL),(243,1,243,4,NULL,NULL),(244,1,244,4,NULL,NULL),(245,1,245,4,NULL,NULL),(246,1,246,4,NULL,NULL),(247,1,247,4,NULL,NULL),(248,1,248,4,NULL,NULL),(249,1,249,4,NULL,NULL),(250,1,250,4,NULL,NULL),(251,1,251,4,NULL,NULL),(252,1,252,4,NULL,NULL),(253,1,253,4,NULL,NULL),(254,1,254,4,NULL,NULL),(255,1,255,4,NULL,NULL),(256,1,256,4,NULL,NULL),(257,1,257,4,NULL,NULL),(258,1,258,4,NULL,NULL),(259,1,259,4,NULL,NULL),(260,1,260,4,NULL,NULL),(261,1,261,4,NULL,NULL),(262,1,262,4,NULL,NULL),(263,1,263,4,NULL,NULL),(264,1,264,4,NULL,NULL),(265,1,265,4,NULL,NULL),(266,1,266,4,NULL,NULL),(267,1,267,4,NULL,NULL),(268,1,268,4,NULL,NULL),(269,1,269,4,NULL,NULL),(270,1,270,4,NULL,NULL),(271,1,271,4,NULL,NULL),(272,1,272,4,NULL,NULL),(273,1,273,4,NULL,NULL),(274,1,274,4,NULL,NULL),(275,1,275,4,NULL,NULL),(276,1,276,4,NULL,NULL),(277,1,277,4,NULL,NULL),(278,1,278,4,NULL,NULL),(279,1,279,4,NULL,NULL),(280,1,280,4,NULL,NULL),(281,1,281,4,NULL,NULL),(282,1,282,4,NULL,NULL),(283,1,283,4,NULL,NULL),(284,1,284,4,NULL,NULL),(285,1,285,4,NULL,NULL),(286,1,286,4,NULL,NULL),(287,1,287,4,NULL,NULL),(288,1,288,4,NULL,NULL),(289,1,289,4,NULL,NULL),(290,1,290,4,NULL,NULL),(291,1,291,4,NULL,NULL),(292,1,292,4,NULL,NULL),(293,1,293,4,NULL,NULL),(294,1,294,4,NULL,NULL),(295,1,295,4,NULL,NULL),(296,1,296,4,NULL,NULL),(297,1,297,4,NULL,NULL),(298,1,298,4,NULL,NULL),(299,1,299,4,NULL,NULL),(300,1,300,4,NULL,NULL),(301,1,301,4,NULL,NULL),(302,1,302,4,NULL,NULL),(303,1,303,4,NULL,NULL),(304,1,304,4,NULL,NULL),(305,1,305,4,NULL,NULL),(306,1,306,4,NULL,NULL),(307,1,307,4,NULL,NULL),(308,1,308,4,NULL,NULL),(309,1,309,4,NULL,NULL),(310,1,310,4,NULL,NULL),(311,1,311,4,NULL,NULL),(312,1,312,4,NULL,NULL),(313,1,313,4,NULL,NULL),(314,1,314,4,NULL,NULL),(315,1,315,4,NULL,NULL),(316,1,316,4,NULL,NULL),(317,1,317,4,NULL,NULL),(318,1,318,4,NULL,NULL),(319,1,319,4,NULL,NULL),(320,1,320,4,NULL,NULL),(321,1,321,4,NULL,NULL),(322,1,322,4,NULL,NULL),(323,1,323,4,NULL,NULL),(324,1,324,4,NULL,NULL),(325,1,325,4,NULL,NULL),(326,1,326,4,NULL,NULL),(327,1,327,4,NULL,NULL),(328,1,328,4,NULL,NULL),(329,1,329,4,NULL,NULL),(330,1,330,4,NULL,NULL),(331,1,331,4,NULL,NULL),(332,1,332,4,NULL,NULL),(333,1,333,4,NULL,NULL),(334,1,334,4,NULL,NULL),(335,1,335,4,NULL,NULL),(336,1,336,4,NULL,NULL),(337,1,337,4,NULL,NULL),(338,1,338,4,NULL,NULL),(339,1,339,4,NULL,NULL),(340,1,340,4,NULL,NULL),(341,1,341,4,NULL,NULL),(342,1,342,4,NULL,NULL),(343,1,343,4,NULL,NULL),(344,1,344,4,NULL,NULL),(345,1,345,4,NULL,NULL),(346,1,346,4,NULL,NULL),(347,1,347,4,NULL,NULL),(348,1,348,4,NULL,NULL),(349,1,349,4,NULL,NULL),(350,1,350,4,NULL,NULL),(351,1,351,4,NULL,NULL),(352,1,352,4,NULL,NULL),(353,1,353,4,NULL,NULL),(354,1,354,4,NULL,NULL),(355,1,355,4,NULL,NULL),(356,1,356,4,NULL,NULL),(357,1,357,4,NULL,NULL),(358,1,358,4,NULL,NULL),(359,1,359,4,NULL,NULL),(360,1,360,4,NULL,NULL),(361,1,361,4,NULL,NULL),(362,3,1,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(363,3,2,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(364,3,3,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(365,3,4,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(366,3,5,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(367,3,6,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(368,3,7,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(369,3,8,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(370,3,9,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(371,3,10,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(372,3,11,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(373,3,12,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(374,3,13,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(375,3,14,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(376,3,15,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(377,3,16,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(378,3,17,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(379,3,18,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(380,3,19,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(381,3,20,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(382,3,21,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(383,3,22,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(384,3,23,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(385,3,24,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(386,3,25,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(387,3,26,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(388,3,27,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(389,3,28,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(390,3,29,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(391,3,30,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(392,3,31,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(393,3,32,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(394,3,33,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(395,3,34,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(396,3,35,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(397,3,36,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(398,3,37,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(399,3,38,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(400,3,39,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(401,3,40,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(402,3,41,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(403,3,42,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(404,3,43,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(405,3,44,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(406,3,45,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(407,3,46,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(408,3,47,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(409,3,48,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(410,3,49,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(411,3,50,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(412,3,51,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(413,3,52,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(414,3,53,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(415,3,54,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(416,3,55,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(417,3,56,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(418,3,57,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(419,3,58,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(420,3,59,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(421,3,60,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(422,3,61,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(423,3,62,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(424,3,63,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(425,3,64,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(426,3,65,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(427,3,66,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(428,3,67,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(429,3,68,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(430,3,69,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(431,3,70,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(432,3,71,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(433,3,72,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(434,3,73,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(435,3,74,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(436,3,75,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(437,3,76,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(438,3,77,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(439,3,78,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(440,3,79,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(441,3,80,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(442,3,81,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(443,3,82,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(444,3,83,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(445,3,84,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(446,3,85,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(447,3,86,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(448,3,87,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(449,3,88,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(450,3,89,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(451,3,90,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(452,3,91,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(453,3,92,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(454,3,93,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(455,3,94,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(456,3,95,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(457,3,96,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(458,3,97,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(459,3,98,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(460,3,99,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(461,3,100,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(462,3,101,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(463,3,102,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(464,3,103,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(465,3,104,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(466,3,105,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(467,3,106,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(468,3,107,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(469,3,108,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(470,3,109,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(471,3,110,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(472,3,111,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(473,3,112,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(474,3,113,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(475,3,114,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(476,3,115,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(477,3,116,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(478,3,117,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(479,3,118,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(480,3,119,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(481,3,120,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(482,3,121,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(483,3,122,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(484,3,123,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(485,3,124,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(486,3,125,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(487,3,126,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(488,3,127,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(489,3,128,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(490,3,129,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(491,3,130,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(492,3,131,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(493,3,132,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(494,3,133,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(495,3,134,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(496,3,135,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(497,3,136,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(498,3,137,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(499,3,138,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(500,3,139,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(501,3,140,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(502,3,141,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(503,3,142,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(504,3,143,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(505,3,144,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(506,3,145,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(507,3,146,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(508,3,147,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(509,3,148,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(510,3,149,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(511,3,150,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(512,3,151,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(513,3,152,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(514,3,153,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(515,3,154,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(516,3,155,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(517,3,156,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(518,3,157,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(519,3,158,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(520,3,159,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(521,3,160,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(522,3,161,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(523,3,162,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(524,3,163,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(525,3,164,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(526,3,165,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(527,3,166,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(528,3,167,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(529,3,168,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(530,3,169,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(531,3,170,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(532,3,171,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(533,3,172,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(534,3,173,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(535,3,174,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(536,3,175,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(537,3,176,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(538,3,177,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(539,3,178,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(540,3,179,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(541,3,180,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(542,3,181,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(543,3,182,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(544,3,183,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(545,3,184,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(546,3,185,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(547,3,186,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(548,3,187,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(549,3,188,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(550,3,189,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(551,3,190,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(552,3,191,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(553,3,192,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(554,3,193,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(555,3,194,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(556,3,195,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(557,3,196,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(558,3,197,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(559,3,198,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(560,3,199,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(561,3,200,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(562,3,201,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(563,3,202,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(564,3,203,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(565,3,204,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(566,3,205,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(567,3,206,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(568,3,207,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(569,3,208,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(570,3,209,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(571,3,210,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(572,3,211,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(573,3,212,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(574,3,213,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(575,3,214,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(576,3,215,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(577,3,216,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(578,3,217,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(579,3,218,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(580,3,219,3,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(581,3,220,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(582,3,221,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(583,3,222,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(584,3,223,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(585,3,224,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(586,3,225,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(587,3,226,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(588,3,227,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(589,3,228,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(590,3,229,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(591,3,230,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(592,3,231,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(593,3,232,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(594,3,233,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(595,3,234,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(596,3,235,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(597,3,236,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(598,3,237,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(599,3,238,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(600,3,239,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(601,3,240,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(602,3,241,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(603,3,242,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(604,3,243,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(605,3,244,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(606,3,245,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(607,3,246,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(608,3,247,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(609,3,248,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(610,3,249,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(611,3,250,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(612,3,251,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(613,3,252,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(614,3,253,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(615,3,254,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(616,3,255,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(617,3,256,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(618,3,257,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(619,3,258,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(620,3,259,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(621,3,260,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(622,3,261,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(623,3,262,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(624,3,263,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(625,3,264,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(626,3,265,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(627,3,266,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(628,3,267,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(629,3,268,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(630,3,269,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(631,3,270,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(632,3,271,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(633,3,272,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(634,3,273,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(635,3,274,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(636,3,275,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(637,3,276,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(638,3,277,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(639,3,278,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(640,3,279,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(641,3,280,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(642,3,281,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(643,3,282,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(644,3,283,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(645,3,284,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(646,3,285,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(647,3,286,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(648,3,287,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(649,3,288,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(650,3,289,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(651,3,290,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(652,3,291,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(653,3,292,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(654,3,293,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(655,3,294,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(656,3,295,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(657,3,296,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(658,3,297,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(659,3,298,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(660,3,299,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(661,3,300,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(662,3,301,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(663,3,302,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(664,3,303,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(665,3,304,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(666,3,305,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(667,3,306,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(668,3,307,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(669,3,308,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(670,3,309,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(671,3,310,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(672,3,311,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(673,3,312,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(674,3,313,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(675,3,314,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(676,3,315,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(677,3,316,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(678,3,317,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(679,3,318,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(680,3,319,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(681,3,320,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(682,3,321,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(683,3,322,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(684,3,323,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(685,3,324,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(686,3,325,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(687,3,326,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(688,3,327,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(689,3,328,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(690,3,329,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(691,3,330,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(692,3,331,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(693,3,332,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(694,3,333,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(695,3,334,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(696,3,335,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(697,3,336,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(698,3,337,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(699,3,338,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(700,3,339,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(701,3,340,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(702,3,341,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(703,3,342,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(704,3,343,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(705,3,344,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(706,3,345,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(707,3,346,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(708,3,347,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(709,3,348,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(710,3,349,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(711,3,350,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(712,3,351,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(713,3,352,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(714,3,353,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(715,3,354,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(716,3,355,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(717,3,356,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(718,3,357,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(719,3,358,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(720,3,359,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(721,3,360,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(722,3,361,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(723,4,1,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(724,4,2,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(725,4,3,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(726,4,4,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(727,4,5,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(728,4,6,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(729,4,7,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(730,4,8,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(731,4,9,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(732,4,10,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(733,4,11,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(734,4,12,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(735,4,13,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(736,4,14,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(737,4,15,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(738,4,16,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(739,4,17,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(740,4,18,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(741,4,19,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(742,4,20,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(743,4,21,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(744,4,22,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(745,4,23,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(746,4,24,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(747,4,25,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(748,4,26,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(749,4,27,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(750,4,28,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(751,4,29,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(752,4,30,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(753,4,31,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(754,4,32,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(755,4,33,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(756,4,34,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(757,4,35,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(758,4,36,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(759,4,37,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(760,4,38,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(761,4,39,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(762,4,40,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(763,4,41,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(764,4,42,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(765,4,43,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(766,4,44,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(767,4,45,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(768,4,46,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(769,4,47,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(770,4,48,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(771,4,49,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(772,4,50,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(773,4,51,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(774,4,52,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(775,4,53,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(776,4,54,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(777,4,55,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(778,4,56,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(779,4,57,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(780,4,58,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(781,4,59,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(782,4,60,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(783,4,61,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(784,4,62,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(785,4,63,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(786,4,64,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(787,4,65,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(788,4,66,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(789,4,67,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(790,4,68,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(791,4,69,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(792,4,70,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(793,4,71,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(794,4,72,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(795,4,73,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(796,4,74,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(797,4,75,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(798,4,76,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(799,4,77,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(800,4,78,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(801,4,79,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(802,4,80,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(803,4,81,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(804,4,82,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(805,4,83,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(806,4,84,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(807,4,85,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(808,4,86,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(809,4,87,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(810,4,88,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(811,4,89,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(812,4,90,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(813,4,91,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(814,4,92,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(815,4,93,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(816,4,94,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(817,4,95,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(818,4,96,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(819,4,97,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(820,4,98,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(821,4,99,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(822,4,100,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(823,4,101,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(824,4,102,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(825,4,103,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(826,4,104,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(827,4,105,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(828,4,106,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(829,4,107,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(830,4,108,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(831,4,109,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(832,4,110,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(833,4,111,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(834,4,112,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(835,4,113,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(836,4,114,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(837,4,115,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(838,4,116,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(839,4,117,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(840,4,118,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(841,4,119,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(842,4,120,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(843,4,121,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(844,4,122,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(845,4,123,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(846,4,124,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(847,4,125,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(848,4,126,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(849,4,127,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(850,4,128,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(851,4,129,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(852,4,130,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(853,4,131,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(854,4,132,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(855,4,133,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(856,4,134,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(857,4,135,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(858,4,136,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(859,4,137,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(860,4,138,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(861,4,139,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(862,4,140,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(863,4,141,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(864,4,142,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(865,4,143,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(866,4,144,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(867,4,145,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(868,4,146,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(869,4,147,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(870,4,148,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(871,4,149,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(872,4,150,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(873,4,151,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(874,4,152,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(875,4,153,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(876,4,154,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(877,4,155,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(878,4,156,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(879,4,157,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(880,4,158,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(881,4,159,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(882,4,160,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(883,4,161,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(884,4,162,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(885,4,163,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(886,4,164,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(887,4,165,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(888,4,166,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(889,4,167,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(890,4,168,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(891,4,169,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(892,4,170,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(893,4,171,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(894,4,172,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(895,4,173,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(896,4,174,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(897,4,175,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(898,4,176,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(899,4,177,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(900,4,178,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(901,4,179,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(902,4,180,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(903,4,181,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(904,4,182,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(905,4,183,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(906,4,184,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(907,4,185,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(908,4,186,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(909,4,187,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(910,4,188,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(911,4,189,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(912,4,190,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(913,4,191,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(914,4,192,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(915,4,193,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(916,4,194,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(917,4,195,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(918,4,196,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(919,4,197,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(920,4,198,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(921,4,199,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(922,4,200,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(923,4,201,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(924,4,202,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(925,4,203,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(926,4,204,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(927,4,205,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(928,4,206,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(929,4,207,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(930,4,208,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(931,4,209,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(932,4,210,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(933,4,211,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(934,4,212,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(935,4,213,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(936,4,214,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(937,4,215,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(938,4,216,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(939,4,217,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(940,4,218,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(941,4,219,3,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(942,4,220,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(943,4,221,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(944,4,222,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(945,4,223,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(946,4,224,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(947,4,225,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(948,4,226,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(949,4,227,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(950,4,228,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(951,4,229,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(952,4,230,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(953,4,231,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(954,4,232,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(955,4,233,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(956,4,234,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(957,4,235,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(958,4,236,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(959,4,237,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(960,4,238,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(961,4,239,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(962,4,240,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(963,4,241,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(964,4,242,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(965,4,243,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(966,4,244,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(967,4,245,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(968,4,246,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(969,4,247,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(970,4,248,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(971,4,249,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(972,4,250,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(973,4,251,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(974,4,252,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(975,4,253,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(976,4,254,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(977,4,255,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(978,4,256,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(979,4,257,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(980,4,258,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(981,4,259,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(982,4,260,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(983,4,261,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(984,4,262,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(985,4,263,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(986,4,264,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(987,4,265,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(988,4,266,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(989,4,267,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(990,4,268,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(991,4,269,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(992,4,270,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(993,4,271,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(994,4,272,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(995,4,273,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(996,4,274,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(997,4,275,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(998,4,276,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(999,4,277,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1000,4,278,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1001,4,279,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1002,4,280,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1003,4,281,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1004,4,282,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1005,4,283,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1006,4,284,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1007,4,285,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1008,4,286,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1009,4,287,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1010,4,288,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1011,4,289,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1012,4,290,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1013,4,291,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1014,4,292,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1015,4,293,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1016,4,294,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1017,4,295,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1018,4,296,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1019,4,297,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1020,4,298,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1021,4,299,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1022,4,300,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1023,4,301,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1024,4,302,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1025,4,303,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1026,4,304,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1027,4,305,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1028,4,306,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1029,4,307,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1030,4,308,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1031,4,309,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1032,4,310,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1033,4,311,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1034,4,312,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1035,4,313,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1036,4,314,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1037,4,315,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1038,4,316,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1039,4,317,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1040,4,318,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1041,4,319,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1042,4,320,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1043,4,321,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1044,4,322,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1045,4,323,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1046,4,324,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1047,4,325,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1048,4,326,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1049,4,327,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1050,4,328,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1051,4,329,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1052,4,330,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1053,4,331,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1054,4,332,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1055,4,333,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1056,4,334,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1057,4,335,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1058,4,336,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1059,4,337,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1060,4,338,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1061,4,339,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1062,4,340,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1063,4,341,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1064,4,342,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1065,4,343,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1066,4,344,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1067,4,345,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1068,4,346,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1069,4,347,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1070,4,348,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1071,4,349,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1072,4,350,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1073,4,351,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1074,4,352,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1075,4,353,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1076,4,354,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1077,4,355,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1078,4,356,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1079,4,357,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1080,4,358,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1081,4,359,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1082,4,360,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1083,4,361,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1084,5,1,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1085,5,2,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1086,5,3,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1087,5,4,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1088,5,5,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1089,5,6,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1090,5,7,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1091,5,8,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1092,5,9,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1093,5,10,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1094,5,11,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1095,5,12,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1096,5,13,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1097,5,14,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1098,5,15,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1099,5,16,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1100,5,17,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1101,5,18,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1102,5,19,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1103,5,20,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1104,5,21,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1105,5,22,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1106,5,23,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1107,5,24,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1108,5,25,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1109,5,26,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1110,5,27,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1111,5,28,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1112,5,29,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1113,5,30,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1114,5,31,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1115,5,32,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1116,5,33,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1117,5,34,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1118,5,35,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1119,5,36,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1120,5,37,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1121,5,38,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1122,5,39,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1123,5,40,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1124,5,41,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1125,5,42,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1126,5,43,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1127,5,44,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1128,5,45,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1129,5,46,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1130,5,47,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1131,5,48,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1132,5,49,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1133,5,50,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1134,5,51,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1135,5,52,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1136,5,53,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1137,5,54,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1138,5,55,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1139,5,56,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1140,5,57,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1141,5,58,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1142,5,59,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1143,5,60,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1144,5,61,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1145,5,62,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1146,5,63,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1147,5,64,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1148,5,65,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1149,5,66,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1150,5,67,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1151,5,68,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1152,5,69,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1153,5,70,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1154,5,71,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1155,5,72,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1156,5,73,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1157,5,74,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1158,5,75,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1159,5,76,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1160,5,77,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1161,5,78,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1162,5,79,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1163,5,80,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1164,5,81,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1165,5,82,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1166,5,83,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1167,5,84,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1168,5,85,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1169,5,86,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1170,5,87,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1171,5,88,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1172,5,89,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1173,5,90,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1174,5,91,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1175,5,92,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1176,5,93,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1177,5,94,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1178,5,95,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1179,5,96,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1180,5,97,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1181,5,98,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1182,5,99,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1183,5,100,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1184,5,101,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1185,5,102,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1186,5,103,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1187,5,104,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1188,5,105,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1189,5,106,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1190,5,107,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1191,5,108,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1192,5,109,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1193,5,110,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1194,5,111,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1195,5,112,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1196,5,113,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1197,5,114,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1198,5,115,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1199,5,116,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1200,5,117,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1201,5,118,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1202,5,119,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1203,5,120,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1204,5,121,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1205,5,122,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1206,5,123,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1207,5,124,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1208,5,125,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1209,5,126,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1210,5,127,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1211,5,128,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1212,5,129,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1213,5,130,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1214,5,131,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1215,5,132,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1216,5,133,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1217,5,134,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1218,5,135,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1219,5,136,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1220,5,137,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1221,5,138,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1222,5,139,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1223,5,140,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1224,5,141,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1225,5,142,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1226,5,143,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1227,5,144,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1228,5,145,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1229,5,146,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1230,5,147,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1231,5,148,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1232,5,149,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1233,5,150,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1234,5,151,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1235,5,152,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1236,5,153,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1237,5,154,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1238,5,155,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1239,5,156,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1240,5,157,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1241,5,158,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1242,5,159,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1243,5,160,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1244,5,161,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1245,5,162,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1246,5,163,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1247,5,164,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1248,5,165,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1249,5,166,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1250,5,167,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1251,5,168,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1252,5,169,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1253,5,170,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1254,5,171,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1255,5,172,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1256,5,173,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1257,5,174,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1258,5,175,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1259,5,176,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1260,5,177,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1261,5,178,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1262,5,179,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1263,5,180,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1264,5,181,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1265,5,182,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1266,5,183,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1267,5,184,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1268,5,185,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1269,5,186,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1270,5,187,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1271,5,188,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1272,5,189,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1273,5,190,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1274,5,191,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1275,5,192,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1276,5,193,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1277,5,194,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1278,5,195,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1279,5,196,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1280,5,197,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1281,5,198,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1282,5,199,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1283,5,200,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1284,5,201,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1285,5,202,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1286,5,203,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1287,5,204,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1288,5,205,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1289,5,206,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1290,5,207,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1291,5,208,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1292,5,209,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1293,5,210,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1294,5,211,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1295,5,212,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1296,5,213,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1297,5,214,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1298,5,215,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1299,5,216,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1300,5,217,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1301,5,218,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1302,5,219,3,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1303,5,220,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1304,5,221,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1305,5,222,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1306,5,223,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1307,5,224,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1308,5,225,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1309,5,226,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1310,5,227,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1311,5,228,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1312,5,229,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1313,5,230,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1314,5,231,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1315,5,232,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1316,5,233,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1317,5,234,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1318,5,235,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1319,5,236,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1320,5,237,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1321,5,238,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1322,5,239,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1323,5,240,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1324,5,241,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1325,5,242,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1326,5,243,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1327,5,244,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1328,5,245,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1329,5,246,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1330,5,247,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1331,5,248,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1332,5,249,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1333,5,250,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1334,5,251,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1335,5,252,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1336,5,253,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1337,5,254,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1338,5,255,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1339,5,256,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1340,5,257,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1341,5,258,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1342,5,259,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1343,5,260,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1344,5,261,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1345,5,262,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1346,5,263,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1347,5,264,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1348,5,265,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1349,5,266,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1350,5,267,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1351,5,268,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1352,5,269,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1353,5,270,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1354,5,271,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1355,5,272,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1356,5,273,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1357,5,274,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1358,5,275,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1359,5,276,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1360,5,277,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1361,5,278,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1362,5,279,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1363,5,280,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1364,5,281,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1365,5,282,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1366,5,283,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1367,5,284,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1368,5,285,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1369,5,286,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1370,5,287,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1371,5,288,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1372,5,289,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1373,5,290,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1374,5,291,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1375,5,292,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1376,5,293,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1377,5,294,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1378,5,295,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1379,5,296,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1380,5,297,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1381,5,298,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1382,5,299,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1383,5,300,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1384,5,301,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1385,5,302,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1386,5,303,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1387,5,304,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1388,5,305,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1389,5,306,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1390,5,307,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1391,5,308,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1392,5,309,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1393,5,310,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1394,5,311,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1395,5,312,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1396,5,313,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1397,5,314,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1398,5,315,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1399,5,316,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1400,5,317,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1401,5,318,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1402,5,319,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1403,5,320,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1404,5,321,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1405,5,322,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1406,5,323,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1407,5,324,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1408,5,325,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1409,5,326,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1410,5,327,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1411,5,328,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1412,5,329,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1413,5,330,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1414,5,331,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1415,5,332,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1416,5,333,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1417,5,334,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1418,5,335,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1419,5,336,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1420,5,337,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1421,5,338,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1422,5,339,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1423,5,340,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1424,5,341,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1425,5,342,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1426,5,343,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1427,5,344,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1428,5,345,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1429,5,346,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1430,5,347,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1431,5,348,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1432,5,349,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1433,5,350,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1434,5,351,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1435,5,352,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1436,5,353,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1437,5,354,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1438,5,355,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1439,5,356,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1440,5,357,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1441,5,358,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1442,5,359,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1443,5,360,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1444,5,361,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1445,6,1,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1446,6,2,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1447,6,3,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1448,6,4,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1449,6,5,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1450,6,6,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1451,6,7,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1452,6,8,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1453,6,9,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1454,6,10,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1455,6,11,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1456,6,12,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1457,6,13,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1458,6,14,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1459,6,15,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1460,6,16,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1461,6,17,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1462,6,18,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1463,6,19,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1464,6,20,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1465,6,21,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1466,6,22,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1467,6,23,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1468,6,24,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1469,6,25,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1470,6,26,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1471,6,27,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1472,6,28,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1473,6,29,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1474,6,30,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1475,6,31,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1476,6,32,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1477,6,33,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1478,6,34,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1479,6,35,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1480,6,36,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1481,6,37,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1482,6,38,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1483,6,39,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1484,6,40,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1485,6,41,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1486,6,42,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1487,6,43,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1488,6,44,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1489,6,45,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1490,6,46,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1491,6,47,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1492,6,48,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1493,6,49,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1494,6,50,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1495,6,51,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1496,6,52,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1497,6,53,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1498,6,54,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1499,6,55,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1500,6,56,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1501,6,57,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1502,6,58,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1503,6,59,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1504,6,60,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1505,6,61,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1506,6,62,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1507,6,63,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1508,6,64,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1509,6,65,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1510,6,66,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1511,6,67,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1512,6,68,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1513,6,69,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1514,6,70,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1515,6,71,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1516,6,72,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1517,6,73,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1518,6,74,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1519,6,75,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1520,6,76,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1521,6,77,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1522,6,78,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1523,6,79,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1524,6,80,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1525,6,81,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1526,6,82,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1527,6,83,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1528,6,84,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1529,6,85,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1530,6,86,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1531,6,87,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1532,6,88,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1533,6,89,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1534,6,90,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1535,6,91,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1536,6,92,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1537,6,93,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1538,6,94,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1539,6,95,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1540,6,96,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1541,6,97,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1542,6,98,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1543,6,99,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1544,6,100,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1545,6,101,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1546,6,102,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1547,6,103,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1548,6,104,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1549,6,105,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1550,6,106,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1551,6,107,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1552,6,108,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1553,6,109,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1554,6,110,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1555,6,111,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1556,6,112,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1557,6,113,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1558,6,114,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1559,6,115,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1560,6,116,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1561,6,117,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1562,6,118,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1563,6,119,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1564,6,120,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1565,6,121,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1566,6,122,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1567,6,123,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1568,6,124,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1569,6,125,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1570,6,126,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1571,6,127,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1572,6,128,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1573,6,129,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1574,6,130,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1575,6,131,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1576,6,132,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1577,6,133,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1578,6,134,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1579,6,135,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1580,6,136,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1581,6,137,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1582,6,138,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1583,6,139,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1584,6,140,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1585,6,141,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1586,6,142,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1587,6,143,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1588,6,144,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1589,6,145,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1590,6,146,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1591,6,147,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1592,6,148,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1593,6,149,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1594,6,150,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1595,6,151,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1596,6,152,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1597,6,153,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1598,6,154,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1599,6,155,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1600,6,156,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1601,6,157,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1602,6,158,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1603,6,159,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1604,6,160,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1605,6,161,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1606,6,162,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1607,6,163,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1608,6,164,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1609,6,165,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1610,6,166,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1611,6,167,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1612,6,168,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1613,6,169,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1614,6,170,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1615,6,171,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1616,6,172,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1617,6,173,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1618,6,174,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1619,6,175,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1620,6,176,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1621,6,177,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1622,6,178,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1623,6,179,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1624,6,180,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1625,6,181,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1626,6,182,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1627,6,183,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1628,6,184,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1629,6,185,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1630,6,186,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1631,6,187,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1632,6,188,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1633,6,189,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1634,6,190,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1635,6,191,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1636,6,192,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1637,6,193,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1638,6,194,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1639,6,195,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1640,6,196,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1641,6,197,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1642,6,198,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1643,6,199,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1644,6,200,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1645,6,201,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1646,6,202,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1647,6,203,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1648,6,204,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1649,6,205,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1650,6,206,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1651,6,207,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1652,6,208,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1653,6,209,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1654,6,210,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1655,6,211,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1656,6,212,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1657,6,213,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1658,6,214,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1659,6,215,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1660,6,216,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1661,6,217,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1662,6,218,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1663,6,219,3,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1664,6,220,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1665,6,221,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1666,6,222,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1667,6,223,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1668,6,224,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1669,6,225,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1670,6,226,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1671,6,227,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1672,6,228,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1673,6,229,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1674,6,230,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1675,6,231,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1676,6,232,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1677,6,233,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1678,6,234,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1679,6,235,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1680,6,236,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1681,6,237,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1682,6,238,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1683,6,239,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1684,6,240,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1685,6,241,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1686,6,242,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1687,6,243,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1688,6,244,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1689,6,245,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1690,6,246,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1691,6,247,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1692,6,248,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1693,6,249,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1694,6,250,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1695,6,251,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1696,6,252,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1697,6,253,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1698,6,254,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1699,6,255,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1700,6,256,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1701,6,257,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1702,6,258,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1703,6,259,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1704,6,260,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1705,6,261,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1706,6,262,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1707,6,263,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1708,6,264,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1709,6,265,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1710,6,266,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1711,6,267,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1712,6,268,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1713,6,269,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1714,6,270,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1715,6,271,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1716,6,272,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1717,6,273,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1718,6,274,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1719,6,275,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1720,6,276,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1721,6,277,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1722,6,278,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1723,6,279,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1724,6,280,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1725,6,281,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1726,6,282,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1727,6,283,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1728,6,284,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1729,6,285,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1730,6,286,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1731,6,287,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1732,6,288,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1733,6,289,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1734,6,290,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1735,6,291,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1736,6,292,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1737,6,293,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1738,6,294,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1739,6,295,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1740,6,296,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1741,6,297,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1742,6,298,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1743,6,299,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1744,6,300,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1745,6,301,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1746,6,302,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1747,6,303,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1748,6,304,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1749,6,305,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1750,6,306,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1751,6,307,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1752,6,308,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1753,6,309,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1754,6,310,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1755,6,311,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1756,6,312,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1757,6,313,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1758,6,314,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1759,6,315,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1760,6,316,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1761,6,317,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1762,6,318,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1763,6,319,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1764,6,320,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1765,6,321,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1766,6,322,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1767,6,323,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1768,6,324,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1769,6,325,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1770,6,326,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1771,6,327,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1772,6,328,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1773,6,329,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1774,6,330,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1775,6,331,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1776,6,332,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1777,6,333,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1778,6,334,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1779,6,335,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1780,6,336,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1781,6,337,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1782,6,338,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1783,6,339,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1784,6,340,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1785,6,341,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1786,6,342,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1787,6,343,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1788,6,344,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1789,6,345,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1790,6,346,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1791,6,347,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1792,6,348,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1793,6,349,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1794,6,350,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1795,6,351,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1796,6,352,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1797,6,353,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1798,6,354,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1799,6,355,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1800,6,356,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1801,6,357,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1802,6,358,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1803,6,359,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1804,6,360,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1805,6,361,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1806,7,1,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1807,7,2,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1808,7,3,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1809,7,4,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1810,7,5,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1811,7,6,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1812,7,7,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1813,7,8,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1814,7,9,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1815,7,10,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1816,7,11,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1817,7,12,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1818,7,13,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1819,7,14,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1820,7,15,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1821,7,16,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1822,7,17,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1823,7,18,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1824,7,19,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1825,7,20,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1826,7,21,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1827,7,22,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1828,7,23,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1829,7,24,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1830,7,25,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1831,7,26,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1832,7,27,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1833,7,28,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1834,7,29,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1835,7,30,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1836,7,31,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1837,7,32,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1838,7,33,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1839,7,34,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1840,7,35,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1841,7,36,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1842,7,37,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1843,7,38,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1844,7,39,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1845,7,40,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1846,7,41,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1847,7,42,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1848,7,43,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1849,7,44,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1850,7,45,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1851,7,46,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1852,7,47,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1853,7,48,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1854,7,49,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1855,7,50,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1856,7,51,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1857,7,52,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1858,7,53,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1859,7,54,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1860,7,55,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1861,7,56,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1862,7,57,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1863,7,58,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1864,7,59,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1865,7,60,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1866,7,61,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1867,7,62,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1868,7,63,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1869,7,64,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1870,7,65,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1871,7,66,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1872,7,67,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1873,7,68,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1874,7,69,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1875,7,70,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1876,7,71,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1877,7,72,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1878,7,73,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1879,7,74,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1880,7,75,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1881,7,76,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1882,7,77,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1883,7,78,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1884,7,79,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1885,7,80,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1886,7,81,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1887,7,82,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1888,7,83,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1889,7,84,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1890,7,85,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1891,7,86,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1892,7,87,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1893,7,88,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1894,7,89,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1895,7,90,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1896,7,91,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1897,7,92,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1898,7,93,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1899,7,94,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1900,7,95,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1901,7,96,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1902,7,97,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1903,7,98,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1904,7,99,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1905,7,100,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1906,7,101,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1907,7,102,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1908,7,103,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1909,7,104,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1910,7,105,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1911,7,106,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1912,7,107,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1913,7,108,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1914,7,109,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1915,7,110,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1916,7,111,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1917,7,112,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1918,7,113,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1919,7,114,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1920,7,115,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1921,7,116,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1922,7,117,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1923,7,118,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1924,7,119,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1925,7,120,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1926,7,121,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1927,7,122,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1928,7,123,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1929,7,124,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1930,7,125,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1931,7,126,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1932,7,127,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1933,7,128,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1934,7,129,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1935,7,130,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1936,7,131,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1937,7,132,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1938,7,133,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1939,7,134,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1940,7,135,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1941,7,136,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1942,7,137,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1943,7,138,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1944,7,139,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1945,7,140,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1946,7,141,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1947,7,142,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1948,7,143,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1949,7,144,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1950,7,145,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1951,7,146,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1952,7,147,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1953,7,148,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1954,7,149,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1955,7,150,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1956,7,151,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1957,7,152,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1958,7,153,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1959,7,154,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1960,7,155,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1961,7,156,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1962,7,157,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1963,7,158,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1964,7,159,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1965,7,160,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1966,7,161,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1967,7,162,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1968,7,163,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1969,7,164,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1970,7,165,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1971,7,166,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1972,7,167,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1973,7,168,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1974,7,169,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1975,7,170,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1976,7,171,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1977,7,172,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1978,7,173,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1979,7,174,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1980,7,175,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1981,7,176,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1982,7,177,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1983,7,178,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1984,7,179,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1985,7,180,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1986,7,181,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1987,7,182,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1988,7,183,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1989,7,184,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1990,7,185,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1991,7,186,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1992,7,187,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1993,7,188,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1994,7,189,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1995,7,190,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1996,7,191,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1997,7,192,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1998,7,193,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(1999,7,194,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2000,7,195,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2001,7,196,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2002,7,197,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2003,7,198,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2004,7,199,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2005,7,200,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2006,7,201,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2007,7,202,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2008,7,203,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2009,7,204,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2010,7,205,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2011,7,206,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2012,7,207,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2013,7,208,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2014,7,209,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2015,7,210,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2016,7,211,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2017,7,212,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2018,7,213,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2019,7,214,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2020,7,215,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2021,7,216,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2022,7,217,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2023,7,218,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2024,7,219,3,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2025,7,220,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2026,7,221,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2027,7,222,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2028,7,223,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2029,7,224,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2030,7,225,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2031,7,226,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2032,7,227,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2033,7,228,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2034,7,229,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2035,7,230,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2036,7,231,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2037,7,232,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2038,7,233,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2039,7,234,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2040,7,235,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2041,7,236,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2042,7,237,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2043,7,238,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2044,7,239,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2045,7,240,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2046,7,241,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2047,7,242,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2048,7,243,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2049,7,244,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2050,7,245,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2051,7,246,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2052,7,247,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2053,7,248,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2054,7,249,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2055,7,250,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2056,7,251,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2057,7,252,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2058,7,253,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2059,7,254,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2060,7,255,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2061,7,256,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2062,7,257,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2063,7,258,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2064,7,259,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2065,7,260,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2066,7,261,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2067,7,262,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2068,7,263,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2069,7,264,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2070,7,265,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2071,7,266,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2072,7,267,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2073,7,268,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2074,7,269,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2075,7,270,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2076,7,271,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2077,7,272,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2078,7,273,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2079,7,274,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2080,7,275,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2081,7,276,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2082,7,277,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2083,7,278,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2084,7,279,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2085,7,280,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2086,7,281,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2087,7,282,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2088,7,283,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2089,7,284,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2090,7,285,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2091,7,286,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2092,7,287,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2093,7,288,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2094,7,289,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2095,7,290,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2096,7,291,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2097,7,292,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2098,7,293,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2099,7,294,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2100,7,295,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2101,7,296,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2102,7,297,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2103,7,298,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2104,7,299,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2105,7,300,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2106,7,301,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2107,7,302,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2108,7,303,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2109,7,304,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2110,7,305,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2111,7,306,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2112,7,307,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2113,7,308,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2114,7,309,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2115,7,310,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2116,7,311,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2117,7,312,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2118,7,313,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2119,7,314,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2120,7,315,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2121,7,316,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2122,7,317,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2123,7,318,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2124,7,319,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2125,7,320,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2126,7,321,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2127,7,322,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2128,7,323,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2129,7,324,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2130,7,325,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2131,7,326,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2132,7,327,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2133,7,328,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2134,7,329,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2135,7,330,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2136,7,331,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2137,7,332,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2138,7,333,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2139,7,334,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2140,7,335,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2141,7,336,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2142,7,337,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2143,7,338,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2144,7,339,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2145,7,340,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2146,7,341,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2147,7,342,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2148,7,343,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2149,7,344,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2150,7,345,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2151,7,346,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2152,7,347,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2153,7,348,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2154,7,349,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2155,7,350,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2156,7,351,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2157,7,352,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2158,7,353,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2159,7,354,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2160,7,355,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2161,7,356,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2162,7,357,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2163,7,358,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2164,7,359,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2165,7,360,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2166,7,361,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2167,8,1,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2168,8,2,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2169,8,3,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2170,8,4,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2171,8,5,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2172,8,6,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2173,8,7,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2174,8,8,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2175,8,9,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2176,8,10,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2177,8,11,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2178,8,12,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2179,8,13,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2180,8,14,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2181,8,15,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2182,8,16,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2183,8,17,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2184,8,18,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2185,8,19,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2186,8,20,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2187,8,21,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2188,8,22,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2189,8,23,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2190,8,24,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2191,8,25,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2192,8,26,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2193,8,27,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2194,8,28,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2195,8,29,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2196,8,30,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2197,8,31,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2198,8,32,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2199,8,33,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2200,8,34,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2201,8,35,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2202,8,36,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2203,8,37,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2204,8,38,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2205,8,39,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2206,8,40,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2207,8,41,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2208,8,42,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2209,8,43,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2210,8,44,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2211,8,45,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2212,8,46,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2213,8,47,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2214,8,48,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2215,8,49,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2216,8,50,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2217,8,51,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2218,8,52,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2219,8,53,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2220,8,54,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2221,8,55,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2222,8,56,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2223,8,57,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2224,8,58,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2225,8,59,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2226,8,60,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2227,8,61,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2228,8,62,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2229,8,63,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2230,8,64,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2231,8,65,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2232,8,66,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2233,8,67,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2234,8,68,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2235,8,69,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2236,8,70,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2237,8,71,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2238,8,72,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2239,8,73,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2240,8,74,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2241,8,75,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2242,8,76,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2243,8,77,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2244,8,78,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2245,8,79,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2246,8,80,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2247,8,81,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2248,8,82,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2249,8,83,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2250,8,84,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2251,8,85,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2252,8,86,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2253,8,87,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2254,8,88,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2255,8,89,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2256,8,90,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2257,8,91,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2258,8,92,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2259,8,93,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2260,8,94,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2261,8,95,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2262,8,96,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2263,8,97,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2264,8,98,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2265,8,99,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2266,8,100,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2267,8,101,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2268,8,102,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2269,8,103,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2270,8,104,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2271,8,105,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2272,8,106,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2273,8,107,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2274,8,108,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2275,8,109,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2276,8,110,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2277,8,111,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2278,8,112,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2279,8,113,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2280,8,114,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2281,8,115,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2282,8,116,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2283,8,117,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2284,8,118,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2285,8,119,2,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2286,8,120,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2287,8,121,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2288,8,122,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2289,8,123,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2290,8,124,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2291,8,125,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2292,8,126,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2293,8,127,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2294,8,128,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2295,8,129,1,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2296,8,130,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2297,8,131,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2298,8,132,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2299,8,133,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2300,8,134,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2301,8,135,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2302,8,136,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2303,8,137,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2304,8,138,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2305,8,139,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2306,8,140,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2307,8,141,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2308,8,142,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2309,8,143,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2310,8,144,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2311,8,145,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2312,8,146,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2313,8,147,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2314,8,148,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2315,8,149,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2316,8,150,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2317,8,151,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2318,8,152,4,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2319,8,153,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2320,8,154,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2321,8,155,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2322,8,156,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2323,8,157,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2324,8,158,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2325,8,159,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2326,8,160,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2327,8,161,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2328,8,162,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2329,8,163,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2330,8,164,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2331,8,165,5,'2023-04-06 06:33:19','2023-04-06 06:33:19'),(2332,8,166,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2333,8,167,2,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2334,8,168,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2335,8,169,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2336,8,170,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2337,8,171,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2338,8,172,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2339,8,173,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2340,8,174,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2341,8,175,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2342,8,176,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2343,8,177,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2344,8,178,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2345,8,179,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2346,8,180,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2347,8,181,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2348,8,182,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2349,8,183,1,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2350,8,184,1,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2351,8,185,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2352,8,186,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2353,8,187,1,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2354,8,188,1,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2355,8,189,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2356,8,190,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2357,8,191,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2358,8,192,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2359,8,193,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2360,8,194,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2361,8,195,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2362,8,196,2,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2363,8,197,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2364,8,198,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2365,8,199,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2366,8,200,2,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2367,8,201,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2368,8,202,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2369,8,203,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2370,8,204,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2371,8,205,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2372,8,206,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2373,8,207,2,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2374,8,208,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2375,8,209,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2376,8,210,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2377,8,211,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2378,8,212,2,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2379,8,213,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2380,8,214,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2381,8,215,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2382,8,216,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2383,8,217,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2384,8,218,1,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2385,8,219,3,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2386,8,220,1,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2387,8,221,1,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2388,8,222,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2389,8,223,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2390,8,224,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2391,8,225,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2392,8,226,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2393,8,227,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2394,8,228,2,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2395,8,229,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2396,8,230,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2397,8,231,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2398,8,232,2,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2399,8,233,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2400,8,234,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2401,8,235,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2402,8,236,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2403,8,237,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2404,8,238,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2405,8,239,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2406,8,240,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2407,8,241,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2408,8,242,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2409,8,243,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2410,8,244,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2411,8,245,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2412,8,246,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2413,8,247,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2414,8,248,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2415,8,249,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2416,8,250,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2417,8,251,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2418,8,252,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2419,8,253,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2420,8,254,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2421,8,255,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2422,8,256,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2423,8,257,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2424,8,258,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2425,8,259,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2426,8,260,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2427,8,261,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2428,8,262,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2429,8,263,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2430,8,264,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2431,8,265,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2432,8,266,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2433,8,267,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2434,8,268,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2435,8,269,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2436,8,270,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2437,8,271,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2438,8,272,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2439,8,273,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2440,8,274,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2441,8,275,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2442,8,276,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2443,8,277,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2444,8,278,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2445,8,279,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2446,8,280,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2447,8,281,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2448,8,282,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2449,8,283,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2450,8,284,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2451,8,285,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2452,8,286,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2453,8,287,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2454,8,288,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2455,8,289,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2456,8,290,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2457,8,291,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2458,8,292,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2459,8,293,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2460,8,294,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2461,8,295,2,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2462,8,296,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2463,8,297,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2464,8,298,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2465,8,299,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2466,8,300,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2467,8,301,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2468,8,302,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2469,8,303,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2470,8,304,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2471,8,305,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2472,8,306,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2473,8,307,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2474,8,308,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2475,8,309,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2476,8,310,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2477,8,311,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2478,8,312,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2479,8,313,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2480,8,314,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2481,8,315,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2482,8,316,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2483,8,317,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2484,8,318,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2485,8,319,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2486,8,320,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2487,8,321,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2488,8,322,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2489,8,323,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2490,8,324,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2491,8,325,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2492,8,326,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2493,8,327,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2494,8,328,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2495,8,329,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2496,8,330,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2497,8,331,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2498,8,332,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2499,8,333,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2500,8,334,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2501,8,335,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2502,8,336,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2503,8,337,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2504,8,338,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2505,8,339,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2506,8,340,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2507,8,341,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2508,8,342,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2509,8,343,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2510,8,344,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2511,8,345,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2512,8,346,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2513,8,347,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2514,8,348,2,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2515,8,349,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2516,8,350,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2517,8,351,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2518,8,352,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2519,8,353,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2520,8,354,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2521,8,355,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2522,8,356,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2523,8,357,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2524,8,358,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2525,8,359,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2526,8,360,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2527,8,361,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2528,9,1,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2529,9,2,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2530,9,3,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2531,9,4,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2532,9,5,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2533,9,6,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2534,9,7,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2535,9,8,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2536,9,9,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2537,9,10,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2538,9,11,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2539,9,12,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2540,9,13,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2541,9,14,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2542,9,15,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2543,9,16,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2544,9,17,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2545,9,18,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2546,9,19,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2547,9,20,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2548,9,21,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2549,9,22,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2550,9,23,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2551,9,24,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2552,9,25,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2553,9,26,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2554,9,27,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2555,9,28,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2556,9,29,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2557,9,30,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2558,9,31,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2559,9,32,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2560,9,33,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2561,9,34,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2562,9,35,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2563,9,36,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2564,9,37,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2565,9,38,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2566,9,39,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2567,9,40,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2568,9,41,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2569,9,42,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2570,9,43,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2571,9,44,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2572,9,45,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2573,9,46,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2574,9,47,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2575,9,48,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2576,9,49,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2577,9,50,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2578,9,51,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2579,9,52,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2580,9,53,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2581,9,54,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2582,9,55,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2583,9,56,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2584,9,57,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2585,9,58,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2586,9,59,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2587,9,60,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2588,9,61,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2589,9,62,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2590,9,63,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2591,9,64,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2592,9,65,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2593,9,66,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2594,9,67,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2595,9,68,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2596,9,69,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2597,9,70,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2598,9,71,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2599,9,72,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2600,9,73,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2601,9,74,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2602,9,75,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2603,9,76,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2604,9,77,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2605,9,78,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2606,9,79,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2607,9,80,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2608,9,81,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2609,9,82,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2610,9,83,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2611,9,84,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2612,9,85,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2613,9,86,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2614,9,87,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2615,9,88,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2616,9,89,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2617,9,90,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2618,9,91,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2619,9,92,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2620,9,93,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2621,9,94,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2622,9,95,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2623,9,96,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2624,9,97,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2625,9,98,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2626,9,99,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2627,9,100,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2628,9,101,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2629,9,102,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2630,9,103,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2631,9,104,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2632,9,105,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2633,9,106,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2634,9,107,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2635,9,108,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2636,9,109,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2637,9,110,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2638,9,111,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2639,9,112,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2640,9,113,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2641,9,114,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2642,9,115,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2643,9,116,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2644,9,117,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2645,9,118,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2646,9,119,2,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2647,9,120,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2648,9,121,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2649,9,122,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2650,9,123,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2651,9,124,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2652,9,125,1,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2653,9,126,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2654,9,127,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2655,9,128,1,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2656,9,129,1,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2657,9,130,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2658,9,131,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2659,9,132,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2660,9,133,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2661,9,134,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2662,9,135,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2663,9,136,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2664,9,137,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2665,9,138,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2666,9,139,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2667,9,140,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2668,9,141,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2669,9,142,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2670,9,143,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2671,9,144,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2672,9,145,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2673,9,146,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2674,9,147,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2675,9,148,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2676,9,149,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2677,9,150,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2678,9,151,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2679,9,152,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2680,9,153,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2681,9,154,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2682,9,155,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2683,9,156,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2684,9,157,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2685,9,158,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2686,9,159,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2687,9,160,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2688,9,161,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2689,9,162,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2690,9,163,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2691,9,164,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2692,9,165,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2693,9,166,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2694,9,167,2,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2695,9,168,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2696,9,169,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2697,9,170,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2698,9,171,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2699,9,172,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2700,9,173,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2701,9,174,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2702,9,175,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2703,9,176,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2704,9,177,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2705,9,178,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2706,9,179,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2707,9,180,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2708,9,181,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2709,9,182,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2710,9,183,1,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2711,9,184,1,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2712,9,185,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2713,9,186,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2714,9,187,1,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2715,9,188,1,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2716,9,189,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2717,9,190,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2718,9,191,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2719,9,192,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2720,9,193,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2721,9,194,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2722,9,195,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2723,9,196,2,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2724,9,197,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2725,9,198,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2726,9,199,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2727,9,200,2,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2728,9,201,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2729,9,202,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2730,9,203,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2731,9,204,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2732,9,205,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2733,9,206,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2734,9,207,2,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2735,9,208,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2736,9,209,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2737,9,210,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2738,9,211,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2739,9,212,2,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2740,9,213,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2741,9,214,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2742,9,215,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2743,9,216,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2744,9,217,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2745,9,218,1,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2746,9,219,3,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2747,9,220,1,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2748,9,221,1,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2749,9,222,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2750,9,223,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2751,9,224,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2752,9,225,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2753,9,226,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2754,9,227,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2755,9,228,2,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2756,9,229,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2757,9,230,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2758,9,231,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2759,9,232,2,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2760,9,233,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2761,9,234,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2762,9,235,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2763,9,236,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2764,9,237,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2765,9,238,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2766,9,239,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2767,9,240,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2768,9,241,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2769,9,242,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2770,9,243,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2771,9,244,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2772,9,245,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2773,9,246,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2774,9,247,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2775,9,248,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2776,9,249,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2777,9,250,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2778,9,251,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2779,9,252,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2780,9,253,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2781,9,254,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2782,9,255,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2783,9,256,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2784,9,257,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2785,9,258,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2786,9,259,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2787,9,260,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2788,9,261,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2789,9,262,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2790,9,263,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2791,9,264,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2792,9,265,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2793,9,266,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2794,9,267,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2795,9,268,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2796,9,269,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2797,9,270,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2798,9,271,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2799,9,272,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2800,9,273,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2801,9,274,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2802,9,275,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2803,9,276,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2804,9,277,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2805,9,278,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2806,9,279,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2807,9,280,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2808,9,281,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2809,9,282,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2810,9,283,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2811,9,284,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2812,9,285,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2813,9,286,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2814,9,287,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2815,9,288,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2816,9,289,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2817,9,290,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2818,9,291,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2819,9,292,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2820,9,293,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2821,9,294,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2822,9,295,2,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2823,9,296,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2824,9,297,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2825,9,298,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2826,9,299,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2827,9,300,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2828,9,301,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2829,9,302,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2830,9,303,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2831,9,304,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2832,9,305,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2833,9,306,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2834,9,307,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2835,9,308,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2836,9,309,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2837,9,310,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2838,9,311,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2839,9,312,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2840,9,313,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2841,9,314,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2842,9,315,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2843,9,316,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2844,9,317,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2845,9,318,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2846,9,319,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2847,9,320,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2848,9,321,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2849,9,322,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2850,9,323,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2851,9,324,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2852,9,325,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2853,9,326,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2854,9,327,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2855,9,328,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2856,9,329,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2857,9,330,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2858,9,331,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2859,9,332,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2860,9,333,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2861,9,334,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2862,9,335,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2863,9,336,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2864,9,337,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2865,9,338,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2866,9,339,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2867,9,340,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2868,9,341,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2869,9,342,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2870,9,343,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2871,9,344,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2872,9,345,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2873,9,346,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2874,9,347,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2875,9,348,2,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2876,9,349,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2877,9,350,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2878,9,351,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2879,9,352,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2880,9,353,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2881,9,354,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2882,9,355,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2883,9,356,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2884,9,357,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2885,9,358,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2886,9,359,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2887,9,360,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2888,9,361,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2889,10,1,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2890,10,2,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2891,10,3,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2892,10,4,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2893,10,5,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2894,10,6,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2895,10,7,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2896,10,8,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2897,10,9,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2898,10,10,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2899,10,11,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2900,10,12,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2901,10,13,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2902,10,14,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2903,10,15,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2904,10,16,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2905,10,17,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2906,10,18,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2907,10,19,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2908,10,20,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2909,10,21,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2910,10,22,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2911,10,23,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2912,10,24,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2913,10,25,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2914,10,26,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2915,10,27,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2916,10,28,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2917,10,29,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2918,10,30,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2919,10,31,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2920,10,32,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2921,10,33,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2922,10,34,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2923,10,35,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2924,10,36,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2925,10,37,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2926,10,38,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2927,10,39,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2928,10,40,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2929,10,41,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2930,10,42,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2931,10,43,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2932,10,44,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2933,10,45,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2934,10,46,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2935,10,47,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2936,10,48,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2937,10,49,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2938,10,50,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2939,10,51,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2940,10,52,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2941,10,53,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2942,10,54,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2943,10,55,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2944,10,56,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2945,10,57,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2946,10,58,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2947,10,59,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2948,10,60,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2949,10,61,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2950,10,62,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2951,10,63,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2952,10,64,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2953,10,65,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2954,10,66,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2955,10,67,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2956,10,68,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2957,10,69,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2958,10,70,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2959,10,71,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2960,10,72,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2961,10,73,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2962,10,74,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2963,10,75,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2964,10,76,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2965,10,77,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2966,10,78,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2967,10,79,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2968,10,80,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2969,10,81,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2970,10,82,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2971,10,83,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2972,10,84,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2973,10,85,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2974,10,86,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2975,10,87,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2976,10,88,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2977,10,89,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2978,10,90,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2979,10,91,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2980,10,92,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2981,10,93,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2982,10,94,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2983,10,95,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2984,10,96,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2985,10,97,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2986,10,98,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2987,10,99,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2988,10,100,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2989,10,101,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2990,10,102,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2991,10,103,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2992,10,104,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2993,10,105,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2994,10,106,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2995,10,107,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2996,10,108,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2997,10,109,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2998,10,110,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(2999,10,111,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3000,10,112,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3001,10,113,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3002,10,114,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3003,10,115,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3004,10,116,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3005,10,117,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3006,10,118,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3007,10,119,2,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3008,10,120,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3009,10,121,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3010,10,122,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3011,10,123,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3012,10,124,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3013,10,125,1,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3014,10,126,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3015,10,127,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3016,10,128,1,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3017,10,129,1,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3018,10,130,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3019,10,131,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3020,10,132,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3021,10,133,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3022,10,134,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3023,10,135,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3024,10,136,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3025,10,137,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3026,10,138,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3027,10,139,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3028,10,140,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3029,10,141,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3030,10,142,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3031,10,143,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3032,10,144,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3033,10,145,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3034,10,146,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3035,10,147,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3036,10,148,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3037,10,149,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3038,10,150,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3039,10,151,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3040,10,152,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3041,10,153,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3042,10,154,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3043,10,155,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3044,10,156,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3045,10,157,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3046,10,158,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3047,10,159,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3048,10,160,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3049,10,161,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3050,10,162,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3051,10,163,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3052,10,164,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3053,10,165,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3054,10,166,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3055,10,167,2,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3056,10,168,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3057,10,169,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3058,10,170,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3059,10,171,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3060,10,172,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3061,10,173,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3062,10,174,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3063,10,175,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3064,10,176,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3065,10,177,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3066,10,178,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3067,10,179,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3068,10,180,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3069,10,181,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3070,10,182,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3071,10,183,1,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3072,10,184,1,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3073,10,185,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3074,10,186,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3075,10,187,1,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3076,10,188,1,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3077,10,189,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3078,10,190,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3079,10,191,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3080,10,192,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3081,10,193,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3082,10,194,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3083,10,195,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3084,10,196,2,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3085,10,197,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3086,10,198,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3087,10,199,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3088,10,200,2,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3089,10,201,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3090,10,202,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3091,10,203,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3092,10,204,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3093,10,205,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3094,10,206,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3095,10,207,2,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3096,10,208,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3097,10,209,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3098,10,210,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3099,10,211,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3100,10,212,2,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3101,10,213,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3102,10,214,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3103,10,215,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3104,10,216,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3105,10,217,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3106,10,218,1,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3107,10,219,3,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3108,10,220,1,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3109,10,221,1,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3110,10,222,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3111,10,223,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3112,10,224,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3113,10,225,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3114,10,226,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3115,10,227,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3116,10,228,2,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3117,10,229,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3118,10,230,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3119,10,231,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3120,10,232,2,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3121,10,233,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3122,10,234,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3123,10,235,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3124,10,236,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3125,10,237,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3126,10,238,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3127,10,239,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3128,10,240,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3129,10,241,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3130,10,242,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3131,10,243,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3132,10,244,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3133,10,245,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3134,10,246,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3135,10,247,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3136,10,248,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3137,10,249,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3138,10,250,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3139,10,251,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3140,10,252,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3141,10,253,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3142,10,254,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3143,10,255,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3144,10,256,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3145,10,257,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3146,10,258,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3147,10,259,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3148,10,260,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3149,10,261,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3150,10,262,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3151,10,263,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3152,10,264,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3153,10,265,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3154,10,266,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3155,10,267,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3156,10,268,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3157,10,269,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3158,10,270,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3159,10,271,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3160,10,272,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3161,10,273,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3162,10,274,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3163,10,275,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3164,10,276,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3165,10,277,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3166,10,278,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3167,10,279,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3168,10,280,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3169,10,281,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3170,10,282,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3171,10,283,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3172,10,284,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3173,10,285,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3174,10,286,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3175,10,287,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3176,10,288,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3177,10,289,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3178,10,290,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3179,10,291,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3180,10,292,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3181,10,293,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3182,10,294,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3183,10,295,2,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3184,10,296,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3185,10,297,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3186,10,298,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3187,10,299,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3188,10,300,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3189,10,301,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3190,10,302,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3191,10,303,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3192,10,304,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3193,10,305,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3194,10,306,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3195,10,307,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3196,10,308,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3197,10,309,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3198,10,310,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3199,10,311,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3200,10,312,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3201,10,313,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3202,10,314,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3203,10,315,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3204,10,316,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3205,10,317,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3206,10,318,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3207,10,319,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3208,10,320,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3209,10,321,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3210,10,322,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3211,10,323,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3212,10,324,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3213,10,325,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3214,10,326,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3215,10,327,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3216,10,328,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3217,10,329,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3218,10,330,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3219,10,331,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3220,10,332,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3221,10,333,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3222,10,334,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3223,10,335,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3224,10,336,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3225,10,337,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3226,10,338,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3227,10,339,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3228,10,340,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3229,10,341,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3230,10,342,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3231,10,343,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3232,10,344,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3233,10,345,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3234,10,346,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3235,10,347,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3236,10,348,2,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3237,10,349,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3238,10,350,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3239,10,351,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3240,10,352,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3241,10,353,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3242,10,354,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3243,10,355,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3244,10,356,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3245,10,357,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3246,10,358,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3247,10,359,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3248,10,360,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3249,10,361,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3250,11,1,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3251,11,2,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3252,11,3,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3253,11,4,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3254,11,5,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3255,11,6,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3256,11,7,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3257,11,8,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3258,11,9,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3259,11,10,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3260,11,11,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3261,11,12,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3262,11,13,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3263,11,14,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3264,11,15,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3265,11,16,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3266,11,17,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3267,11,18,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3268,11,19,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3269,11,20,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3270,11,21,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3271,11,22,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3272,11,23,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3273,11,24,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3274,11,25,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3275,11,26,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3276,11,27,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3277,11,28,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3278,11,29,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3279,11,30,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3280,11,31,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3281,11,32,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3282,11,33,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3283,11,34,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3284,11,35,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3285,11,36,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3286,11,37,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3287,11,38,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3288,11,39,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3289,11,40,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3290,11,41,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3291,11,42,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3292,11,43,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3293,11,44,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3294,11,45,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3295,11,46,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3296,11,47,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3297,11,48,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3298,11,49,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3299,11,50,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3300,11,51,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3301,11,52,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3302,11,53,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3303,11,54,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3304,11,55,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3305,11,56,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3306,11,57,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3307,11,58,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3308,11,59,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3309,11,60,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3310,11,61,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3311,11,62,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3312,11,63,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3313,11,64,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3314,11,65,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3315,11,66,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3316,11,67,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3317,11,68,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3318,11,69,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3319,11,70,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3320,11,71,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3321,11,72,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3322,11,73,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3323,11,74,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3324,11,75,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3325,11,76,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3326,11,77,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3327,11,78,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3328,11,79,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3329,11,80,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3330,11,81,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3331,11,82,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3332,11,83,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3333,11,84,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3334,11,85,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3335,11,86,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3336,11,87,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3337,11,88,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3338,11,89,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3339,11,90,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3340,11,91,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3341,11,92,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3342,11,93,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3343,11,94,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3344,11,95,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3345,11,96,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3346,11,97,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3347,11,98,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3348,11,99,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3349,11,100,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3350,11,101,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3351,11,102,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3352,11,103,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3353,11,104,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3354,11,105,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3355,11,106,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3356,11,107,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3357,11,108,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3358,11,109,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3359,11,110,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3360,11,111,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3361,11,112,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3362,11,113,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3363,11,114,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3364,11,115,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3365,11,116,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3366,11,117,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3367,11,118,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3368,11,119,2,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3369,11,120,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3370,11,121,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3371,11,122,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3372,11,123,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3373,11,124,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3374,11,125,1,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3375,11,126,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3376,11,127,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3377,11,128,1,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3378,11,129,1,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3379,11,130,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3380,11,131,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3381,11,132,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3382,11,133,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3383,11,134,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3384,11,135,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3385,11,136,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3386,11,137,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3387,11,138,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3388,11,139,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3389,11,140,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3390,11,141,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3391,11,142,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3392,11,143,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3393,11,144,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3394,11,145,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3395,11,146,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3396,11,147,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3397,11,148,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3398,11,149,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3399,11,150,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3400,11,151,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3401,11,152,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3402,11,153,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3403,11,154,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3404,11,155,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3405,11,156,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3406,11,157,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3407,11,158,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3408,11,159,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3409,11,160,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3410,11,161,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3411,11,162,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3412,11,163,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3413,11,164,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3414,11,165,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3415,11,166,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3416,11,167,2,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3417,11,168,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3418,11,169,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3419,11,170,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3420,11,171,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3421,11,172,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3422,11,173,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3423,11,174,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3424,11,175,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3425,11,176,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3426,11,177,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3427,11,178,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3428,11,179,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3429,11,180,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3430,11,181,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3431,11,182,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3432,11,183,1,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3433,11,184,1,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3434,11,185,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3435,11,186,4,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3436,11,187,1,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3437,11,188,1,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3438,11,189,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3439,11,190,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3440,11,191,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3441,11,192,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3442,11,193,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3443,11,194,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3444,11,195,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3445,11,196,2,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3446,11,197,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3447,11,198,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3448,11,199,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3449,11,200,2,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3450,11,201,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3451,11,202,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3452,11,203,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3453,11,204,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3454,11,205,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3455,11,206,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3456,11,207,2,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3457,11,208,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3458,11,209,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3459,11,210,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3460,11,211,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3461,11,212,2,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3462,11,213,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3463,11,214,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3464,11,215,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3465,11,216,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3466,11,217,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3467,11,218,1,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3468,11,219,3,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3469,11,220,1,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3470,11,221,1,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3471,11,222,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3472,11,223,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3473,11,224,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3474,11,225,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3475,11,226,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3476,11,227,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3477,11,228,2,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3478,11,229,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3479,11,230,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3480,11,231,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3481,11,232,2,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3482,11,233,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3483,11,234,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3484,11,235,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3485,11,236,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3486,11,237,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3487,11,238,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3488,11,239,5,'2023-04-06 06:33:20','2023-04-06 06:33:20'),(3489,11,240,5,'2023-04-06 06:33:20','2023-04-06 0